import re

class Lang():
    def __init__(self, obs=[], feat_dict={}):
        self.obs = obs                                  # obs = [[SR, Word]]
        self.feat_dict = feat_dict  

    def get_allomorph(self):
        parsed = [[re.split(' - | -', i[0]), 
                   [j for j in re.split(' ', i[1].replace('stem', '')) if j!='']]
                  for i in self.obs]
        allomorph = {}
        for i in parsed:
            for j in range(len(i[0])):
                if i[1][j] not in allomorph.keys(): # if the current morpheme is not stored in the allomorphs yet
                    allomorph[i[1][j]] = [i[0][j]] # put up the first observed set
                else: # if it's stored
                    if i[0][j] not in allomorph[i[1][j]]: #if the current surface realization is not in the allomorph set
                        allomorph[i[1][j]].append(i[0][j]) # add in the current surface realization
        return allomorph
    
    
    def _alternating_segs(self, srs, segs_alternating):
        ''' 
        Parameters
        ----------
        srs: a list of strings; an allomorph set for a morpheme
        seges_alternationg: a dictionary containing detected segmental alternations 


        Returns
        -------
        segs_alternating: an updated dictionary of segmental alternations

        For example, if the srs are ['b e t', 'b e d'], then segs_alternating should be added with the following entries
            {'t':['d'], 'd':['t']}

        '''
        new_srs = [i.split(' ') for i in srs]

        alternating = []
        for i in range(len(new_srs[0])): #count the number of phonemes
            curr = []
            for item in new_srs:
                if item[i] not in curr:
                    curr.append(item[i]) #tallying up the observed segments at each position

            if len(curr) == 1: #if there is only one possible segment at this location, nothing happens
                pass 
            else: #if multiple segments observed, need to be recorded
                alternating.append(curr)

        for item in alternating:
            for seg in item: 
                if seg not in segs_alternating: #check whether the current segment is already in the alternation set
                    #if no, create a new entry and put everything it alternates with in the alternation set. 
                    segs_alternating[seg] = [i for i in item if i != seg]

                elif seg in segs_alternating: #if the current segment is already in the alternation list
                    #only supplement with novel alternating segment detected for the anchor segment
                    segs_alternating[seg] += [i for i in item if i != seg \
                                              and i not in segs_alternating[seg]]
        return segs_alternating
    
    def get_alternating_segments(self):
        alternation = {}
        allomorphs = self.get_allomorph()
        for _, surface in allomorphs.items():
            alternation = self._alternating_segs(surface, alternation) #iterate through all allomorph sets of this langauge
        return alternation