class Interpolation():
    def __init__(self):
        '''
        '''
    
    def phonetically_intermediate(a, b, feat_dict):
        ''' 
        Parameters
        ----------
        a: a segment a
        b: a segment b
        f: a feature system (we assume fully specified binary-valued features); should be organized as feat_dict

        Returns
        -------
        result: a list of segments that are intermediate between 'a' and 'b' according to a feature system f
        '''
        result = []
        feature_a = feat_dict[a] #pulling out the feature specifications of segment a 
        feature_b = feat_dict[b] #pulling out the feature specifications of segment b 
    
        segs = list(feat_dict.keys()) ## get all segments
        features = list(feature_a.keys()) ## get all feature names
        for seg in segs:
            add = True
            if seg == a or seg == b: ## the phonetically intermediate segment(s) need to be different from both alternating segments
                add = False
            else:
                for f in features:
                    if (feat_dict[seg][f] != feature_a[f] and feat_dict[seg][f] != feature_b[f]):#if there exists a feature F such that F(seg) is not equal to F(a) AND F(seg) is not equal to F(b)
                        add = False
            if add == True:
                result.append(seg)
        return result
    
    def feature_mismatch(a, b, feat_dict):
        ''' 
        Parameters
        ----------
        a: a segment a
        b: a segment b
        f: a feature system (we assume fully specified binary-valued features); should be organized as feat_dict

        Returns
        -------
        result: a list of segments that are intermediate between 'a' and 'b' according to a feature system f
        '''
        result = []
        feature_a = feat_dict[a] #pulling out the feature specifications of segment a 
        feature_b = feat_dict[b] #pulling out the feature specifications of segment b 
        features = list(feature_a.keys()) ## get all feature names
        for f in features:
            if feat_dict[a][f] != feat_dict[b][f]:
                result.append(f)
        return result