VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "MaxEnt Affix Discovery"
   ClientHeight    =   4245
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   18195
   LinkTopic       =   "Form1"
   OLEDropMode     =   1  'Manual
   ScaleHeight     =   4245
   ScaleWidth      =   18195
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox chkHarshParseReliability 
      Caption         =   "Impose strong penalty for low Parse Reliability"
      Height          =   495
      Left            =   14160
      TabIndex        =   15
      Top             =   1080
      Width           =   2895
   End
   Begin VB.CheckBox chkWugDictionary 
      Caption         =   "Use the wug dictionary to get ratings of wug forms"
      Height          =   495
      Left            =   14160
      TabIndex        =   13
      Top             =   600
      Width           =   3015
   End
   Begin VB.CommandButton cmdUseLastTime 
      Caption         =   "Use same input file as last time"
      Height          =   375
      Left            =   14160
      TabIndex        =   12
      Top             =   1560
      Width           =   2895
   End
   Begin VB.CheckBox chkMakeWeightingFile 
      Caption         =   "Use the Silver Standard to make file meant to set the constraint weight"
      Height          =   495
      Left            =   10920
      TabIndex        =   11
      Top             =   600
      Width           =   3015
   End
   Begin VB.Frame Frame2 
      Caption         =   "Select data corpus"
      Height          =   1215
      Left            =   7560
      TabIndex        =   8
      Top             =   600
      Width           =   3015
      Begin VB.OptionButton optGoldwaterCorpus 
         Caption         =   "Goldwater"
         Height          =   375
         Left            =   240
         TabIndex        =   10
         Top             =   600
         Width           =   2000
      End
      Begin VB.OptionButton optPearlCorpus 
         Caption         =   "Pearl"
         Height          =   495
         Left            =   240
         TabIndex        =   9
         Top             =   240
         Value           =   -1  'True
         Width           =   2655
      End
   End
   Begin VB.CommandButton cmdExcelHowTo 
      Caption         =   "How to do this"
      Height          =   375
      Left            =   11160
      TabIndex        =   7
      Top             =   1560
      Width           =   2655
   End
   Begin VB.CheckBox chkEvaluateResult 
      Caption         =   "Don't run algorithm, evaluate Excel result instead"
      Height          =   375
      Left            =   10920
      TabIndex        =   6
      Top             =   1200
      Width           =   3015
   End
   Begin VB.TextBox txtExampleMinimum 
      Alignment       =   2  'Center
      Height          =   375
      Left            =   9000
      TabIndex        =   4
      Text            =   "10"
      Top             =   2040
      Width           =   495
   End
   Begin VB.Frame Frame1 
      Caption         =   "Type or token frequency"
      Height          =   1215
      Left            =   4320
      TabIndex        =   1
      Top             =   600
      Width           =   3015
      Begin VB.OptionButton optToken 
         Caption         =   "Use corpus token frequency"
         Height          =   375
         Left            =   240
         TabIndex        =   3
         Top             =   600
         Width           =   2655
      End
      Begin VB.OptionButton optTypes 
         Caption         =   "Use type frequency"
         Height          =   255
         Left            =   240
         TabIndex        =   2
         Top             =   360
         Value           =   -1  'True
         Width           =   2175
      End
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Drag an input file of the Dictionary type onto the blank space below to start."
      Height          =   1575
      Left            =   1080
      TabIndex        =   0
      Top             =   720
      Width           =   3015
   End
   Begin VB.Line Line1 
      X1              =   600
      X2              =   17640
      Y1              =   3000
      Y2              =   3000
   End
   Begin VB.Label lblFile 
      Height          =   255
      Left            =   720
      TabIndex        =   14
      Top             =   2520
      Width           =   16575
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label1 
      Caption         =   "At least this many examples needed for an affix to be considered:"
      Height          =   375
      Left            =   4320
      TabIndex        =   5
      Top             =   2040
      Width           =   4695
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Maxent model of affix discovery

'Current limits:  1-5 segments, prefixes and suffixes.

    Option Explicit
    
'Module-level variables
    
    'The input file and its location
        Dim mInputFileName As String
        Dim mInputFilePath As String
        Dim mOutputFilePath As String
    
    'Encoding the learning data
        Dim mWords() As String
        Dim mWordFrequencies() As Long
        Dim mNumberOfWords As Long          'For looping through the dictionary, including wug forms.
        Dim mNumberOfNonWugWords As Long    'For counting real words, excluding wug forms.
        Dim mNumberOfSilverWords As Long
        Dim mNumberOfWordTokens As Long
    
    'The true data, with prefixes marked as xx[ and suffixes as ]xx.
    '   By "silver standard" is meant that we transcribed the types of the corpus, not the tokens, hence a lesser metal.
        Dim mSilverStandard() As String
        Dim mSilverStandardFrequencies() As Long
        
    'Properties of potential suffixes and suffixes, for assessing violations.
        'Suffixes
            Dim mNumberOfPotentialSuffixes As Long
            Dim mPotentialSuffixes() As String
            'This is the number of words (types or tokens, depending) that begin or end in the potential suffix.
                Dim mFrequencyOfPotentialSuffixes() As Long
            'We collect type and token frequencies separately.
                Dim mTypeFrequencyOfPotentialSuffixes() As Long
                Dim mTokenFrequencyOfPotentialSuffixes() As Long
            
        'Prefixes
            Dim mNumberOfPotentialPrefixes As Long
            Dim mPotentialPrefixes() As String
            Dim mFrequencyOfPotentialPrefixes() As Long
            Dim mTypeFrequencyOfPotentialPrefixes() As Long
            Dim mTokenFrequencyOfPotentialPrefixes() As Long
        'This many are needed to include as a candidate; saves run time, but perhaps losing meaningful results?
            Dim mExampleMinimum As Long
    
    'Properties for assessing constraint violations, used in the MaxEnt method of suffix evaluation, for both Suffixes and Prefixes
        'These are raw counts, later adjusted with suitable denominators.
        'If X exists, how often does X+Suf or Pre+X exist?
            Dim mSuffixRawAttachmentCapacity() As Long
            Dim mPrefixRawAttachmentCapacity() As Long
        'If X+Suf or Pre+X exists, how often does X exist?
            Dim mSuffixParseReliability() As Long
            Dim mPrefixParseReliability() As Long
            '8/21/2021:  For diagnosis, let us also do this with types and tokens.
                Dim mSuffixParseReliabilityTypes() As Long
                Dim mPrefixParseReliabilityTypes() As Long
                Dim mSuffixParseReliabilityTokens() As Long
                Dim mPrefixParseReliabilityTokens() As Long
            
    'Constants for designating a prefix and suffix
        Const mPrefix As Long = 0
        Const mSuffix As Long = 1
        
    'Storing information about candidates
        Dim mAllCandidates() As String
        Dim mCandidateHarmonies() As Single
        Dim mAllProbabilityValues() As Single
        Dim mAllWinners() As Long
        
    'The constraint weights
        Dim mWeightSet As String    'A label, forming the file name minus .txt of the weight file used.
        
        Dim mWStarPrefixed As Single
        Dim mWStarSuffixed As Single
        Dim mWBadStem As Single
        Dim mWAffTooRare As Single
        Dim mWLogFrequentTerminus As Single
        Dim mWAttachCapac As Single
        Dim mWParseReliability  As Single
        Dim mWAffLength As Single
        Dim mWStemLengthRecip As Single
        Dim mWNullStem As Single
        
    'Real affixes, from the Silver Standard
        Dim mNumberOfRealAffixes As Long
        Dim mRealAffixes() As String
        Dim mRealAffixFrequencies() As Long
        
    'Output labels
        Dim DiagnosticLabels As String
    
    'For scaling up to longer affixes
        Const mcMaximumAffixLength As Long = 5
    
Private Sub cmdUseLastTime_Click()

    'This is a special button, useful primarily for debugging, that reads in the file name and path of the most
    '   recent file analyzed.
        
        'But not in auto mode.
            If Command <> "" Then Exit Sub
        
        Open App.Path + "/LastTimesFile.txt" For Input As #1
        Line Input #1, mInputFileName
        Line Input #1, mInputFilePath
        Call MakeOutputFilePath
        Close #1
        Call UpdateCommandButton

End Sub

Sub MakeOutputFilePath()
    
    Let mOutputFilePath = mInputFilePath + "Bottom\"
    
    'Create the folder if needed.
        If Dir$(mOutputFilePath, vbDirectory) = "" Then
            MkDir (mOutputFilePath)
        End If

End Sub


Sub Form_load()

    Dim i As Long, MyLine As String
    
    'If the user drags a file onto the icon then use it; else use the last file (stored info).  We can also parse the Command string when this program
    '   is called by another program.
    
    'Read binary choices off the user-choices file
        Call UpdateInterfaceFromUserFile
        
    'Here, the program has been called by another program, so the string Command is not null.
        If Trim(Command) <> "" Then
            'Parse the Command into filename and path.
                For i = Len(Command) To 1 Step -1
                    Select Case Mid(Command, i, 1)
                        Case "/", "\"
                            Let mInputFileName = s.Capitalize(Mid(Command, i + 1))
                            'Take off the .txt.
                                If Right(mInputFileName, 4) = ".txt" Then
                                    Let mInputFileName = Left(mInputFileName, Len(mInputFileName) - 4)
                                End If
                            
                            Let mInputFilePath = Left(Command, i)
                            Call MakeOutputFilePath
                            'MsgBox "Maxent Bottom is ready to work on " + mInputFileName + "."
                            Load Form1
                            Form1.Show
                            'Let user see what you're working on.
                            Call UpdateCommandButton
                            Call Command1_Click
                            Exit For
                    End Select
                Next i
        End If
        
    'Also, read binary choices off the user-choices file
        Open App.Path + "\LastTimesFile.txt" For Input As #1
        'Ignore file name and path.
            Line Input #1, MyLine
            Line Input #1, MyLine
        'Types or tokens
            Line Input #1, MyLine
            Let MyLine = Trim(MyLine)
            Select Case MyLine
                Case "types"
                    Let optTypes.Value = True
                    Let optToken.Value = False
                Case "tokens"
                    Let optTypes.Value = False
                    Let optToken.Value = True
                Case Else
                    MsgBox "The file called LastTimesFile.txt, line 2, should read either types or tokens.  Please fix this and rerun the program."
                    Close
                    End
            End Select
        'Pearl or Goldwater corpus
            Line Input #1, MyLine
            Let MyLine = LCase(Trim(MyLine))
            Select Case MyLine
                Case "pearl"
                    Let optPearlCorpus.Value = True
                    Let optGoldwaterCorpus.Value = False
                Case "goldwater"
                    Let optPearlCorpus.Value = False
                    Let optGoldwaterCorpus.Value = True
                Case Else
                    MsgBox "The file called LastTimesFile.txt, line 3, should read either Pearl or Goldwater.  Please fix this and rerun the program."
                    Close
                    End
            End Select
                
        Close #1
        
End Sub

Sub UpdateInterfaceFromUserFile()

    'This is a little file that remembers settings from run to run.
    '   One use of it is to set types/tokens and Pearl/Goldwater in place for multi-file run.
        
        Dim MyLine As String
        
        Open App.Path + "\LastTimesFile.txt" For Input As #1
        
        'Ignore file name and path, which will only be obtained from this file if the user clicks a button to that effect.
            Line Input #1, MyLine
            Line Input #1, MyLine
        'Types or tokens
            Line Input #1, MyLine
            Let MyLine = Trim(MyLine)
            Select Case MyLine
                Case "types"
                    Let optTypes.Value = True
                    Let optToken.Value = False
                Case "tokens"
                    Let optTypes.Value = False
                    Let optToken.Value = True
                Case Else
                    MsgBox "The file called LastTimesFile.txt, line 2, should read either types or tokens.  Please fix this and rerun the program."
                    Close
                    End
            End Select
        'Pearl or Goldwater corpus
            Line Input #1, MyLine
            Let MyLine = LCase(Trim(MyLine))
            Select Case MyLine
                Case "pearl"
                    Let optPearlCorpus.Value = True
                    Let optGoldwaterCorpus.Value = False
                Case "goldwater"
                    Let optPearlCorpus.Value = False
                    Let optGoldwaterCorpus.Value = True
                Case Else
                    MsgBox "The file called LastTimesFile.txt, line 3, should read either Pearl or Goldwater.  Please fix this and rerun the program."
                    Close
                    End
            End Select
                
        Close #1
        

End Sub


Private Sub Form_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)

    'Easy way to open a file:  drag it onto the interface.

      Dim FileString As String, i As Long
      
    'Obtain file string
        With Data
            Let FileString = Data.Files.Item(1)
        End With

    'Parse it into filename and path.
        For i = Len(FileString) To 1 Step -1
            Select Case Mid(FileString, i, 1)
                Case "/", "\"
                    Let mInputFileName = Mid(FileString, i + 1)
                    'Take off the .txt.
                        If Right(mInputFileName, 4) = ".txt" Then
                            Let mInputFileName = Left(mInputFileName, Len(mInputFileName) - 4)
                        End If
                    Let mInputFilePath = Left(FileString, i)
                            Call MakeOutputFilePath
                    Exit For
            End Select
        Next i

    Call UpdateCommandButton
    
    Call UpdateLastTimesFile
    
    
End Sub

Sub UpdateLastTimesFile()

    'Save the user choices
        Open App.Path + "/LastTimesFile.txt" For Output As #2
        Print #2, mInputFileName
        Print #2, mInputFilePath
        
        If optTypes Then
            Print #2, "types"
        Else
            Print #2, "tokens"
        End If
        
        If optPearlCorpus Then
            Print #2, "Pearl"
        Else
            Print #2, "Goldwater"
        End If
        
        Close #2

End Sub

Sub UpdateCommandButton()

    'Show file name on the command button, so the user knows it worked; also show the task being performed.
        If chkEvaluateResult.Value = vbChecked Then
            Let Command1.Caption = "Ready to evaluate results of spreadsheet MaxEnt weighting."
        ElseIf chkMakeWeightingFile.Value = vbChecked Then
            Let Command1.Caption = "Ready to create a weight-learning spreadsheet file."
        ElseIf chkEvaluateResult.Value <> vbChecked Then
            Let Command1.Caption = "Ready to report results of applying grammar to the dictionary file."
        Else
            Stop
        End If
        
    'Let's put the file name always in a label window.
        Let lblFile.Caption = "Input file is:  " + mInputFilePath + mInputFileName
        
        DoEvents
        
End Sub

Private Sub Command1_Click()

    'The main command button; executed when user clicks.
    
    Static ButtonStatus As Boolean
    
    'Reuse as exit button.
        If ButtonStatus = True Then
            Close
            End
        End If
        Let ButtonStatus = True
        
    'The user, before pressing Command1, may have made a new choice about types/tokens or corpus;
    '   remember these for future use.
        Call UpdateLastTimesFile
    
    'Force the user to pick types or tokens.
        If optTypes.Value = False And optToken.Value = False Then
            MsgBox "Please pick tokens or types, then click the command button again."
            Exit Sub
        End If
    
    'Read the silver standard first.  It will be used to check errors in the dictionary.
    '  "Silver":  like gold, but we only checked dictionary entries, not the tokens of the corpora.
        If ReadTheSilverStandard = False Then
            Stop
            Exit Sub
        End If
    
    'Don't try to run a null input file name (see below).
        If ReadTheInputFile = True Then
            
            'Caution user about bad input file names.
                If LCase(Left(mInputFileName, 4)) <> "dict" And LCase(Left(mInputFileName, 13)) <> "wugdictionary" Then
                    MsgBox "Caution, I expect an input file that begins with the word dictionary."
                End If
            
            'Interface must be read no matter what.
                Call ReadTheInterface
                Call SetTheWeights
                Call SetTheExampleMinimum
            
            'Three options:
                'run a file with the existing constraints and weights
                'Assume a previous run, and make a file documenting the behavior of discovered affixes.
                'prepare an OTSoft-style file for weight calculation (on silver standard)
                
                If chkMakeWeightingFile <> vbChecked And chkEvaluateResult.Value <> vbChecked Then
                    'Use the standard grammar.
                        Call MakeAListOfPotentialAffixes
                        Call EvaluateAffixesForLanguageLikelihood
                        Call CreateSpreadsheetAndWinnerList("existinggrammar")
                        Call MakeFileOfAllDiscoveredAffixes(mInputFileName)
                ElseIf chkEvaluateResult.Value = vbChecked Then
                    'Utility:  the user has computed maxent weights, collate the predictions.
                        Call MakeFileOfAllDiscoveredAffixes(mInputFileName)
                ElseIf chkMakeWeightingFile = vbChecked Then
                    'Make the OTSoft-style file, for purposes of setting the best-fit weights.
                        Call MakeAListOfPotentialAffixes
                        Call EvaluateAffixesForLanguageLikelihood
                        Call CreateSpreadsheetAndWinnerList("newgrammar")
                Else
                    Stop
                End If
            'Announce completion.
                Close
                'Autoexit if autocalled, else let user exit you.
                    If Command <> "" Then
                        End
                    Else
                        Let Command1.Caption = "Done!  Click again to exit."
                    End If
        End If

End Sub

Sub ReadTheInterface()

    Let mExampleMinimum = Val(Trim(txtExampleMinimum.Text))
    
    'If this file name has "tiny" in it, this should be zero no matter what.
        If Replace(LCase(mInputFileName), "tiny", "") <> LCase(mInputFileName) Then
            Let mExampleMinimum = 0
        End If

End Sub


Function ReadTheInputFile() As Boolean

    Dim MyLine As String, MismatchFound As Boolean
    
    'Detect failure to drag an input file.
        If mInputFileName = "" Then
            Let ReadTheInputFile = False
            Let Command1.Caption = "Please drag an input file onto the interface, and only then click this button."
            Exit Function
        Else
            Let ReadTheInputFile = True
        End If
    
    'Detect failure to drag a dictionary file.
        If LCase(Left(mInputFileName, 10)) <> "dictionary" And LCase(Left(mInputFileName, 13)) <> "wugdictionary" Then
            MsgBox "Caution:  you are running a file whose name does not begin with the word dictionary"
        End If
    
    'Read the words (phonetic notation) and their frequencies, from a tab-delimited file with two columns.
        Open mInputFilePath + mInputFileName + ".txt" For Input As #1
        Do While Not EOF(1)
            Line Input #1, MyLine
            Let MyLine = Trim(MyLine)
            'Protect from blanks.
                If MyLine <> "" Then
                    Let mNumberOfWords = mNumberOfWords + 1
                    ReDim Preserve mWords(mNumberOfWords)
                    ReDim Preserve mWordFrequencies(mNumberOfWords)
                    Let mWords(mNumberOfWords) = Trim(s.Chomp(MyLine))
                    If Not WugWord(mWords(mNumberOfWords)) Then
                        Let mNumberOfNonWugWords = mNumberOfNonWugWords + 1
                    End If
                    Let mWordFrequencies(mNumberOfWords) = Val(Trim(s.Residue(MyLine)))
                    'Count the total tokens.
                        Let mNumberOfWordTokens = mNumberOfWordTokens + mWordFrequencies(mNumberOfWords)
                
                    'Make sure the dictionary file matches the silver standard.
                    '   This can only be imposed when learning from the Pearl file itself; else there is no silver dictionary.
                        If chkMakeWeightingFile.Value = vbChecked Then
                            If BracketDelete(mSilverStandard(mNumberOfWords)) <> mWords(mNumberOfWords) Then
                                If MismatchFound = False Then
                                    MsgBox "Caution:  mismatch at line " + Trim(Str(mNumberOfWords)) + ".  Silver standard:   " + mSilverStandard(mNumberOfWords) + ".  Dictionary:  " + mWords(mNumberOfWords)
                                    Let MismatchFound = True
                                End If
                            End If
                        End If
                End If
        Loop
        Close #1
        
        'Redimension the silver standard file so it won't crash.
            If mNumberOfSilverWords < mNumberOfWords Then
                Let mNumberOfSilverWords = mNumberOfWords
                ReDim Preserve mSilverStandard(mNumberOfSilverWords)
                ReDim Preserve mSilverStandardFrequencies(mNumberOfSilverWords)
            End If
            
        
End Function
    
Function ReadTheSilverStandard() As Boolean
    
    'The true morphological parse, approximated in our "silver standard".
    'It demarcates prefixes with [ and suffixes with ].
    'We will use this to establish the true number of words, thus vetting dictionary files.
    
    Dim MyLine As String, MyFrequencyString As String
    Dim MyAffix As String, AffixIndex As Long
    Dim FileName As String
    
    'This must be handle either the Pearl or the Goldwater corpus (or the Tiny debugging file).
        
        If Replace(LCase(mInputFileName), "tiny", "") <> LCase(mInputFileName) Then
            If optTypes Then
                Open mInputFilePath + "/TinyWordTypesSilverStandard.txt" For Input As #1
            ElseIf optToken Then
                Open mInputFilePath + "/TinyWordTokensSilverStandard.txt" For Input As #1
            End If
            Let ReadTheSilverStandard = True
        ElseIf optPearlCorpus Then
            Open App.Path + "/Files/PearlWordTypesSilverStandard.txt" For Input As #1
            Let ReadTheSilverStandard = True
        ElseIf optGoldwaterCorpus Then
            Open App.Path + "/Files/GoldwaterWordTypesSilverStandard.txt" For Input As #1
            Let ReadTheSilverStandard = True
        Else
            MsgBox "Please select a corpus first."
            Let ReadTheSilverStandard = False
            Exit Function
        End If
        
    
    Do While Not EOF(1)
        Line Input #1, MyLine
        
        'The list now includes wug forms, which should be excluded -- or not?  How else to get correct forms in the tableau?
            Let MyLine = Trim(MyLine)
        
        Let mNumberOfSilverWords = mNumberOfSilverWords + 1
        ReDim Preserve mSilverStandard(mNumberOfSilverWords)
        'Avoid the bogus bronze-standard pseudo affixes.
            Let mSilverStandard(mNumberOfSilverWords) = Trim(s.Chomp(Replace(MyLine, ">", "")))
        ReDim Preserve mSilverStandardFrequencies(mNumberOfSilverWords)
        Let mSilverStandardFrequencies(mNumberOfSilverWords) = Val(Trim(s.Residue(MyLine)))
        'Affixes -- typize
            Let MyAffix = AffixOf(mSilverStandard(mNumberOfSilverWords))
            'None of this should be done for wug forms, marked in silverstandard with frequency zero.
            If mSilverStandardFrequencies(mNumberOfSilverWords) > 0 Then
                For AffixIndex = 1 To mNumberOfRealAffixes
                    If MyAffix = mRealAffixes(AffixIndex) Then
                        'Update frequency according to type or token.
                            If optToken.Value = True Then
                                Let mRealAffixFrequencies(AffixIndex) = mRealAffixFrequencies(AffixIndex) + mSilverStandardFrequencies(mNumberOfSilverWords)
                            Else
                                Let mRealAffixFrequencies(AffixIndex) = mRealAffixFrequencies(AffixIndex) + 1
                            End If
                        GoTo ExitPoint
                    End If
                Next AffixIndex
                'New one, install it.
                    Let mNumberOfRealAffixes = mNumberOfRealAffixes + 1
                    ReDim Preserve mRealAffixes(mNumberOfRealAffixes)
                    ReDim Preserve mRealAffixFrequencies(mNumberOfRealAffixes)
                    Let mRealAffixes(mNumberOfRealAffixes) = MyAffix
                    'Install its frequency according to type or token.
                        If optToken.Value = True Then
                            Let mRealAffixFrequencies(AffixIndex) = mSilverStandardFrequencies(mNumberOfSilverWords)
                        Else
                            Let mRealAffixFrequencies(AffixIndex) = 1
                        End If
            End If
ExitPoint:
    Loop
    
    'Print an affix directory
        Dim AffFile As Long
        Let AffFile = FreeFile
        'Open the file.
        If optToken Then
            Let FileName = "AffixListFor" + mInputFileName + "Tokens.txt"
        Else
            Let FileName = "AffixListFor" + mInputFileName + "Types.txt"
        End If
        Open mOutputFilePath + FileName For Output As #AffFile
        For AffixIndex = 1 To mNumberOfRealAffixes
            Print #AffFile, mRealAffixes(AffixIndex);
            Print #AffFile, Chr(9);
            Print #AffFile, Trim(Str(mRealAffixFrequencies(AffixIndex)));
            Print #AffFile,
        Next AffixIndex
        Close #AffFile
    
    Close #1

End Function

Function WugWord(MyWord As String) As Boolean

    'In the dictionary file, wug words are presented as "qqq".
        If Len(MyWord) < 3 Then Exit Function
        If Left(MyWord, 3) = "qqq" Then
            Let WugWord = True
        ElseIf Right(MyWord, 3) = "qqq" Then
            Let WugWord = True
        End If

End Function

Function RealAffix(MyAffix As String) As Boolean

    'For use in not penalizing rare real affixes below.
        Dim i As Long
        For i = 1 To mNumberOfRealAffixes
            If MyAffix = mRealAffixes(i) Then
                Let RealAffix = True
                Exit Function
            End If
        Next i
        
End Function

Function AffixOf(MyWord As String) As String

    Dim i As Long
    For i = 1 To Len(MyWord)
        Select Case Mid(MyWord, i, 1)
            Case "["
                Let AffixOf = Left(MyWord, i)
                Exit Function
            Case "]"
                Let AffixOf = Mid(MyWord, i)
                Exit Function
        End Select
    Next i
    Let AffixOf = ""
    
End Function



Sub SetTheWeights()

    'We have been exploring various ways to set the constraint weights.
    '   These are placed in labeled files.  The one to use right now is placed in App.Path + "/files/LocationOfWeights.txt".
    '   This is kludgy, but helps when this program is run over and over in a diachronic simulation.
    
    'This routine looks up the weights (in the Files part of the application folder) and records them for reference and clarity
    '    in the output folder for the corpus being analysed.
    
    Dim MyLine As String, MyConstraintName As String
    Dim WeightFile As Long, WeightLocationFile As Long, RemWeightFile As Long
    
    'Look up the name of the weight file in the Files folder, daughter of App.path.
        Let WeightLocationFile = FreeFile
        Open App.Path + "/files/LocationOfWeights.txt" For Input As #WeightLocationFile
        Line Input #WeightLocationFile, MyLine
        Let MyLine = Trim(MyLine)
        'Store just the name, not the .txt suffix.
            If Right(MyLine, 4) = ".txt" Then
                Let mWeightSet = Left(MyLine, Len(MyLine) - 4)
            Else
                Let mWeightSet = MyLine
            End If
        Close WeightLocationFile
        
    'Open the weight file whose location you just determined.
        Let WeightFile = FreeFile
        Open App.Path + "/files/weights/" + mWeightSet + ".txt" For Input As #WeightFile
    
    'Also, open the  file that will remember the weights you used.
        Let RemWeightFile = FreeFile
        Open mOutputFilePath + "WeightsEmployed.txt" For Output As #RemWeightFile
    
    'Print the id for the particular weight set as first line in remembrance file.
            Print #RemWeightFile, mWeightSet
    
    'Penalty for being a prefix.
        Let MyConstraintName = "*Prefixed"
        Line Input #WeightFile, MyLine
        'Check that the file is of good format.
            If s.Chomp(MyLine) <> MyConstraintName Then Stop
        Let mWStarPrefixed = Val(s.Residue(MyLine))
        'Record this constraint name and weight in the remembrance file.
            Print #RemWeightFile, MyConstraintName; Chr(9); Val(s.Residue(MyLine))
        
    'Penalty for being a suffix.
        Let MyConstraintName = "*Suffixed"
        Line Input #WeightFile, MyLine
        If s.Chomp(MyLine) <> MyConstraintName Then Stop
        Let mWStarSuffixed = Val(s.Residue(MyLine))
        Print #RemWeightFile, MyConstraintName; Chr(9); Val(s.Residue(MyLine))
        
    'Does the affix attach to a real stem (defined as able to occur in isolation)?
        Let MyConstraintName = "*BadStem"
        Line Input #WeightFile, MyLine
        If s.Chomp(MyLine) <> MyConstraintName Then Stop
        Let mWBadStem = Val(s.Residue(MyLine))
        Print #RemWeightFile, MyConstraintName; Chr(9); Val(s.Residue(MyLine))
        
    'Is the affix too rare to be considered?  We encode this as a violation.
        Let MyConstraintName = "*AffTooRare"
        Line Input #WeightFile, MyLine
        If s.Chomp(MyLine) <> MyConstraintName Then Stop
        Let mWAffTooRare = Val(s.Residue(MyLine))
        Print #RemWeightFile, MyConstraintName; Chr(9); Val(s.Residue(MyLine))
        
    'Do a lot of words end in (resp. start) with this affix?  Log domain.
        Let MyConstraintName = "LogFreqTerminus"
        Line Input #WeightFile, MyLine
        If s.Chomp(MyLine) <> MyConstraintName Then Stop
        Let mWLogFrequentTerminus = Val(s.Residue(MyLine))
        Print #RemWeightFile, MyConstraintName; Chr(9); Val(s.Residue(MyLine))
        
    'When you have a word, how often is the result of attaching this affix also a word?  Currently inactive.
        Let MyConstraintName = "AttachCapac"
        Line Input #WeightFile, MyLine
        If s.Chomp(MyLine) <> MyConstraintName Then Stop
        Let mWAttachCapac = Val(s.Residue(MyLine))
        Print #RemWeightFile, MyConstraintName; Chr(9); Val(s.Residue(MyLine))
        
    'When this suffix appears at the end of a word (resp. prefix at beginning), how often is the residue a word?
        Let MyConstraintName = "ParseReliability"
        Line Input #WeightFile, MyLine
        If s.Chomp(MyLine) <> MyConstraintName Then Stop
        Let mWParseReliability = Val(s.Residue(MyLine))
        Print #RemWeightFile, MyConstraintName; Chr(9); Val(s.Residue(MyLine))
        
    'Affix length
        Let MyConstraintName = "AffLength"
        Line Input #WeightFile, MyLine
        If s.Chomp(MyLine) <> MyConstraintName Then Stop
        Let mWAffLength = Val(s.Residue(MyLine))
        Print #RemWeightFile, MyConstraintName; Chr(9); Val(s.Residue(MyLine))
        
    'Null stems are forbidden.
        Let MyConstraintName = "StarNullStem"
        Line Input #WeightFile, MyLine
        If s.Chomp(MyLine) <> MyConstraintName Then Stop
        Let mWNullStem = Val(s.Residue(MyLine))
        Print #RemWeightFile, MyConstraintName; Chr(9); Val(s.Residue(MyLine))
        
    'Stems tend to be long -- penalize by reciprocal.
        Let MyConstraintName = "StemLenRecip"
        Line Input #WeightFile, MyLine
        If s.Chomp(MyLine) <> MyConstraintName Then Stop
        Let mWStemLengthRecip = Val(s.Residue(MyLine))
        Print #RemWeightFile, MyConstraintName; Chr(9); Val(s.Residue(MyLine))
        
        Close #RemWeightFile
        
End Sub


Sub SetTheExampleMinimum()

    'This is originally set on the interface, with override for "tiny" files.
    'However, it needs to be higher for tokens, by the overall token/type ratio.
        If optToken Then
            Let mExampleMinimum = mExampleMinimum * mNumberOfWordTokens / mNumberOfWords
        End If

End Sub


Sub MakeAListOfPotentialAffixes()

    'These are defined as all right-edge, resp. left-edge, strings of length 1 or 2.

    Dim MyWord As String, MyFrequency As Long, MySuffix As String, MyPrefix As String
    Dim WordIndex As Long, LengthIndex As Long, SuffixIndex As Long, PrefixIndex As Long
    
    'Report progress
        Let Command1.Caption = "Discovering potential suffixes ..."
        DoEvents
    
    For LengthIndex = 1 To mcMaximumAffixLength
        For WordIndex = 1 To mNumberOfWords
            Let MyWord = mWords(WordIndex)
            Let MyFrequency = mWordFrequencies(WordIndex)
            'Suffixes
                Let MySuffix = Right(MyWord, LengthIndex)
                'Typize
                    For SuffixIndex = 1 To mNumberOfPotentialSuffixes
                        If MySuffix = mPotentialSuffixes(SuffixIndex) Then
                            'Don't augment counts if this word is a wug-word. An affix that occurs only in wug words should have zero frequency.
                            '"wug" yields the prefix w[ so we use qqq
                                If Left(MyWord, 3) <> "qqq" Then
                                    'Augment frequency, following either types or tokens.
                                        Let mTypeFrequencyOfPotentialSuffixes(SuffixIndex) = mTypeFrequencyOfPotentialSuffixes(SuffixIndex) + 1
                                        Let mTokenFrequencyOfPotentialSuffixes(SuffixIndex) = mTokenFrequencyOfPotentialSuffixes(SuffixIndex) + MyFrequency
                                        'The one used in modeling.
                                            If optTypes Then
                                                Let mFrequencyOfPotentialSuffixes(SuffixIndex) = mFrequencyOfPotentialSuffixes(SuffixIndex) + 1
                                            ElseIf optToken Then
                                                Let mFrequencyOfPotentialSuffixes(SuffixIndex) = mFrequencyOfPotentialSuffixes(SuffixIndex) + MyFrequency
                                            End If
                                End If
                            'Skip code for new items.
                                GoTo SuffixExitPoint
                        End If
                    Next SuffixIndex
                    'New entry
                        Let mNumberOfPotentialSuffixes = mNumberOfPotentialSuffixes + 1
                        ReDim Preserve mPotentialSuffixes(mNumberOfPotentialSuffixes)
                        'Frequency measures:
                            ReDim Preserve mFrequencyOfPotentialSuffixes(mNumberOfPotentialSuffixes)
                            ReDim Preserve mTypeFrequencyOfPotentialSuffixes(mNumberOfPotentialSuffixes)
                            ReDim Preserve mTokenFrequencyOfPotentialSuffixes(mNumberOfPotentialSuffixes)
                        ReDim Preserve mSuffixRawAttachmentCapacity(mNumberOfPotentialSuffixes)
                        ReDim Preserve mSuffixParseReliability(mNumberOfPotentialSuffixes)
                        ReDim Preserve mSuffixParseReliabilityTypes(mNumberOfPotentialSuffixes)
                        ReDim Preserve mSuffixParseReliabilityTokens(mNumberOfPotentialSuffixes)
                        Let mPotentialSuffixes(mNumberOfPotentialSuffixes) = MySuffix
                        
                        'Initial frequency is either 1 (for types) or MyFrequency (for tokens).
                        '   For wug words, we want their suffixes to enter the catalog, but with a frequency of zero.
                            If Left(MyWord, 3) <> "qqq" Then
                                'This is doubly encoded, I guess for debugging purposes.  Clean up?
                                    Let mTypeFrequencyOfPotentialSuffixes(SuffixIndex) = 1
                                    Let mTokenFrequencyOfPotentialSuffixes(SuffixIndex) = MyFrequency
                                    If optTypes Then
                                        Let mFrequencyOfPotentialSuffixes(mNumberOfPotentialSuffixes) = 1
                                        'msgbox "Adding initial token of the suffix ]" + MySuffix + ", based on:  " + MyWord + ". Count is now at " + Trim(Str(mFrequencyOfPotentialSuffixes(SuffixIndex))) + "."
                                    ElseIf optToken Then
                                        Let mFrequencyOfPotentialSuffixes(mNumberOfPotentialSuffixes) = MyFrequency
                                        'msgbox "Adding initial token set of the suffix ]" + MySuffix + ", based on:  " + MyWord + ". Count is now at " + Trim(Str(mFrequencyOfPotentialSuffixes(SuffixIndex))) + "."
                                    End If
                            End If
                            
SuffixExitPoint:

            'Prefixes
                Let MyPrefix = Left(MyWord, LengthIndex)
                'Typize
                    For PrefixIndex = 1 To mNumberOfPotentialPrefixes
                        If MyPrefix = mPotentialPrefixes(PrefixIndex) Then
                                If Right(MyWord, 3) <> "qqq" Then
                                    'Augment frequency, following either types or tokens.
                                        Let mTypeFrequencyOfPotentialPrefixes(PrefixIndex) = mTypeFrequencyOfPotentialPrefixes(PrefixIndex) + 1
                                        Let mTokenFrequencyOfPotentialPrefixes(PrefixIndex) = mTokenFrequencyOfPotentialPrefixes(PrefixIndex) + MyFrequency
                                        If optTypes Then
                                            Let mFrequencyOfPotentialPrefixes(PrefixIndex) = mFrequencyOfPotentialPrefixes(PrefixIndex) + 1
                                        ElseIf optToken Then
                                            Let mFrequencyOfPotentialPrefixes(PrefixIndex) = mFrequencyOfPotentialPrefixes(PrefixIndex) + MyFrequency
                                        End If
                                End If
                            'Skip code for new items.
                                GoTo PrefixExitPoint
                        End If
                    Next PrefixIndex
                    'New entry
                        Let mNumberOfPotentialPrefixes = mNumberOfPotentialPrefixes + 1
                        ReDim Preserve mPotentialPrefixes(mNumberOfPotentialPrefixes)
                        'Frequency measures:
                            ReDim Preserve mFrequencyOfPotentialPrefixes(mNumberOfPotentialPrefixes)
                            ReDim Preserve mTypeFrequencyOfPotentialPrefixes(mNumberOfPotentialPrefixes)
                            ReDim Preserve mTokenFrequencyOfPotentialPrefixes(mNumberOfPotentialPrefixes)
                        ReDim Preserve mPrefixRawAttachmentCapacity(mNumberOfPotentialPrefixes)
                        ReDim Preserve mPrefixParseReliability(mNumberOfPotentialPrefixes)
                        ReDim Preserve mPrefixParseReliabilityTypes(mNumberOfPotentialPrefixes)
                        ReDim Preserve mPrefixParseReliabilityTokens(mNumberOfPotentialPrefixes)
                        Let mPotentialPrefixes(mNumberOfPotentialPrefixes) = MyPrefix
                        'Initial frequency is either 1 (for types) or MyFrequency (for tokens)
                            'Not for wug words.
                                If Right(MyWord, 3) <> "qqq" Then
                                    Let mTypeFrequencyOfPotentialPrefixes(PrefixIndex) = 1
                                    Let mTokenFrequencyOfPotentialPrefixes(PrefixIndex) = MyFrequency
                                    If optTypes Then
                                        Let mFrequencyOfPotentialPrefixes(mNumberOfPotentialPrefixes) = 1
                                    ElseIf optToken Then
                                        Let mFrequencyOfPotentialPrefixes(mNumberOfPotentialPrefixes) = MyFrequency
                                    End If
                                End If
PrefixExitPoint:
WugExitPoint:

        Next WordIndex      'Go through all the words in the learning corpus.
    Next LengthIndex        'Try all legal affix lengths.
    
    
End Sub

Sub EvaluateAffixesForLanguageLikelihood()

    'Raw frequency of the affixes, done without regard to the "stems" they define.
        Dim MySuffixFrequency As Long
        Dim MyPrefixFrequency As Long
    
    'Localizers
        Dim MyWord As String, MyFrequency As Long, MySuffix As String, MySuffixLength As Long, MyPrefix As String, MyPrefixLength As Long
    
    'Indices
        Dim PotentialSuffixIndex As Long, PotentialPrefixIndex As Long, LocalLexiconIndex As Long, WordIndex As Long
    
'SUFFIXES:
    'Loop over all candidate suffixes
        For PotentialSuffixIndex = 1 To mNumberOfPotentialSuffixes
        
            'Report progress.
                If PotentialSuffixIndex Mod 10 = 0 Then
                    Let Command1.Caption = "Checking potential suffixes, done with " + Trim(Str(PotentialSuffixIndex)) + "/" + Trim(Str(mNumberOfPotentialSuffixes))
                    DoEvents
                End If
        
            'Localize for clarity.
                Let MySuffix = mPotentialSuffixes(PotentialSuffixIndex)
                Let MySuffixLength = Len(MySuffix)
            
            'Skip rare pseudo affixes, which will be penalized by a blanket constraint.  But evaluate real ones no matter how rare.
                Let MySuffixFrequency = mFrequencyOfPotentialSuffixes(PotentialSuffixIndex)
                If MySuffixFrequency <= mExampleMinimum Then
                    If Not RealAffix("]" + MySuffix) Then
                        GoTo SuffixExitPoint
                    End If
                End If
            
            'Calculate attachment capability and parse reliability.
                For WordIndex = 1 To mNumberOfWords
                    'Localize
                        Let MyWord = mWords(WordIndex)
                    
                    'This must not be calculated based on wug words.
                        If Not WugWord(MyWord) Then
                            'Attachment capacity.  Currently not used.
                                'The function LocalWordFrequency() returns 1 for type learning, the word frequency for token learning.
                                    If IsAWord(MyWord + MySuffix) Then
                                        Let mSuffixRawAttachmentCapacity(PotentialSuffixIndex) = mSuffixRawAttachmentCapacity(PotentialSuffixIndex) + LocalWordFrequency(WordIndex)
                                        'If MySuffix = "i" Then MsgBox "now has attachment capacity of " + Str(mSuffixRawAttachmentCapacity(PotentialSuffixIndex))
                                    End If
                            'Parse reliability.
                                'Don't crash if word is too short.
                                    If Len(MyWord) > Len(MySuffix) Then
                                        If Right(MyWord, Len(MySuffix)) = MySuffix Then
                                            If IsAWord(Left(MyWord, Len(MyWord) - Len(MySuffix))) Then
                                                Let mSuffixParseReliability(PotentialSuffixIndex) = mSuffixParseReliability(PotentialSuffixIndex) + LocalWordFrequency(WordIndex)
                                                'Keep records of types and tokens:
                                                    Let mSuffixParseReliabilityTypes(PotentialSuffixIndex) = mSuffixParseReliabilityTypes(PotentialSuffixIndex) + 1
                                                    Let mSuffixParseReliabilityTokens(PotentialSuffixIndex) = mSuffixParseReliabilityTokens(PotentialSuffixIndex) + mWordFrequencies(WordIndex)
                                                'If MySuffix = "z" Then MsgBox MySuffix + " now has parsing reliability of " + Str(mSuffixParseReliability(PotentialSuffixIndex)) + ", thanks to word " + MyWord
                                            End If
                                        End If
                                    End If
                        End If
                        
                Next WordIndex
        
SuffixExitPoint:
        Next PotentialSuffixIndex
        
'PREFIXES:
    'Loop over all candidate Prefixes
        For PotentialPrefixIndex = 1 To mNumberOfPotentialPrefixes
        
            'Report progress.
                If PotentialPrefixIndex Mod 10 = 0 Then
                    Let Command1.Caption = "Checking potential prefixes, done with " + Trim(Str(PotentialPrefixIndex)) + "/" + Trim(Str(mNumberOfPotentialPrefixes))
                    DoEvents
                End If
        
            'Localize.
                Let MyPrefix = mPotentialPrefixes(PotentialPrefixIndex)
                Let MyPrefixLength = Len(MyPrefix)
            
            'Skip rare pseudo affixes, which will be penalized by a blanket constraint.  But evaluate real ones no matter how rare.
                Let MyPrefixFrequency = mFrequencyOfPotentialPrefixes(PotentialPrefixIndex)
                If MyPrefixFrequency <= mExampleMinimum Then
                    If Not RealAffix(MyPrefix + "[") Then
                        GoTo PrefixExitPoint
                    End If
                End If
            
            'Attachment capability and parsing reliability
                For WordIndex = 1 To mNumberOfWords
                    Let MyWord = mWords(WordIndex)
                    'This must not be calculated based on wug words.
                        If Not WugWord(MyWord) Then
                            If IsAWord(MyPrefix + MyWord) Then
                                Let mPrefixRawAttachmentCapacity(PotentialPrefixIndex) = mPrefixRawAttachmentCapacity(PotentialPrefixIndex) + LocalWordFrequency(WordIndex)
                            End If
                            If Len(MyWord) > Len(MyPrefix) Then
                                If Left(MyWord, Len(MyPrefix)) = MyPrefix Then
                                    If IsAWord(Mid(MyWord, Len(MyPrefix) + 1)) Then
                                        Let mPrefixParseReliability(PotentialPrefixIndex) = mPrefixParseReliability(PotentialPrefixIndex) + LocalWordFrequency(WordIndex)
                                    End If
                                End If
                            End If
                        End If
                        
                Next WordIndex          'Examine all words with respect to this prefix.
PrefixExitPoint:
        Next PotentialPrefixIndex       'Examine all candidate prefixes.
        
        
End Sub

Function LocalWordFrequency(MyWordIndex As Long) As Long

    'This is 1 for type learning, the word frequency if token learning.
        If optTypes Then
            'Not wug words
                If mWordFrequencies(MyWordIndex) > 0 Then
                    Let LocalWordFrequency = 1
                Else
                    Let LocalWordFrequency = 0
                End If
        Else
            Let LocalWordFrequency = mWordFrequencies(MyWordIndex)
        End If

End Function

Sub CreateSpreadsheetAndWinnerList(Task As String)

    Dim FileName As String
    Dim WordIndex As Long, MyWord As String, MyStem As String
    Dim MySuffix As String, MyParse As String, SuffixLengthIndex As Long, MyPrefix As String, PrefixLengthIndex As Long
    Dim CandidateNumber As Long
    Dim SpreadsheetFile As Long, WinnerFile As Long, WugFile As Long
    'Variables for establishing winners in the existing grammar.
        Dim WinningParse As String
        Dim CurrentHarmony As Single, BestHarmony As Single
        Dim LocalHarmony() As Single
        Dim LocalCandidate() As String
        Dim LocalEHarmony() As Double
        Dim MyViolationString As String
        Dim Z As Single
        Dim i As Long
    
    Dim NumberOfCandidates As Long
    Let NumberOfCandidates = 2 * mcMaximumAffixLength + 1
    
    'Redimension arrays that depend on the longest affix length searched.
        ReDim LocalHarmony(NumberOfCandidates) As Single
        ReDim LocalCandidate(NumberOfCandidates) As String
        ReDim LocalEHarmony(NumberOfCandidates) As Double
    
    'Open the spreadsheet file for output.
        If optToken Then
            Let FileName = "MaxEntFileFor" + mInputFileName + "Tokens.txt"
        Else
            Let FileName = "MaxEntFileFor" + mInputFileName + "Types.txt"
        End If
        Let SpreadsheetFile = FreeFile
        Open mOutputFilePath + "/" + FileName For Output As #SpreadsheetFile
    
    'Open the winner file.
        Let FileName = "Parsed" + mInputFileName + ".txt"
        Let WinnerFile = FreeFile
        Open mInputFilePath + "/" + FileName For Output As #WinnerFile

    'On the spreadsheet, print the header.
            Print #SpreadsheetFile, "Input";
            Print #SpreadsheetFile, Chr(9);
            Print #SpreadsheetFile, "Cand #";
            Print #SpreadsheetFile, Chr(9);
            Print #SpreadsheetFile, "Cand";
            Print #SpreadsheetFile, Chr(9);
            Print #SpreadsheetFile, "Winner";
            Print #SpreadsheetFile, Chr(9);
            Print #SpreadsheetFile, "Harmony";
            Print #SpreadsheetFile, ViolationString(0, "", "", "", 0, Task);
            Print #SpreadsheetFile,
        
    'Print the precomputed weights
            Print #SpreadsheetFile, Chr(9);
            Print #SpreadsheetFile, Chr(9);
            Print #SpreadsheetFile, Chr(9);
            Print #SpreadsheetFile, Chr(9);
            Print #SpreadsheetFile, ViolationString(-1, "", "", "", 0, Task);
            Print #SpreadsheetFile,
    
    'Inputs, candidates, violations
        For WordIndex = 1 To mNumberOfWords
        
            'Initialize the metric for best parse at an unrealistically high value.
               Let BestHarmony = 1000000
            
            Let MyWord = mWords(WordIndex)
            
            'Initialize the numbering of the candidates
                Let CandidateNumber = 0
            
            'Try zero, plus all planned lengths, for suffixes
                For SuffixLengthIndex = 0 To mcMaximumAffixLength
                    
                    'Characterize the candidate.
                        If SuffixLengthIndex = 0 Then
                            'Unaffixed form
                                Let MyParse = MyWord
                                Let LocalCandidate(SuffixLengthIndex + 1) = MyParse
                                Let MyStem = MyWord
                                Let MySuffix = ""
                        Else
                            If Len(MyWord) < SuffixLengthIndex Then
                                'Weird case; it's all suffix.
                                    Let MyStem = ""
                                    Let MySuffix = MyWord
                                    Let MyParse = "]" + MySuffix
                                    Let LocalCandidate(SuffixLengthIndex + 1) = MyParse
                            Else
                                'Normal case with noticeable stem and suffix
                                    Let MyStem = Left(MyWord, Len(MyWord) - SuffixLengthIndex)
                                    Let MySuffix = Right(MyWord, SuffixLengthIndex)
                                    Let MyParse = MyStem + "]" + MySuffix
                                    Let LocalCandidate(SuffixLengthIndex + 1) = MyParse
                            End If
                        End If
                    
                    'For the spreadsheet, print the word, the number of the candidate, and the candidate.
                            'Word and parse:
                                Print #SpreadsheetFile, MyWord;
                                Print #SpreadsheetFile, Chr(9);
                                Let CandidateNumber = CandidateNumber + 1
                                Print #SpreadsheetFile, Trim(Str(CandidateNumber));
                                Print #SpreadsheetFile, Chr(9);
                                Print #SpreadsheetFile, MyParse;
                                Print #SpreadsheetFile, Chr(9);
                            'Winner?
                                'Check for error.  This only works right now with the full file, since we don't have silver standards for all
                                '   the sample, or means to derive them.
                                    'If chkMakeWeightingFile.Value = vbChecked Then
                                        If NoBrackets(mSilverStandard(WordIndex)) <> NoBrackets(MyParse) Then
                                        '    MsgBox "Silver standard doesn't match dictionary:  silver " + NoBrackets(mSilverStandard(WordIndex)) + " vs. dictionary " + NoBrackets(MyParse)
                                        End If
                                    'End If
                            
                                If mSilverStandard(WordIndex) = MyParse Then
                                    'Winners can be reported either with types (frequency 1) or tokens (corpus frequency)
                                        If optTypes Then
                                            Print #SpreadsheetFile, "1";
                                        Else
                                            Print #SpreadsheetFile, Trim(Str(mSilverStandardFrequencies(WordIndex)));
                                        End If
                                End If
                                Print #SpreadsheetFile, Chr(9);
                            
                            'Violation string, created by a separate routine.  Put it in local variable.
                                'mSuffix is a parameter causing violations to be assessed with regard to suffixes.
                                Let MyViolationString = ViolationString(WordIndex, MyWord, MyStem, MySuffix, mSuffix, "newgrammar")
                                
                            'Print the violations.
                                Print #SpreadsheetFile, MyViolationString;
                                    
                            'End of tableau line
                                Print #SpreadsheetFile,
                        
                            'We also wish to assess the standard grammar on this file.
                                'We use the first element of ViolationsString(), which has the harmony in it.
                                Let CurrentHarmony = Val(s.Chomp(MyViolationString))
                                'MsgBox "CurrentHarmony is:  " + Str(CurrentHarmony)
                                Let LocalHarmony(SuffixLengthIndex + 1) = CurrentHarmony
                                If CurrentHarmony < BestHarmony Then
                                    Let WinningParse = Trim(MyStem + "]" + MySuffix)
                                    Let BestHarmony = CurrentHarmony
                                End If
                
                Next SuffixLengthIndex      'Go through suffix lengths of 0-2.
        
            'Try one, two-segment prefixes. We omit zero because it's already been done with the suffixes.
                For PrefixLengthIndex = 1 To mcMaximumAffixLength
                    
                    'Characterize the candidate.
                        If PrefixLengthIndex = 0 Then
                            'Unaffixed form
                                Let MyParse = MyWord
                                Let LocalCandidate(PrefixLengthIndex + mcMaximumAffixLength + 1) = MyParse
                                Let MyStem = MyWord
                                Let MyPrefix = ""
                        Else
                            If Len(MyWord) < PrefixLengthIndex Then
                                'Weird case; it's all prefix.
                                    Let MyStem = ""
                                    Let MyPrefix = MyWord
                                    Let MyParse = MyPrefix + "["
                                    Let LocalCandidate(PrefixLengthIndex + mcMaximumAffixLength + 1) = MyParse
                            Else
                                'Normal case with noticeable prefix and stem.
                                    Let MyStem = Mid(MyWord, PrefixLengthIndex + 1)
                                    Let MyPrefix = Left(MyWord, PrefixLengthIndex)
                                    Let MyParse = MyPrefix + "[" + MyStem
                                    Let LocalCandidate(PrefixLengthIndex + mcMaximumAffixLength + 1) = MyParse
                            End If
                        End If
                    
                    'For the spreadsheet, print the word, the number of the candidate, and the candidate.
                            
                            'Print the word, the number of the candidate, and the candidate.
                                Print #SpreadsheetFile, MyWord;
                                Print #SpreadsheetFile, Chr(9);
                                Let CandidateNumber = CandidateNumber + 1
                                Print #SpreadsheetFile, Trim(Str(CandidateNumber));
                                Print #SpreadsheetFile, Chr(9);
                                Print #SpreadsheetFile, MyParse;
                                Print #SpreadsheetFile, Chr(9);
                            'Winner?
                                'Check for error.
                                    If chkMakeWeightingFile.Value = vbChecked Then
                                        If NoBrackets(mSilverStandard(WordIndex)) <> NoBrackets(MyParse) Then
                                            MsgBox "Silver standard doesn't match dictionary:  silver " + NoBrackets(mSilverStandard(WordIndex)) + " vs. dictionary " + NoBrackets(MyParse)
                                        End If
                                    End If
                                If mSilverStandard(WordIndex) = MyParse Then
                                    'Winners can be reported either with types (frequency 1) or tokens (corpus frequency)
                                        If optTypes Then
                                            Print #SpreadsheetFile, "1";
                                        Else
                                            Print #SpreadsheetFile, Trim(Str(mSilverStandardFrequencies(WordIndex)));
                                        End If
                                End If
                                Print #SpreadsheetFile, Chr(9);
                            
                            
                            'Violation string, created by a separate routine.  Put it in local variable.
                                'mSuffix is a parameter causing violations to be assessed with regard to suffixes.
                                Let MyViolationString = ViolationString(WordIndex, MyWord, MyStem, MyPrefix, mPrefix, Task)
                                
                            'Print the violations.
                                Print #SpreadsheetFile, MyViolationString;
                                    
                            'End of tableau line
                                Print #SpreadsheetFile,
                        
                            'We also wish to assess the standard grammar on this file.
                                'We use the ViolationsString() in its numerical avatar (selected via check boxes) to assess harmony.
                                    Let CurrentHarmony = Val(s.Chomp(MyViolationString))
                                    'Let CurrentHarmony = Val(ViolationString(WordIndex, MyWord, MyStem, MyPrefix, mPrefix, Task))
                                    Let LocalHarmony(PrefixLengthIndex + mcMaximumAffixLength + 1) = CurrentHarmony
                                    If CurrentHarmony < BestHarmony Then
                                        Let WinningParse = Trim(MyPrefix + "[" + MyStem)
                                        Let BestHarmony = CurrentHarmony
                                    End If
                        
                Next PrefixLengthIndex      'Try both prefix lengths.
                
                'Under simple evaluation of the standard model, we simply print the winning candidate (given
                '   the grammar, there will not be ties (stem length different).
                    Print #WinnerFile, WinningParse
                    'MsgBox "Printed out the winning parse " + WinningParse
        
                'Doing the MaxEnt calculations, placing candidates and probabilities all in one single array along the way.
                    ReDim Preserve mAllProbabilityValues(NumberOfCandidates, WordIndex)
                    ReDim Preserve mAllCandidates(NumberOfCandidates, WordIndex)
                    ReDim Preserve mAllWinners(WordIndex)
                    'Let zeroth entry be the input.
                        Let mAllCandidates(0, WordIndex) = MyWord
                    'Now the MaxEnt:
                        Let Z = 0
                        For i = 1 To NumberOfCandidates
                            Let mAllCandidates(i, WordIndex) = LocalCandidate(i)
                            If LocalHarmony(i) < -500 Then Stop
                            '    Let LocalEHarmony(i) = Exp(-500)
                            'Else
                                Let LocalEHarmony(i) = Exp(-LocalHarmony(i))
                            'End If
                            Let Z = Z + LocalEHarmony(i)
                        Next i
                        For i = 1 To NumberOfCandidates
                            Let mAllProbabilityValues(i, WordIndex) = LocalEHarmony(i) / Z
                        Next i
                        Let BestHarmony = 1000000
                        'Record the winner
                            For i = 1 To NumberOfCandidates
                                If LocalHarmony(i) < BestHarmony Then
                                    Let mAllWinners(WordIndex) = i
                                    Let BestHarmony = LocalHarmony(i)
                                End If
                            Next i
        
        Next WordIndex                      'Go through all the words in the training data.
        
        Close #WinnerFile
        Close #SpreadsheetFile
        
        'Create a probability list.
            Dim PListFile As Long
            Let PListFile = FreeFile
            Open mOutputFilePath + "ProbabilityListFor" + mInputFileName + ".txt" For Output As #PListFile
            For WordIndex = 1 To mNumberOfWords
                For i = 1 To NumberOfCandidates
                    Print #PListFile, mAllCandidates(i, WordIndex);
                    Print #PListFile, Chr(9);
                    If i = mAllWinners(WordIndex) Then
                        If optToken Then
                            Print #PListFile, Trim(Str(mSilverStandardFrequencies(WordIndex)));
                        ElseIf optTypes Then
                            Print #PListFile, "1";
                        Else
                            Stop
                        End If
                    Else
                        Print #PListFile, "0";
                    End If
                    Print #PListFile, Chr(9);
                    Print #PListFile, Trim(Str(mAllProbabilityValues(i, WordIndex)))
                Next i
            Next WordIndex
        
            Close #PListFile
            
        'PREDICTIONS
        'Append to a wug-test output file, assuming certain wug words were included in the input.
            'Open the file.  It must be created or appended to, depending on whether it already exists.
                    Dim MyFile As String
                    Let WugFile = FreeFile
                'Informative file name:
                    'Let MyFile = App.Path + "/Files/WugTestResults_W" + mWeightSet + ".txt"
                'Uniform file name, so DDR can delete it at the start of long run:
                    Let MyFile = App.Path + "/Files/WugTestResults.txt"
                    If Dir$(MyFile) = "" Then
                        Open MyFile For Output As #WugFile
                    Else
                        Open MyFile For Append As #WugFile
                    End If
                'Print a header.
                    'Sort index, to remove extra headers.
                        Print #WugFile, "1";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "Date";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "Time";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "Folder";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "File";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "wug]z";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "wug]s";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "wug]d";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "wug]t";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "wug]IG";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "wug]i";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "wug]R";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "wug]nt";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "wug]li";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "wug]Id";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "wug]Iz";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "wug]xl";
                    'Print #WugFile, Chr(9);
                    'Print #WugFile,
                    'Print #WugFile, "wug]S";
                    'Print #WugFile, Chr(9);
                    'Print #WugFile,
                    'Print #WugFile, "IG[wug";
                    'Print #WugFile, Chr(9);
                    'Print #WugFile,
                    'Print #WugFile, "z[wug";
                    'Print #WugFile, Chr(9);
                    Print #WugFile,
                'Identify this trial.
                    Print #WugFile, "2";
                    Print #WugFile, Chr(9);
                    Print #WugFile, Date;
                    Print #WugFile, Chr(9);
                    Print #WugFile, Time;
                    Print #WugFile, Chr(9);
                    Print #WugFile, mInputFilePath;
                    Print #WugFile, Chr(9);
                    Print #WugFile, mInputFileName;
                'Find the suffixed candidates of the wug words and fill them out.
                    For WordIndex = 1 To mNumberOfWords
                        For i = 1 To NumberOfCandidates
                            Select Case mAllCandidates(i, WordIndex)
                                'Case "wug]z"
                                Case "qqq]z"
                                    Print #WugFile, Chr(9);
                                    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "wug]s"
                                Case "qqq]s"
                                    Print #WugFile, Chr(9);
                                    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "wug]d"
                                Case "qqq]d"
                                    Print #WugFile, Chr(9);
                                    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "wug]t"
                                Case "qqq]t"
                                    Print #WugFile, Chr(9);
                                    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "wug]IG"
                                Case "qqq]IG"
                                    Print #WugFile, Chr(9);
                                    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "wug]i", "qqq]i"
                                Case "qqq]i"
                                    Print #WugFile, Chr(9);
                                    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "wug]R"
                                Case "qqq]R"
                                    Print #WugFile, Chr(9);
                                    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "wug]nt"
                                Case "qqq]nt"
                                    Print #WugFile, Chr(9);
                                    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "wug]li"
                                Case "qqq]li"
                                    Print #WugFile, Chr(9);
                                    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "wug]Id"
                                Case "qqq]Id"
                                    Print #WugFile, Chr(9);
                                    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "wug]Iz"
                                Case "qqq]Iz"
                                    Print #WugFile, Chr(9);
                                    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "wug]xl"
                                Case "qqq]xl"
                                    Print #WugFile, Chr(9);
                                    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "wug]S", "qqq]z"
                                '    Print #WugFile, Chr(9);
                                '    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "IG[wug", "qqq]z"
                                '    Print #WugFile, Chr(9);
                                '    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                'Case "z[wug", "qqq]z"
                                '    Print #WugFile, Chr(9);
                                '    Print #WugFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                                
                            End Select
                        Next i
                    Next WordIndex
                    Print #WugFile,
        
            Close #WugFile
            
            
        'VIOLATIONS
        'Append to a violations-of-wugs output file, assuming certain wug words were included in the input.
            
            'Get ready to provide constraint captions.
                Dim MyConstraintLabels As String
                'Zero in the first argument returns constraint labels.  These begin with a tab, so no need to insert.
                    Let MyConstraintLabels = ViolationString(0, "", "", "", 0, Task)
                    Let DiagnosticLabels = _
                        Chr(9) + "TypeFr" + _
                        Chr(9) + "TokenFr" + _
                        Chr(9) + "TypeHasBase" + _
                        Chr(9) + "Total" + _
                        Chr(9) + "TokenHasBase" + _
                        Chr(9) + "Total"
            'Open the file.
                    Let WugFile = FreeFile
                'Informative file name:
                '    Let MyFile = App.Path + "/Files/WugTestViolations_W" + mWeightSet + ".txt"
                'Uniform file name, so DDR can delete it at the start of a long run:
                    Let MyFile = App.Path + "/Files/WugTestViolations.txt"
                    'MsgBox "Opening " + MyFile
                    If Dir$(MyFile) = "" Then
                        Open MyFile For Output As #WugFile
                    Else
                        Open MyFile For Append As #WugFile
                    End If
                'Print a header, with 1's and 2's to permit sorting.
                    Print #WugFile, "1";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "Date";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "Time";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "Folder";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "File";
                    
                    Print #WugFile, Chr(9);
                    'Print #WugFile, "wug]z";
                    Print #WugFile, "qqq]z";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "p";
                    Print #WugFile, MyConstraintLabels + DiagnosticLabels;
                    Print #WugFile, Chr(9);
                    'Print #WugFile, "wug]s";
                    Print #WugFile, "qqq]s";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "p";
                    Print #WugFile, MyConstraintLabels + DiagnosticLabels;
                    Print #WugFile, Chr(9);
                    'Print #WugFile, "wug]d";
                    Print #WugFile, "qqq]d";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "p";
                    Print #WugFile, MyConstraintLabels + DiagnosticLabels;
                    Print #WugFile, Chr(9);
                    'Print #WugFile, "wug]t";
                    Print #WugFile, "qqq]t";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "p";
                    Print #WugFile, MyConstraintLabels + DiagnosticLabels;
                    Print #WugFile, Chr(9);
                    'Print #WugFile, "wug]IG";
                    Print #WugFile, "qqq]IG";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "p";
                    Print #WugFile, MyConstraintLabels + DiagnosticLabels;
                    Print #WugFile, Chr(9);
                    'Print #WugFile, "wug]i";
                    Print #WugFile, "qqq]i";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "p";
                    Print #WugFile, MyConstraintLabels + DiagnosticLabels;
                    Print #WugFile, Chr(9);
                    'Print #WugFile, "wug]R";
                    Print #WugFile, "qqq]R";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "p";
                    Print #WugFile, MyConstraintLabels + DiagnosticLabels;
                    Print #WugFile, Chr(9);
                    'Print #WugFile, "wug]nt";
                    Print #WugFile, "qqq]nt";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "p";
                    Print #WugFile, MyConstraintLabels + DiagnosticLabels;
                    Print #WugFile, Chr(9);
                    'Print #WugFile, "wug]Id";
                    Print #WugFile, "qqq]Id";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "p";
                    Print #WugFile, MyConstraintLabels + DiagnosticLabels;
                    Print #WugFile, Chr(9);
                    'Print #WugFile, "wug]li";
                    Print #WugFile, "qqq]li";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "p";
                    Print #WugFile, MyConstraintLabels + DiagnosticLabels;
                    Print #WugFile, Chr(9);
                    'Print #WugFile, "wug]Iz";
                    Print #WugFile, "qqq]Iz";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "p";
                    Print #WugFile, MyConstraintLabels + DiagnosticLabels;
                    Print #WugFile, Chr(9);
                    'Print #WugFile, "wug]xl";
                    Print #WugFile, "qqq]xl";
                    Print #WugFile, Chr(9);
                    Print #WugFile, "p";
                    Print #WugFile, MyConstraintLabels + DiagnosticLabels;
                    Print #WugFile, Chr(9);
                    'Let's not bother with these; they are accessible but less important.
                    'Print #WugFile, "wug]S";
                    'Print #WugFile, "qqq]S";
                    'Print #WugFile, Chr(9);
                    'Print #WugFile, "p";
                    'Print #WugFile, "IG[wug";
                    'Print #WugFile, "IG[qqq";
                    'Print #WugFile, Chr(9);
                    'Print #WugFile, "p";
                    'Print #WugFile, "z[wug";
                    'Print #WugFile, "z[qqq";
                    'Print #WugFile, Chr(9);
                    'Print #WugFile, "p";
                    'Print #WugFile, MyConstraintLabels + DiagnosticLabels;
                    
                    Print #WugFile,
                
                'SECOND LINE.  Identify this row, then the trial.
                    Print #WugFile, "2";
                    Print #WugFile, Chr(9);
                    Print #WugFile, Date;
                    Print #WugFile, Chr(9);
                    Print #WugFile, Time;
                    Print #WugFile, Chr(9);
                    Print #WugFile, mInputFilePath;
                    Print #WugFile, Chr(9);
                    Print #WugFile, mInputFileName;
                'Find the suffixed candidates of the wug words and fill them out.
                    Call FindViolations(WugFile, NumberOfCandidates, "qqq]z")
                    Call FindViolations(WugFile, NumberOfCandidates, "qqq]s")
                    Call FindViolations(WugFile, NumberOfCandidates, "qqq]d")
                    Call FindViolations(WugFile, NumberOfCandidates, "qqq]t")
                    Call FindViolations(WugFile, NumberOfCandidates, "qqq]IG")
                    Call FindViolations(WugFile, NumberOfCandidates, "qqq]i")
                    Call FindViolations(WugFile, NumberOfCandidates, "qqq]R")
                    Call FindViolations(WugFile, NumberOfCandidates, "qqq]nt")
                    Call FindViolations(WugFile, NumberOfCandidates, "qqq]Id")
                    Call FindViolations(WugFile, NumberOfCandidates, "qqq]li")
                    Call FindViolations(WugFile, NumberOfCandidates, "qqq]Iz")
                    Call FindViolations(WugFile, NumberOfCandidates, "qqq]xl")
                    'See above.
                    'Call FindViolations(WugFile, NumberOfCandidates, "qqq]S")
                    'Call FindViolations(WugFile, NumberOfCandidates, "IG[qqq")
                    'Call FindViolations(WugFile, NumberOfCandidates, "z[qqq")
                    'End the line.
                        Print #WugFile,
        
            Close #WugFile
            
            
End Sub

Function FindViolations(MyFile As Long, NumberOfCandidates, MyWug As String)

    'Look up the parsed wug-form and print its info.
    
    Dim MyStem As String, MySuffix As String, MySuffixIndex As Long
    Dim WordIndex As Long, i As Long
    
    For WordIndex = 1 To mNumberOfWords
        For i = 1 To NumberOfCandidates
            If mAllCandidates(i, WordIndex) = MyWug Then
                Print #MyFile, Chr(9);
                'The candidate itself.
                    Print #MyFile, MyWug;
                'Its probability
                    Print #MyFile, Chr(9);
                    Print #MyFile, Trim(Str(Round(mAllProbabilityValues(i, WordIndex), 3)));
                'Parse stem and suffix
                    Let MyStem = s.CustomChomp(MyWug, "]")
                    Let MySuffix = s.CustomResidue(MyWug, "]")
                'Its violations
                    Print #MyFile, Chr(9);
                    Print #MyFile, s.Residue(ViolationString(WordIndex, MyWug, MyStem, MySuffix, mSuffix, "existinggrammar"));
                
                'Let's add a few more for diagnosis.
                    Let MySuffixIndex = IndexOfAffix(MySuffix, mSuffix)
                    Print #MyFile, Chr(9);
                    Print #MyFile, mTypeFrequencyOfPotentialSuffixes(MySuffixIndex);
                    Print #MyFile, Chr(9);
                    Print #MyFile, mTokenFrequencyOfPotentialSuffixes(MySuffixIndex);
                    Print #MyFile, Chr(9);
                    Print #MyFile, mSuffixParseReliabilityTypes(MySuffixIndex);
                    Print #MyFile, Chr(9);
                    Print #MyFile, mNumberOfWords;
                    Print #MyFile, Chr(9);
                    Print #MyFile, mSuffixParseReliabilityTokens(MySuffixIndex);
                    Print #MyFile, Chr(9);
                    Print #MyFile, mNumberOfWordTokens;
                    'No line end; that is added after all are complete.
                    
                'Done; get out.
                    Exit Function
            End If
        Next i
    Next WordIndex
    
    'Error.  Just print enough tabs to keep a table ok.
        Print #MyFile, Chr(9);
        Print #MyFile, Chr(9);
        Print #MyFile, Chr(9);
        Print #MyFile, Chr(9);
        Print #MyFile, Chr(9);
        Print #MyFile, Chr(9);
    
End Function



Function ViolationString(MyWordIndex As Long, MyWord As String, MyStem As String, MyAffix As String, PrefixOrSuffix As Long, MyTask As String) As String

    Dim ViolationBuffer As String, MyAffixIndex As Long, NumBuffer As Single
    
    'Be ready to print out the stored constraint weights.
        Dim WeightList As String, MyWeight As Single
        
    'Calculate the harmony penalty
        Dim HarmonyBuffer As Single
    
    'If MyWordIndex is 0, we are just establishing constraint names; else assessing violations.
    
    'First, look up the affix to get its index.
        Let MyAffixIndex = IndexOfAffix(MyAffix, PrefixOrSuffix)
    
    'All constraints are treated as providing labels when the word index is zero, else violation counts.
    
    'Penalty for being a prefix.
        'Add the tab.
            Let ViolationBuffer = ViolationBuffer + Chr(9)
        'Establish the current weight.
            Let MyWeight = mWStarPrefixed
            Let WeightList = WeightList + Chr(9) + Str(MyWeight)
        'Add the label or violations.
            If MyWordIndex = 0 Then
                Let ViolationBuffer = ViolationBuffer + "*Prefixed"
            Else
                If MyStem = MyWord Then
                    Let ViolationBuffer = ViolationBuffer + "0"
                Else
                    If PrefixOrSuffix = mPrefix Then
                        Let ViolationBuffer = ViolationBuffer + "1"
                        Let HarmonyBuffer = HarmonyBuffer + MyWeight
                    Else
                        Let ViolationBuffer = ViolationBuffer + "0"
                    End If
                End If
            End If
    
    'Penalty for being a suffix.
        Let ViolationBuffer = ViolationBuffer + Chr(9)
            Let MyWeight = mWStarSuffixed
        Let WeightList = WeightList + Chr(9) + Str(MyWeight)
        If MyWordIndex = 0 Then
            Let ViolationBuffer = ViolationBuffer + "*Suffixed"
        Else
            If MyStem = MyWord Then
                Let ViolationBuffer = ViolationBuffer + "0"
            Else
                If PrefixOrSuffix = mSuffix Then
                    Let ViolationBuffer = ViolationBuffer + "1"
                    Let HarmonyBuffer = HarmonyBuffer + MyWeight
                Else
                    Let ViolationBuffer = ViolationBuffer + "0"
                End If
            End If
        End If
    
    'Does the affix attach to a real stem (defined as able to occur in isolation)?
        Let ViolationBuffer = ViolationBuffer + Chr(9)
        Let MyWeight = mWBadStem
        Let WeightList = WeightList + Chr(9) + Str(MyWeight)
        If MyWordIndex = 0 Then
            Let ViolationBuffer = ViolationBuffer + "*BadStem"
        Else
            If IsAWord(MyStem) Then
                Let ViolationBuffer = ViolationBuffer + "0"
            Else
                Let ViolationBuffer = ViolationBuffer + "1"
                Let HarmonyBuffer = HarmonyBuffer + MyWeight
            End If
        End If
        
    'Is the affix too rare to be considered?  We encode this as a violation.
        Let ViolationBuffer = ViolationBuffer + Chr(9)
        Let MyWeight = mWAffTooRare
        Let WeightList = WeightList + Chr(9) + Str(MyWeight)
        If MyWordIndex = 0 Then
            Let ViolationBuffer = ViolationBuffer + "*AffTooRare"
        Else
            If MyAffix <> "" Then
                Select Case PrefixOrSuffix
                    Case mPrefix
                        If Not RealAffix(MyAffix + "[") Then
                            If mFrequencyOfPotentialPrefixes(MyAffixIndex) < mExampleMinimum Then
                                Let ViolationBuffer = ViolationBuffer + "1"
                                Let HarmonyBuffer = HarmonyBuffer + MyWeight
                            Else
                                Let ViolationBuffer = ViolationBuffer + "0"
                            End If
                        End If
                    Case mSuffix
                        If Not RealAffix("]" + MyAffix) Then
                            If mFrequencyOfPotentialSuffixes(MyAffixIndex) < mExampleMinimum Then
                                Let ViolationBuffer = ViolationBuffer + "1"
                                Let HarmonyBuffer = HarmonyBuffer + MyWeight
                            Else
                                Let ViolationBuffer = ViolationBuffer + "0"
                            End If
                        Else
                            Let ViolationBuffer = ViolationBuffer + "0"
                        End If
                    Case Else
                        Stop
                End Select
            Else
                'Record no violations for the null affix.
                    Let ViolationBuffer = ViolationBuffer + "0"
            End If
        End If
        
    'LOG FREQUENT TERMINUS
    
    'Do a lot of words end in (resp. start) with this affix?
    'This now uses only log freq; direct seems to do poorly.
    'We normalize by number of non-wug words.
        Let ViolationBuffer = ViolationBuffer + Chr(9)
        Let MyWeight = mWLogFrequentTerminus
        Let WeightList = WeightList + Chr(9) + Str(MyWeight)
        If MyWordIndex = 0 Then
            Let ViolationBuffer = ViolationBuffer + "LogFreqTerminus"
        Else
            'Find the appropriate count.
                If MyAffix = "" Then
                    'Well, we suppose that zero occurs at the end of every string.  We've also done this with the interpretation of no violations.
                        Let NumBuffer = 1
                        Let HarmonyBuffer = HarmonyBuffer + MyWeight * NumBuffer
                Else
                    Select Case PrefixOrSuffix
                        Case mPrefix
                            If MyAffix <> "" Then
                                'Note that this frequency has already been calculated to reflect types or tokens, per user specification.
                                If optTypes Then
                                    Let NumBuffer = mFrequencyOfPotentialPrefixes(MyAffixIndex) / mNumberOfNonWugWords
                                    'MsgBox "just divided by mnumberofnonwugwords, which is " + Str(mNumberOfNonWugWords)
                                    'In Visual Basic, Log means the natural logarithm.
                                        'We must do something to avoid log of zero -- score needs to be low.
                                            If NumBuffer = 0 Then
                                                Let NumBuffer = Log(0.0000000001)
                                                'MsgBox "Caution:  the affix " + MyAffix + " occurred zero times and will receive an anomalous value for LnFrequentTerminus."
                                            Else
                                                Let NumBuffer = Log(NumBuffer)
                                            End If
                                    Let HarmonyBuffer = HarmonyBuffer + MyWeight * NumBuffer
                                Else
                                    Let NumBuffer = mFrequencyOfPotentialPrefixes(MyAffixIndex) / mNumberOfWordTokens
                                    'In Visual Basic, Log means the natural logarithm.
                                        'We must do something to avoid log of zero -- score needs to be low.
                                            If NumBuffer = 0 Then
                                                Let NumBuffer = Log(0.0000000001)
                                                'MsgBox "Caution:  the affix " + MyAffix + " occurred zero times and will receive an anomalous value for LnFrequentTerminus."
                                            Else
                                                Let NumBuffer = Log(NumBuffer)
                                            End If
                                    'This should have its weight calculated with tokens before using.
                                        Let HarmonyBuffer = HarmonyBuffer + MyWeight * NumBuffer
                                        'Stop
                                End If
                            End If
                        Case mSuffix
                            If MyAffix <> "" Then
                                If optTypes Then
                                    Let NumBuffer = mFrequencyOfPotentialSuffixes(MyAffixIndex) / mNumberOfNonWugWords
                                    'MsgBox "just divided by mnumberofnonwugwords, which is " + Str(mNumberOfNonWugWords)
                                    'In Visual Basic, Log means the natural logarithm.
                                        'We must do something to avoid log of zero -- score needs to be low.
                                            If NumBuffer = 0 Then
                                                Let NumBuffer = Log(0.0000000001)
                                                'MsgBox "Caution:  the affix " + MyAffix + " occurred zero times and will receive an anomalous value for LnFrequentTerminus."
                                            Else
                                                Let NumBuffer = Log(NumBuffer)
                                            End If
                                    Let HarmonyBuffer = HarmonyBuffer + MyWeight * NumBuffer
                                Else
                                    Let NumBuffer = mFrequencyOfPotentialSuffixes(MyAffixIndex) / mNumberOfWordTokens
                                        'We must do something to avoid log of zero -- score needs to be low.
                                            If NumBuffer = 0 Then
                                                Let NumBuffer = Log(0.0000000001)
                                                'MsgBox "Caution:  the affix " + MyAffix + " occurred zero times and will receive an anomalous value for LnFrequentTerminus."
                                            Else
                                                Let NumBuffer = Log(NumBuffer)
                                            End If
                                        Let HarmonyBuffer = HarmonyBuffer + MyWeight * NumBuffer
                                        'Stop
                                End If
                            End If
                    End Select
                End If
            'Format and record.
                Let ViolationBuffer = ViolationBuffer + FormattedViolationCount(NumBuffer)
        End If
  
  
    'Attachment capacity:  when you have a word, how often is the result of attaching this affix also a word?
        Let ViolationBuffer = ViolationBuffer + Chr(9)
        Let MyWeight = mWAttachCapac
        Let WeightList = WeightList + Chr(9) + Str(MyWeight)
        If MyWordIndex = 0 Then
            Let ViolationBuffer = ViolationBuffer + "AttachCapac"
        Else
            If MyAffix = "" Then
                'Let's try one instead of zero, more logical.
                Let NumBuffer = 1
            Else
                'Here the denominator should be the word count -- every word is in play.
                'Moreover, the word count must reflect types or tokens.
                If optToken Then
                    'Tokens
                        Select Case PrefixOrSuffix
                                Case mPrefix
                                        Let NumBuffer = mPrefixRawAttachmentCapacity(MyAffixIndex) / mNumberOfWordTokens
                                Case mSuffix
                                        Let NumBuffer = mSuffixRawAttachmentCapacity(MyAffixIndex) / mNumberOfWordTokens
                        End Select
                Else
                    'Types
                        Select Case PrefixOrSuffix
                                Case mPrefix
                                        Let NumBuffer = mPrefixRawAttachmentCapacity(MyAffixIndex) / mNumberOfNonWugWords
                                Case mSuffix
                                        Let NumBuffer = mSuffixRawAttachmentCapacity(MyAffixIndex) / mNumberOfNonWugWords
                        End Select
                End If
            End If
            'Adjust by appropriate denominator and record.
                Let ViolationBuffer = ViolationBuffer + FormattedViolationCount(NumBuffer)
                Let HarmonyBuffer = HarmonyBuffer + MyWeight * NumBuffer
        End If
        
    'Parse Reliability.  When this suffix appears at the end of a word (resp. prefix at beginning), how often is the residue a word?
        Let ViolationBuffer = ViolationBuffer + Chr(9)
        Let MyWeight = mWParseReliability
        Let WeightList = WeightList + Chr(9) + Str(MyWeight)
        If MyWordIndex = 0 Then
            Let ViolationBuffer = ViolationBuffer + "ParseReliability"
        Else
            If MyAffix = "" Then
                'Let's try one instead of zero, more logical.  It really doesn't matter, for in the end this is compensated for
                '   by the *Affix family.
                Let NumBuffer = 1
            Else
                Select Case PrefixOrSuffix
                    Case mPrefix
                        If mFrequencyOfPotentialPrefixes(MyAffixIndex) = 0 Then
                            Let NumBuffer = 0
                        Else
                            Let NumBuffer = mPrefixParseReliability(MyAffixIndex) / mFrequencyOfPotentialPrefixes(MyAffixIndex)
                        End If
                    Case mSuffix
                    
                        If mFrequencyOfPotentialSuffixes(MyAffixIndex) = 0 Then
                            Let NumBuffer = 0
                        Else
                            Let NumBuffer = mSuffixParseReliability(MyAffixIndex) / mFrequencyOfPotentialSuffixes(MyAffixIndex)
                        End If
                End Select
            End If
            
            'Perform a necessary remapping on ParseReliability
                Let NumBuffer = AdjustedParseReliability(NumBuffer)
            'Format and record.
                Let ViolationBuffer = ViolationBuffer + FormattedViolationCount(NumBuffer)
                Let HarmonyBuffer = HarmonyBuffer + (MyWeight * NumBuffer)
        End If
      
        
    'Affixes tend to be short
        Let ViolationBuffer = ViolationBuffer + Chr(9)
        Let MyWeight = mWAffLength
        Let WeightList = WeightList + Chr(9) + Str(MyWeight)
        If MyWordIndex = 0 Then
            Let ViolationBuffer = ViolationBuffer + "AffLength"
        Else
            Let ViolationBuffer = ViolationBuffer + Trim(Str(Len(MyAffix)))
            Let HarmonyBuffer = HarmonyBuffer + (MyWeight * Len(MyAffix))
        End If
        
    'Stems are never null -- works better if this strong constraint is separate.
        Let ViolationBuffer = ViolationBuffer + Chr(9)
        Let MyWeight = mWNullStem
        Let WeightList = WeightList + Chr(9) + Str(MyWeight)
        If MyWordIndex = 0 Then
            Let ViolationBuffer = ViolationBuffer + "StarNullStem"
        Else
            If Len(MyStem) = 0 Then
                Let ViolationBuffer = ViolationBuffer + "1"
                Let HarmonyBuffer = HarmonyBuffer + MyWeight
            Else
                Let ViolationBuffer = ViolationBuffer + "0"
            End If
        End If
        
    'Stems tend to be long -- penalize by reciprocal.
        Let ViolationBuffer = ViolationBuffer + Chr(9)
        Let MyWeight = mWStemLengthRecip
        Let WeightList = WeightList + Chr(9) + Str(MyWeight)
        If MyWordIndex = 0 Then
            Let ViolationBuffer = ViolationBuffer + "StemLenRecip"
        Else
            If Len(MyStem) = 0 Then
                'These are penalized separately -- see immediately above.
                    Let ViolationBuffer = ViolationBuffer + "0"
                    'Let HarmonyBuffer = HarmonyBuffer + (MyWeight * 0)
            Else
                Let ViolationBuffer = ViolationBuffer + Trim(Str(1 / Len(MyStem)))
                Let HarmonyBuffer = HarmonyBuffer + (MyWeight / Len(MyStem))
            End If
        End If
        
    'Record the final result, bundling everything.
    
        If MyWordIndex = -1 Then
            'Weights:
                Let ViolationString = WeightList
        ElseIf MyWordIndex = 0 Then
            'Constraint names:
                Let ViolationString = ViolationBuffer
        Else
            'Harmony and violations
                Let ViolationString = Trim(Str(HarmonyBuffer)) + ViolationBuffer
                'MsgBox "ViolationString is:  " + ViolationString
        End If
        

End Function


Function AdjustedParseReliability(MyReal As Single) As Single

    'This is a change from earlier versions. We note that [-ng] is a terrible candidate, but is not penalized enough by Parse Reliability (its value
    '   in our data is zero.)
    
    'The user may request that harsh penalties be imposed for candidates with very low parse reliability. This is in the Dec. 2022 version of the paper; we now have qualms.
        If Form1.chkHarshParseReliability.Value = vbChecked Then
            If MyReal < 0.01 Then
                Let AdjustedParseReliability = -1
            Else
                Let AdjustedParseReliability = MyReal
            End If
        Else
            Let AdjustedParseReliability = MyReal
        End If

End Function

Function IsAWord(MyStem As String) As Boolean

    Dim WordIndex As Long
    For WordIndex = 1 To mNumberOfWords
        If mWords(WordIndex) = MyStem Then
            Let IsAWord = True
            Exit Function
        End If
    Next WordIndex

End Function

Function FormattedViolationCount(MyBuffer As Single) As String

    Dim LocalBuffer As Single
                
    Let LocalBuffer = MyBuffer
    Let LocalBuffer = Round(LocalBuffer, 4)
    Let FormattedViolationCount = Trim(Str(LocalBuffer))

End Function

Function IndexOfAffix(MyAffix As String, PrefixOrSuffix As Long) As Long

    Dim PrefixIndex As Long, SuffixIndex As Long
    
    'Look up the prefix or suffix in a list, and return its index.
    
    If MyAffix = "" Then
        Let IndexOfAffix = 0
    Else
        If PrefixOrSuffix = mPrefix Then
            For PrefixIndex = 1 To mNumberOfPotentialPrefixes
                If mPotentialPrefixes(PrefixIndex) = MyAffix Then
                    Let IndexOfAffix = PrefixIndex
                    Exit Function
                End If
            Next PrefixIndex
            Stop
        ElseIf PrefixOrSuffix = mSuffix Then
            For SuffixIndex = 1 To mNumberOfPotentialSuffixes
                If mPotentialSuffixes(SuffixIndex) = MyAffix Then
                    Let IndexOfAffix = SuffixIndex
                    Exit Function
                End If
            Next SuffixIndex
            Stop
        Else
            Stop
        End If
    End If

End Function


Sub MakeFileOfAllDiscoveredAffixes(MyFileName As String)

    'Look at three columns extracted from the detailed probability list (all candidates) and calculate/print some stats that evaluate the
    '   learned affixes in toto.
    
    'Variables with information about all affixes discovered.
        Dim NumberOfPrefixes As Long
        Dim NumberOfSuffixes As Long
        Dim Prefixes() As String
        Dim Suffixes() As String
        Dim PrefixFrequencies() As Long
        Dim SuffixFrequencies() As Long
        Dim ClaimedPrefixHits() As Long
        Dim ClaimedSuffixHits() As Long
        Dim TruePrefixHits() As Long
        Dim TrueSuffixHits() As Long
        Dim AggregatePrefixProbability() As Single
        Dim AggregateSuffixProbability() As Single
        Dim PrefixExamples() As String
        Dim SuffixExamples() As String
        'Maximum and minimum scores.
            Dim SuffixMaxScore() As Single
            Dim SuffixMaxScoreExample() As String
            Dim SuffixMinScore() As Single
            Dim SuffixMinScoreExample() As String
            Dim PrefixMaxScore() As Single
            Dim PrefixMaxScoreExample() As String
            Dim PrefixMinScore() As Single
            Dim PrefixMinScoreExample() As String
    
    'For the winner file
        Dim BestScore As Single
        Dim CandidateWithBestScore As String
        Dim NumberOfWords As Long
        Dim ViolationBuffer As String
    
    'Variables for localizing information/clarity.
        Dim MyLine As String, WugTest As String
        Dim MyWord As String, MyPrefix As String, MySuffix As String, MyWinner As Long, MyPercentage As Single
    
    'What kind of example we have.
        Dim MyTag As String
        
    'For wug-testing the model on each suffix.
        Dim WugForm As String
    
    'Indices and file numbers.
        Dim AffixTypeIndex As Long, AffixIndex As Long, WordIndex As Long
        Dim ProbFile As Long, StatsFile As Long, LineIndex As Long
    
    
    'Open the intermediate file with probability list.  This may be user generated or generated at an earlier stage of this program.
        Let ProbFile = FreeFile
        'If chkEvaluateResult.Value = vbChecked Then
            'Probably obsolete; here the assumption is that the input file is user generated. Still useful for debugging.
            '    MsgBox "Opening " + mInputFilePath + MyFileName
            '    Open mInputFilePath + MyFileName + ".txt" For Input As #ProbFile
        'Else
            'Machine-generated, by this very program, just now.
                Open mOutputFilePath + "ProbabilityListFor" + mInputFileName + ".txt" For Input As #ProbFile
        'End If
        
    'Initialize
        Let WordIndex = 1
    
        
    'Loop through the candidate/probability file and process it line by line.
        Do While Not EOF(ProbFile)
        
            Line Input #ProbFile, MyLine
            
            'Don't do anything with wug words
                Let WugTest = Trim(s.Chomp(MyLine))
                'If Left(WugTest, 3) = "wug" Or Right(WugTest, 3) = "wug" Then
                If Left(WugTest, 3) = "qqq" Or Right(WugTest, 3) = "qqq" Then
                    'MsgBox "rejecting " + WugTest + " in " + MyLine
                    'You must also reject the next 10 lines, with the other parses in them.
                        For LineIndex = 1 To 10
                            Line Input #ProbFile, MyLine
                        Next LineIndex
                    'However, you need to update the word index, so that the Silver Standard will be read properly.
                        Let WordIndex = WordIndex + 1
                    GoTo ExitPoint
                End If
                
            'Every eleven lines repeat a pattern of affix type and length. We do tricky stuff to track this numbering.
                Let AffixTypeIndex = AffixTypeIndex + 1
                'Check to see if you finished the candidates for this word and are ready to move on to the next word.
                    If AffixTypeIndex = 2 * mcMaximumAffixLength + 2 Then
                        'Initialize the count of affixes-per-word.
                            Let AffixTypeIndex = 1
                        'Augment the count for words.
                            Let WordIndex = WordIndex + 1
                        'Initialize superlatives collected for each word.
                            Let BestScore = 0
                            Let CandidateWithBestScore = ""
                    End If
            
            'Parse the line
                Let MyWord = Trim(s.Chomp(MyLine))
                Let MyWinner = Val(Trim(s.Chomp(s.Residue(MyLine))))
                Let MyPercentage = Val(Trim(s.Residue(s.Residue(MyLine))))
            'Let's not clutter the output file with candidates that are all affix.
                If Left(MyWord, 1) = "]" Or Right(MyWord, 1) = "[" Then
                    'MsgBox "Rejected parse:  " + MyWord
                    GoTo ExitPoint
                End If
            'Update best score
                If MyPercentage > BestScore Then
                    Let CandidateWithBestScore = MyWord
                    Let BestScore = MyPercentage
                End If
            'Find the affix, if any.  Follow the numbering system with:  no affix, suffixes, then prefixes
                'MsgBox "AffixTypeIndex is " + Trim(Str(AffixTypeIndex))
                'Stop
                Select Case AffixTypeIndex
                    Case 1
                        'There is no affix.
                            GoTo ExitPoint
                    Case 2, 3, 4, 5, 6
                        'Set up a candidate suffix.
                            Let MySuffix = Right(MyWord, AffixTypeIndex - 1)
                        'Once you hit a right bracket, you can no longer be finding affix candidates, for they will include a boundary symbol.
                            If Left(MySuffix, 1) = "]" Then GoTo ExitPoint
                        'MsgBox "Suffix of " + MyWord + " is " + MySuffix
                        If Trim(MySuffix) = "" Then GoTo ExitPoint
                    Case 7, 8, 9, 10, 11
                        Let MyPrefix = Left(MyWord, AffixTypeIndex - 6)
                        If Right(MyPrefix, 1) = "[" Then GoTo ExitPoint
                        'MsgBox "Prefix of " + MyWord + " is " + MyPrefix
                        If Trim(MyPrefix) = "" Then GoTo ExitPoint
                    Case Else
                        Stop
                End Select
            'Collect the stats, by type.
                Select Case AffixTypeIndex
                    Case 2, 3, 4, 5, 6
                        'These are suffixes.  Typize and count.
                            For AffixIndex = 1 To NumberOfSuffixes
                                If MySuffix = Suffixes(AffixIndex) Then
                                    'If MySuffix = "z" Then
                                    '    MsgBox "Found a z in " + MyWord
                                    'End If
                                    'You have it already, augment the stats.
                                        'This needs to be augmented for tokens.
                                            If optToken Then
                                                Let SuffixFrequencies(AffixIndex) = SuffixFrequencies(AffixIndex) + mWordFrequencies(WordIndex)
                                            ElseIf optTypes Then
                                                Let SuffixFrequencies(AffixIndex) = SuffixFrequencies(AffixIndex) + 1
                                            Else
                                                Stop
                                            End If
                                        Let AggregateSuffixProbability(AffixIndex) = AggregateSuffixProbability(AffixIndex) + MyPercentage
                                        Let ClaimedSuffixHits(AffixIndex) = ClaimedSuffixHits(AffixIndex) + MyWinner
                                        'Compute a tag to label the examples.
                                            Let MyTag = ComputeATag(MyWord, WordIndex, MyWinner)
                                        'Count true hits
                                            'MsgBox "MyWord is " + MyWord + ".  SilverStandard is " + mSilverStandard(WordIndex)
                                            If MyWord = mSilverStandard(WordIndex) Then
                                                'This needs to treat tokens distinctly from types.
                                                    If optToken Then
                                                        Let TrueSuffixHits(AffixIndex) = TrueSuffixHits(AffixIndex) + mWordFrequencies(WordIndex)
                                                    ElseIf optTypes Then
                                                        Let TrueSuffixHits(AffixIndex) = TrueSuffixHits(AffixIndex) + 1
                                                    Else
                                                        Stop
                                                    End If
                                            End If
                                        'Add the example to the list of examples.
                                            Let SuffixExamples(AffixIndex) = SuffixExamples(AffixIndex) + Chr(9) + MyWord + " " + MyTag
                                        'Check for maxima and minima.
                                            If MyPercentage > SuffixMaxScore(AffixIndex) Then
                                                Let SuffixMaxScore(AffixIndex) = MyPercentage
                                                Let SuffixMaxScoreExample(AffixIndex) = MyWord + " " + MyTag
                                            ElseIf MyPercentage < SuffixMinScore(AffixIndex) Then
                                                'This is set at a positive value below, on first encounter, so we never have to compare with zero.
                                                    Let SuffixMinScore(AffixIndex) = MyPercentage
                                                    Let SuffixMinScoreExample(AffixIndex) = MyWord + " " + MyTag
                                            End If
                                        'This complete the processing needed for this line, since each line contains only one suffix at most.
                                            GoTo ExitPoint
                                End If
                            Next AffixIndex
                            'A new suffix to add to the catalog.
                                Let NumberOfSuffixes = NumberOfSuffixes + 1
                                'Redimension everything.
                                    ReDim Preserve Suffixes(NumberOfSuffixes)
                                    ReDim Preserve SuffixFrequencies(NumberOfSuffixes)
                                    ReDim Preserve AggregateSuffixProbability(NumberOfSuffixes)
                                    ReDim Preserve ClaimedSuffixHits(NumberOfSuffixes)
                                    ReDim Preserve TrueSuffixHits(NumberOfSuffixes)
                                    ReDim Preserve SuffixExamples(NumberOfSuffixes)
                                    ReDim Preserve SuffixMaxScore(NumberOfSuffixes)
                                    ReDim Preserve SuffixMaxScoreExample(NumberOfSuffixes)
                                    ReDim Preserve SuffixMinScore(NumberOfSuffixes)
                                    ReDim Preserve SuffixMinScoreExample(NumberOfSuffixes)
                                
                                'Compute a tag to label the examples.
                                    Let MyTag = ComputeATag(MyWord, WordIndex, MyWinner)
                                'Count true hits
                                    'MsgBox "MyWord is " + MyWord + ".  SilverStandard is " + mSilverStandard(WordIndex)
                                    If MyWord = mSilverStandard(WordIndex) Then
                                        If optToken Then
                                            Let TrueSuffixHits(AffixIndex) = TrueSuffixHits(AffixIndex) + mWordFrequencies(WordIndex)
                                        ElseIf optTypes Then
                                            Let TrueSuffixHits(AffixIndex) = TrueSuffixHits(AffixIndex) + 1
                                        Else
                                            Stop
                                        End If
                                    End If
                                
                                'Fill in values for this suffix.
                                    Let Suffixes(NumberOfSuffixes) = MySuffix
                                    'If MySuffix = "z" Then
                                    '    MsgBox "Found a z in " + MyWord
                                    'End If
                                    'This should be augmented to allow token counts; right now, just type.
                                        Let SuffixFrequencies(NumberOfSuffixes) = 1
                                    Let AggregateSuffixProbability(NumberOfSuffixes) = MyPercentage
                                    Let ClaimedSuffixHits(NumberOfSuffixes) = MyWinner
                                    Let SuffixMaxScore(NumberOfSuffixes) = MyPercentage
                                    Let SuffixMaxScoreExample(NumberOfSuffixes) = MyWord + " " + MyTag
                                    Let SuffixMinScore(NumberOfSuffixes) = MyPercentage
                                    Let SuffixMinScoreExample(NumberOfSuffixes) = MyWord + " " + MyTag
                                
                                'Add to the list of examples.
                                    Let SuffixExamples(AffixIndex) = SuffixExamples(AffixIndex) + Chr(9) + MyWord + " " + MyTag
                                    
                    Case 7, 8, 9, 10, 11
                        'These are prefixes.  Typize and count.
                        For AffixIndex = 1 To NumberOfPrefixes
                            If MyPrefix = Prefixes(AffixIndex) Then
                                'You have it already, augment the records.
                                    Let PrefixFrequencies(AffixIndex) = PrefixFrequencies(AffixIndex) + 1
                                    Let AggregatePrefixProbability(AffixIndex) = AggregatePrefixProbability(AffixIndex) + MyPercentage
                                    Let ClaimedPrefixHits(AffixIndex) = ClaimedPrefixHits(AffixIndex) + MyWinner
                                    
                                'Compute a tag to label the examples.
                                    Let MyTag = ComputeATag(MyWord, WordIndex, MyWinner)
                                'Count true hits
                                    If MyWord = mSilverStandard(WordIndex) Then
                                        Let TruePrefixHits(AffixIndex) = TruePrefixHits(AffixIndex) + 1
                                    End If
                                    
                                'Add to list of examples.
                                    Let PrefixExamples(AffixIndex) = PrefixExamples(AffixIndex) + Chr(9) + MyWord + " " + MyTag
                                'Check for maxima and minima.
                                    If MyPercentage > PrefixMaxScore(AffixIndex) Then
                                        Let PrefixMaxScore(AffixIndex) = MyPercentage
                                        Let PrefixMaxScoreExample(AffixIndex) = MyWord + " " + MyTag
                                    ElseIf MyPercentage < PrefixMinScore(AffixIndex) Then
                                        'This is set at a positive value below, on first encounter, so we never have to compare with zero.
                                            Let PrefixMinScore(AffixIndex) = MyPercentage
                                            Let PrefixMinScoreExample(AffixIndex) = MyWord + " " + MyTag
                                    End If
                                'This complete the processing needed for this line, since each line contains only one Prefix at most.
                                    GoTo ExitPoint
                            End If
                        Next AffixIndex
                            'new one
                                'Redimension everything.
                                    Let NumberOfPrefixes = NumberOfPrefixes + 1
                                    ReDim Preserve Prefixes(NumberOfPrefixes)
                                    ReDim Preserve PrefixFrequencies(NumberOfPrefixes)
                                    ReDim Preserve AggregatePrefixProbability(NumberOfPrefixes)
                                    ReDim Preserve ClaimedPrefixHits(NumberOfPrefixes)
                                    ReDim Preserve TruePrefixHits(NumberOfPrefixes)
                                    ReDim Preserve PrefixExamples(NumberOfPrefixes)
                                    ReDim Preserve PrefixMaxScore(NumberOfPrefixes)
                                    ReDim Preserve PrefixMaxScoreExample(NumberOfPrefixes)
                                    ReDim Preserve PrefixMinScore(NumberOfPrefixes)
                                    ReDim Preserve PrefixMinScoreExample(NumberOfPrefixes)
                                    
                                'Compute a tag to label the examples.
                                    Let MyTag = ComputeATag(MyWord, WordIndex, MyWinner)
                                'Count true hits
                                    If MyWord = mSilverStandard(WordIndex) Then
                                        Let TruePrefixHits(AffixIndex) = TruePrefixHits(AffixIndex) + 1
                                    End If
                                
                                'Fill in values for this prefix.
                                    Let Prefixes(NumberOfPrefixes) = MyPrefix
                                    Let PrefixFrequencies(NumberOfPrefixes) = 1
                                    Let AggregatePrefixProbability(NumberOfPrefixes) = MyPercentage
                                    Let ClaimedPrefixHits(NumberOfPrefixes) = MyWinner
                                    Let PrefixMaxScore(NumberOfPrefixes) = MyPercentage
                                    Let PrefixMaxScoreExample(NumberOfPrefixes) = MyWord + " " + MyTag
                                    Let PrefixMinScore(NumberOfPrefixes) = MyPercentage
                                    Let PrefixMinScoreExample(NumberOfPrefixes) = MyWord + " " + MyTag
                                'Add to list of examples.
                                    Let PrefixExamples(AffixIndex) = PrefixExamples(AffixIndex) + Chr(9) + MyWord + " " + MyTag
                End Select
            
ExitPoint:
            
        Loop
        Close #ProbFile
    
    
    'Print the results.
        Let StatsFile = FreeFile
        
        Open mOutputFilePath + "AnalysisOfAllAffixesFound_" + mInputFileName + ".txt" For Output As #StatsFile
        'Header
            Print #StatsFile, "Type";
            Print #StatsFile, Chr(9);
            Print #StatsFile, "Affix";
            Print #StatsFile, Chr(9);
            Print #StatsFile, "Raw Count";
            Print #StatsFile, Chr(9);
            Print #StatsFile, "Claimed hits";
            Print #StatsFile, Chr(9);
            Print #StatsFile, "Real hits";
            Print #StatsFile, Chr(9);
            Print #StatsFile, "Ave. model score";
            Print #StatsFile, Chr(9);
            Print #StatsFile, "Max score";
            Print #StatsFile, Chr(9);
            Print #StatsFile, "in:";
            Print #StatsFile, Chr(9);
            Print #StatsFile, "Min score";
            Print #StatsFile, Chr(9);
            Print #StatsFile, "in:";
            'Print #StatsFile, Chr(9);
            'Print #StatsFile, "Wug test";
            'Print #StatsFile, Chr(9);
            'Print #StatsFile, "P";
            'Print #StatsFile, ViolationString(0, "", "", "", 0, "");
            Print #StatsFile, Chr(9);
            Print #StatsFile, "All examples. S = Silver standard, M = model choice";
            Print #StatsFile,
        'Content, suffixes first.
            For AffixIndex = 1 To NumberOfSuffixes
                Print #StatsFile, "Suffix";
                Print #StatsFile, Chr(9);
                Print #StatsFile, "]" + Suffixes(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, SuffixFrequencies(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, ClaimedSuffixHits(AffixIndex);
                Print #StatsFile, Chr(9);
                'hithere this is bad, no tokens
                Print #StatsFile, TrueSuffixHits(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, AggregateSuffixProbability(AffixIndex) / SuffixFrequencies(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, SuffixMaxScore(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, SuffixMaxScoreExample(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, SuffixMinScore(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, SuffixMinScoreExample(AffixIndex);
                'Let's sort the examples of the full list by type, using a function.
                    Print #StatsFile, ExtractExamples("SM", SuffixExamples(), AffixIndex);
                    Print #StatsFile, ExtractExamples("S", SuffixExamples(), AffixIndex);
                    Print #StatsFile, ExtractExamples("M", SuffixExamples(), AffixIndex);
                    Print #StatsFile, ExtractExamples("", SuffixExamples(), AffixIndex);
                    'Print #StatsFile, SuffixExamples(AffixIndex);
                Print #StatsFile,
            Next AffixIndex
            For AffixIndex = 1 To NumberOfPrefixes
                Print #StatsFile, "Prefix";
                Print #StatsFile, Chr(9);
                Print #StatsFile, Prefixes(AffixIndex) + "[";
                Print #StatsFile, Chr(9);
                Print #StatsFile, PrefixFrequencies(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, ClaimedPrefixHits(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, TruePrefixHits(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, AggregatePrefixProbability(AffixIndex) / PrefixFrequencies(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, PrefixMaxScore(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, PrefixMaxScoreExample(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, PrefixMinScore(AffixIndex);
                Print #StatsFile, Chr(9);
                Print #StatsFile, PrefixMinScoreExample(AffixIndex);
                'Add the constraint violations that would be obtained by adding this prefix to the stem "wug".
                '    Let WugForm = Prefixes(AffixIndex) + "[wug"
                '    Print #StatsFile, Chr(9);
                '    Print #StatsFile, WugForm;
                '    Print #StatsFile, Chr(9);
                '    Print #StatsFile, ViolationString(1, WugForm, "wug", Prefixes(AffixIndex), mPrefix, "");
                'Now, the examples.  Let's sort them by type, using a function.
                    Print #StatsFile, ExtractExamples("SM", PrefixExamples(), AffixIndex);
                    Print #StatsFile, ExtractExamples("S", PrefixExamples(), AffixIndex);
                    Print #StatsFile, ExtractExamples("M", PrefixExamples(), AffixIndex);
                    Print #StatsFile, ExtractExamples("", PrefixExamples(), AffixIndex);
                Print #StatsFile,
            Next AffixIndex
        
        Close #StatsFile
        
        'Lastly, produce a file for testing all possible wug forms on a later run.
            'Call MakeAFileToWugTestAllAffixes(Suffixes(), NumberOfSuffixes, Prefixes(), NumberOfPrefixes)

End Sub

Function ComputeATag(MyWord As String, MyWordIndex As Long, MyWinner As Long) As String

    'Compute a tag to label the examples.
    
    Dim Buffer As String
    
    'True hits
        If MyWord = mSilverStandard(MyWordIndex) Then
            Let Buffer = Buffer + "S"
        End If
    'Model-advocated hits
        If MyWinner > 0 Then Let Buffer = Buffer + "M"
    'Report result
        Let ComputeATag = Buffer

End Function

Function ExtractExamples(MyType As String, MySourceArray() As String, MyAffixIndex As Long)

    'Look among the arrays of prefix or suffix examples, and return the ones that bear the tag for type.
    
    Dim MySetOfExamples As String, MyExample As String, OutBuffer As String
    
    Let MySetOfExamples = MySourceArray(MyAffixIndex)
        
    Do
        'Discard first entry.  This is ok even on the first round, for the input begins with a tab.
        Let MySetOfExamples = s.Residue(MySetOfExamples)
        Let MyExample = s.Chomp(MySetOfExamples)
        If Trim(MyExample) = "" Then Exit Do
        If Right(MyExample, 3) = " SM" Then
            If MyType = "SM" Then
                Let OutBuffer = OutBuffer + Chr(9) + MyExample
            End If
        Else
            Select Case Right(MyExample, 2)
                Case " S"
                    If MyType = "S" Then
                        Let OutBuffer = OutBuffer + Chr(9) + MyExample
                    End If
                Case " M"
                    If MyType = "M" Then
                        Let OutBuffer = OutBuffer + Chr(9) + MyExample
                    End If
                Case Else
                    If MyType = "" Then
                        Let OutBuffer = OutBuffer + Chr(9) + MyExample
                    End If
            End Select
        End If
    Loop
    
    Let ExtractExamples = OutBuffer

End Function



Function BracketReplace(MyString As String) As String

    Dim Buffer As String
    Let Buffer = MyString
    Let Buffer = Replace(Buffer, "[", " ")
    Let Buffer = Replace(Buffer, "]", " ")
    Let BracketReplace = Buffer
    
End Function
Function BracketDelete(MyString As String) As String

    Dim Buffer As String
    Let Buffer = MyString
    Let Buffer = Replace(Buffer, "[", "")
    Let Buffer = Replace(Buffer, "]", "")
    Let Buffer = Replace(Buffer, ">", "")
    Let BracketDelete = Buffer
    
End Function


Private Sub cmdExcelHowTo_Click()

    Dim MessageString As String
    
    Let MessageString = "You need a text-format, tab-delimited input file."
    Let MessageString = MessageString + vbCr + vbLf
    Let MessageString = MessageString + vbCr + vbLf
    Let MessageString = MessageString + "There should be no header line.  "
    Let MessageString = MessageString + vbCr + vbLf
    Let MessageString = MessageString + vbCr + vbLf
    Let MessageString = MessageString + "There should be three columns:  candidates, winners, probability assigned by model."
    Let MessageString = MessageString + vbCr + vbLf
    Let MessageString = MessageString + vbCr + vbLf
    Let MessageString = MessageString + "Drag the file onto the interface to start the process, selecting the Evaluate Excel result option and clicking with the main command button."
    
    MsgBox MessageString

End Sub

Function NoBrackets(MyString As String) As String

    Dim Buffer As String
    Let Buffer = MyString
    Let Buffer = Replace(Buffer, "[", "")
    Let NoBrackets = Replace(Buffer, "]", "")
    
End Function

