VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Find minimal pairs"
   ClientHeight    =   5025
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   6285
   Icon            =   "MinimalPairs.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   5025
   ScaleWidth      =   6285
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command1 
      Caption         =   "Go"
      Height          =   1695
      Left            =   1680
      TabIndex        =   2
      Top             =   1200
      Width           =   2895
   End
   Begin VB.TextBox Text2 
      Alignment       =   2  'Center
      Height          =   495
      Left            =   3360
      TabIndex        =   1
      Text            =   "T"
      Top             =   3240
      Width           =   1215
   End
   Begin VB.TextBox Text1 
      Alignment       =   2  'Center
      Height          =   495
      Left            =   1680
      TabIndex        =   0
      Text            =   "P"
      Top             =   3240
      Width           =   1215
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "Help"
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Find minimal pairs

Option Explicit

    Dim mWords() As String
    Dim mNumberOfWords As Long
    Dim mNumberOfPhoneme1Words As Long
    Dim mPhoneme1List() As String
    Dim mNumberOfPhoneme2Words As Long
    Dim mPhoneme2List() As String
    

Private Sub Command1_Click()

    Static ButtonStatus As Boolean
    If ButtonStatus = True Then End
    Let ButtonStatus = True
    
    Dim MyLine As String
    Dim WordIndex As Long, Phoneme1Index As Long, Phoneme2Index As Long
    Dim MyWord As String
    Dim Phoneme1 As String, Phoneme2 As String
    
    Let Phoneme1 = " " + Trim(Text1.Text) + " "
    Let Phoneme2 = " " + Trim(Text2.Text) + " "
    
    'Read the input file.
        Let Command1.Caption = "Reading input file ..."
        Open App.Path + "/in.txt" For Input As #1
        Do While Not EOF(1)
            Line Input #1, MyLine
            Let mNumberOfWords = mNumberOfWords + 1
            ReDim Preserve mWords(mNumberOfWords)
            Let mWords(mNumberOfWords) = " " + Trim(MyLine) + " "
        Loop
        Close #1
        
    'Trim down to just words that have the relevant phoneme.
        Open App.Path + "/output/ListOfWordsWith " + Trim(Phoneme1) + ".txt" For Output As #2
        Let Command1.Caption = "Making lists of words that have the relevant phonemes ..."
        For WordIndex = 1 To mNumberOfWords
            If Replace(mWords(WordIndex), Phoneme1, "") <> mWords(WordIndex) Then
                Let mNumberOfPhoneme1Words = mNumberOfPhoneme1Words + 1
                ReDim Preserve mPhoneme1List(mNumberOfPhoneme1Words)
                Let mPhoneme1List(mNumberOfPhoneme1Words) = mWords(WordIndex)
                Print #2, mWords(WordIndex)
            End If
        Next WordIndex
        Close #2
        Open App.Path + "/output/ListOfWordsWith " + Trim(Phoneme2) + ".txt" For Output As #2
        For WordIndex = 1 To mNumberOfWords
            If Replace(mWords(WordIndex), Phoneme2, "") <> mWords(WordIndex) Then
                Let mNumberOfPhoneme2Words = mNumberOfPhoneme2Words + 1
                ReDim Preserve mPhoneme2List(mNumberOfPhoneme2Words)
                Let mPhoneme2List(mNumberOfPhoneme2Words) = mWords(WordIndex)
                Print #2, mWords(WordIndex)
            End If
        Next WordIndex
        Close #2
        
        MsgBox Str(mNumberOfPhoneme1Words) + " words have " + Phoneme1 + ", " + Str(mNumberOfPhoneme2Words) + " words have " + Phoneme2 + ".  Click OK to continue."
        
    Let Command1.Caption = "Begun search for minimal pairs ..."
    Open App.Path + "/output/MinimalPairsFor" + Trim(Phoneme1) + "And" + Trim(Phoneme2) + ".txt" For Output As #2
    For Phoneme1Index = 1 To mNumberOfPhoneme1Words
        If Phoneme1Index / 100 = Int(Phoneme1Index / 100) Then
            Let Command1.Caption = "Completed " + Str(Phoneme1Index) + " / " + Str(mNumberOfPhoneme1Words) + " words containing " + Phoneme1 + "."
        End If
        Let MyWord = mPhoneme1List(Phoneme1Index)
        For Phoneme2Index = 1 To mNumberOfPhoneme2Words
            If Replace(mPhoneme2List(Phoneme2Index), Phoneme2, Phoneme1) = MyWord Then
                Print #2, Trim(MyWord); Chr(9); Trim(mPhoneme2List(Phoneme2Index))
            End If
        Next Phoneme2Index
    Next Phoneme1Index
    Close
    
    Let Command1.Caption = "Done!  Click again to exit."
        

End Sub

Private Sub mnuHelp_Click()
    Dim m As String
    Let m = "Find minimal pairs.  "
    Let m = m + Chr(13) + Chr(13)
    Let m = m + "There should be a file called in.txt, in the same folder as this program, that has words in plain text format, one word per line."
    Let m = m + " Phonetic symbols should be plain text; a symbol can have more than one character in it; separate the symbols with spaces, like this:  K AE1 T."
    Let m = m + Chr(13) + Chr(13)
    Let m = m + "In the main program window, enter the two symbols you want minimal pairs for.  The program will put lists of words having these two symbols, plus a file with the minimal pairs, in the Output folder.  Be sure that this folder exists before you run the program."
    Let m = m + Chr(13) + Chr(13)
    Let m = m + "If your word list is long and your two symbols are common phonemes, be prepared to wait a while for the program to finish."
    Let m = m + Chr(13) + Chr(13)
    Let m = m + "Bugs, comments, etc. to Bruce Hayes at bhayes@humnet.ucla.edu."
    MsgBox m
    
    
End Sub
