/*
 * Decompiled with CFR 0.152.
 */
package program.mainUI.inforTree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import program.grammar.Grammar;
import program.mainUI.Interface;
import program.mainUI.drawingPanel.Plain;
import program.mainUI.inforTree.IndexNode;

public class SentenceTree
extends JPanel {
    JPanel buttons = new JPanel();
    JButton newCategory = new JButton("New Category");
    Interface treeMode;
    JScrollPane scrollPane;
    public STree sentence;
    public DefaultMutableTreeNode presentNode;
    boolean pasteStatus = false;
    public Interface.TeacherPanel teacherPanel;
    public Plain treeModePlain;
    public String status = "Add";
    IndexNode copyNode;
    JPopupMenu popup = new JPopupMenu();
    JMenuItem nc = new JMenuItem("New Category");
    JMenuItem delete = new JMenuItem("Delete");

    public void selectNode() {
        this.teacherPanel.clean.doClick();
        this.treeModePlain.clearUndo();
        if (this.presentNode != this.sentence.root) {
            IndexNode present = (IndexNode)this.presentNode;
            if (this.treeMode.status.equals("edit")) {
                if (present.type.equals("sentence")) {
                    this.treeMode.forSentenceEdit();
                    Rectangle bounds = this.treeModePlain.drawroom.getViewport().getViewRect();
                    present.outputTree(this.teacherPanel.sentence, this.teacherPanel.meaning, this.treeModePlain, bounds);
                } else if (present.type.equals("instruction")) {
                    this.treeMode.forInstructionEdit();
                    this.treeModePlain.dialogue.setText(present.instruction);
                } else if (present.type.equals("folder")) {
                    this.treeMode.forFolder();
                }
            } else if (present.type.equals("sentence")) {
                this.treeMode.forSentence();
                Rectangle bounds = this.treeModePlain.drawroom.getViewport().getViewRect();
                present.outputTree(this.teacherPanel.sentence, this.teacherPanel.meaning, this.treeModePlain, bounds);
            } else if (present.type.equals("instruction")) {
                this.treeMode.forInstruction();
                this.treeModePlain.dialogue.setText(present.instruction);
            } else if (present.type.equals("folder")) {
                this.treeMode.forFolder();
            }
        } else {
            this.treeMode.forFolder();
        }
    }

    public void changeSTree(STree tree) {
        this.sentence.changeRoot(tree.root);
        this.presentNode = this.sentence.root;
        this.scrollPane.setViewportView(this.sentence);
    }

    public SentenceTree(Interface treeModeInput) {
        this.treeMode = treeModeInput;
        this.treeModePlain = this.treeMode.drawingPanel;
        this.teacherPanel = this.treeMode.teacherPanel;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.buttons.add(this.newCategory);
        this.newCategory.setVisible(false);
        this.newCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SentenceTree.this.addCategory();
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weighty = 0.0;
        this.add((Component)this.buttons, c);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Sentences");
        this.sentence = new STree(root, "default");
        this.sentence.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = SentenceTree.this.sentence.getClosestPathForLocation(e.getX(), e.getY());
                SentenceTree.this.sentence.setSelectionPath(path);
                try {
                    SentenceTree.this.treeMode.saveTree();
                    ((DefaultTreeModel)SentenceTree.this.sentence.getModel()).reload(SentenceTree.this.presentNode);
                }
                catch (Exception pp) {
                    pp.printStackTrace();
                }
                try {
                    SentenceTree.this.presentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                    SentenceTree.this.selectNode();
                }
                catch (Exception ell) {
                    ell.printStackTrace();
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    if (SentenceTree.this.presentNode.equals(SentenceTree.this.sentence.root)) {
                        new PopUp("root").show(e.getComponent(), e.getX(), e.getY());
                    } else {
                        IndexNode now = (IndexNode)SentenceTree.this.presentNode;
                        if (now.type.equals("instruction")) {
                            new PopUp("instruction").show(e.getComponent(), e.getX(), e.getY());
                        } else if (now.type.equals("folder")) {
                            new PopUp("folder").show(e.getComponent(), e.getX(), e.getY());
                        } else if (now.type.equals("sentence")) {
                            new PopUp("sentence").show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                }
            }
        });
        int i = 0;
        while (i < this.sentence.getRowCount()) {
            this.sentence.expandRow(i);
            ++i;
        }
        this.scrollPane = new JScrollPane(this.sentence);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.scrollPane, c);
        this.popup.add(this.nc);
        this.popup.add(this.delete);
    }

    private IndexNode copyNode(IndexNode original) {
        String name = original.name;
        String type = original.type;
        IndexNode r = new IndexNode("", name, type);
        r.instruction = original.instruction;
        r.tree = original.tree.copyTree();
        return r;
    }

    public IndexNode copyWholeNode(IndexNode original) {
        IndexNode now;
        IndexNode r = this.copyNode(original);
        Stack<IndexNode> process = new Stack<IndexNode>();
        int i = 0;
        while (i < original.getChildCount()) {
            now = (IndexNode)original.getChildAt(i);
            IndexNode childAsNow = this.copyNode(now);
            process.add(now);
            process.add(childAsNow);
            r.add(childAsNow);
            ++i;
        }
        while (process.size() > 0) {
            IndexNode nowcopy = (IndexNode)process.pop();
            now = (IndexNode)process.pop();
            int i2 = 0;
            while (i2 < now.getChildCount()) {
                IndexNode child = (IndexNode)now.getChildAt(i2);
                IndexNode childcopy = this.copyNode(child);
                process.add(child);
                process.add(childcopy);
                nowcopy.add(childcopy);
                ++i2;
            }
        }
        return r;
    }

    private static Vector<String> addCategoryWindow() {
        JTextField name = new JTextField("");
        JTextArea instruction = new JTextArea("");
        instruction.setLineWrap(true);
        instruction.setWrapStyleWord(true);
        JScrollPane ip = new JScrollPane(instruction);
        ip.setPreferredSize(new Dimension(300, 200));
        JPanel panel = new JPanel(new GridBagLayout());
        Vector<String> r = new Vector<String>();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        panel.add((Component)new JLabel("Please enter the name of the category"), c);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        panel.add((Component)name, c);
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 1;
        panel.add((Component)new JLabel("Please enter information or instruction of this category"), c);
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 1;
        panel.add((Component)ip, c);
        int result = JOptionPane.showConfirmDialog(null, panel, "New Category", 2, -1);
        if (result != 0) {
            return null;
        }
        r.add(name.getText());
        r.add(instruction.getText());
        return r;
    }

    public void addCategory() {
        Vector<String> info = SentenceTree.addCategoryWindow();
        if (info != null) {
            String name = info.elementAt(0);
            String instruction = info.elementAt(1);
            IndexNode node = new IndexNode("", name, "folder");
            IndexNode in = new IndexNode("", "instruction", "instruction");
            in.instruction = instruction;
            node.add(in);
            if (this.presentNode.equals(this.sentence.root)) {
                if (this.presentNode.getChildCount() > 0 && ((IndexNode)this.presentNode.getChildAt((int)0)).type.equals("instruction")) {
                    this.presentNode.insert(node, 1);
                } else {
                    this.presentNode.insert(node, 0);
                }
                ((DefaultTreeModel)this.sentence.getModel()).nodeStructureChanged(this.presentNode);
            } else {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.presentNode.getParent();
                int index = parent.getIndex(this.presentNode);
                parent.insert(node, index + 1);
                ((DefaultTreeModel)this.sentence.getModel()).nodeStructureChanged(this.presentNode.getParent());
            }
            this.sentence.resetIndex();
            this.sentence.expandPath(new TreePath(node.getPath()));
            this.sentence.setSelectionPath(new TreePath(node.getPath()));
            this.presentNode = node;
            this.selectNode();
        }
    }

    private static String renameWindow() {
        JTextField name = new JTextField("");
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        panel.add((Component)new JLabel("Please enter a new name"), c);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        panel.add((Component)name, c);
        int result = JOptionPane.showConfirmDialog(null, panel, "Rename", 2, -1);
        if (result != 0) {
            return null;
        }
        String r = name.getText();
        return r;
    }

    private static void errorWindow() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        panel.add((Component)new JLabel("Instruction cannot be replaced by non-instruction object."), c);
        JOptionPane.showMessageDialog(null, panel, "Error", 0);
    }

    public void addSentence(Interface.Tree tree, DefaultMutableTreeNode node) {
        IndexNode addedSentence = new IndexNode(tree);
        if (node == this.sentence.root) {
            node.add(addedSentence);
            ((DefaultTreeModel)this.sentence.getModel()).nodeStructureChanged(node);
            this.sentence.resetIndex();
            this.sentence.expandPath(new TreePath(node.getPath()));
        } else {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            int index = parent.getIndex(node);
            parent.insert(addedSentence, index + 1);
            ((DefaultTreeModel)this.sentence.getModel()).nodeStructureChanged(parent);
            this.sentence.resetIndex();
            this.sentence.expandPath(new TreePath(parent.getPath()));
        }
        this.sentence.setSelectionPath(new TreePath(addedSentence.getPath()));
        this.presentNode = addedSentence;
        ((DefaultTreeModel)this.sentence.getModel()).reload(addedSentence);
    }

    public void changeSentence(Interface.Tree tree, DefaultMutableTreeNode node) {
        IndexNode changedSentence = new IndexNode(tree);
        IndexNode now = (IndexNode)node;
        if (now.type.equals("instruction")) {
            now.instruction = this.treeModePlain.dialogue.getText();
        } else if (now.type.equals("sentence")) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            int index = parent.getIndex(node);
            parent.remove(node);
            parent.insert(changedSentence, index);
            ((DefaultTreeModel)this.sentence.getModel()).nodeStructureChanged(parent);
            this.sentence.resetIndex();
            this.sentence.setSelectionPath(new TreePath(changedSentence.getPath()));
            this.presentNode = changedSentence;
            ((DefaultTreeModel)this.sentence.getModel()).reload(changedSentence);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Grammar grammar = new Grammar();
        Plain layers = new Plain(grammar);
        Interface main_interface = new Interface(layers);
        SentenceTree st = new SentenceTree(main_interface);
        frame.add(st);
        frame.setVisible(true);
        frame.pack();
    }

    public void updateATreeNode(IndexNode now, Interface.Tree tree) {
        this.sentence.updateATreenNode(now, tree);
    }

    class PopUp
    extends JPopupMenu {
        JMenuItem delete = new JMenuItem("Delete");
        JMenuItem rename = new JMenuItem("Rename");
        JMenuItem copy = new JMenuItem("Copy");
        JMenuItem cut = new JMenuItem("Cut");
        JMenuItem paste = new JMenuItem("Paste After");
        JMenuItem newCategoryAfter = new JMenuItem("Insert New Category After");
        JMenuItem pasteReplace = new JMenuItem("Paste To Replace");

        public PopUp(String type) {
            if (type.equals("root")) {
                this.add(this.rename);
            }
            if (type.equals("folder")) {
                this.add(this.delete);
                this.add(this.rename);
                this.add(this.copy);
                this.add(this.cut);
                this.add(this.paste);
                this.add(this.pasteReplace);
                this.add(this.newCategoryAfter);
            } else if (type.equals("instruction")) {
                this.add(this.copy);
                this.add(this.paste);
                this.add(this.pasteReplace);
                this.add(this.newCategoryAfter);
            } else if (type.equals("sentence")) {
                this.add(this.delete);
                this.add(this.copy);
                this.add(this.cut);
                this.add(this.paste);
                this.add(this.pasteReplace);
                this.add(this.newCategoryAfter);
            }
            this.delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)((PopUp)PopUp.this).SentenceTree.this.presentNode.getParent();
                    DefaultMutableTreeNode next = ((PopUp)PopUp.this).SentenceTree.this.presentNode.getNextSibling();
                    if (next == null) {
                        next = ((PopUp)PopUp.this).SentenceTree.this.presentNode.getPreviousSibling();
                    }
                    if (next == null) {
                        next = parent;
                    }
                    parent.remove(((PopUp)PopUp.this).SentenceTree.this.presentNode);
                    ((DefaultTreeModel)((PopUp)PopUp.this).SentenceTree.this.sentence.getModel()).nodeStructureChanged(parent);
                    ((PopUp)PopUp.this).SentenceTree.this.sentence.resetIndex();
                    ((PopUp)PopUp.this).SentenceTree.this.sentence.expandPath(new TreePath(next.getPath()));
                    ((PopUp)PopUp.this).SentenceTree.this.sentence.setSelectionPath(new TreePath(next.getPath()));
                    ((PopUp)PopUp.this).SentenceTree.this.presentNode = next;
                }
            });
            this.rename.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String name = SentenceTree.renameWindow();
                    if (name != null) {
                        if (((PopUp)PopUp.this).SentenceTree.this.presentNode == ((PopUp)PopUp.this).SentenceTree.this.sentence.root) {
                            ((PopUp)PopUp.this).SentenceTree.this.presentNode.setUserObject(name);
                        } else {
                            IndexNode now = (IndexNode)((PopUp)PopUp.this).SentenceTree.this.presentNode;
                            now.setUserObject(String.valueOf(now.index) + " " + name);
                        }
                        ((DefaultTreeModel)((PopUp)PopUp.this).SentenceTree.this.sentence.getModel()).reload(((PopUp)PopUp.this).SentenceTree.this.presentNode);
                        ((PopUp)PopUp.this).SentenceTree.this.sentence.expandPath(new TreePath(((PopUp)PopUp.this).SentenceTree.this.presentNode.getPath()));
                    }
                }
            });
            this.copy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((PopUp)PopUp.this).SentenceTree.this.copyNode = SentenceTree.this.copyWholeNode((IndexNode)((PopUp)PopUp.this).SentenceTree.this.presentNode);
                    ((PopUp)PopUp.this).SentenceTree.this.pasteStatus = true;
                }
            });
            this.paste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)((PopUp)PopUp.this).SentenceTree.this.presentNode.getParent();
                    int index = parent.getIndex(((PopUp)PopUp.this).SentenceTree.this.presentNode);
                    parent.insert(((PopUp)PopUp.this).SentenceTree.this.copyNode, index + 1);
                    ((DefaultTreeModel)((PopUp)PopUp.this).SentenceTree.this.sentence.getModel()).nodeStructureChanged(parent);
                    ((PopUp)PopUp.this).SentenceTree.this.sentence.resetIndex();
                    ((PopUp)PopUp.this).SentenceTree.this.sentence.expandPath(new TreePath(((PopUp)PopUp.this).SentenceTree.this.copyNode.getPath()));
                    ((PopUp)PopUp.this).SentenceTree.this.sentence.setSelectionPath(new TreePath(((PopUp)PopUp.this).SentenceTree.this.copyNode.getPath()));
                    ((PopUp)PopUp.this).SentenceTree.this.presentNode = ((PopUp)PopUp.this).SentenceTree.this.copyNode;
                    ((PopUp)PopUp.this).SentenceTree.this.pasteStatus = false;
                }
            });
            if (!SentenceTree.this.pasteStatus) {
                this.paste.setEnabled(false);
            }
            this.pasteReplace.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IndexNode present = (IndexNode)((PopUp)PopUp.this).SentenceTree.this.presentNode;
                    if (present.type.equals("instruction")) {
                        if (((PopUp)PopUp.this).SentenceTree.this.copyNode.type != "instruction") {
                            SentenceTree.errorWindow();
                        } else {
                            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)((PopUp)PopUp.this).SentenceTree.this.presentNode.getParent();
                            int index = parent.getIndex(((PopUp)PopUp.this).SentenceTree.this.presentNode);
                            parent.insert(((PopUp)PopUp.this).SentenceTree.this.copyNode, index);
                            parent.remove(((PopUp)PopUp.this).SentenceTree.this.presentNode);
                            ((DefaultTreeModel)((PopUp)PopUp.this).SentenceTree.this.sentence.getModel()).nodeStructureChanged(parent);
                            ((PopUp)PopUp.this).SentenceTree.this.sentence.resetIndex();
                            ((PopUp)PopUp.this).SentenceTree.this.sentence.expandPath(new TreePath(((PopUp)PopUp.this).SentenceTree.this.copyNode.getPath()));
                            ((PopUp)PopUp.this).SentenceTree.this.sentence.setSelectionPath(new TreePath(((PopUp)PopUp.this).SentenceTree.this.copyNode.getPath()));
                            ((PopUp)PopUp.this).SentenceTree.this.presentNode = ((PopUp)PopUp.this).SentenceTree.this.copyNode;
                        }
                    } else {
                        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)((PopUp)PopUp.this).SentenceTree.this.presentNode.getParent();
                        int index = parent.getIndex(((PopUp)PopUp.this).SentenceTree.this.presentNode);
                        parent.insert(((PopUp)PopUp.this).SentenceTree.this.copyNode, index);
                        parent.remove(((PopUp)PopUp.this).SentenceTree.this.presentNode);
                        ((DefaultTreeModel)((PopUp)PopUp.this).SentenceTree.this.sentence.getModel()).nodeStructureChanged(parent);
                        ((PopUp)PopUp.this).SentenceTree.this.sentence.resetIndex();
                        ((PopUp)PopUp.this).SentenceTree.this.sentence.expandPath(new TreePath(((PopUp)PopUp.this).SentenceTree.this.copyNode.getPath()));
                        ((PopUp)PopUp.this).SentenceTree.this.sentence.setSelectionPath(new TreePath(((PopUp)PopUp.this).SentenceTree.this.copyNode.getPath()));
                        ((PopUp)PopUp.this).SentenceTree.this.presentNode = ((PopUp)PopUp.this).SentenceTree.this.copyNode;
                    }
                    ((PopUp)PopUp.this).SentenceTree.this.pasteStatus = false;
                }
            });
            if (!SentenceTree.this.pasteStatus) {
                this.pasteReplace.setEnabled(false);
            }
            this.cut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((PopUp)PopUp.this).SentenceTree.this.copyNode = (IndexNode)((PopUp)PopUp.this).SentenceTree.this.presentNode;
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)((PopUp)PopUp.this).SentenceTree.this.presentNode.getParent();
                    DefaultMutableTreeNode next = ((PopUp)PopUp.this).SentenceTree.this.presentNode.getNextSibling();
                    if (next == null) {
                        next = ((PopUp)PopUp.this).SentenceTree.this.presentNode.getPreviousSibling();
                    }
                    if (next == null) {
                        next = parent;
                    }
                    parent.remove(((PopUp)PopUp.this).SentenceTree.this.presentNode);
                    ((DefaultTreeModel)((PopUp)PopUp.this).SentenceTree.this.sentence.getModel()).nodeStructureChanged(parent);
                    ((PopUp)PopUp.this).SentenceTree.this.sentence.resetIndex();
                    ((PopUp)PopUp.this).SentenceTree.this.sentence.expandPath(new TreePath(parent.getPath()));
                    ((PopUp)PopUp.this).SentenceTree.this.sentence.setSelectionPath(new TreePath(next.getPath()));
                    ((PopUp)PopUp.this).SentenceTree.this.presentNode = next;
                    ((PopUp)PopUp.this).SentenceTree.this.pasteStatus = true;
                    PopUp.this.paste.setEnabled(true);
                }
            });
            this.newCategoryAfter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SentenceTree.this.addCategory();
                }
            });
        }
    }

    public class STree
    extends JTree {
        public DefaultMutableTreeNode root;
        public IndexNode instructionNode;

        public void teacherupdate() {
            Stack<IndexNode> process = new Stack<IndexNode>();
            int i = 0;
            while (i < this.root.getChildCount()) {
                IndexNode now = (IndexNode)this.root.getChildAt(i);
                process.add(now);
                ++i;
            }
            while (process.size() > 0) {
                IndexNode now = (IndexNode)process.pop();
                if (now.type.equals("sentence")) {
                    now.tree.changeStructureToTree(now.structure);
                    continue;
                }
                if (!now.type.equals("folder")) continue;
                int i2 = 0;
                while (i2 < now.getChildCount()) {
                    IndexNode toadd = (IndexNode)now.getChildAt(i2);
                    process.add(toadd);
                    ++i2;
                }
            }
        }

        public void studentupdate() {
            Stack<IndexNode> process = new Stack<IndexNode>();
            int i = 0;
            while (i < this.root.getChildCount()) {
                IndexNode now = (IndexNode)this.root.getChildAt(i);
                process.add(now);
                ++i;
            }
            while (process.size() > 0) {
                IndexNode now = (IndexNode)process.pop();
                if (now.type.equals("sentence")) {
                    if (now.response.equals("none") || now.response.equals("error") || now.response.equals("")) {
                        now.tree.changeStructureToTree2(now.structure);
                        continue;
                    }
                    now.tree.changeStructureToTree(now.response);
                    continue;
                }
                if (!now.type.equals("folder")) continue;
                int i2 = 0;
                while (i2 < now.getChildCount()) {
                    IndexNode toadd = (IndexNode)now.getChildAt(i2);
                    process.add(toadd);
                    ++i2;
                }
            }
        }

        public STree(DefaultMutableTreeNode rootInput, String mode) {
            super(rootInput);
            this.root = rootInput;
            if (mode.equals("default")) {
                IndexNode instruction0 = new IndexNode("0.", "instruction", "instruction");
                instruction0.instruction = "Please import a sentence set by clicking ->File->Open";
                this.root.add(instruction0);
                this.instructionNode = instruction0;
                super.setSelectionPath(new TreePath(this.instructionNode.getPath()));
                SentenceTree.this.presentNode = this.instructionNode;
                SentenceTree.this.treeMode.forInstructionEdit();
                SentenceTree.this.treeModePlain.dialogue.setText(this.instructionNode.instruction);
            } else {
                super.setSelectionPath(new TreePath(this.instructionNode.getPath()));
                SentenceTree.this.presentNode = this.root;
                SentenceTree.this.treeMode.forFolder();
            }
            this.setCellRenderer(new MyTreeCellRenderer());
        }

        public void resetIndex(IndexNode node) {
            int i = 0;
            while (i < node.getChildCount()) {
                IndexNode child = (IndexNode)node.getChildAt(i);
                child.changeIndex(String.valueOf(node.index) + i + ".");
                ((DefaultTreeModel)this.getModel()).nodeStructureChanged(child);
                ++i;
            }
        }

        public void changeRoot(DefaultMutableTreeNode node) {
            this.root = node;
            DefaultMutableTreeNode root = node;
            DefaultTreeModel model = new DefaultTreeModel(root);
            this.setModel(null);
            this.setModel(model);
        }

        public void resetIndex() {
            Stack<IndexNode> process = new Stack<IndexNode>();
            int i = 0;
            while (i < this.root.getChildCount()) {
                IndexNode node = (IndexNode)this.root.getChildAt(i);
                node.changeIndex(String.valueOf(i) + ".");
                process.add(node);
                ((DefaultTreeModel)this.getModel()).reload(node);
                ++i;
            }
            while (process.size() > 0) {
                IndexNode now = (IndexNode)process.pop();
                int i2 = 0;
                while (i2 < now.getChildCount()) {
                    IndexNode node = (IndexNode)now.getChildAt(i2);
                    node.changeIndex(String.valueOf(now.index) + i2 + ".");
                    ((DefaultTreeModel)this.getModel()).reload(node);
                    process.add(node);
                    ++i2;
                }
            }
        }

        public void updateATreenNode(IndexNode now, Interface.Tree tree) {
            now.updateTree(tree);
            ((DefaultTreeModel)this.getModel()).reload(now);
        }

        public void setSelectedNode(DefaultMutableTreeNode x) {
            super.setSelectionPath(new TreePath(x.getPath()));
        }

        public class MyTreeCellRenderer
        extends DefaultTreeCellRenderer {
            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean exp, boolean leaf, int row, boolean hasFocus) {
                block6: {
                    super.getTreeCellRendererComponent(tree, value, sel, exp, leaf, row, hasFocus);
                    if (leaf) {
                        try {
                            IndexNode node = (IndexNode)value;
                            if (node.correct == 1) {
                                this.setOpaque(true);
                                this.setBackground(Color.decode("0x99FF99"));
                                break block6;
                            }
                            if (node.correct == -1) {
                                this.setOpaque(true);
                                this.setBackground(Color.decode("0xFFCCCC"));
                                break block6;
                            }
                            this.setOpaque(false);
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                    } else {
                        this.setOpaque(false);
                    }
                }
                return this;
            }
        }
    }
}

