/*
 * Decompiled with CFR 0.152.
 */
package program.mainUI.inforTree;

import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import program.grammar.Grammar;
import program.mainUI.Interface;
import program.mainUI.LMenuBar;
import program.mainUI.drawingPanel.Plain;
import program.mainUI.inforTree.IndexNode;
import program.mainUI.inforTree.NodeStorage;
import program.mainUI.inforTree.SentenceTree;

public class SentenceSetStorage {
    SentenceTree sentenceTree;
    Interface treeMode;
    SentenceTree.STree tree;
    Vector<NodeStorage> store = new Vector();
    String output;
    static String newline = System.getProperty("line.separator");

    public SentenceSetStorage(Grammar g, LMenuBar menu) {
        Plain plain = new Plain(g);
        this.treeMode = new Interface(plain);
        this.sentenceTree = new SentenceTree(this.treeMode);
        this.treeMode.teacherMode();
    }

    public boolean validString(String input) {
        return true;
    }

    private NodeStorage transformTXT2(Vector<String> block) {
        NodeStorage r = new NodeStorage();
        r.index = block.elementAt(0).split(":")[1];
        r.type = block.elementAt(1).split(":")[1];
        if (r.type.equals("sentence")) {
            String correct;
            String response;
            String sentence = block.elementAt(2).split(":")[1];
            if (sentence.equals("null")) {
                sentence = "";
            }
            r.name = sentence;
            String meaning = block.elementAt(3).split(":")[1];
            if (meaning.equals("null")) {
                meaning = "";
            }
            r.meaning = meaning;
            String structure = block.elementAt(4).split(":")[1];
            if (structure.equals("null")) {
                structure = "";
            }
            r.structure = structure;
            r.response = response = block.elementAt(5).split(":")[1];
            r.correct = correct = block.elementAt(6);
        } else if (r.type.equals("folder")) {
            String name = block.elementAt(2).split(":")[1];
            if (name.equals("null")) {
                name = "";
            }
            r.name = name;
        } else if (r.type.equals("instruction")) {
            String instruction = block.elementAt(2).split(":")[1];
            if (instruction.equals("null")) {
                instruction = "";
            }
            r.instruction = instruction;
            r.name = "instruction";
        }
        return r;
    }

    private NodeStorage transformTXT(Vector<String> block) {
        NodeStorage r = new NodeStorage();
        r.index = block.elementAt(0).split(":")[1];
        r.type = block.elementAt(1).split(":")[1];
        if (r.type.equals("sentence")) {
            String sentence = block.elementAt(2).split(":")[1];
            if (sentence.equals("null")) {
                sentence = "";
            }
            r.name = sentence;
            String meaning = block.elementAt(3).split(":")[1];
            if (meaning.equals("null")) {
                meaning = "";
            }
            r.meaning = meaning;
            String structure = block.elementAt(4).split(":")[1];
            if (structure.equals("null")) {
                structure = "";
            }
            r.structure = structure;
        } else if (r.type.equals("folder")) {
            String name = block.elementAt(2).split(":")[1];
            if (name.equals("null")) {
                name = "";
            }
            r.name = name;
        } else if (r.type.equals("instruction")) {
            String instruction = block.elementAt(2).split(":")[1];
            if (instruction.equals("null")) {
                instruction = "";
            }
            r.instruction = instruction;
            r.name = "instruction";
        }
        return r;
    }

    private IndexNode createNode(NodeStorage store) {
        IndexNode r = new IndexNode(store.index, store.name, store.type);
        if (store.type.equals("sentence")) {
            Interface.Tree tree;
            r.tree = tree = this.treeMode.createNewTree2(store.name, store.meaning, store.structure);
            r.structure = store.structure;
            if (store.correct.equals("Incorrect")) {
                r.correct = -1;
            } else if (store.correct.equals("Correct")) {
                r.correct = 1;
            }
            r.response = store.response;
        } else if (store.type.equals("instruction")) {
            r.instruction = store.instruction;
        }
        return r;
    }

    public String outputTXT2(SentenceTree.STree tree) {
        String r = "";
        r = String.valueOf(r) + tree.root.toString() + newline;
        r = String.valueOf(r) + "*" + newline;
        Vector<NodeStorage> store = this.getStorageStructure(tree);
        for (NodeStorage x : store) {
            r = String.valueOf(r) + "index:" + x.index + newline;
            r = String.valueOf(r) + "type:" + x.type + newline;
            if (x.type.equals("folder")) {
                r = String.valueOf(r) + "name:" + x.name + newline;
            } else if (x.type.equals("instruction")) {
                r = x.instruction.equals("") ? String.valueOf(r) + "instruction:null" + newline : String.valueOf(r) + "instruction:" + x.instruction + newline;
            } else if (x.type.equals("sentence")) {
                r = x.name.equals("") ? String.valueOf(r) + "sentence:null" + newline : String.valueOf(r) + "sentence:" + x.name + newline;
                r = x.meaning.equals("") ? String.valueOf(r) + "meaning:null" + newline : String.valueOf(r) + "meaning:" + x.meaning + newline;
                r = String.valueOf(r) + "response:" + x.response + newline;
                r = String.valueOf(r) + x.correct + newline;
            }
            r = String.valueOf(r) + "*" + newline;
        }
        return r;
    }

    public String outputTXT3(SentenceTree.STree tree) {
        String r = "";
        r = String.valueOf(r) + tree.root.toString() + newline;
        r = String.valueOf(r) + "*" + newline;
        Vector<NodeStorage> store = this.getStorageStructure(tree);
        for (NodeStorage x : store) {
            r = String.valueOf(r) + "index:" + x.index + newline;
            r = String.valueOf(r) + "type:" + x.type + newline;
            if (x.type.equals("folder")) {
                r = String.valueOf(r) + "name:" + x.name + newline;
            } else if (x.type.equals("instruction")) {
                r = x.instruction.equals("") ? String.valueOf(r) + "instruction:null" + newline : String.valueOf(r) + "instruction:" + x.instruction + newline;
            } else if (x.type.equals("sentence")) {
                r = x.name.equals("") ? String.valueOf(r) + "sentence:null" + newline : String.valueOf(r) + "sentence:" + x.name + newline;
                r = x.meaning.equals("") ? String.valueOf(r) + "meaning:null" + newline : String.valueOf(r) + "meaning:" + x.meaning + newline;
                r = String.valueOf(r) + "structure:" + x.structure + newline;
                r = String.valueOf(r) + "response:" + x.response + newline;
                r = String.valueOf(r) + x.correct + newline;
            }
            r = String.valueOf(r) + "*" + newline;
        }
        return r;
    }

    private Vector<NodeStorage> getStorageStructure(SentenceTree.STree tree) {
        Vector<NodeStorage> r = new Vector<NodeStorage>();
        DefaultMutableTreeNode root = tree.root;
        Stack<IndexNode> process = new Stack<IndexNode>();
        int i = 0;
        while (i < root.getChildCount()) {
            IndexNode now = (IndexNode)root.getChildAt(i);
            process.add(now);
            ++i;
        }
        while (process.size() > 0) {
            IndexNode now = (IndexNode)process.firstElement();
            process.removeElementAt(0);
            NodeStorage nowStorage = new NodeStorage();
            nowStorage.index = now.index;
            nowStorage.type = now.type;
            String name = now.name;
            if (name.equals("")) {
                name = "null";
            }
            nowStorage.name = name;
            if (now.type.equals("instruction")) {
                String instruction = now.instruction;
                if (instruction.equals("")) {
                    instruction = "null";
                }
                nowStorage.instruction = instruction;
            } else if (now.type.equals("sentence")) {
                String response;
                String meaning = now.tree.meaning;
                if (meaning.equals("")) {
                    meaning = "null";
                }
                nowStorage.meaning = meaning;
                nowStorage.response = response = now.tree.bracketForm();
                nowStorage.structure = now.structure;
                nowStorage.correct = now.correct == 1 ? "Correct" : (now.correct == 0 ? "Incomplete" : "Incorrect");
            }
            r.add(nowStorage);
            int i2 = 0;
            while (i2 < now.getChildCount()) {
                IndexNode child = (IndexNode)now.getChildAt(i2);
                process.add(child);
                ++i2;
            }
        }
        return r;
    }

    public String outputTXT(SentenceTree.STree tree) {
        String r = "";
        r = String.valueOf(r) + tree.root.toString() + newline;
        r = String.valueOf(r) + "*" + newline;
        Vector<NodeStorage> store = this.getStorageStructure(tree);
        for (NodeStorage x : store) {
            r = String.valueOf(r) + "index:" + x.index + newline;
            r = String.valueOf(r) + "type:" + x.type + newline;
            if (x.type.equals("folder")) {
                r = String.valueOf(r) + "name:" + x.name + newline;
            } else if (x.type.equals("instruction")) {
                r = x.instruction.equals("") ? String.valueOf(r) + "instruction:null" + newline : String.valueOf(r) + "instruction:" + x.instruction + newline;
            } else if (x.type.equals("sentence")) {
                r = x.name.equals("") ? String.valueOf(r) + "sentence:null" + newline : String.valueOf(r) + "sentence:" + x.name + newline;
                r = x.meaning.equals("") ? String.valueOf(r) + "meaning:null" + newline : String.valueOf(r) + "meaning:" + x.meaning + newline;
                r = String.valueOf(r) + "structure:" + x.structure + newline;
            }
            r = String.valueOf(r) + "*" + newline;
        }
        return r;
    }

    public void setTree(String input, SentenceTree.STree stree, int identifier) {
        DefaultMutableTreeNode root;
        Vector<String> lines = new Vector<String>();
        String[] stringArray = input.split("\r\n|\r|\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String x = stringArray[n2];
            lines.add(x);
            ++n2;
        }
        if (lines.elementAt(0) != "*") {
            root = new DefaultMutableTreeNode(lines.elementAt(0));
            lines.removeElementAt(0);
        } else {
            root = new DefaultMutableTreeNode("");
        }
        stree.changeRoot(root);
        Vector<String> block = new Vector<String>();
        Vector<String> lines2 = new Vector<String>();
        int i = 0;
        while (i < lines.size()) {
            if (!((String)lines.elementAt(i)).equals("")) {
                lines2.add((String)lines.elementAt(i));
            }
            ++i;
        }
        i = 1;
        while (i < lines2.size()) {
            if (!((String)lines2.elementAt(i)).equals("*")) {
                block.add((String)lines2.elementAt(i));
            } else {
                NodeStorage nowStore = identifier == 1 ? this.transformTXT(block) : this.transformTXT2(block);
                IndexNode now = this.createNode(nowStore);
                now.attachTo(root);
                if (now.type.equals("instruction")) {
                    stree.instructionNode = now;
                }
                block = new Vector();
            }
            ++i;
        }
    }

    public static void main(String[] args) {
    }
}

