/*
 * Decompiled with CFR 0.152.
 */
package program.mainUI.inforTree;

import java.awt.Rectangle;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import program.mainUI.Interface;
import program.mainUI.drawingPanel.Plain;

public class IndexNode
extends DefaultMutableTreeNode {
    String index = "";
    String name = "";
    public String type = "";
    public String structure = "";
    String response = "";
    String instruction = "";
    Interface.Tree tree = null;
    public int correct = 0;

    public IndexNode(String indexInput, String nameInput, String typeInput) {
        super(String.valueOf(indexInput) + " " + nameInput);
        this.index = indexInput;
        this.name = nameInput;
        this.type = typeInput;
    }

    public void updateTree(Interface.Tree treeInput) {
        this.name = treeInput.sentence;
        super.setUserObject(String.valueOf(this.index) + " " + this.name);
        this.type = "sentence";
        this.tree = treeInput;
    }

    public IndexNode(Interface.Tree treeInput) {
        this.name = treeInput.sentence;
        this.type = "sentence";
        this.tree = treeInput;
    }

    public void changeIndex(String x) {
        this.index = x;
        super.setUserObject(String.valueOf(this.index) + " " + this.name);
    }

    public void outputTree(JTextField sentenceString, JTextField meaning, Plain plain, Rectangle bounds) {
        sentenceString.setText(this.tree.sentence);
        meaning.setText(this.tree.meaning);
        this.tree.setLocation(bounds);
        this.tree.addInLines();
        plain.showTree(this.tree);
    }

    public void attachTo(DefaultMutableTreeNode root) {
        Object now = null;
        Vector<IndexNode> children = new Vector<IndexNode>();
        Stack<IndexNode> childrenstack = new Stack<IndexNode>();
        int i = 0;
        while (i < root.getChildCount()) {
            IndexNode xc = (IndexNode)root.getChildAt(i);
            childrenstack.add(xc);
            ++i;
        }
        while (childrenstack.size() > 0) {
            IndexNode nowc = (IndexNode)childrenstack.pop();
            children.add(nowc);
            int i2 = 0;
            while (i2 < nowc.getChildCount()) {
                IndexNode xc = (IndexNode)nowc.getChildAt(i2);
                childrenstack.add(xc);
                ++i2;
            }
        }
        String parentIndex = null;
        Pattern p = Pattern.compile("(.*)(\\d+.)$");
        Matcher m = p.matcher(this.index);
        if (m.find()) {
            parentIndex = m.group(1);
        }
        DefaultMutableTreeNode parent = null;
        for (IndexNode ji : children) {
            if (!ji.index.equals(parentIndex)) continue;
            parent = ji;
            break;
        }
        if (parent != null) {
            parent.add(this);
        } else {
            root.add(this);
        }
    }

    public void updateInstruction(String text) {
        this.instruction = text;
    }
}

