/*
 * Decompiled with CFR 0.152.
 */
package program.mainUI.drawingPanel.grammarPanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import program.grammar.Grammar;
import program.mainUI.drawingPanel.grammarPanel.LLabel;

public class SingleColumnPanel
extends JScrollPane {
    Grammar grammar;
    public JPanel back = new JPanel();

    public JLabel getTheLabel(int x, int y) {
        JLabel label = null;
        try {
            label = (JLabel)this.back.getComponentAt(x, y);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return label;
    }

    JPanel getThePanel(int x, int y) {
        Object label = null;
        JPanel panel = (JPanel)super.getComponentAt(new Point(x, y));
        while (label == null) {
            Point location = panel.getLocation();
            if (panel.getComponentAt(x -= location.x, y -= location.y) instanceof JLabel) {
                return panel;
            }
            if (panel.getComponentAt(x, y) == null) break;
            panel = (JPanel)panel.getComponentAt(x, y);
        }
        return null;
    }

    public SingleColumnPanel(Grammar x) {
        super.setViewportView(this.back);
        this.grammar = x;
        this.back.setLayout(new GridBagLayout());
        this.addingNodes();
    }

    public void updateGrammar() {
        this.back.removeAll();
        this.addingNodes();
    }

    private void addingNodes() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 0, 0);
        Vector<String> set = new Vector<String>();
        for (String x : this.grammar.set) {
            set.add(x);
        }
        Collections.sort(set);
        for (String x : set) {
            LLabel now = new LLabel(x, this.grammar);
            this.back.add((Component)now, c);
            ++c.gridy;
        }
        this.back.setSize(this.back.getPreferredSize());
        super.setSize(this.back.getSize());
        super.setPreferredSize(this.back.getSize());
    }

    public static int isOptional(String input) {
        int i = 0;
        if (input.length() > 2 && input.charAt(0) == '(' && input.charAt(input.length() - 1) == ')') {
            i = 1;
        } else if (input.length() > 0 && input.charAt(0) == '(') {
            i = 2;
        } else if (input.length() > 0 && input.charAt(input.length() - 1) == ')') {
            i = 2;
        }
        return i;
    }

    public static int isMultiple(String input) {
        int i = 0;
        if (input.length() > 2 && input.charAt(0) == '{' && input.charAt(input.length() - 1) == '}') {
            i = 1;
        }
        return i;
    }

    public static String noParenthesis(String x) {
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i < x.length() - 1) {
            sb.append(x.charAt(i));
            ++i;
        }
        String sr = sb.toString();
        return sr;
    }

    public static String nobrackets(String x) {
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i < x.length() - 1) {
            sb.append(x.charAt(i));
            ++i;
        }
        String sr = sb.toString();
        return sr;
    }

    private static void createAndShowUI() {
        JFrame frame = new JFrame("DragLabelOnLayeredPane");
        JPanel back = new JPanel();
        back.setBackground(Color.white);
        GridBagLayout lay = new GridBagLayout();
        back.setLayout(lay);
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        SingleColumnPanel pp = new SingleColumnPanel(new Grammar());
        c1.anchor = 17;
        back.add((Component)pp, c1);
        frame.getContentPane().add(back);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    public static void main(String[] args) {
        SingleColumnPanel.setUIFont(new FontUIResource("Serif", 0, 40));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SingleColumnPanel.createAndShowUI();
            }
        });
    }
}

