/*
 * Decompiled with CFR 0.152.
 */
package program.mainUI.drawingPanel.grammarPanel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import program.grammar.Block;
import program.grammar.Grammar;
import program.grammar.Rule;
import program.mainUI.drawingPanel.grammarPanel.LLabel;

public class RuleFormPanel
extends JScrollPane {
    Grammar grammar;
    public JPanel back = new JPanel();
    public int labelHeight = 0;

    public RuleFormPanel(Grammar g) {
        super.setViewportView(this.back);
        this.grammar = g;
        this.back.setLayout(new GridBagLayout());
        this.addingNodes();
    }

    private void addingNodes() {
        GridBagConstraints c = new GridBagConstraints();
        int i = 0;
        for (Rule rule : this.grammar.rules) {
            if (rule.blocks.size() <= 0) continue;
            c.gridx = 0;
            c.gridy = i;
            c.insets = new Insets(0, 5, 0, 0);
            c.fill = 2;
            LLabel head = new LLabel(rule.head.node, this.grammar);
            if (this.labelHeight == 0) {
                this.labelHeight = head.getPreferredSize().height;
            }
            head.setHorizontalAlignment(0);
            LLabel symbol = new LLabel("-->", this.grammar);
            this.back.add((Component)head, c);
            c.gridx = 1;
            this.back.add((Component)symbol, c);
            c.gridx = 2;
            c.fill = 0;
            c.anchor = 17;
            this.back.add((Component)this.getRightPanel(rule), c);
            ++i;
        }
    }

    public void updateGrammar() {
        this.back.removeAll();
        this.addingNodes();
    }

    private JPanel getBlockPanel(Block block) {
        JPanel back = new JPanel();
        back.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        if (block.type.equals("basic")) {
            LLabel now = new LLabel(block.node, this.grammar);
            back.add((Component)now, c);
        } else if (block.property.equals("substitute")) {
            int height = block.blockList.size();
            c.gridx = 0;
            c.gridy = 0;
            c.gridheight = height;
            c.fill = 1;
            LLabel left = new LLabel("{", this.grammar);
            back.add((Component)left, c);
            LLabel right = new LLabel("}", this.grammar);
            c.gridx = 2;
            back.add((Component)right, c);
            int i = 0;
            while (i < block.blockList.size()) {
                c.gridheight = 1;
                c.gridx = 1;
                c.gridy = i;
                back.add((Component)this.getBlockPanel(block.blockList.elementAt(i)), c);
                ++i;
            }
        } else {
            LLabel right;
            LLabel left;
            if (block.property.equals("optional")) {
                c.gridx = 0;
                c.gridy = 0;
                c.gridheight = 1;
                c.fill = 1;
                left = new LLabel("(", this.grammar);
                back.add((Component)left, c);
                right = new LLabel(")", this.grammar);
                c.gridx = block.blockList.size() + 1;
                back.add((Component)right, c);
            } else if (block.property.equals("together")) {
                c.gridx = 0;
                c.gridy = 0;
                c.gridheight = 1;
                c.fill = 1;
                left = new LLabel("[", this.grammar);
                back.add((Component)left, c);
                right = new LLabel("]", this.grammar);
                c.gridx = block.blockList.size() + 1;
                back.add((Component)right, c);
            } else if (block.property.equals("repetitive")) {
                if (block.blockList.size() == 1) {
                    c.gridx = 0;
                    c.gridy = 0;
                    c.gridheight = 1;
                    c.fill = 1;
                    left = new LLabel("", this.grammar);
                    back.add((Component)left, c);
                    right = new LLabel("*", this.grammar);
                    c.gridx = block.blockList.size() + 1;
                    back.add((Component)right, c);
                } else {
                    c.gridx = 0;
                    c.gridy = 0;
                    c.gridheight = 1;
                    c.fill = 1;
                    left = new LLabel("(", this.grammar);
                    back.add((Component)left, c);
                    right = new LLabel(")*", this.grammar);
                    c.gridx = block.blockList.size() + 1;
                    back.add((Component)right, c);
                }
            }
            int i = 0;
            while (i < block.blockList.size()) {
                c.gridx = i + 1;
                c.gridy = 0;
                c.gridheight = 1;
                c.fill = 1;
                if (i > 0) {
                    c.insets = new Insets(0, 5, 0, 0);
                }
                back.add((Component)this.getBlockPanel(block.blockList.elementAt(i)), c);
                ++i;
            }
        }
        return back;
    }

    private JPanel getRightPanel(Rule rule) {
        JPanel back = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        int i = 0;
        while (i < rule.blocks.size()) {
            c.gridx = i;
            c.gridy = 0;
            c.fill = 1;
            if (i > 0) {
                c.insets = new Insets(0, 5, 0, 0);
            }
            back.add((Component)this.getBlockPanel(rule.blocks.elementAt(i)), c);
            ++i;
        }
        return back;
    }

    public LLabel getTheLabel(int x, int y) {
        LLabel label = null;
        JPanel panel = this.back;
        while (label == null) {
            Point location = panel.getLocation();
            if (panel.getComponentAt(x -= location.x, y -= location.y) instanceof LLabel) {
                LLabel now = (LLabel)panel.getComponentAt(x, y);
                if (now.type.equals("symbol")) {
                    return null;
                }
                return now;
            }
            JPanel now_panel = (JPanel)panel.getComponentAt(x, y);
            if (now_panel == panel) {
                return null;
            }
            panel = (JPanel)panel.getComponentAt(x, y);
        }
        return label;
    }

    public static void main(String[] args) {
        Grammar g = new Grammar();
        RuleFormPanel j = new RuleFormPanel(g);
        JFrame frame = new JFrame("Grammar_Rule_Panel");
        frame.add(j);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

