/*
 * Decompiled with CFR 0.152.
 */
package program.mainUI.drawingPanel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import program.Preference;
import program.grammar.Grammar;
import program.grammar.HeadRule;
import program.mainUI.Interface;
import program.mainUI.LUndoEdit;
import program.mainUI.drawingPanel.Line;
import program.mainUI.drawingPanel.NodeLabel;
import program.mainUI.drawingPanel.grammarPanel.RuleFormPanel;
import program.mainUI.drawingPanel.grammarPanel.SingleColumnPanel;

public class Plain
extends JLayeredPane {
    private UndoManager undoManager = new UndoManager();
    Point beforeMove;
    int checkGEorNot = 1;
    public int locationx;
    public int locationy;
    public int locationw;
    public int locationh;
    int enabled = 1;
    MouseAdapter sgMouseAdapter;
    MouseAdapter dialogueMouseAdapter;
    MouseAdapter drMouseAdapter;
    MouseAdapter nodesMouseAdapter;
    Preference pp = new Preference();
    private int rightclick = 0;
    private NodeLabel dragLabel = null;
    JLabel labeler = null;
    private int dragLabelWidthDiv2;
    private int dragLabelHeightDiv2;
    private JPanel clickedPanel = null;
    private Point location = null;
    private Point relLocation = null;
    private Point realInLocation = null;
    Point now = null;
    JSplitPane trashDialog;
    JSplitPane right;
    final JSplitPane total;
    final JSplitPane upDown;
    Plain plain = this;
    Top top;
    Grammar grammar;
    JPanel back;
    public JTextArea dialogue;
    JScrollPane dialogueP;
    JPanel trash;
    JScrollPane trashP;
    RuleFormPanel nodes;
    public DrawPanel drawroom;
    SingleColumnPanel sg;
    JLabel info = new JLabel();
    public Vector<NodeLabel> list;
    public Vector<Line> linelist;
    NodeLabel dlabel;
    Vector<Line> dline;
    Vector<Line> deleteL;
    Vector<NodeLabel> doublenode = new Vector();
    final Vector<Point> store;
    int height = 0;
    int width = 0;
    Vector<String> error = new Vector();
    public double widthIndex = this.pp.getDouble("WidthIndex");
    public double heightIndex = this.pp.getDouble("HeightIndex");
    Point pointEnd = null;
    public MyMouseAdapter myMouseAdapter;
    int clicked = 0;

    public static void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    public static void main(String[] args) {
        Plain.setUIFont(new FontUIResource("Serif", 0, 24));
        JFrame frame = new JFrame("DragLabelOnLayeredPane");
        Grammar grammar = new Grammar();
        Plain layers = new Plain(grammar);
        frame.setPreferredSize(new Dimension(1200, 900));
        frame.add((Component)layers, "Center");
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public void changeGrammar(Grammar g) {
        this.grammar = g;
    }

    public Vector<NodeLabel> copylist(Vector<NodeLabel> list) {
        Vector<NodeLabel> r = new Vector<NodeLabel>();
        for (NodeLabel x : list) {
            NodeLabel now = new NodeLabel(x.label.getText(), this.plain);
            now.location = new Point(x.location.x, x.location.y);
            now.setLocation(now.location);
            now.color = x.color;
            now.type = x.type;
            now.grammar_error = x.grammar_error;
            r.add(now);
        }
        int i = 0;
        while (i < list.size()) {
            int index;
            NodeLabel now = list.elementAt(i);
            NodeLabel copy = r.elementAt(i);
            for (NodeLabel x : now.children) {
                index = list.indexOf(x);
                copy.children.add(r.elementAt(index));
            }
            for (NodeLabel y : now.parents) {
                index = list.indexOf(y);
                copy.parents.add(r.elementAt(index));
            }
            ++i;
        }
        return r;
    }

    public void updateGrammar() {
        this.nodes.updateGrammar();
        this.nodes.revalidate();
        this.sg.updateGrammar();
        this.sg.revalidate();
        int nodesDividerLocation = this.nodes.back.getPreferredSize().width;
        this.total.setDividerLocation(nodesDividerLocation);
        this.right.revalidate();
        this.total.revalidate();
    }

    public Vector<Line> copyLinelist(Vector<NodeLabel> copyNode, Vector<NodeLabel> list, Vector<Line> linelist) {
        int index;
        Object copy;
        Vector<Line> r = new Vector<Line>();
        for (Line x : linelist) {
            NodeLabel children;
            copy = new Line(this.plain);
            ((Line)copy).start = x.start;
            ((Line)copy).end = x.end;
            ((Line)copy).color = x.color;
            NodeLabel parent = x.parent;
            if (parent != null) {
                int index2 = list.indexOf(parent);
                ((Line)copy).parent = copyNode.elementAt(index2);
            }
            if ((children = x.children) != null) {
                index = list.indexOf(children);
                ((Line)copy).children = copyNode.elementAt(index);
            }
            r.add((Line)copy);
        }
        int i = 0;
        while (i < list.size()) {
            NodeLabel ori = list.elementAt(i);
            copy = copyNode.elementAt(i);
            for (Line x : ori.parentlines) {
                index = linelist.indexOf(x);
                ((NodeLabel)copy).parentlines.add(r.elementAt(index));
            }
            for (Line x : ori.childrenlines) {
                index = linelist.indexOf(x);
                ((NodeLabel)copy).childrenlines.add(r.elementAt(index));
            }
            ++i;
        }
        return r;
    }

    public void clean() {
        this.linelist = new Vector();
        this.list = new Vector();
        this.drawroom.canvas.removeAll();
        this.dialogue.setText("");
        this.repaint();
    }

    public Point getLocation(int i) {
        Point p1 = this.upDown.getLocation();
        Point p2 = this.total.getLocation();
        Point p3 = this.right.getLocation();
        Point p4 = this.sg.getLocation();
        Point p5 = this.trashP.getLocation();
        Point r = null;
        if (i == 1) {
            r = new Point(p1.x + p2.x, p1.y + p2.y);
        } else if (i == 2) {
            r = new Point(p1.x + p2.x + p3.x, p1.y + p2.y + p3.y);
        } else if (i == 3) {
            r = new Point(p1.x + p2.x + p3.x + p4.x, p1.y + p2.y + p3.y + p4.y);
        } else if (i == 4) {
            r = new Point(p1.x, p1.y);
        } else if (i == 5) {
            r = new Point(p1.x + p5.x, p1.y + p5.y);
        }
        return r;
    }

    public JPanel getPanel(Point p) {
        JPanel r = null;
        JSplitPane mediate = null;
        try {
            mediate = (JSplitPane)this.back.getComponentAt(p);
        }
        catch (Exception e) {
            return r;
        }
        boolean i = false;
        while (!i) {
            Point mediateLocation = mediate.getLocation();
            p = new Point(p.x - mediateLocation.x, p.y - mediateLocation.y);
            try {
                JSplitPane mediate2;
                mediate = mediate2 = (JSplitPane)mediate.getComponentAt(p);
            }
            catch (Exception e) {
                JPanel rr = null;
                try {
                    JScrollPane getReturn = (JScrollPane)mediate.getComponentAt(p);
                    p = new Point(p.x - getReturn.getLocation().x, p.y - getReturn.getLocation().y);
                    rr = (JPanel)getReturn.getViewport().getView();
                    return rr;
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
        return r;
    }

    public void showTree(Interface.Tree tree) {
        this.dialogue.setText("");
        this.list = this.copylist(tree.list);
        this.linelist = this.copyLinelist(this.list, tree.list, tree.linelist);
        this.drawroom.canvas.removeAll();
        for (NodeLabel x : this.list) {
            x.setSize(x.getPreferredSize());
            x.setColor();
            this.drawroom.canvas.add(x);
            this.drawroom.revalidate();
            this.drawroom.repaint();
        }
        this.repaint();
    }

    public void input(String s) {
        this.clean();
        Rectangle bounds = this.drawroom.getViewport().getViewRect();
        Point zeroP = this.drawroom.getViewport().getViewPosition();
        NodeLabel temp = new NodeLabel("oi", this.plain);
        int height = (int)(this.heightIndex * temp.label.getPreferredSize().getHeight());
        int heightdraw = (int)((double)(bounds.height - height) - temp.getPreferredSize().getHeight()) + zeroP.y;
        int i = 40 + zeroP.x;
        String[] stringArray = s.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String y = stringArray[n2];
            NodeLabel add = new NodeLabel(y, this.plain);
            i = (int)((double)i + this.widthIndex * add.label.getPreferredSize().getHeight());
            add.setVisible(true);
            add.setLocation(i, heightdraw);
            add.setSize(add.getPreferredSize());
            add.location = add.getLocation();
            add.type = 1;
            i = (int)((double)i + add.getPreferredSize().getWidth());
            this.list.addElement(add);
            this.drawroom.canvas.add(add);
            ++n2;
        }
        this.drawroom.revalidate();
        this.drawroom.repaint();
    }

    public void orange(NodeLabel dragLabel) {
        Vector<NodeLabel> heads = new Vector<NodeLabel>();
        for (NodeLabel x : this.list) {
            x.setColor();
            x.setPlain();
            if (x.parents.size() != 0) continue;
            heads.add(x);
        }
        if (dragLabel.type == 0 && dragLabel.children.size() == 0) {
            int i;
            Component checker2;
            Point draglu = dragLabel.location;
            Point center = new Point(draglu.x + dragLabel.getWidth() / 2, draglu.y + dragLabel.getHeight() / 2);
            boolean check = false;
            for (NodeLabel nl : this.list) {
                if (nl.parents.size() != 0) continue;
                int x1 = nl.getLocation().x + nl.label.getLocation().x;
                int x2 = x1 + nl.label.getWidth();
                int y1 = nl.getLocation().y - nl.getHeight();
                int y2 = nl.getLocation().y;
                if (center.x >= x2 || center.x <= x1 || center.y >= y2 || center.y <= y1) continue;
                nl.label.setForeground(Color.decode("0x994C00"));
                dragLabel.label.setForeground(Color.decode("0x994C00"));
                nl.setBold();
                dragLabel.setBold();
                check = true;
                break;
            }
            Collections.sort(heads);
            Component checker = null;
            if (!check) {
                for (NodeLabel xi : heads) {
                    Point center2 = new Point(xi.getLocation().x + xi.getWidth() / 2, xi.getLocation().y + xi.getHeight() / 2);
                    if (center2.y <= center.y + xi.getHeight() / 2 || center2.y >= center.y + xi.getHeight() / 2 * 3) continue;
                    if (checker == null) {
                        checker = xi;
                        continue;
                    }
                    if (Math.abs(center2.x - center.x) >= Math.abs(checker.getLocation().x + ((JComponent)checker).getWidth() / 2 - center.x)) continue;
                    checker = xi;
                }
                if (checker != null) {
                    int centerr;
                    checker2 = null;
                    int checkercenter = checker.getLocation().x + ((JComponent)checker).getWidth() / 2;
                    if (checkercenter < center.x) {
                        i = heads.indexOf(checker);
                        if (i > 0 && (centerr = ((NodeLabel)heads.elementAt((int)(i - 1))).getLocation().x + ((NodeLabel)heads.elementAt(i - 1)).getWidth() / 2) > center.x) {
                            checker2 = (NodeLabel)heads.elementAt(i - 1);
                        }
                    } else {
                        i = heads.indexOf(checker);
                        if (i < heads.size() - 1 && (centerr = ((NodeLabel)heads.elementAt((int)(i + 1))).getLocation().x + ((NodeLabel)heads.elementAt(i + 1)).getWidth() / 2) < center.x) {
                            checker2 = (NodeLabel)heads.elementAt(i + 1);
                        }
                    }
                    if (checker2 != null && ((NodeLabel)checker).type == 0 && ((NodeLabel)checker2).type == 0 && checker2.getLocation().y > center.y) {
                        check = true;
                        ((NodeLabel)checker).label.setForeground(Color.decode("0x994C00"));
                        ((NodeLabel)checker2).label.setForeground(Color.decode("0x994C00"));
                        dragLabel.label.setForeground(Color.decode("0x994C00"));
                        ((NodeLabel)checker).setBold();
                        ((NodeLabel)checker2).setBold();
                        dragLabel.setBold();
                    }
                }
            }
            if (!check) {
                checker = null;
                for (NodeLabel xi : heads) {
                    int x1 = xi.getLocation().x + xi.label.getLocation().x;
                    int x2 = x1 + xi.label.getWidth();
                    if (center.x >= x2 || center.x <= x1) continue;
                    checker = xi;
                }
                if (checker != null) {
                    checker2 = null;
                    NodeLabel checker3 = null;
                    i = heads.size() - 1;
                    while (i >= 0) {
                        if (((NodeLabel)heads.elementAt((int)i)).getLocation().x > checker.getLocation().x) {
                            checker3 = (NodeLabel)heads.elementAt(i);
                            if (i >= heads.size() - 2) break;
                            checker2 = (NodeLabel)heads.elementAt(i + 2);
                            break;
                        }
                        --i;
                    }
                    if (checker2 != null && checker3 != null && ((NodeLabel)checker).type == 0 && ((NodeLabel)checker2).type == 0 && checker3.type == 0 && checker2.getLocation().y > center.y && checker3.getLocation().y > center.y) {
                        int ymin = checker.getLocation().y;
                        if (ymin > checker2.getLocation().y) {
                            ymin = checker2.getLocation().y;
                        }
                        if (ymin > checker3.getLocation().y) {
                            ymin = checker3.getLocation().y;
                        }
                        if (center.y > ymin - 2 * ((JComponent)checker).getHeight()) {
                            check = true;
                            ((NodeLabel)checker).label.setForeground(Color.decode("0x994C00"));
                            ((NodeLabel)checker2).label.setForeground(Color.decode("0x994C00"));
                            checker3.label.setForeground(Color.decode("0x994C00"));
                            dragLabel.label.setForeground(Color.decode("0x994C00"));
                            ((NodeLabel)checker).setBold();
                            ((NodeLabel)checker2).setBold();
                            checker3.setBold();
                            dragLabel.setBold();
                        }
                    }
                }
            }
        }
    }

    private void orangeLines(NodeLabel dragLabel) {
        Vector<NodeLabel> heads = new Vector<NodeLabel>();
        for (NodeLabel x : this.list) {
            x.setPlain();
            if (x.color == 4) {
                x.label.setForeground(Color.red);
            } else {
                x.label.setForeground(Color.black);
            }
            if (x.parents.size() != 0) continue;
            heads.add(x);
        }
        if (dragLabel.type == 0 && dragLabel.children.size() == 0) {
            int i;
            Component checker2;
            Point center = new Point(dragLabel.location.x + dragLabel.getWidth() / 2, dragLabel.location.y + dragLabel.getHeight() / 2);
            boolean check = false;
            for (NodeLabel nl : this.list) {
                if (nl.parents.size() != 0) continue;
                int x1 = nl.getLocation().x + nl.label.getLocation().x;
                int x2 = x1 + nl.label.getWidth();
                int y1 = nl.getLocation().y - nl.getHeight();
                int y2 = nl.getLocation().y;
                if (center.x >= x2 || center.x <= x1 || center.y >= y2 || center.y <= y1) continue;
                this.addlines(nl, dragLabel);
                this.adjustOneTree(dragLabel);
                check = true;
                break;
            }
            Collections.sort(heads);
            Component checker = null;
            if (!check) {
                for (NodeLabel xi : heads) {
                    Point center2 = new Point(xi.getLocation().x + xi.getWidth() / 2, xi.getLocation().y + xi.getHeight() / 2);
                    if (center2.y <= center.y + xi.getHeight() / 2 || center2.y >= center.y + xi.getHeight() / 2 * 3) continue;
                    if (checker == null) {
                        checker = xi;
                        continue;
                    }
                    if (Math.abs(center2.x - center.x) >= Math.abs(checker.getLocation().x + ((JComponent)checker).getWidth() / 2 - center.x)) continue;
                    checker = xi;
                }
                if (checker != null) {
                    int centerr;
                    checker2 = null;
                    int checkercenter = checker.getLocation().x + ((JComponent)checker).getWidth() / 2;
                    if (checkercenter < center.x) {
                        i = heads.indexOf(checker);
                        if (i > 0 && (centerr = ((NodeLabel)heads.elementAt((int)(i - 1))).getLocation().x + ((NodeLabel)heads.elementAt(i - 1)).getWidth() / 2) > center.x) {
                            checker2 = (NodeLabel)heads.elementAt(i - 1);
                        }
                    } else {
                        i = heads.indexOf(checker);
                        if (i < heads.size() - 1 && (centerr = ((NodeLabel)heads.elementAt((int)(i + 1))).getLocation().x + ((NodeLabel)heads.elementAt(i + 1)).getWidth() / 2) < center.x) {
                            checker2 = (NodeLabel)heads.elementAt(i + 1);
                        }
                    }
                    if (checker2 != null && ((NodeLabel)checker).type == 0 && ((NodeLabel)checker2).type == 0 && checker2.getLocation().y > center.y) {
                        check = true;
                        this.addlines(dragLabel, (NodeLabel)checker);
                        this.addlines(dragLabel, (NodeLabel)checker2);
                        this.adjustOneTree(dragLabel);
                    }
                }
            }
            if (!check) {
                checker = null;
                for (NodeLabel xi : heads) {
                    int x1 = xi.getLocation().x + xi.label.getLocation().x;
                    int x2 = x1 + xi.label.getWidth();
                    if (center.x >= x2 || center.x <= x1) continue;
                    checker = xi;
                }
                if (checker != null) {
                    checker2 = null;
                    NodeLabel checker3 = null;
                    i = heads.size() - 1;
                    while (i >= 0) {
                        if (((NodeLabel)heads.elementAt((int)i)).getLocation().x > checker.getLocation().x) {
                            checker3 = (NodeLabel)heads.elementAt(i);
                            if (i >= heads.size() - 2) break;
                            checker2 = (NodeLabel)heads.elementAt(i + 2);
                            break;
                        }
                        --i;
                    }
                    if (checker2 != null && checker3 != null && ((NodeLabel)checker).type == 0 && ((NodeLabel)checker2).type == 0 && checker3.type == 0 && checker2.getLocation().y > center.y && checker3.getLocation().y > center.y) {
                        int ymin = checker.getLocation().y;
                        if (ymin > checker2.getLocation().y) {
                            ymin = checker2.getLocation().y;
                        }
                        if (ymin > checker3.getLocation().y) {
                            ymin = checker3.getLocation().y;
                        }
                        if (center.y > ymin - 2 * ((JComponent)checker).getHeight()) {
                            check = true;
                            this.addlines(dragLabel, (NodeLabel)checker);
                            this.addlines(dragLabel, (NodeLabel)checker2);
                            this.addlines(dragLabel, checker3);
                            this.adjustOneTree(dragLabel);
                        }
                    }
                }
            }
        }
    }

    private void findaddinline(NodeLabel dragLabel) {
        Line cl = null;
        for (Line i : this.linelist) {
            if (!dragLabel.crosslingLine(i)) continue;
            cl = i;
            break;
        }
        if (cl != null) {
            cl.color = 6;
            this.top.repaint();
        }
    }

    private NodeLabel findHead(NodeLabel x) {
        Stack<NodeLabel> stack = new Stack<NodeLabel>();
        stack.add(x);
        NodeLabel r = null;
        while (stack.size() > 0) {
            NodeLabel now = (NodeLabel)stack.pop();
            if (now.parents.size() == 0) {
                r = now;
                continue;
            }
            if (now.parents.size() > 1) {
                return null;
            }
            stack.add(now.parents.elementAt(0));
        }
        return r;
    }

    private void addinline(NodeLabel dragLabel) {
        Line cl = null;
        for (Line i : this.linelist) {
            if (!dragLabel.crosslingLine(i)) continue;
            cl = i;
            break;
        }
        if (cl != null && cl.parent != null && cl.children != null) {
            this.removelines(cl.parent, cl.children);
            this.addlines(dragLabel, cl.parent);
            this.addlines(dragLabel, cl.children);
            this.adjustOneTree(this.findHead(cl.parent));
        }
    }

    public void removeNode(NodeLabel dlabel) {
        this.drawroom.remove(dlabel);
        Vector<NodeLabel> others = new Vector<NodeLabel>();
        for (NodeLabel x : dlabel.children) {
            others.add(x);
        }
        for (NodeLabel x : dlabel.parents) {
            others.add(x);
        }
        for (NodeLabel x : others) {
            this.removelines(dlabel, x);
        }
        this.list.remove(dlabel);
        Vector<Line> ll = new Vector<Line>();
        for (Line x : this.linelist) {
            if (x.parent != dlabel && x.children != dlabel) continue;
            ll.add(x);
        }
        for (Line xy : ll) {
            this.linelist.remove(xy);
        }
        this.repaint();
    }

    static boolean inRange(Line line, Point p) {
        int mx = line.start.x;
        int my = line.start.y;
        int nx = line.end.x;
        int ny = line.end.y;
        int px = p.x;
        int py = p.y;
        double length = Math.sqrt((mx - nx) * (mx - nx) + (my - ny) * (my - ny));
        double rangeLength = length / 5.0;
        if (mx == nx) {
            if (px - mx > -5 && px - mx < 5 && my > ny) {
                if ((double)py <= (double)my - rangeLength && (double)py >= (double)ny + rangeLength) {
                    return true;
                }
                if ((double)py <= (double)ny - rangeLength && (double)py >= (double)my + rangeLength) {
                    return true;
                }
            }
        } else if (my == ny) {
            if (mx > nx) {
                if ((double)px <= (double)mx - rangeLength && (double)px >= (double)nx + rangeLength) {
                    return true;
                }
                if ((double)px <= (double)nx - rangeLength && (double)px >= (double)mx + rangeLength) {
                    return true;
                }
            }
        } else {
            double tangent = -1.0 / (double)(my - ny) * (double)(mx - nx);
            double c = (double)py - tangent * (double)px;
            double t = (double)(my - ny) / (double)(mx - nx);
            double ct = (double)my - t * (double)mx;
            double x = (c - ct) / (t - tangent);
            double y = x * tangent + c;
            if ((x - (double)px) * (x - (double)px) + (y - (double)py) * (y - (double)py) < 25.0) {
                double xx = rangeLength / Math.sqrt(1.0 + t * t);
                if (mx < nx ? x < (double)nx - xx && x > (double)mx + xx : x > (double)nx + xx && x < (double)mx - xx) {
                    return true;
                }
            }
        }
        return false;
    }

    public void adjustOneTree(NodeLabel head) {
        NodeLabel now;
        Stack<NodeLabel> tree;
        Stack<NodeLabel> terminals;
        Stack<NodeLabel> process1 = new Stack<NodeLabel>();
        int maxnonwords = 0;
        int maxwords = 0;
        head.level = 1;
        if (head.children.size() == 0) {
            if (head.type == 1) {
                maxwords = 1;
            } else {
                maxnonwords = 1;
            }
        } else {
            process1.add(head);
            while (process1.size() > 0) {
                NodeLabel now2 = (NodeLabel)process1.pop();
                for (NodeLabel c : now2.children) {
                    c.level = now2.level + 1;
                    process1.add(c);
                    if (c.children.size() == 0 && c.type != 1 && c.level > maxnonwords) {
                        maxnonwords = c.level;
                    }
                    if (c.type != 1 || c.children.size() != 0 || c.level <= maxwords) continue;
                    maxwords = c.level;
                }
            }
        }
        if (maxwords > 0 && maxnonwords == 0) {
            int total = maxwords + 1;
            process1.add(head);
            int y = 0;
            Stack<NodeLabel> queue = new Stack<NodeLabel>();
            while (process1.size() > 0) {
                NodeLabel nodeLabel = (NodeLabel)process1.firstElement();
                process1.remove(0);
                queue.add(nodeLabel);
                if (nodeLabel.children.size() == 0 && y == 0) {
                    y = nodeLabel.location.y;
                }
                nodeLabel.level = nodeLabel.type == 1 ? 1 : total - nodeLabel.level;
                for (NodeLabel x : nodeLabel.children) {
                    process1.add(x);
                }
            }
            while (queue.size() > 0) {
                NodeLabel nodeLabel = (NodeLabel)queue.pop();
                if (nodeLabel.level > 1) {
                    nodeLabel.location.y = (int)((double)(y - (nodeLabel.level - 1) * nodeLabel.getHeight()) - (double)(nodeLabel.level - 1) * this.heightIndex * (double)nodeLabel.label.getHeight());
                }
                if (nodeLabel.parents.size() <= 0 || nodeLabel == head) continue;
                NodeLabel nowparent = nodeLabel.parents.elementAt(0);
                Collections.sort(nowparent.children);
                int x2 = nowparent.children.firstElement().location.x + nowparent.children.firstElement().getWidth();
                int x1 = nowparent.children.lastElement().location.x;
                nowparent.location.x = (x2 + x1) / 2 - nowparent.getWidth() / 2;
                for (NodeLabel cw : nowparent.children) {
                    try {
                        queue.remove(cw);
                        if (cw.level <= 1) continue;
                        cw.location.y = (int)((double)(y - (cw.level - 1) * cw.getHeight()) - (double)(cw.level - 1) * this.heightIndex * (double)cw.label.getHeight());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        } else if (maxnonwords > 0 && maxwords == 0) {
            int x;
            terminals = new Stack();
            tree = new Stack();
            process1.add(head);
            while (process1.size() > 0) {
                now = (NodeLabel)process1.pop();
                tree.add(now);
                for (NodeLabel nodeLabel : now.children) {
                    process1.add(nodeLabel);
                }
            }
            for (NodeLabel wh : tree) {
                if (wh.level > 1) {
                    wh.location.y = (int)((double)head.location.y + (double)(wh.level - 1) * ((double)wh.getHeight() + (double)wh.label.getHeight() * this.heightIndex));
                }
                if (wh.children.size() != 0) continue;
                terminals.add(wh);
            }
            Collections.sort(terminals);
            int n = x = ((NodeLabel)terminals.lastElement()).location.x;
            int i = terminals.size() - 1;
            while (i >= 0) {
                int n2;
                ((NodeLabel)terminals.elementAt((int)i)).location.x = n2;
                n2 = (int)((double)n2 + ((double)((NodeLabel)terminals.elementAt(i)).getWidth() + (double)((NodeLabel)terminals.elementAt((int)i)).label.getHeight() * this.widthIndex));
                --i;
            }
            while (terminals.size() > 0) {
                NodeLabel now4 = (NodeLabel)terminals.pop();
                if (now4.parents.size() <= 0 || now4 == head) continue;
                NodeLabel nowparent = now4.parents.firstElement();
                Collections.sort(nowparent.children);
                int x1 = nowparent.children.lastElement().location.x;
                int x2 = nowparent.children.firstElement().location.x + nowparent.children.firstElement().getWidth();
                int center = (x1 + x2) / 2;
                nowparent.location.x = center - nowparent.getWidth() / 2;
                terminals.add(nowparent);
                for (NodeLabel jh : nowparent.children) {
                    try {
                        terminals.remove(jh);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        } else {
            int x;
            terminals = new Stack<NodeLabel>();
            tree = new Stack<NodeLabel>();
            process1.add(head);
            while (process1.size() > 0) {
                now = (NodeLabel)process1.pop();
                tree.add(now);
                for (NodeLabel nodeLabel : now.children) {
                    process1.add(nodeLabel);
                }
            }
            for (NodeLabel wh : tree) {
                if (wh.children.size() != 0) continue;
                terminals.add(wh);
            }
            Collections.sort(terminals);
            int n = x = ((NodeLabel)terminals.lastElement()).location.x;
            int i = terminals.size() - 1;
            while (i >= 0) {
                int n3;
                ((NodeLabel)terminals.elementAt((int)i)).location.x = n3;
                n3 = (int)((double)n3 + ((double)((NodeLabel)terminals.elementAt(i)).getWidth() + (double)((NodeLabel)terminals.elementAt((int)i)).label.getHeight() * this.widthIndex));
                --i;
            }
            while (terminals.size() > 0) {
                NodeLabel now5 = (NodeLabel)terminals.pop();
                if (now5.parents.size() <= 0 || now5 == head) continue;
                NodeLabel nowparent = now5.parents.firstElement();
                Collections.sort(nowparent.children);
                int x1 = nowparent.children.lastElement().location.x;
                int x2 = nowparent.children.firstElement().location.x + nowparent.children.firstElement().getWidth();
                int center = (x1 + x2) / 2;
                nowparent.location.x = center - nowparent.getWidth() / 2;
                terminals.add(nowparent);
                for (NodeLabel jh : nowparent.children) {
                    try {
                        terminals.remove(jh);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            int total = 0;
            total = maxwords >= maxnonwords + 2 || maxnonwords == 0 ? maxwords + 1 : maxnonwords + 3;
            int yu = 0;
            process1.add(head);
            while (process1.size() > 0) {
                NodeLabel now6 = (NodeLabel)process1.pop();
                if (now6.type == 1) {
                    yu = now6.location.y;
                }
                for (NodeLabel ccc : now6.children) {
                    process1.add(ccc);
                }
            }
            process1.add(head);
            while (process1.size() > 0) {
                NodeLabel now7 = (NodeLabel)process1.pop();
                if (now7.type == 1) {
                    now7.level = 1;
                } else {
                    now7.level = total - now7.level;
                    now7.location.y = (int)((double)yu - (double)(now7.level - 1) * ((double)now7.getHeight() + (double)now7.label.getHeight() * this.heightIndex));
                }
                for (NodeLabel xc : now7.children) {
                    process1.add(xc);
                }
            }
        }
        head.setLocation(head.location);
        for (NodeLabel xu : this.list) {
            xu.setLocation(xu.location);
        }
        for (Line i : this.linelist) {
            i.update();
        }
        this.drawroom.revalidate();
        this.drawroom.repaint();
    }

    public void adjust() {
        Vector<NodeLabel> here = new Vector<NodeLabel>();
        Vector<NodeLabel> words = new Vector<NodeLabel>();
        for (NodeLabel x : this.list) {
            if (x.parents.size() == 0) {
                here.add(x);
            }
            if (x.type != 1) continue;
            words.add(x);
        }
        Collections.sort(words);
        Collections.reverse(words);
        Rectangle bounds = this.drawroom.getViewport().getViewRect();
        Point zeroP = this.drawroom.getViewport().getViewPosition();
        int heightdraw = (int)((double)bounds.height * 0.9) + zeroP.y;
        int i = 40 + zeroP.x;
        for (NodeLabel y : words) {
            y.setLocation(i, heightdraw);
            y.location = y.getLocation();
            i = (int)((double)i + this.widthIndex * y.label.getPreferredSize().getHeight());
            i = (int)((double)i + y.getPreferredSize().getWidth());
        }
        for (NodeLabel y : here) {
            this.adjustOneTree(y);
        }
        for (Line xy : this.linelist) {
            xy.update();
        }
        this.repaint();
    }

    public void topDown() {
        this.adjust();
        for (NodeLabel x : this.list) {
            if (x.type != 1) continue;
            x.location.y = (int)((double)(x.parents.elementAt((int)0).getLocation().y + x.getHeight()) + this.heightIndex * (double)x.label.getHeight());
            x.setLocation(x.location);
        }
        for (Line y : this.linelist) {
            y.start = new Point(y.children.location.x + y.children.getWidth() / 2, y.children.location.y + y.children.label.getLocation().y);
            y.end = new Point(y.parent.location.x + y.parent.getWidth() / 2, y.parent.location.y + y.parent.label.getHeight() + y.parent.label.getLocation().y);
        }
    }

    public void bottomUp() {
        for (NodeLabel x : this.list) {
            int heightdraw;
            if (x.type != 1) continue;
            Rectangle bounds = this.drawroom.getViewport().getViewRect();
            Point zeroP = this.drawroom.getViewport().getViewPosition();
            x.location.y = heightdraw = (int)((double)bounds.height * 0.8) + zeroP.y;
            x.setLocation(x.location);
        }
        this.adjust();
    }

    public void removeline(Line x) {
        if (x.parent != null && x.children != null) {
            this.removelines(x.parent, x.children);
        } else {
            this.linelist.remove(x);
            if (x.parent != null) {
                x.parent.childrenlines.remove(x);
            } else if (x.children != null) {
                x.children.parentlines.remove(x);
            }
        }
    }

    public void removelines(NodeLabel dragLabel) {
        Vector<NodeLabel> pp = new Vector<NodeLabel>();
        for (NodeLabel xx : dragLabel.parents) {
            pp.add(xx);
        }
        for (NodeLabel x : pp) {
            this.removelines(dragLabel, x);
        }
        Vector<NodeLabel> cc = new Vector<NodeLabel>();
        for (NodeLabel xx : dragLabel.children) {
            cc.add(xx);
        }
        for (NodeLabel x : cc) {
            this.removelines(dragLabel, x);
        }
        for (Line i : dragLabel.childrenlines) {
            this.linelist.remove(i);
        }
        for (Line i : dragLabel.parentlines) {
            this.linelist.remove(i);
        }
    }

    public Line removelines(NodeLabel x, NodeLabel y) {
        Vector<Line> xparentss = new Vector<Line>();
        Vector<Line> yparentss = new Vector<Line>();
        Line r = null;
        for (Line i : x.parentlines) {
            xparentss.add(i);
        }
        for (Line i : y.parentlines) {
            yparentss.add(i);
        }
        boolean anothercheck = false;
        for (Line xy : xparentss) {
            if (xy.parent != y) continue;
            x.parentlines.remove(xy);
            y.childrenlines.remove(xy);
            this.linelist.remove(xy);
            r = xy;
            y.children.remove(x);
            x.parents.remove(y);
            anothercheck = true;
        }
        if (!anothercheck) {
            for (Line xy : yparentss) {
                if (xy.parent != x) continue;
                y.parentlines.remove(xy);
                x.childrenlines.remove(xy);
                this.linelist.remove(xy);
                r = xy;
                x.children.remove(y);
                y.parents.remove(x);
                break;
            }
        }
        return r;
    }

    public Line addlines(NodeLabel x, NodeLabel y) {
        int widthy = y.getWidth() / 2;
        int heighty = y.getHeight();
        int widthx = x.getWidth() / 2;
        int heightx = x.getHeight();
        Line r = null;
        if (x.location.getY() > y.location.getY()) {
            Line newline = new Line(this.plain);
            newline.start = new Point(x.location.x + widthx, x.location.y + x.label.getLocation().y);
            newline.end = new Point(y.location.x + widthy, y.location.y + heighty - y.label.getLocation().y);
            newline.parent = y;
            newline.children = x;
            this.linelist.add(newline);
            r = newline;
            x.parentlines.add(newline);
            y.childrenlines.add(newline);
            x.parents.add(y);
            y.children.add(x);
        } else {
            Line newline = new Line(this.plain);
            newline.end = new Point(x.location.x + widthx, x.location.y + heightx - x.label.getLocation().y);
            newline.start = new Point(y.location.x + widthy, y.location.y + y.label.getLocation().y);
            newline.parent = x;
            newline.children = y;
            this.linelist.add(newline);
            r = newline;
            y.parentlines.add(newline);
            x.childrenlines.add(newline);
            y.parents.add(x);
            x.children.add(y);
        }
        return r;
    }

    public void updatePC(NodeLabel dragLabel) {
        Vector<Line> dclines = new Vector<Line>();
        Vector<Line> dplines = new Vector<Line>();
        for (Line i : dragLabel.parentlines) {
            dplines.add(i);
        }
        for (Line i : dragLabel.childrenlines) {
            dclines.add(i);
        }
        for (Line xy : dclines) {
            if (xy.children != null) {
                this.removelines(dragLabel, xy.children);
                this.addlines(dragLabel, xy.children);
                continue;
            }
            xy.end = new Point(dragLabel.location.x + dragLabel.getWidth() / 2, dragLabel.location.y + dragLabel.label.getLocation().y + dragLabel.label.getHeight());
        }
        for (Line xy : dplines) {
            if (xy.parent != null) {
                this.removelines(dragLabel, xy.parent);
                this.addlines(dragLabel, xy.parent);
                continue;
            }
            xy.start = new Point(dragLabel.location.x + dragLabel.getWidth() / 2, dragLabel.location.y + dragLabel.label.getLocation().y);
        }
    }

    public void setdt() {
        this.info.setText("Welcome to UCLA-Parse and Practice Program");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        super.doLayout();
        Object object = this.getTreeLock();
        synchronized (object) {
            int w = this.getWidth();
            int h = this.getHeight();
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (this.getLayer(c) == JLayeredPane.DEFAULT_LAYER.intValue() || this.getLayer(c) == JLayeredPane.PALETTE_LAYER.intValue()) {
                    c.setBounds(0, 0, w, h);
                }
                ++n2;
            }
        }
        this.dialogueP.getViewport().setViewPosition(new Point(0, 0));
    }

    public void disableDrawing() {
    }

    public void checkGE() {
        if (this.checkGEorNot == 1) {
            String check = null;
            for (NodeLabel ji : this.list) {
                ji.grammar_error = "";
                Collections.sort(ji.children);
                Collections.reverse(ji.children);
                String e = Plain.obeyRules(ji, ji.children, this.grammar);
                if (e != null) {
                    check = e;
                    ji.color = 4;
                    ji.label.setForeground(Color.red);
                    ji.grammar_error = e;
                    continue;
                }
                ji.color = 0;
                ji.label.setForeground(Color.black);
            }
            if (check == null) {
                this.dialogue.setText("");
            } else {
                this.dialogue.setText(check);
                this.dialogueP.getViewport().setViewPosition(new Point(0, 0));
            }
        } else {
            for (NodeLabel ji : this.list) {
                ji.color = 0;
                ji.label.setForeground(Color.black);
            }
        }
    }

    public static String obeyRules(NodeLabel head, Vector<NodeLabel> jiji, Grammar grammar) {
        String headt = head.label.getText();
        if (head.type == 1) {
            if (jiji.size() > 0) {
                return "Warning: word nodes cannot have daughters;";
            }
            return null;
        }
        if (!grammar.set.contains(headt)) {
            return "Warning: " + headt + " is not a defined node;";
        }
        if (jiji.size() == 0) {
            return "Caution: " + headt + " is incomplete;";
        }
        if (!grammar.setBasic.contains(headt)) {
            for (NodeLabel cc : jiji) {
                if (cc.type != 1) continue;
                return "Warning: " + headt + " is not a terminal node, it cannot have a word node as its daughter;";
            }
        }
        if (!grammar.medium.contains(headt)) {
            if (jiji.size() > 1 || jiji.elementAt((int)0).type != 1) {
                return "Warning: " + headt + " is a terminal node, it can only have one word node as its daughter;";
            }
            return null;
        }
        HeadRule now = null;
        for (HeadRule hr : grammar.headRules) {
            if (!hr.head.equals(headt)) continue;
            now = hr;
            break;
        }
        Vector<String> children = new Vector<String>();
        for (NodeLabel ji : jiji) {
            children.add(ji.label.getText());
        }
        return now.obeyRule(headt, children);
    }

    public Plain(Grammar g) {
        this.top = new Top();
        this.grammar = g;
        this.back = new JPanel();
        this.dialogue = new JTextArea();
        this.trash = new JPanel();
        this.nodes = new RuleFormPanel(this.grammar);
        this.drawroom = new DrawPanel();
        this.sg = new SingleColumnPanel(this.grammar);
        this.info = new JLabel();
        this.now = null;
        this.dlabel = null;
        this.dline = new Vector();
        this.list = new Vector();
        this.linelist = new Vector();
        this.deleteL = new Vector();
        this.store = new Vector();
        super.add((Component)this.back, JLayeredPane.DEFAULT_LAYER);
        super.add((Component)this.top, JLayeredPane.PALETTE_LAYER);
        this.myMouseAdapter = new MyMouseAdapter();
        super.addMouseListener(this.myMouseAdapter);
        super.addMouseMotionListener(this.myMouseAdapter);
        this.top.repaint();
        this.top.setOpaque(false);
        this.back.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.back.setBackground(Color.LIGHT_GRAY);
        this.dialogue.setEditable(false);
        this.dialogue.setBackground(Color.decode("0xA0A0A0"));
        this.dialogue.setLineWrap(true);
        this.dialogue.setWrapStyleWord(true);
        this.dialogueP = new JScrollPane(this.dialogue);
        JLabel message = new JLabel("Trash");
        this.trashP = new JScrollPane(this.trash);
        this.trash.add(message);
        this.trashDialog = new JSplitPane(1, this.dialogueP, this.trashP);
        this.right = new JSplitPane(1, this.drawroom, this.sg);
        this.total = new JSplitPane(1, this.nodes, this.right);
        this.upDown = new JSplitPane(0, this.trashDialog, this.total);
        this.right.setBorder(null);
        this.right.setResizeWeight(1.0);
        this.upDown.setBorder(null);
        this.upDown.setResizeWeight(0.1);
        this.total.setBorder(null);
        this.trashDialog.setBorder(null);
        this.trashDialog.setResizeWeight(0.7);
        this.dialogueP.setBorder(new LineBorder(Color.black, 1));
        this.trashP.setBorder(new LineBorder(Color.black, 1));
        this.nodes.setBorder(new LineBorder(Color.black, 1));
        this.drawroom.setBorder(new LineBorder(Color.black, 1));
        this.sg.setBorder(new LineBorder(Color.black, 1));
        this.sgMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(3);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.sg.back.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.sg.back.getLocation().y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 501, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mousePressed(me);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(3);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.sg.back.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.sg.back.getLocation().y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 506, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseDragged(me);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(3);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.sg.back.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.sg.back.getLocation().y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 502, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseReleased(me);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(3);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.sg.back.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.sg.back.getLocation().y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 503, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseMoved(me);
            }
        };
        this.sg.addMouseListener(this.sgMouseAdapter);
        this.sg.addMouseMotionListener(this.sgMouseAdapter);
        this.drMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(2);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.drawroom.canvas.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.drawroom.canvas.getLocation().y);
                if (e.getButton() == 3) {
                    Plain.this.rightclick = 1;
                }
                MouseEvent me = new MouseEvent(Plain.this.plain, e.getButton(), 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mousePressed(me);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(2);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.drawroom.canvas.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.drawroom.canvas.getLocation().y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 506, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseDragged(me);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Plain.this.rightclick = 0;
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(2);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.drawroom.canvas.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.drawroom.canvas.getLocation().y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 502, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseReleased(me);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(2);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.drawroom.canvas.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.drawroom.canvas.getLocation().y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 503, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseMoved(me);
            }
        };
        this.drawroom.addMouseListener(this.drMouseAdapter);
        this.drawroom.addMouseMotionListener(this.drMouseAdapter);
        this.nodesMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(1);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.nodes.back.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.nodes.back.getLocation().y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 501, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mousePressed(me);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(1);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.nodes.back.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.nodes.back.getLocation().y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 506, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseDragged(me);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(1);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.nodes.back.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.nodes.back.getLocation().y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 502, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseReleased(me);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(1);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.nodes.back.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.nodes.back.getLocation().y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 503, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseMoved(me);
            }
        };
        this.nodes.addMouseListener(this.nodesMouseAdapter);
        this.nodes.addMouseMotionListener(this.nodesMouseAdapter);
        MouseAdapter trashPMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(5);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 503, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseMoved(me);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(5);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 506, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseDragged(me);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(5);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 502, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseReleased(me);
            }
        };
        this.trashP.addMouseMotionListener(trashPMouseAdapter);
        this.trashP.addMouseListener(trashPMouseAdapter);
        this.dialogueMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(4);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 503, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseMoved(me);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(4);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 506, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseDragged(me);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Plain.this.relLocation = e.getPoint();
                Plain.this.location = Plain.this.getLocation(4);
                Plain.this.now = new Point(((Plain)Plain.this).location.x + ((Plain)Plain.this).relLocation.x, ((Plain)Plain.this).location.y + ((Plain)Plain.this).relLocation.y);
                MouseEvent me = new MouseEvent(Plain.this.plain, 502, 0L, 0, Plain.this.now.x, Plain.this.now.y, 0, false);
                Plain.this.myMouseAdapter.mouseReleased(me);
            }
        };
        this.dialogue.addMouseMotionListener(this.dialogueMouseAdapter);
        this.dialogue.addMouseListener(this.dialogueMouseAdapter);
        int nodesDividerLocation = this.nodes.back.getPreferredSize().width;
        this.total.setDividerLocation(nodesDividerLocation);
        this.sg.setMinimumSize(new Dimension(this.sg.getWidth(), this.nodes.labelHeight * 2));
        this.trashP.setMinimumSize(new Dimension(this.trash.getPreferredSize().width, this.nodes.labelHeight * 2));
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(10, 10, 5, 10);
        this.back.add((Component)this.upDown, c);
        this.info.setBackground(Color.lightGray);
        this.info.setText("Welcome to UCLA-Parse and Practice Program");
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        c.insets = new Insets(5, 10, 10, 10);
        this.back.add((Component)this.info, c);
    }

    public void clean2() {
        this.linelist = new Vector();
        Vector<NodeLabel> deleteList = new Vector<NodeLabel>();
        for (NodeLabel x : this.list) {
            if (x.type != 1) {
                deleteList.add(x);
                continue;
            }
            x.parentlines = new Vector();
            x.parents = new Vector();
            x.children = new Vector();
            x.childrenlines = new Vector();
        }
        for (NodeLabel x : deleteList) {
            this.drawroom.canvas.remove(x);
            this.list.remove(x);
        }
        this.dialogue.setText("");
        this.repaint();
    }

    public void instructionEdit() {
        this.dialogue.setBorder(new LineBorder(Color.black, 3));
        this.sg.removeMouseListener(this.sgMouseAdapter);
        this.drawroom.removeMouseListener(this.drMouseAdapter);
        this.nodes.removeMouseListener(this.nodesMouseAdapter);
        this.dialogue.removeMouseListener(this.dialogueMouseAdapter);
        this.dialogue.setEditable(true);
    }

    public void sentenceEdit() {
        this.dialogue.setBorder(null);
        this.dialogue.setEditable(false);
        this.sg.removeMouseListener(this.sgMouseAdapter);
        this.drawroom.removeMouseListener(this.drMouseAdapter);
        this.nodes.removeMouseListener(this.nodesMouseAdapter);
        this.sg.addMouseListener(this.sgMouseAdapter);
        this.drawroom.addMouseListener(this.drMouseAdapter);
        this.nodes.addMouseListener(this.nodesMouseAdapter);
        this.dialogue.removeMouseListener(this.dialogueMouseAdapter);
        this.dialogue.addMouseListener(this.dialogueMouseAdapter);
    }

    public void folderEdit() {
        this.dialogue.setBorder(null);
        this.dialogue.setEditable(false);
        this.sg.removeMouseListener(this.sgMouseAdapter);
        this.drawroom.removeMouseListener(this.drMouseAdapter);
        this.nodes.removeMouseListener(this.nodesMouseAdapter);
        this.dialogue.removeMouseListener(this.dialogueMouseAdapter);
    }

    public void instruction() {
        this.sg.removeMouseListener(this.sgMouseAdapter);
        this.drawroom.removeMouseListener(this.drMouseAdapter);
        this.nodes.removeMouseListener(this.nodesMouseAdapter);
        this.dialogue.removeMouseListener(this.dialogueMouseAdapter);
    }

    public void sentence() {
        this.sg.removeMouseListener(this.sgMouseAdapter);
        this.drawroom.removeMouseListener(this.drMouseAdapter);
        this.nodes.removeMouseListener(this.nodesMouseAdapter);
        this.sg.addMouseListener(this.sgMouseAdapter);
        this.drawroom.addMouseListener(this.drMouseAdapter);
        this.nodes.addMouseListener(this.nodesMouseAdapter);
        this.dialogue.removeMouseListener(this.dialogueMouseAdapter);
        this.dialogue.addMouseListener(this.dialogueMouseAdapter);
    }

    public void getlocationcor() {
        int xmin = 0;
        int ymin = 0;
        int xmax = 0;
        int ymax = 0;
        for (NodeLabel x : this.list) {
            int nxmin = x.getLocation().x;
            int nxmax = x.getLocation().x + x.getWidth();
            int nymin = x.getLocation().y;
            int nymax = x.getLocation().y + x.getHeight();
            if (xmin == 0) {
                xmin = nxmin;
            } else if (nxmin < xmin) {
                xmin = nxmin;
            }
            if (ymin == 0) {
                ymin = nymin;
            } else if (nymin < ymin) {
                ymin = nymin;
            }
            if (xmax == 0) {
                xmax = nxmax;
            } else if (nxmax > xmax) {
                xmax = nxmax;
            }
            if (ymax == 0) {
                ymax = nymax;
                continue;
            }
            if (nymax <= ymax) continue;
            ymax = nymax;
        }
        this.locationx = xmin;
        this.locationy = ymin;
        this.locationw = xmax - xmin;
        this.locationh = ymax - ymin;
    }

    public boolean completeTree() {
        int right = 0;
        for (NodeLabel x : this.list) {
            if (x.parents.size() != 0) continue;
            ++right;
        }
        return right == 1;
    }

    public void turnoffRC() {
        this.checkGEorNot = 0;
        this.checkGE();
    }

    public void turnonRC() {
        this.checkGEorNot = 1;
        this.checkGE();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void redo() {
        this.undoManager.redo();
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public void undo() {
        this.undoManager.undo();
    }

    public void clearUndo() {
        this.undoManager = new UndoManager();
    }

    public class Canvas
    extends JPanel {
        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            super.paint(g);
            for (Line xy : Plain.this.linelist) {
                if (xy.color == 0) {
                    g2.setStroke(new BasicStroke(1.0f));
                    g.setColor(Color.black);
                } else if (xy.color == 3) {
                    g2.setStroke(new BasicStroke(3.0f));
                    g.setColor(Color.decode("0x994C00"));
                } else if (xy.color == 6) {
                    g2.setStroke(new BasicStroke(3.0f));
                    g.setColor(Color.decode("0xFF66FF"));
                } else {
                    g2.setStroke(new BasicStroke(2.0f));
                    g.setColor(Color.blue);
                }
                g.drawLine(xy.start.x, xy.start.y, xy.end.x, xy.end.y);
            }
        }
    }

    public class DrawPanel
    extends JScrollPane {
        JPopupMenu menu = new JPopupMenu("Popup");
        JMenuItem delete = new JMenuItem("delete");
        public Canvas canvas;

        public DrawPanel() {
            this.canvas = new Canvas();
            this.canvas.setPreferredSize(new Dimension(3000, 3000));
            this.canvas.setBackground(Color.white);
            this.canvas.setLayout(null);
            super.setViewportView(this.canvas);
            this.menu.add(this.delete);
            this.delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (Line xx : ((DrawPanel)DrawPanel.this).Plain.this.deleteL) {
                        Plain.this.removeline(xx);
                    }
                    DrawPanel.this.repaint();
                }
            });
        }
    }

    class MyMouseAdapter
    extends MouseAdapter {
        MyMouseAdapter() {
        }

        void draggingNodes(int x, int y, NodeLabel dl) {
            Plain.this.location = Plain.this.getLocation(2);
            Plain.this.relLocation = new Point(x - ((Plain)Plain.this).location.x, y - ((Plain)Plain.this).location.y);
            Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.drawroom.canvas.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.drawroom.canvas.getLocation().y);
            dl.setLocation(x - Plain.this.dragLabelWidthDiv2, y - Plain.this.dragLabelHeightDiv2);
            dl.location = new Point(((Plain)Plain.this).realInLocation.x - Plain.this.dragLabelWidthDiv2, ((Plain)Plain.this).realInLocation.y - Plain.this.dragLabelHeightDiv2);
            Plain.this.orange(dl);
            this.linesReady(dl);
            Plain.this.findaddinline(dl);
        }

        void linesReady(NodeLabel dl) {
            for (Line hihi : Plain.this.linelist) {
                hihi.color = 0;
            }
            Vector<Line> parentss = new Vector<Line>();
            Vector<Line> childrens = new Vector<Line>();
            for (Line xixi : Plain.this.linelist) {
                if (xixi.parent == null && xixi.children != dl && xixi.end.x <= dl.location.x + dl.getWidth() && xixi.end.x >= dl.location.x && xixi.end.y <= dl.location.y + dl.getHeight() && xixi.end.y >= dl.location.y) {
                    parentss.add(xixi);
                }
                if (xixi.children != null || xixi.parent == dl || xixi.start.x > dl.location.x + dl.getWidth() || xixi.start.x < dl.location.x || xixi.start.y > dl.location.y + dl.getHeight() || xixi.start.y < dl.location.y) continue;
                childrens.add(xixi);
            }
            for (Line hihi : parentss) {
                hihi.color = 3;
            }
            for (Line hihi : childrens) {
                hihi.color = 3;
            }
        }

        void pairupwithLines(NodeLabel dl) {
            for (Line hihi : Plain.this.linelist) {
                hihi.color = 0;
            }
            Vector<Line> parentss = new Vector<Line>();
            Vector<Line> childrens = new Vector<Line>();
            for (Line xixi : Plain.this.linelist) {
                if (xixi.parent == null && xixi.children != dl && xixi.end.x <= dl.location.x + dl.getWidth() && xixi.end.x >= dl.location.x && xixi.end.y <= dl.location.y + dl.getHeight() && xixi.end.y >= dl.location.y) {
                    parentss.add(xixi);
                }
                if (xixi.children != null || xixi.parent == dl || xixi.start.x > dl.location.x + dl.getWidth() || xixi.start.x < dl.location.x || xixi.start.y > dl.location.y + dl.getHeight() || xixi.start.y < dl.location.y) continue;
                childrens.add(xixi);
            }
            for (Line hihi : parentss) {
                hihi.color = 0;
            }
            for (Line hihi : childrens) {
                hihi.color = 0;
            }
            for (Line hihi : parentss) {
                hihi.end = new Point(((Plain)Plain.this).dragLabel.location.x + Plain.this.dragLabel.getWidth() / 2, ((Plain)Plain.this).dragLabel.location.y + ((Plain)Plain.this).dragLabel.label.getLocation().y + ((Plain)Plain.this).dragLabel.label.getHeight());
                hihi.parent = Plain.this.dragLabel;
                ((Plain)Plain.this).dragLabel.childrenlines.add(hihi);
                if (hihi.children == null) continue;
                ((Plain)Plain.this).dragLabel.children.add(hihi.children);
            }
            for (Line hihi : childrens) {
                hihi.start = new Point(((Plain)Plain.this).dragLabel.location.x + Plain.this.dragLabel.getWidth() / 2, ((Plain)Plain.this).dragLabel.location.y + ((Plain)Plain.this).dragLabel.label.getLocation().y);
                hihi.children = Plain.this.dragLabel;
                ((Plain)Plain.this).dragLabel.parentlines.add(hihi);
                if (hihi.parent == null) continue;
                ((Plain)Plain.this).dragLabel.parents.add(hihi.parent);
            }
        }

        void pressOnGP() {
            if (Plain.this.labeler == null) {
                return;
            }
            Plain.this.labeler.setBorder(new BevelBorder(1));
            Plain.this.dragLabel = new NodeLabel(Plain.this.labeler.getText(), Plain.this.plain);
            Plain.this.dragLabel.setSize(Plain.this.dragLabel.getPreferredSize());
            Plain.this.dragLabelWidthDiv2 = Plain.this.dragLabel.getWidth() / 2;
            Plain.this.dragLabelHeightDiv2 = Plain.this.dragLabel.getHeight() / 2;
            int x = Plain.this.now.x - Plain.this.dragLabelWidthDiv2;
            int y = Plain.this.now.y - Plain.this.dragLabelHeightDiv2;
            Plain.this.dragLabel.setLocation(x, y);
            Plain.this.location = Plain.this.getLocation(2);
            Plain.this.relLocation = new Point(Plain.this.now.x - ((Plain)Plain.this).location.x, Plain.this.now.y - ((Plain)Plain.this).location.y);
            Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.drawroom.canvas.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.drawroom.canvas.getLocation().y);
            ((Plain)Plain.this).dragLabel.location = new Point(((Plain)Plain.this).realInLocation.x - Plain.this.dragLabelWidthDiv2, ((Plain)Plain.this).realInLocation.y - Plain.this.dragLabelHeightDiv2);
            Plain.this.add((Component)Plain.this.dragLabel, JLayeredPane.DRAG_LAYER);
            Plain.this.clicked = 1;
        }

        void pressOnDR(MouseEvent me) {
            try {
                Plain.this.dragLabel = (NodeLabel)Plain.this.clickedPanel.getComponentAt(((Plain)Plain.this).realInLocation.x, ((Plain)Plain.this).realInLocation.y);
                int xnow = ((Plain)Plain.this).realInLocation.x - ((Plain)Plain.this).dragLabel.getLocation().x;
                int ynow = ((Plain)Plain.this).realInLocation.y - ((Plain)Plain.this).dragLabel.getLocation().y;
                Plain.this.labeler = (JLabel)Plain.this.dragLabel.getComponentAt(xnow, ynow);
            }
            catch (Exception xnow) {
                // empty catch block
            }
            if (Plain.this.labeler == null) {
                boolean tostart = false;
                for (Line xy : Plain.this.linelist) {
                    if (!Plain.inRange(xy, Plain.this.realInLocation)) continue;
                    double x1 = xy.start.getX();
                    double y1 = xy.start.getY();
                    double x2 = xy.end.getX();
                    double y2 = xy.end.getY();
                    xy.color = 1;
                    tostart = true;
                    xy.x1 = x1 - (double)((Plain)Plain.this).realInLocation.x;
                    xy.y1 = y1 - (double)((Plain)Plain.this).realInLocation.y;
                    xy.x2 = x2 - (double)((Plain)Plain.this).realInLocation.x;
                    xy.y2 = y2 - (double)((Plain)Plain.this).realInLocation.y;
                    Plain.this.dline.addElement(xy);
                }
                if (!tostart) {
                    Plain.this.store.add(Plain.this.realInLocation);
                } else if (Plain.this.rightclick == 1) {
                    Plain.this.drawroom.menu.show(me.getComponent(), me.getX(), me.getY());
                    for (Line i : Plain.this.dline) {
                        Plain.this.deleteL.add(i);
                    }
                }
            } else {
                Plain.this.clicked = 3;
                Plain.this.beforeMove = ((Plain)Plain.this).dragLabel.location;
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            Plain.this.now = me.getPoint();
            if (Plain.this.clicked == 1) {
                Plain.this.clicked = 11;
            } else {
                Plain.this.clickedPanel = Plain.this.getPanel(Plain.this.now);
                if (Plain.this.clickedPanel == Plain.this.nodes.back) {
                    Plain.this.location = Plain.this.getLocation(1);
                    Plain.this.relLocation = new Point(Plain.this.now.x - ((Plain)Plain.this).location.x, Plain.this.now.y - ((Plain)Plain.this).location.y);
                    Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.nodes.back.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.nodes.back.getLocation().y);
                    Plain.this.labeler = Plain.this.nodes.getTheLabel(((Plain)Plain.this).realInLocation.x, ((Plain)Plain.this).realInLocation.y);
                    this.pressOnGP();
                } else if (Plain.this.clickedPanel == Plain.this.sg.back) {
                    Plain.this.location = Plain.this.getLocation(3);
                    Plain.this.relLocation = new Point(Plain.this.now.x - ((Plain)Plain.this).location.x, Plain.this.now.y - ((Plain)Plain.this).location.y);
                    Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.sg.back.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.sg.back.getLocation().y);
                    Plain.this.labeler = Plain.this.sg.getTheLabel(((Plain)Plain.this).realInLocation.x, ((Plain)Plain.this).realInLocation.y);
                    this.pressOnGP();
                } else if (Plain.this.clickedPanel == Plain.this.drawroom.canvas) {
                    Plain.this.location = Plain.this.getLocation(2);
                    Plain.this.relLocation = new Point(Plain.this.now.x - ((Plain)Plain.this).location.x, Plain.this.now.y - ((Plain)Plain.this).location.y);
                    Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.drawroom.canvas.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.drawroom.canvas.getLocation().y);
                    this.pressOnDR(me);
                }
            }
        }

        void MovingMouse() {
            Plain.this.location = Plain.this.getLocation(2);
            Plain.this.relLocation = new Point(Plain.this.now.x - ((Plain)Plain.this).location.x, Plain.this.now.y - ((Plain)Plain.this).location.y);
            Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.drawroom.canvas.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.drawroom.canvas.getLocation().y);
            Plain.this.dlabel = null;
            Plain.this.dline = new Vector();
            boolean tostart = false;
            for (Line xy : Plain.this.linelist) {
                xy.color = 0;
                if (Plain.inRange(xy, Plain.this.realInLocation)) {
                    xy.color = 1;
                    double x1 = xy.start.getX();
                    double y1 = xy.start.getY();
                    double x2 = xy.end.getX();
                    double y2 = xy.end.getY();
                    xy.x1 = x1 - (double)((Plain)Plain.this).realInLocation.x;
                    xy.y1 = y1 - (double)((Plain)Plain.this).realInLocation.y;
                    xy.x2 = x2 - (double)((Plain)Plain.this).realInLocation.x;
                    xy.y2 = y2 - (double)((Plain)Plain.this).realInLocation.y;
                    tostart = true;
                    Plain.this.dline.addElement(xy);
                }
                Plain.this.top.repaint();
            }
            for (NodeLabel x : Plain.this.list) {
                x.setPlain();
                x.setColor();
            }
            if (!tostart) {
                NodeLabel colored = null;
                for (NodeLabel x : Plain.this.list) {
                    if (x.distanceToLabel(Plain.this.realInLocation) == 0) continue;
                    if (colored == null) {
                        colored = x;
                        continue;
                    }
                    if (x.distanceToLabel(Plain.this.realInLocation) >= colored.distanceToLabel(Plain.this.realInLocation)) continue;
                    colored = x;
                }
                if (colored != null) {
                    colored.setBold();
                    colored.label.setForeground(Color.blue);
                    if (!colored.grammar_error.equals(Plain.this.dialogue.getText())) {
                        Plain.this.dialogueP.getViewport().setViewPosition(new Point(0, 0));
                        Plain.this.dialogue.setText(colored.grammar_error);
                    }
                    Plain.this.dlabel = colored;
                    Plain.this.info.setText("Node " + colored.label.getText() + " is ready to draw a line");
                } else {
                    Plain.this.setdt();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            Plain.this.now = me.getPoint();
            if (Plain.this.clicked == 1) {
                this.draggingNodes(Plain.this.now.x, Plain.this.now.y, Plain.this.dragLabel);
            } else {
                Plain.this.clickedPanel = Plain.this.getPanel(Plain.this.now);
                if (Plain.this.clickedPanel == Plain.this.drawroom.canvas) {
                    this.MovingMouse();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            Plain.this.now = me.getPoint();
            Plain.this.location = Plain.this.getLocation(2);
            Plain.this.relLocation = new Point(Plain.this.now.x - ((Plain)Plain.this).location.x, Plain.this.now.y - ((Plain)Plain.this).location.y);
            Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.drawroom.canvas.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.drawroom.canvas.getLocation().y);
            if (Plain.this.labeler == null) {
                if (Plain.this.dline.size() > 0) {
                    for (Line xy : Plain.this.dline) {
                        xy.start.setLocation(xy.x1 + (double)((Plain)Plain.this).realInLocation.x, xy.y1 + (double)((Plain)Plain.this).realInLocation.y);
                        xy.end.setLocation(xy.x2 + (double)((Plain)Plain.this).realInLocation.x, xy.y2 + (double)((Plain)Plain.this).realInLocation.y);
                    }
                } else {
                    Plain.this.pointEnd = Plain.this.realInLocation;
                    Plain.this.clicked = 10;
                }
            } else if (Plain.this.clicked == 1) {
                Plain.this.clicked = 2;
            } else if (Plain.this.clicked == 3) {
                Plain.this.clicked = 4;
                int x = Plain.this.now.x - Plain.this.dragLabelWidthDiv2;
                int y = Plain.this.now.y - Plain.this.dragLabelHeightDiv2;
                Plain.this.dragLabel.setLocation(x, y);
                Plain.this.drawroom.remove(Plain.this.dragLabel);
                Plain.this.list.remove(Plain.this.dragLabel);
                Plain.this.add((Component)Plain.this.dragLabel, JLayeredPane.DRAG_LAYER);
            } else {
                this.draggingNodes(Plain.this.now.x, Plain.this.now.y, Plain.this.dragLabel);
                Plain.this.updatePC(Plain.this.dragLabel);
            }
            Plain.this.repaint();
        }

        public void releaseDR(MouseEvent e) {
            Plain.this.now = e.getPoint();
            Plain.this.location = Plain.this.getLocation(2);
            Plain.this.relLocation = new Point(Plain.this.now.x - ((Plain)Plain.this).location.x, Plain.this.now.y - ((Plain)Plain.this).location.y);
            Plain.this.realInLocation = new Point(((Plain)Plain.this).relLocation.x - Plain.this.drawroom.canvas.getLocation().x, ((Plain)Plain.this).relLocation.y - Plain.this.drawroom.canvas.getLocation().y);
            if (Plain.this.labeler == null) {
                if (Plain.this.dline.size() > 0) {
                    for (Line xy : Plain.this.dline) {
                        xy.start.setLocation(xy.x1 + (double)((Plain)Plain.this).realInLocation.x, xy.y1 + (double)((Plain)Plain.this).realInLocation.y);
                        xy.end.setLocation(xy.x2 + (double)((Plain)Plain.this).realInLocation.x, xy.y2 + (double)((Plain)Plain.this).realInLocation.y);
                    }
                    Plain.this.dline.removeAllElements();
                } else if (Plain.this.store.size() == 1) {
                    Point start = Plain.this.store.elementAt(0);
                    if ((start.x - ((Plain)Plain.this).realInLocation.x) * (start.x - ((Plain)Plain.this).realInLocation.x) + (start.y - ((Plain)Plain.this).realInLocation.y) * (start.y - ((Plain)Plain.this).realInLocation.y) > 100) {
                        Plain.this.store.addElement(Plain.this.realInLocation);
                    } else {
                        Plain.this.store.removeAllElements();
                    }
                } else if (Plain.this.doublenode.size() == 1) {
                    Plain.this.doublenode.elementAt(0).stop();
                    Plain.this.doublenode.removeAllElements();
                }
            } else if (Plain.this.clicked == 2 || Plain.this.clicked == 11 || Plain.this.clicked == 4) {
                LUndoEdit undoableEdit;
                Plain.this.dragLabel.setLocation(((Plain)Plain.this).realInLocation.x - Plain.this.dragLabelWidthDiv2, ((Plain)Plain.this).realInLocation.y - Plain.this.dragLabelHeightDiv2);
                ((Plain)Plain.this).dragLabel.location = Plain.this.dragLabel.getLocation();
                Plain.this.remove(Plain.this.dragLabel);
                Plain.this.drawroom.canvas.add(Plain.this.dragLabel);
                if (Plain.this.clicked == 2 || Plain.this.clicked == 11) {
                    undoableEdit = new LUndoEdit(Plain.this.dragLabel){

                        @Override
                        public void redo() throws CannotRedoException {
                            super.redo();
                            Plain.this.remove(this.dl);
                            ((MyMouseAdapter)MyMouseAdapter.this).Plain.this.drawroom.canvas.add(this.dl);
                            ((MyMouseAdapter)MyMouseAdapter.this).Plain.this.drawroom.repaint();
                        }

                        @Override
                        public void undo() throws CannotUndoException {
                            super.undo();
                            ((MyMouseAdapter)MyMouseAdapter.this).Plain.this.drawroom.canvas.remove(this.dl);
                            ((MyMouseAdapter)MyMouseAdapter.this).Plain.this.drawroom.repaint();
                        }
                    };
                    Plain.this.undoManager.addEdit(undoableEdit);
                }
                if (Plain.this.clicked == 4) {
                    undoableEdit = new LUndoEdit(Plain.this.dragLabel, Plain.this.beforeMove){

                        @Override
                        public void redo() throws CannotRedoException {
                            super.redo();
                            ((MyMouseAdapter)MyMouseAdapter.this).Plain.this.drawroom.canvas.remove(this.dl);
                            this.dl.setLocation(this.endMove);
                            ((MyMouseAdapter)MyMouseAdapter.this).Plain.this.drawroom.canvas.add(this.dl);
                            ((MyMouseAdapter)MyMouseAdapter.this).Plain.this.drawroom.repaint();
                        }

                        @Override
                        public void undo() throws CannotUndoException {
                            super.undo();
                            ((MyMouseAdapter)MyMouseAdapter.this).Plain.this.drawroom.canvas.remove(this.dl);
                            this.dl.setLocation(this.beforeMove);
                            ((MyMouseAdapter)MyMouseAdapter.this).Plain.this.drawroom.canvas.add(this.dl);
                            ((MyMouseAdapter)MyMouseAdapter.this).Plain.this.drawroom.repaint();
                        }
                    };
                    Plain.this.undoManager.addEdit(undoableEdit);
                }
                Plain.this.orangeLines(Plain.this.dragLabel);
                this.pairupwithLines(Plain.this.dragLabel);
                Plain.this.list.add(Plain.this.dragLabel);
                Plain.this.addinline(Plain.this.dragLabel);
                if (Plain.this.clicked != 4) {
                    Plain.this.labeler.setBorder(new BevelBorder(0));
                }
            } else if (Plain.this.clicked == 3) {
                if (Plain.this.doublenode.size() == 1 && Plain.this.doublenode.elementAt(0) == Plain.this.dragLabel) {
                    Plain.this.doublenode.removeAllElements();
                    Plain.this.dragLabel.stop();
                } else {
                    Plain.this.dragLabel.browntwinkle();
                    Plain.this.doublenode.add(Plain.this.dragLabel);
                }
                Plain.this.drawroom.repaint();
            }
            Plain.this.dragLabel = null;
            Plain.this.labeler = null;
        }

        public void releaseEL() {
            if (Plain.this.labeler == null) {
                if (Plain.this.dline.size() > 0) {
                    for (Line xx : Plain.this.dline) {
                        Plain.this.removeline(xx);
                    }
                    Plain.this.dline.removeAllElements();
                } else if (Plain.this.store.size() == 1) {
                    Plain.this.store.removeAllElements();
                    Plain.this.info.setText("line cannot be added because it goes beyond the range of the drawing panel");
                    Plain.this.repaint();
                }
                return;
            }
            if (Plain.this.clicked == 2 || Plain.this.clicked == 11 || Plain.this.clicked == 4) {
                Plain.this.removelines(Plain.this.dragLabel);
                Plain.this.remove(Plain.this.dragLabel);
                Plain.this.list.remove(Plain.this.dragLabel);
                if (Plain.this.clicked == 2 || Plain.this.clicked == 11) {
                    Plain.this.labeler.setBorder(new BevelBorder(0));
                }
                Plain.this.dragLabel = null;
                Plain.this.labeler = null;
            } else if (Plain.this.clicked != 1) {
                Plain.this.dragLabel = null;
                Plain.this.labeler = null;
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (Plain.this.clicked != 10 && Plain.this.store.size() > 0) {
                Plain.this.store.removeElementAt(Plain.this.store.size() - 1);
            }
            try {
                Plain.this.clickedPanel = Plain.this.getPanel(Plain.this.now);
            }
            catch (ClassCastException ec) {
                Plain.this.clickedPanel = null;
            }
            if (Plain.this.clickedPanel == Plain.this.drawroom.canvas) {
                this.releaseDR(me);
            } else {
                this.releaseEL();
            }
            Plain.this.checkGE();
            Plain.this.repaint();
        }
    }

    class Top
    extends JPanel {
        Top() {
        }

        public void updateTP() {
            LUndoEdit undoableEdit;
            Line newline = new Line(Plain.this.plain);
            if (Plain.this.store.elementAt((int)0).y > Plain.this.store.elementAt((int)1).y) {
                newline.start = Plain.this.store.elementAt(0);
                newline.end = Plain.this.store.elementAt(1);
            } else {
                newline.start = Plain.this.store.elementAt(1);
                newline.end = Plain.this.store.elementAt(0);
            }
            newline.checkfornodes();
            Line existed = null;
            for (Line ll : Plain.this.linelist) {
                if (ll.parent != newline.parent || ll.children != newline.children || ll.parent == null || ll.children == null) continue;
                existed = ll;
                break;
            }
            if (existed == null) {
                Plain.this.linelist.addElement(newline);
                undoableEdit = new LUndoEdit(newline){

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        ((Top)Top.this).Plain.this.linelist.addElement(this.line);
                        ((Top)Top.this).Plain.this.top.repaint();
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        ((Top)Top.this).Plain.this.linelist.removeElement(this.line);
                        ((Top)Top.this).Plain.this.top.repaint();
                    }
                };
                Plain.this.undoManager.addEdit(undoableEdit);
            } else {
                undoableEdit = new LUndoEdit(existed.parent, existed.children){

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        Plain.this.addlines(this.head, this.end);
                        ((Top)Top.this).Plain.this.top.repaint();
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        Plain.this.removelines(this.head, this.end);
                        ((Top)Top.this).Plain.this.top.repaint();
                    }
                };
                Plain.this.undoManager.addEdit(undoableEdit);
            }
            Plain.this.pointEnd = null;
            Plain.this.store.removeElementAt(1);
            Plain.this.store.removeElementAt(0);
        }

        public void updateDN() {
            LUndoEdit undoableEdit;
            boolean delete = false;
            for (NodeLabel xy : Plain.this.doublenode.elementAt((int)0).children) {
                if (xy != Plain.this.doublenode.elementAt(1)) continue;
                delete = true;
                break;
            }
            if (!delete) {
                for (NodeLabel xy : Plain.this.doublenode.elementAt((int)0).parents) {
                    if (xy != Plain.this.doublenode.elementAt(1)) continue;
                    delete = true;
                    break;
                }
            }
            if (delete) {
                Plain.this.removelines(Plain.this.doublenode.elementAt(0), Plain.this.doublenode.elementAt(1));
                undoableEdit = new LUndoEdit(Plain.this.doublenode.elementAt(0), Plain.this.doublenode.elementAt(1)){

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        Plain.this.removelines(this.head, this.end);
                        ((Top)Top.this).Plain.this.top.repaint();
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        Plain.this.addlines(this.head, this.end);
                        ((Top)Top.this).Plain.this.top.repaint();
                    }
                };
                Plain.this.undoManager.addEdit(undoableEdit);
            } else {
                Plain.this.addlines(Plain.this.doublenode.elementAt(0), Plain.this.doublenode.elementAt(1));
                undoableEdit = new LUndoEdit(Plain.this.doublenode.elementAt(0), Plain.this.doublenode.elementAt(1)){

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        Plain.this.addlines(this.head, this.end);
                        ((Top)Top.this).Plain.this.top.repaint();
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        Plain.this.removelines(this.head, this.end);
                        ((Top)Top.this).Plain.this.top.repaint();
                    }
                };
                Plain.this.undoManager.addEdit(undoableEdit);
            }
            Plain.this.doublenode.elementAt(0).stop();
            Plain.this.doublenode.elementAt(1).stop();
            Plain.this.doublenode.removeAllElements();
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            super.paint(g);
            if (Plain.this.store.size() == 2) {
                this.updateTP();
                this.repaint();
                Plain.this.checkGE();
            }
            if (Plain.this.doublenode.size() == 2) {
                this.updateDN();
                this.repaint();
                Plain.this.checkGE();
            }
            g2.setStroke(new BasicStroke(1.0f));
            Point adjust = Plain.this.plain.drawroom.canvas.getLocation();
            if (Plain.this.store.size() == 1) {
                g2.setStroke(new BasicStroke(2.0f));
                g.setColor(Color.blue);
                try {
                    g.drawLine(Plain.this.store.elementAt((int)0).x + Plain.this.plain.getLocation((int)2).x + adjust.x, Plain.this.store.elementAt((int)0).y + Plain.this.plain.getLocation((int)2).y + adjust.y, Plain.this.pointEnd.x + Plain.this.plain.getLocation((int)2).x + adjust.x, Plain.this.pointEnd.y + Plain.this.plain.getLocation((int)2).y + adjust.y);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (Plain.this.dline.size() > 0) {
                for (Line xy : Plain.this.dline) {
                    g2.setStroke(new BasicStroke(2.0f));
                    g.setColor(Color.blue);
                    g.drawLine(xy.start.x + Plain.this.plain.getLocation((int)2).x + adjust.x, xy.start.y + Plain.this.plain.getLocation((int)2).y + adjust.y, xy.end.x + Plain.this.plain.getLocation((int)2).x + adjust.x, xy.end.y + Plain.this.plain.getLocation((int)2).y + adjust.y);
                }
            }
        }
    }
}

