/*
 * Decompiled with CFR 0.152.
 */
package program.mainUI.drawingPanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import program.mainUI.Int;
import program.mainUI.drawingPanel.Line;
import program.mainUI.drawingPanel.Plain;

public class NodeLabel
extends JPanel
implements Comparable<NodeLabel>,
Serializable {
    public JLabel label = new JLabel();
    transient Plain plain;
    public String grammar_error = "";
    public Point location = new Point(0, 0);
    public Vector<NodeLabel> children = new Vector();
    public Vector<NodeLabel> parents = new Vector();
    public Vector<Line> parentlines = new Vector();
    public Vector<Line> childrenlines = new Vector();
    int color = 0;
    private transient JPopupMenu right_click_menu;
    public int type = 0;
    int levelsUp = 0;
    int levelsDown = 0;
    public String bracketForm = null;
    int standardx = 0;
    int yUp = 0;
    int yDown = 0;
    int level = 0;
    Timer timer = null;
    int dragged = 0;

    public void setColor() {
        if (this.color == 1) {
            this.label.setForeground(Color.blue);
            this.setBold();
        } else if (this.color == 3) {
            this.label.setForeground(Color.decode("0x994C00"));
            this.setBold();
        } else if (this.color == 4) {
            this.label.setForeground(Color.red);
            this.setBold();
        } else if (this.color == 5) {
            this.label.setForeground(Color.decode("0x4c9900"));
            this.setBold();
        } else {
            this.label.setForeground(Color.black);
            this.setPlain();
        }
    }

    public void setPlain() {
    }

    public void setBold() {
    }

    public String wellFormed_and_complete() {
        return null;
    }

    public int distanceToLabel(Point p) {
        int xi1 = super.getLocation().x + this.label.getLocation().x;
        int xi2 = super.getLocation().x + this.label.getLocation().x + this.label.getWidth();
        int yi1 = super.getLocation().y + this.label.getLocation().y;
        int yi2 = super.getLocation().y + this.label.getLocation().y + this.label.getHeight();
        int xo1 = xi1 - this.label.getHeight();
        int xo2 = xi2 + this.label.getHeight();
        int yo1 = yi1 - this.label.getHeight();
        int yo2 = yi2 + this.label.getHeight();
        int x = p.x;
        int y = p.y;
        if (x <= xo2 && x >= xo1 && y > yo1 && y < yo2) {
            if (x > xi2 || x < xi1 || y < yi1 || y > yi2) {
                if (x <= xi2 && x >= xi1) {
                    if (y < yi1) {
                        return yi1 - y;
                    }
                    return y - yi2;
                }
                if (y >= yi1 && y <= yi2) {
                    if (x < xi1) {
                        return xi1 - x;
                    }
                    return x - xi2;
                }
                if (x < xi1 && x >= xo1) {
                    if (y < yi1) {
                        if (yi1 - y > xi1 - x) {
                            return yi1 - y;
                        }
                        return xi1 - x;
                    }
                    if (y - yi2 > xi1 - x) {
                        return y - yi2;
                    }
                    return xi1 - x;
                }
                if (y < yi1) {
                    if (yi1 - y > x - xi2) {
                        return yi1 - y;
                    }
                    return x - xi2;
                }
                if (y - yi2 > x - xi2) {
                    return y - yi2;
                }
                return x - xi2;
            }
            return -1;
        }
        return 0;
    }

    public void attachTo(Plain p) {
        this.plain = p;
    }

    public NodeLabel(String x, Plain p) {
        super.setOpaque(false);
        super.setLayout(new GridBagLayout());
        this.label.setText(x);
        Dimension labelsize = this.label.getPreferredSize();
        this.plain = p;
        super.add(this.label);
        super.setPreferredSize(new Dimension((int)(labelsize.getWidth() + labelsize.getHeight()), (int)(labelsize.getHeight() * 2.0)));
        this.label.addMouseListener(new ML());
        this.label.addMouseMotionListener(new ML());
        this.label.setSize(labelsize);
        this.label.setLocation(labelsize.height / 2, labelsize.height / 2);
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(0);
        JPanel changeto = new JPanel();
        changeto.setBackground(Color.white);
        changeto.setLayout(new GridBagLayout());
        GridBagConstraints ctc = new GridBagConstraints();
        ctc.gridx = 0;
        ctc.gridy = 0;
        ctc.gridwidth = 2;
        ctc.insets = new Insets(0, 20, 0, 0);
        JLabel ch = new JLabel("Change Node to:");
        ctc.anchor = 17;
        changeto.add((Component)ch, ctc);
        final JTextField item = new JTextField();
        item.setPreferredSize(new Dimension(item.getPreferredSize().height * 4, item.getPreferredSize().height));
        ctc.gridx = 0;
        ctc.gridy = 1;
        ctc.gridwidth = 1;
        ctc.weightx = 1.0;
        changeto.add((Component)item, ctc);
        ctc.insets = new Insets(0, 0, 0, 0);
        ctc.gridx = 1;
        ctc.weightx = 0.0;
        this.right_click_menu = new JPopupMenu();
        final JButton change_to = new JButton("GO");
        changeto.add((Component)change_to, ctc);
        change_to.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeLabel.this.label.setText(item.getText());
                Dimension labelsize = NodeLabel.this.label.getPreferredSize();
                NodeLabel.this.setSize(new Dimension((int)(labelsize.getWidth() + labelsize.getHeight()), (int)(labelsize.getHeight() * 2.0)));
                NodeLabel.this.repaint();
            }
        });
        JMenuItem delete = new JMenuItem("Delete");
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<NodeLabel> pp = new Vector<NodeLabel>();
                for (NodeLabel xx : NodeLabel.this.parents) {
                    pp.add(xx);
                }
                for (NodeLabel xii : pp) {
                    NodeLabel.this.plain.removelines(NodeLabel.this, xii);
                }
                Vector<NodeLabel> cc = new Vector<NodeLabel>();
                for (NodeLabel xx : NodeLabel.this.children) {
                    cc.add(xx);
                }
                for (NodeLabel x : cc) {
                    NodeLabel.this.plain.removelines(NodeLabel.this, x);
                }
                for (Line ll : NodeLabel.this.childrenlines) {
                    NodeLabel.this.plain.linelist.remove(ll);
                }
                for (Line ll : NodeLabel.this.parentlines) {
                    NodeLabel.this.plain.linelist.remove(ll);
                }
                NodeLabel.this.plain.drawroom.canvas.remove(NodeLabel.this);
                NodeLabel.this.plain.list.remove(NodeLabel.this);
                NodeLabel.this.plain.drawroom.repaint();
            }
        });
        this.right_click_menu.add(delete);
        JMenu item3 = new JMenu("Change To");
        this.right_click_menu.add(item3);
        item3.add(changeto);
        item.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    change_to.doClick();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.label.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 49) {
                    NodeLabel.this.plain.drawroom.delete.doClick();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private boolean twoPointsOut(NodeLabel nl, Line l) {
        Vector<Point> p = new Vector<Point>();
        p.add(l.start);
        p.add(l.end);
        int nx1 = nl.location.x + nl.label.getLocation().x;
        int nx2 = nx1 + nl.label.getWidth();
        int ny1 = nl.location.y + nl.label.getLocation().y;
        int ny2 = ny1 + nl.label.getHeight();
        for (Point i : p) {
            int x = i.x;
            int y = i.y;
            if ((x > nx1 || x < nx2) && (x < nx1 || x > nx2) || (y > ny1 || x < ny2) && (y < ny1 || y > ny2)) continue;
            return false;
        }
        return true;
    }

    public boolean crosslingLine(Line x) {
        int x1 = x.start.x;
        int y1 = x.start.y;
        int x2 = x.end.x;
        int y2 = x.end.y;
        int lx1 = this.location.x + this.label.getLocation().x;
        int lx2 = lx1 + this.label.getWidth();
        int ly1 = this.location.y + this.label.getLocation().y;
        int ly2 = ly1 + this.label.getHeight();
        if (this.twoPointsOut(this, x)) {
            if (x1 == x2) {
                if (x1 >= lx1 && x1 <= lx2 && ly2 < y1 && ly1 > y2) {
                    return true;
                }
            } else if (y1 == y2) {
                if (y1 >= ly1 && y1 <= ly2) {
                    return true;
                }
            } else {
                double t = (double)(y2 - y1) / (double)(x2 - x1);
                double c = (double)y1 - t * (double)x1;
                double ynow1 = t * (double)lx1 + c;
                double xnow1 = ((double)ly1 - c) / t;
                double ynow2 = t * (double)lx2 + c;
                double xnow2 = ((double)ly2 - c) / t;
                if (ynow1 <= (double)ly2 && ynow1 >= (double)ly1 && (lx1 <= x1 && lx1 >= x2 || lx1 >= x1 && lx1 <= x2) || xnow1 <= (double)lx2 && xnow1 >= (double)lx1 && (ly1 <= y1 && ly2 >= y2 || ly1 >= y1 && ly2 <= y2) || ynow2 <= (double)ly2 && ynow2 >= (double)ly1 && (lx2 <= x1 && lx2 >= x2 || lx1 >= x1 && lx2 <= x2) || xnow2 <= (double)lx2 && xnow2 >= (double)lx1 && (ly2 <= y1 && ly2 >= y2 || ly2 >= y1 && ly2 <= y2)) {
                    return true;
                }
            }
        }
        return false;
    }

    void browntwinkle() {
        Font font = this.label.getFont();
        Font boldFont = new Font(font.getFontName(), 1, font.getSize());
        this.setFont(boldFont);
        this.setSize(super.getPreferredSize());
        final Int i = new Int();
        this.timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ++i.number;
                if (i.number % 3 == 0 || i.number % 3 == 2) {
                    NodeLabel.this.setVisible(true);
                } else {
                    NodeLabel.this.setVisible(false);
                }
                NodeLabel.this.repaint();
            }
        });
        this.timer.setRepeats(true);
        this.timer.setCoalesce(true);
        this.timer.start();
    }

    void stop() {
        final Int i = new Int();
        this.timer.stop();
        this.timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ++i.number;
                if (i.number == 1 || i.number == 2) {
                    NodeLabel.this.label.setForeground(Color.decode("0x4c9900"));
                    NodeLabel.this.setBold();
                } else if (i.number == 3) {
                    NodeLabel.this.setColor();
                } else {
                    NodeLabel.this.timer.stop();
                }
                NodeLabel.this.repaint();
            }
        });
        this.timer.setRepeats(true);
        this.timer.setCoalesce(true);
        this.setVisible(true);
        this.timer.start();
        Font font = this.label.getFont();
        this.setFont(font);
    }

    @Override
    public int compareTo(NodeLabel o) {
        int midxo = o.location.x + o.getWidth() / 2;
        int midx = this.location.x + this.getWidth() / 2;
        return midxo - midx;
    }

    public class ML
    extends MouseAdapter {
        @Override
        public void mouseExited(MouseEvent me) {
            NodeLabel.this.label.setBorder(null);
            NodeLabel.this.plain.drawroom.repaint();
            Point zz = me.getPoint();
            Point hh = NodeLabel.this.label.getLocation();
            Point xx = NodeLabel.super.getLocation();
            Point yy = NodeLabel.this.plain.drawroom.getLocation();
            MouseEvent e = new MouseEvent(NodeLabel.this.plain, 506, 0L, 0, xx.x + yy.x + zz.x + hh.x, xx.y + yy.y + zz.y + hh.y, 0, false);
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            Point zz = me.getPoint();
            Point xx = NodeLabel.this.location;
            Point hh = NodeLabel.this.label.getLocation();
            Point yy = NodeLabel.this.plain.drawroom.canvas.getLocation();
            Point tt = NodeLabel.this.plain.getLocation(2);
            MouseEvent e = new MouseEvent(NodeLabel.this.plain, 503, 0L, 0, tt.x + xx.x + yy.x + zz.x + hh.x, xx.y + yy.y + zz.y + hh.y + tt.y, 0, false);
            NodeLabel.this.plain.myMouseAdapter.mouseMoved(e);
            NodeLabel.this.plain.info.setText("Node " + NodeLabel.this.label.getText() + " is ready to be dragged or chosen");
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            NodeLabel.this.label.setForeground(Color.blue);
            NodeLabel.this.label.setBorder(new LineBorder(Color.black, 2));
            NodeLabel.this.label.setSize(NodeLabel.this.getPreferredSize());
            NodeLabel.this.plain.info.setText("Node " + NodeLabel.this.label.getText() + " is ready to be dragged or chosen");
            NodeLabel.this.plain.info.revalidate();
            NodeLabel.this.plain.info.repaint();
            NodeLabel.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.getButton() == 1) {
                Point zz = me.getPoint();
                Point hh = NodeLabel.this.label.getLocation();
                Point xx = NodeLabel.this.location;
                Point yy = NodeLabel.this.plain.drawroom.canvas.getLocation();
                Point tt = NodeLabel.this.plain.getLocation(2);
                MouseEvent e = new MouseEvent(NodeLabel.this.plain, 0, 0L, 0, xx.x + yy.x + zz.x + hh.x + tt.x, xx.y + yy.y + zz.y + hh.y + tt.y, 1, false);
                NodeLabel.this.plain.myMouseAdapter.mousePressed(e);
            } else if (me.getButton() == 3) {
                NodeLabel.this.right_click_menu.show(me.getComponent(), me.getX(), me.getY());
            }
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            Point zz = me.getPoint();
            Point xx = NodeLabel.this.location;
            Point hh = NodeLabel.this.label.getLocation();
            Point yy = NodeLabel.this.plain.drawroom.canvas.getLocation();
            Point tt = NodeLabel.this.plain.getLocation(2);
            MouseEvent e = new MouseEvent(NodeLabel.this.plain, 506, 0L, 0, xx.x + zz.x + yy.x + hh.x + tt.x, xx.y + zz.y + yy.y + hh.y + tt.y, 0, false);
            NodeLabel.this.plain.myMouseAdapter.mouseDragged(e);
            NodeLabel.this.dragged = 1;
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            Point zz = me.getPoint();
            Point xx = NodeLabel.this.location;
            Point hh = NodeLabel.this.label.getLocation();
            Point yy = NodeLabel.this.plain.drawroom.canvas.getLocation();
            Point tt = NodeLabel.this.plain.getLocation(2);
            MouseEvent e = new MouseEvent(NodeLabel.this.plain, 502, 0L, 0, tt.x + xx.x + zz.x + yy.x + hh.x, xx.y + zz.y + yy.y + hh.y + tt.y, 0, false);
            NodeLabel.this.plain.myMouseAdapter.mouseReleased(e);
            NodeLabel.this.dragged = 0;
        }
    }
}

