/*
 * Decompiled with CFR 0.152.
 */
package program.mainUI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.DefaultMutableTreeNode;
import program.Preference;
import program.grammar.Grammar;
import program.mainUI.drawingPanel.Line;
import program.mainUI.drawingPanel.NodeLabel;
import program.mainUI.drawingPanel.Plain;
import program.mainUI.inforTree.IndexNode;
import program.mainUI.inforTree.SentenceTree;

public class Interface
extends JPanel {
    Preference pp = new Preference();
    String newline = System.getProperty("line.separator");
    String output = "";
    public Plain drawingPanel;
    public String status = "edit";
    JPanel freeDrawingPanel;
    public TeacherPanel teacherPanel;
    JPanel rightPanel;
    JSplitPane splitPane;
    public SentenceTree sentenceTree;
    Tree tree = new Tree();

    public Interface(Plain inputdp) {
        this.drawingPanel = inputdp;
        this.teacherPanel = new TeacherPanel();
        this.sentenceTree = new SentenceTree(this);
        this.sentenceTree.teacherPanel = this.teacherPanel;
        this.sentenceTree.treeModePlain = inputdp;
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new GridBagLayout());
        this.splitPane = new JSplitPane(1, this.sentenceTree, this.rightPanel);
        this.splitPane.setDividerLocation(200);
        this.splitPane.setOneTouchExpandable(true);
        this.setLayout(new GridBagLayout());
    }

    public void clearPanels() {
        super.removeAll();
        this.rightPanel.removeAll();
        this.splitPane = null;
    }

    public void freedrawingMode() {
        this.clearPanels();
        this.forSentence();
        this.drawingPanel.dialogue.setEditable(false);
        this.teacherPanel.sentence.setEditable(true);
        this.teacherPanel.meaning.setVisible(false);
        this.teacherPanel.sn.setVisible(false);
        this.teacherPanel.savechange.setVisible(false);
        this.teacherPanel.saveasnew.setVisible(false);
        this.teacherPanel.check.setVisible(false);
        this.teacherPanel.next.setVisible(false);
        this.teacherPanel.tlabel.setText("Tree Drawing");
        this.teacherPanel.mlabel.setVisible(false);
        this.drawingPanel.dialogue.setText("");
        this.teacherPanel.start.setVisible(true);
        this.teacherPanel.sl.setVisible(true);
        this.teacherPanel.clean.setVisible(true);
        this.teacherPanel.clean2.setVisible(false);
        this.status = "practice";
        this.splitPane = new JSplitPane(1, this.sentenceTree, this.rightPanel);
        this.splitPane.setDividerLocation(200);
        this.splitPane.setOneTouchExpandable(true);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.insets = new Insets(10, 10, 5, 10);
        this.rightPanel.add((Component)this.teacherPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.rightPanel.add((Component)this.drawingPanel, c);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.rightPanel, c);
    }

    public void teacherMode() {
        this.clearPanels();
        this.drawingPanel.dialogue.setEditable(true);
        this.teacherPanel.sentence.setEditable(false);
        this.teacherPanel.meaning.setEditable(false);
        this.teacherPanel.meaning.setVisible(true);
        this.teacherPanel.mlabel.setVisible(true);
        this.sentenceTree.selectNode();
        this.teacherPanel.sn.setVisible(true);
        this.teacherPanel.savechange.setVisible(false);
        this.teacherPanel.saveasnew.setVisible(false);
        this.teacherPanel.check.setVisible(false);
        this.teacherPanel.next.setVisible(false);
        this.teacherPanel.tlabel.setText("Teacher Mode");
        this.teacherPanel.start.setVisible(false);
        this.teacherPanel.sl.setVisible(false);
        this.teacherPanel.clean.setVisible(true);
        this.teacherPanel.clean2.setVisible(false);
        this.status = "edit";
        this.splitPane = new JSplitPane(1, this.sentenceTree, this.rightPanel);
        this.splitPane.setDividerLocation(200);
        this.splitPane.setOneTouchExpandable(true);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.insets = new Insets(10, 10, 5, 10);
        this.rightPanel.add((Component)this.teacherPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.rightPanel.add((Component)this.drawingPanel, c);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.splitPane, c);
    }

    public void practiceMode() {
        this.clearPanels();
        this.teacherPanel.mlabel.setVisible(true);
        this.sentenceTree.selectNode();
        this.drawingPanel.dialogue.setEditable(false);
        this.teacherPanel.sentence.setEditable(false);
        this.teacherPanel.meaning.setEditable(false);
        this.teacherPanel.meaning.setVisible(true);
        this.teacherPanel.sn.setVisible(false);
        this.teacherPanel.savechange.setVisible(false);
        this.teacherPanel.saveasnew.setVisible(false);
        this.teacherPanel.check.setVisible(false);
        this.teacherPanel.next.setVisible(false);
        this.teacherPanel.tlabel.setText("");
        this.teacherPanel.start.setVisible(false);
        this.teacherPanel.sl.setVisible(false);
        this.teacherPanel.clean.setVisible(false);
        this.teacherPanel.clean2.setVisible(false);
        this.status = "practice";
        this.splitPane = new JSplitPane(1, this.sentenceTree, this.rightPanel);
        this.splitPane.setDividerLocation(200);
        this.splitPane.setOneTouchExpandable(true);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.insets = new Insets(10, 10, 5, 10);
        this.rightPanel.add((Component)this.teacherPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.rightPanel.add((Component)this.drawingPanel, c);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.splitPane, c);
    }

    private static void createAndShowUI() {
    }

    public static void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    public Tree createNewTree(String sentence, String meaning, String structure) {
        Tree r = new Tree();
        r.sentence = sentence;
        r.meaning = meaning;
        r.changeStructureToTree(structure);
        return r;
    }

    private void editMode() {
        this.clearPanels();
        GridBagConstraints c = new GridBagConstraints();
        this.teacherPanel.sentence.setEditable(true);
        this.teacherPanel.meaning.setEditable(true);
        this.teacherPanel.sn.setVisible(true);
        this.teacherPanel.check.setVisible(false);
        this.teacherPanel.tlabel.setText("Teacher Mode");
        this.status = "view";
        this.splitPane = new JSplitPane(1, this.sentenceTree, this.rightPanel);
        this.splitPane.setDividerLocation(200);
        this.splitPane.setOneTouchExpandable(true);
        BasicSplitPaneUI ui = (BasicSplitPaneUI)this.splitPane.getUI();
        JButton oneClick = (JButton)ui.getDivider().getComponent(0);
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.insets = new Insets(10, 10, 5, 10);
        this.rightPanel.add((Component)this.teacherPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.rightPanel.add((Component)this.drawingPanel, c);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.splitPane, c);
    }

    public void saveTree() {
        if (this.sentenceTree.presentNode != this.sentenceTree.sentence.root) {
            IndexNode now = (IndexNode)this.sentenceTree.presentNode;
            if (now.type.equals("sentence")) {
                this.tree.linelist = this.drawingPanel.linelist;
                this.tree.list = this.drawingPanel.list;
                this.tree.sentence = this.teacherPanel.sentence.getText();
                this.tree.meaning = this.teacherPanel.meaning.getText();
                this.sentenceTree.updateATreeNode(now, this.tree);
                now.updateTree(this.tree);
            } else if (now.type.equals("instruction")) {
                now.updateInstruction(this.drawingPanel.dialogue.getText());
            }
        }
    }

    public void forInstructionEdit() {
        this.teacherPanel.sentence.setEditable(false);
        this.teacherPanel.meaning.setEditable(false);
        this.drawingPanel.instructionEdit();
        this.teacherPanel.savechange.setVisible(false);
        this.teacherPanel.saveasnew.setVisible(false);
        this.teacherPanel.start.setVisible(false);
        this.teacherPanel.sl.setVisible(false);
        this.teacherPanel.clean.setVisible(true);
    }

    public void forSentenceEdit() {
        this.teacherPanel.sentence.setEditable(true);
        this.teacherPanel.meaning.setEditable(true);
        this.drawingPanel.sentenceEdit();
        this.teacherPanel.savechange.setVisible(true);
        this.teacherPanel.saveasnew.setVisible(true);
        this.teacherPanel.start.setVisible(true);
        this.teacherPanel.sl.setVisible(true);
        this.teacherPanel.clean.setVisible(true);
    }

    public void forFolder() {
        this.teacherPanel.sentence.setEditable(false);
        this.teacherPanel.meaning.setEditable(false);
        this.drawingPanel.folderEdit();
        this.teacherPanel.savechange.setVisible(false);
        this.teacherPanel.saveasnew.setVisible(false);
        this.teacherPanel.start.setVisible(false);
        this.teacherPanel.sl.setVisible(false);
        this.teacherPanel.clean.setVisible(false);
    }

    public Tree createNewTree2(String name, String meaning, String structure) {
        Tree r = new Tree();
        r.sentence = name;
        r.meaning = meaning;
        return r;
    }

    public void forSentence() {
        this.drawingPanel.sentence();
        this.teacherPanel.sl.setVisible(true);
        this.teacherPanel.clean2.setVisible(true);
        this.teacherPanel.check.setVisible(true);
        this.teacherPanel.next.setVisible(true);
    }

    public void forInstruction() {
        this.drawingPanel.instruction();
        this.teacherPanel.sl.setVisible(false);
        this.teacherPanel.clean2.setVisible(false);
        this.teacherPanel.check.setVisible(false);
        this.teacherPanel.next.setVisible(false);
    }

    public static void main(String[] args) {
        Interface.setUIFont(new FontUIResource("Serif", 0, 22));
        JFrame frame = new JFrame("UCLA-PPP Parse and Practice Program");
        Grammar grammar = new Grammar();
        Plain layers = new Plain(grammar);
        Interface main_interface = new Interface(layers);
        frame.add((Component)main_interface, "Center");
        main_interface.freedrawingMode();
        Toolkit tk = Toolkit.getDefaultToolkit();
        int xSize = (int)tk.getScreenSize().getWidth();
        int ySize = (int)tk.getScreenSize().getHeight();
        frame.setPreferredSize(new Dimension(xSize - 300, ySize));
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public class TeacherPanel
    extends JPanel {
        public JButton check = new JButton("Check Answer");
        JButton next = new JButton("Next");
        JButton sn = new JButton("New");
        JButton savechange = new JButton("Save Change");
        JButton saveasnew = new JButton("Save as New");
        JLabel tlabel = new JLabel("Teacher Mode");
        JButton start = new JButton("Start");
        JButton sl = new JButton("Straighten Lines");
        public JButton clean = new JButton("Clear");
        JButton clean2 = new JButton("Clear");
        JLabel slabel = new JLabel("Sentence");
        public JTextField sentence = new JTextField();
        JLabel mlabel = new JLabel("Meaning");
        public JTextField meaning = new JTextField();

        public void setBasicLayout() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.add((Component)this.sn, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.add((Component)this.savechange, c);
            c.gridx = 2;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.add((Component)this.saveasnew, c);
            c.gridx = 3;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.add((Component)this.check, c);
            c.gridx = 4;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.add((Component)this.next, c);
            c.gridx = 5;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.fill = 0;
            this.add((Component)this.tlabel, c);
            c.gridx = 6;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 1;
            this.add((Component)this.start, c);
            c.gridx = 7;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 1;
            this.add((Component)this.sl, c);
            c.gridx = 8;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 1;
            this.add((Component)this.clean, c);
            c.gridx = 9;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.add((Component)this.clean2, c);
            JPanel enter = new JPanel();
            enter.setLayout(new GridBagLayout());
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 10;
            c.weightx = 1.0;
            c.fill = 1;
            this.add((Component)enter, c);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 1;
            enter.add((Component)this.slabel, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.fill = 1;
            enter.add((Component)this.sentence, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 1;
            enter.add((Component)this.mlabel, c);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.fill = 1;
            enter.add((Component)this.meaning, c);
        }

        public void checkanswer() {
            Tree newtree = new Tree();
            newtree.list = Interface.this.drawingPanel.copylist(Interface.this.drawingPanel.list);
            String x = newtree.bracketForm();
            IndexNode nownode = (IndexNode)Interface.this.sentenceTree.presentNode;
            Tree newtree2 = new Tree();
            String y = nownode.structure;
            if (x.equals(y)) {
                Interface.this.drawingPanel.dialogue.setText("Correct!");
                nownode.correct = 1;
            } else {
                boolean ee = false;
                for (NodeLabel xf : newtree.list) {
                    if (xf.grammar_error.equals("")) continue;
                    ee = true;
                    break;
                }
                nownode.correct = -1;
                if (ee) {
                    Interface.this.drawingPanel.dialogue.setText("Incorrect! Not legal structure by the rules.");
                } else {
                    Interface.this.drawingPanel.dialogue.setText("Incorrect!This is a legal structure, but it doesn't have a right meaning.");
                }
            }
        }

        public TeacherPanel() {
            this.setBasicLayout();
            Interface.this.drawingPanel.removeMouseListener(Interface.this.drawingPanel.myMouseAdapter);
            Interface.this.drawingPanel.removeMouseMotionListener(Interface.this.drawingPanel.myMouseAdapter);
            this.clean.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TeacherPanel)TeacherPanel.this).Interface.this.drawingPanel.clean();
                    TeacherPanel.this.sentence.setText("");
                    TeacherPanel.this.meaning.setText("");
                    ((TeacherPanel)TeacherPanel.this).Interface.this.tree = new Tree();
                }
            });
            this.clean2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TeacherPanel)TeacherPanel.this).Interface.this.drawingPanel.clean2();
                }
            });
            this.sl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TeacherPanel)TeacherPanel.this).Interface.this.drawingPanel.adjust();
                }
            });
            this.start.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = TeacherPanel.this.sentence.getText();
                    ((TeacherPanel)TeacherPanel.this).Interface.this.drawingPanel.input(s);
                    ((TeacherPanel)TeacherPanel.this).Interface.this.tree.sentence = s;
                    Interface.this.saveTree();
                }
            });
            this.check.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TeacherPanel.this.checkanswer();
                }
            });
            this.sn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Interface.this.saveTree();
                    ((TeacherPanel)TeacherPanel.this).Interface.this.tree = new Tree();
                    ((TeacherPanel)TeacherPanel.this).Interface.this.sentenceTree.addSentence(((TeacherPanel)TeacherPanel.this).Interface.this.tree, ((TeacherPanel)TeacherPanel.this).Interface.this.sentenceTree.presentNode);
                    ((TeacherPanel)TeacherPanel.this).Interface.this.sentenceTree.selectNode();
                    TeacherPanel.this.repaint();
                }
            });
            this.next.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = ((TeacherPanel)TeacherPanel.this).Interface.this.sentenceTree.sentence.root.getIndex(((TeacherPanel)TeacherPanel.this).Interface.this.sentenceTree.presentNode);
                    if (i < ((TeacherPanel)TeacherPanel.this).Interface.this.sentenceTree.sentence.root.getChildCount()) {
                        DefaultMutableTreeNode now = (DefaultMutableTreeNode)((TeacherPanel)TeacherPanel.this).Interface.this.sentenceTree.sentence.root.getChildAt(i + 1);
                        ((TeacherPanel)TeacherPanel.this).Interface.this.sentenceTree.sentence.setSelectedNode(now);
                        ((TeacherPanel)TeacherPanel.this).Interface.this.sentenceTree.presentNode = now;
                        ((TeacherPanel)TeacherPanel.this).Interface.this.sentenceTree.selectNode();
                    }
                }
            });
            this.savechange.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Interface.this.saveTree();
                    ((TeacherPanel)TeacherPanel.this).Interface.this.tree = new Tree();
                    ((TeacherPanel)TeacherPanel.this).Interface.this.tree.sentence = TeacherPanel.this.sentence.getText();
                    ((TeacherPanel)TeacherPanel.this).Interface.this.tree.meaning = TeacherPanel.this.meaning.getText();
                    ((TeacherPanel)TeacherPanel.this).Interface.this.tree.list = ((TeacherPanel)TeacherPanel.this).Interface.this.drawingPanel.copylist(((TeacherPanel)TeacherPanel.this).Interface.this.drawingPanel.list);
                    ((TeacherPanel)TeacherPanel.this).Interface.this.tree.linelist = ((TeacherPanel)TeacherPanel.this).Interface.this.drawingPanel.copyLinelist(((TeacherPanel)TeacherPanel.this).Interface.this.tree.list, ((TeacherPanel)TeacherPanel.this).Interface.this.drawingPanel.list, ((TeacherPanel)TeacherPanel.this).Interface.this.drawingPanel.linelist);
                    ((TeacherPanel)TeacherPanel.this).Interface.this.drawingPanel.showTree(((TeacherPanel)TeacherPanel.this).Interface.this.tree);
                }
            });
            this.saveasnew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TeacherPanel)TeacherPanel.this).Interface.this.tree.list = ((TeacherPanel)TeacherPanel.this).Interface.this.drawingPanel.list;
                    ((TeacherPanel)TeacherPanel.this).Interface.this.tree.linelist = ((TeacherPanel)TeacherPanel.this).Interface.this.drawingPanel.linelist;
                    ((TeacherPanel)TeacherPanel.this).Interface.this.tree.sentence = TeacherPanel.this.sentence.getText();
                    ((TeacherPanel)TeacherPanel.this).Interface.this.tree.meaning = TeacherPanel.this.meaning.getText();
                    ((TeacherPanel)TeacherPanel.this).Interface.this.sentenceTree.addSentence(((TeacherPanel)TeacherPanel.this).Interface.this.tree, ((TeacherPanel)TeacherPanel.this).Interface.this.sentenceTree.presentNode);
                    ((TeacherPanel)TeacherPanel.this).Interface.this.sentenceTree.selectNode();
                    TeacherPanel.this.repaint();
                }
            });
        }
    }

    public class Tree {
        public Vector<NodeLabel> list = new Vector();
        public Vector<Line> linelist = new Vector();
        public String sentence = "";
        public String meaning = "";
        Vector<String> structureError;

        public boolean completeTree() {
            this.structureError = new Vector();
            Vector<NodeLabel> heads = new Vector<NodeLabel>();
            for (NodeLabel treenode : this.list) {
                if (treenode.parents.size() > 1) {
                    String errorMSG = "Node " + treenode.label.getText() + " has " + treenode.parents.size() + " parents:";
                    for (NodeLabel parent : treenode.parents) {
                        errorMSG = String.valueOf(errorMSG) + " " + parent.label.getText();
                    }
                    errorMSG = String.valueOf(errorMSG) + ".";
                    this.structureError.add(errorMSG);
                    continue;
                }
                if (treenode.parents.size() != 0) continue;
                heads.add(treenode);
            }
            if (heads.size() > 1) {
                String errorMSG = "There are more than one head nodes:";
                for (NodeLabel head : heads) {
                    errorMSG = String.valueOf(errorMSG) + " " + head.label.getText();
                }
                errorMSG = String.valueOf(errorMSG) + ".";
                this.structureError.add(errorMSG);
            }
            int numberofwords = 0;
            String[] stringArray = this.sentence.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ww = stringArray[n2];
                if (!ww.equals("")) {
                    ++numberofwords;
                }
                ++n2;
            }
            if (numberofwords == this.list.size() && heads.size() == numberofwords) {
                this.structureError = new Vector();
                return false;
            }
            return this.structureError.size() <= 0;
        }

        public String bracketForm() {
            NodeLabel now;
            if (!this.completeTree()) {
                if (this.structureError.size() != 0) {
                    return "error";
                }
                return "none";
            }
            Stack<NodeLabel> process1 = new Stack<NodeLabel>();
            Stack<NodeLabel> process2 = new Stack<NodeLabel>();
            NodeLabel root = new NodeLabel("", Interface.this.drawingPanel);
            for (NodeLabel x : this.list) {
                Collections.sort(x.children);
                Collections.reverse(x.children);
                if (x.parents.size() != 0) continue;
                root = x;
            }
            process1.add(root);
            while (process1.size() > 0) {
                now = (NodeLabel)process1.firstElement();
                process1.remove(0);
                process2.add(now);
                for (NodeLabel x : now.children) {
                    process1.add(x);
                }
            }
            while (process2.size() > 0) {
                now = (NodeLabel)process2.pop();
                if (now.children.size() == 0) {
                    now.bracketForm = " " + now.label.getText();
                    continue;
                }
                now.bracketForm = "[" + now.label.getText();
                for (NodeLabel x : now.children) {
                    now.bracketForm = String.valueOf(now.bracketForm) + x.bracketForm;
                }
                now.bracketForm = String.valueOf(now.bracketForm) + "]";
            }
            return root.bracketForm;
        }

        public Tree copyTree() {
            Tree r = new Tree();
            r.list = Interface.this.drawingPanel.copylist(this.list);
            r.linelist = Interface.this.drawingPanel.copyLinelist(r.list, this.list, this.linelist);
            r.meaning = this.meaning;
            r.sentence = this.sentence;
            return r;
        }

        private Vector<String> getVector(String input) {
            Vector<String> r = new Vector<String>();
            StringBuffer buffer = new StringBuffer("");
            String now = "";
            int i = 0;
            while (i < input.length()) {
                if (input.charAt(i) != '[' && input.charAt(i) != ']') {
                    buffer.append(input.charAt(i));
                } else {
                    now = buffer.toString();
                    if (!now.equals("")) {
                        r.add(now);
                    }
                    buffer = new StringBuffer("");
                    if (input.charAt(i) == '[') {
                        now = "[";
                    } else if (input.charAt(i) == ']') {
                        now = "]";
                    }
                    r.add(now);
                    now = "";
                }
                ++i;
            }
            return r;
        }

        private Vector<NodeLabel> addInNodes(Vector<String> material) {
            Interface.this.teacherPanel.clean.doClick();
            Stack<NodeLabel> process = new Stack<NodeLabel>();
            Vector<NodeLabel> r = new Vector<NodeLabel>();
            for (String x : material) {
                NodeLabel now;
                if (x.contains(" ")) {
                    now = new NodeLabel(x.split(" ")[0], Interface.this.drawingPanel);
                    now.setSize(now.getPreferredSize());
                    NodeLabel nowchild = new NodeLabel(x.split(" ")[1], Interface.this.drawingPanel);
                    nowchild.setSize(nowchild.getPreferredSize());
                    nowchild.type = 1;
                    now.children.add(nowchild);
                    nowchild.parents.add(now);
                    process.add(now);
                    r.add(now);
                    r.add(nowchild);
                    continue;
                }
                if (x != "]") {
                    now = new NodeLabel(x, Interface.this.drawingPanel);
                    process.add(now);
                    if (x == "[") continue;
                    now.setSize(now.getPreferredSize());
                    r.add(now);
                    continue;
                }
                Stack<NodeLabel> newmaterial = new Stack<NodeLabel>();
                while (!((NodeLabel)process.peek()).label.getText().equals("[")) {
                    newmaterial.add((NodeLabel)process.pop());
                }
                process.pop();
                if (newmaterial.size() <= 0) continue;
                NodeLabel parent = (NodeLabel)newmaterial.pop();
                while (newmaterial.size() > 0) {
                    NodeLabel child = (NodeLabel)newmaterial.pop();
                    parent.children.add(child);
                    child.parents.add(parent);
                }
                process.add(parent);
            }
            return r;
        }

        public void setLocation(Rectangle bounds) {
            Vector<NodeLabel> basement = new Vector<NodeLabel>();
            Vector<NodeLabel> head = new Vector<NodeLabel>();
            if (this.list != null) {
                for (NodeLabel n : this.list) {
                    n.label.setFont(new Font(Interface.this.pp.getString("FontStyle"), 0, Interface.this.pp.getInt("TreeSize")));
                    n.label.revalidate();
                    n.revalidate();
                    if (n.type == 1) {
                        basement.add(n);
                    }
                    if (n.parents.size() != 0) continue;
                    head.add(n);
                }
            }
            int heightdraw = (int)((double)bounds.height * 0.9) + bounds.y;
            int i = 40 + bounds.x;
            for (NodeLabel bb : basement) {
                i = (int)((double)i + Interface.this.drawingPanel.widthIndex * bb.label.getPreferredSize().getHeight());
                bb.setVisible(true);
                bb.setLocation(i, heightdraw);
                bb.setSize(bb.getPreferredSize());
                bb.location = bb.getLocation();
                i = (int)((double)i + bb.getPreferredSize().getWidth());
            }
            for (NodeLabel x : head) {
                Interface.this.drawingPanel.adjustOneTree(x);
            }
        }

        public void addInLines() {
            this.linelist = new Vector();
            for (NodeLabel y : this.list) {
                y.childrenlines = new Vector();
                y.parentlines = new Vector();
            }
            for (NodeLabel x : this.list) {
                for (NodeLabel y : x.children) {
                    Line line = new Line();
                    line.children = y;
                    line.parent = x;
                    line.end = new Point(x.location.x + x.getWidth() / 2, x.location.y + x.label.getLocation().y + x.label.getHeight());
                    line.start = new Point(y.location.x + y.getWidth() / 2, y.location.y + y.label.getLocation().y);
                    y.parentlines.add(line);
                    x.childrenlines.add(line);
                    this.linelist.add(line);
                }
            }
        }

        public void changeStructureToTree(String structure) {
            Vector<String> nodeString = this.getVector(structure);
            Vector<NodeLabel> nodes = this.addInNodes(nodeString);
            this.list = nodes;
            this.linelist = new Vector();
        }

        public void changeStructureToTree2(String structure2) {
            Vector<String> nodeString = this.getVector(structure2);
            Vector<NodeLabel> nodes = this.addInNodes(nodeString);
            Vector<NodeLabel> nodes2 = new Vector<NodeLabel>();
            for (NodeLabel x : nodes) {
                if (x.children.size() != 0) continue;
                nodes2.add(x);
                x.parents = new Vector();
            }
            this.list = nodes2;
            this.linelist = new Vector();
        }

        public void setLocation2(Rectangle bounds, Plain drawingPanel) {
            Vector<NodeLabel> basement = new Vector<NodeLabel>();
            Vector<NodeLabel> head = new Vector<NodeLabel>();
            for (NodeLabel n : this.list) {
                if (n.type == 1) {
                    basement.add(n);
                }
                if (n.parents.size() != 0) continue;
                head.add(n);
            }
            int heightdraw = (int)((double)bounds.height * 0.8) + bounds.y;
            int i = 40 + bounds.x;
            for (NodeLabel cc : basement) {
                NodeLabel bb = new NodeLabel(cc.label.getText(), drawingPanel);
                bb.type = 1;
                i = (int)((double)i + drawingPanel.widthIndex * bb.label.getPreferredSize().getHeight());
                bb.setVisible(true);
                bb.setLocation(i, heightdraw);
                bb.setSize(bb.getPreferredSize());
                bb.location = bb.getLocation();
                drawingPanel.drawroom.canvas.add(bb);
                drawingPanel.list.add(bb);
                i = (int)((double)i + bb.getPreferredSize().getWidth());
            }
        }
    }
}

