/*
 * Decompiled with CFR 0.152.
 */
package program.grammar;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import program.grammar.Block;
import program.grammar.Rule;

public class HeadRule {
    String newline = System.getProperty("line.separator");
    public String head = null;
    Vector<Rule> rules = new Vector();
    Set<String> legalChildren = new HashSet<String>();

    public HeadRule(Rule x) {
        this.head = x.head.node;
        this.rules.add(x);
        for (Block yx : x.legalChildren) {
            this.legalChildren.add(yx.node);
        }
    }

    public void addRule(Rule x) {
        this.rules.add(x);
        for (Block yx : x.legalChildren) {
            this.legalChildren.add(yx.node);
        }
    }

    public String obeyRule(String mother, Vector<String> children) {
        if (this.head.equals(mother)) {
            for (Rule x : this.rules) {
                if (!x.obeyRule(mother, children)) continue;
                return null;
            }
            String error = "";
            for (String xy : children) {
                if (this.legalChildren.contains(xy)) continue;
                error = "Warning: " + mother + " has illegal daughter [" + xy + "];" + this.newline;
                break;
            }
            if (error.equals("")) {
                error = String.valueOf(mother) + " cannot be formed by [";
                int i = 0;
                while (i < children.size()) {
                    error = String.valueOf(error) + children.elementAt(i);
                    if (i != children.size() - 1) {
                        error = String.valueOf(error) + " ";
                    }
                    ++i;
                }
                error = String.valueOf(error) + "];" + this.newline;
            }
            error = String.valueOf(error) + this.newline + "Legal rules: " + this.newline;
            for (Rule x : this.rules) {
                error = String.valueOf(error) + x.string + this.newline;
            }
            return error;
        }
        return "The input combination does not obey this headRule because it has a different head than this headRule";
    }
}

