/*
 * Decompiled with CFR 0.152.
 */
package program.grammar;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import program.Preference;
import program.grammar.Block;
import program.grammar.HeadRule;
import program.grammar.LegalText;
import program.grammar.Rule;
import program.grammar.Unit;

public class Grammar {
    private Preference preference = new Preference();
    String grammar_text = "";
    public Set<String> set = new HashSet<String>();
    public Set<String> setBasic = new HashSet<String>();
    public Set<String> medium = new HashSet<String>();
    public Vector<Rule> rules = new Vector();
    Vector<Integer> wrongLine = new Vector();
    Vector<Line> lines = new Vector();
    public Vector<HeadRule> headRules = new Vector();

    public Grammar() {
        this.grammar_text = this.preference.getString("grammar_text");
        this.constructor(this.grammar_text);
    }

    public Grammar(String input) {
        this.constructor(input);
    }

    public void changeToGrammar(Grammar newg) {
        this.set = newg.set;
        this.setBasic = newg.setBasic;
        this.medium = newg.medium;
        this.rules = newg.rules;
        this.wrongLine = newg.wrongLine;
        this.lines = newg.lines;
        this.headRules = newg.headRules;
    }

    public boolean successfully_created() {
        return this.wrongLine.size() == 0;
    }

    public String error_message() {
        String error_message = "";
        for (int i : this.wrongLine) {
            error_message = String.valueOf(error_message) + "Line " + i + ":" + this.lines.elementAt((int)(i - 1)).error + Preference.newline;
        }
        return error_message;
    }

    private void constructor(String input) {
        this.grammar_text = input;
        int i = 1;
        String[] stringArray = input.split(Preference.newline);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Line nowline = new Line(line, i);
            this.lines.add(nowline);
            if (nowline.error == null) {
                this.addingRule(nowline);
            } else {
                this.wrongLine.add(i);
            }
            ++i;
            ++n2;
        }
        for (String x : this.set) {
            if (this.medium.contains(x)) continue;
            this.setBasic.add(x);
            Rule newRule = new Rule(x);
            this.rules.add(newRule);
        }
        boolean whether = false;
        for (Rule rule : this.rules) {
            whether = false;
            HeadRule headrule = new HeadRule(rule);
            for (HeadRule x : this.headRules) {
                if (!headrule.head.equals(x.head)) continue;
                x.addRule(rule);
                whether = true;
            }
            if (whether) continue;
            this.headRules.add(headrule);
        }
    }

    public void addingRule(Line line) {
        Rule now = new Rule(line.units);
        if (now.error == null) {
            this.rules.add(now);
            this.set.add(now.head.node);
            for (Block x : now.legalChildren) {
                this.set.add(x.node);
            }
            if (now.blocks.size() == 0) {
                this.setBasic.add(now.head.node);
            } else {
                this.medium.add(now.head.node);
            }
        } else {
            line.error = now.error;
            this.wrongLine.add(line.index);
        }
    }

    public String obeyRules(String mother, Vector<String> children) {
        if (children.size() == 0) {
            return null;
        }
        for (HeadRule head_Rule : this.headRules) {
            if (!head_Rule.head.equals(mother)) continue;
            return head_Rule.obeyRule(mother, children);
        }
        return "Node " + mother + " is not allowed to have children";
    }

    public static void main(String[] args) {
        Grammar g = new Grammar();
        for (String string : g.set) {
            System.out.println("set " + string);
        }
        for (String string : g.setBasic) {
            System.out.println("setBasic" + string);
        }
        for (String string : g.medium) {
            System.out.println("medium " + string);
        }
        for (Rule rule : g.rules) {
            System.out.println(String.valueOf(rule.head.node) + "head");
        }
        for (Rule rule : g.rules) {
            System.out.println(rule.string);
        }
    }

    static class Line {
        int index;
        Vector<Block> units;
        String error;

        public Line(String x, int indexInput) {
            this.units = this.getVector(x);
            this.index = indexInput;
        }

        private Object[] getUnit(String input) {
            LegalText legal = new LegalText();
            Object[] r = new Object[2];
            for (String symbol : legal.set) {
                Pattern p = Pattern.compile(legal.getRE(symbol));
                Matcher m = p.matcher(input);
                if (!m.find()) continue;
                if (Arrays.asList(legal.setOfSymbols).contains(symbol)) {
                    r[0] = new Unit(symbol);
                } else {
                    Block now = new Block(m.group(2));
                    r[0] = now;
                }
                Pattern blank = Pattern.compile("^\\s*$");
                Matcher blankm = blank.matcher(m.group(3));
                r[1] = blankm.find() ? null : m.group(3);
                return r;
            }
            this.error = "The beginning of the following string is unrecognizable : " + input;
            return null;
        }

        private Vector<Block> getVector(String input) {
            Vector<Block> r = new Vector<Block>();
            Block unit = null;
            String rest = input;
            do {
                Object[] result;
                if ((result = this.getUnit(rest)) == null) {
                    return null;
                }
                unit = (Block)result[0];
                rest = (String)result[1];
                r.add(unit);
            } while (rest != null);
            return r;
        }
    }
}

