/*
 * Decompiled with CFR 0.152.
 */
package program;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.prefs.Preferences;
import javax.swing.UIManager;

public class Preference {
    private Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
    public static String newline = System.getProperty("line.separator");
    private static Font default_font = UIManager.getDefaults().getFont("TabbedPane.font");
    private static int default_font_size = default_font.getSize();
    private static String default_font_name = default_font.getFontName();
    public static String grammar_path = "grammar.txt";

    public void setInt(String x, int i) {
        this.prefs.putInt(x, i);
    }

    public int getInt(String x) {
        if (x.equals("SystemFontSize")) {
            return this.prefs.getInt("SystemFontSize", default_font_size);
        }
        return 10;
    }

    public void setString(String string, String i) {
        this.prefs.put(string, i);
    }

    public String getString(String x) {
        if (x.equals("FontStyle")) {
            return this.prefs.get(x, default_font_name);
        }
        if (x.equals("grammar_text")) {
            String default_grammar_text = "";
            try {
                default_grammar_text = Preference.get_string_from_jar(grammar_path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.prefs.get(x, default_grammar_text);
        }
        return this.prefs.get(x, "error");
    }

    public void setDouble(String string, double i) {
        this.prefs.putDouble(string, i);
    }

    public double getDouble(String x) {
        return this.prefs.getDouble(x, 1.0);
    }

    public static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    public static String get_string_from_jar(String path) throws IOException {
        InputStream iStream = Preference.class.getClassLoader().getResourceAsStream(path);
        InputStreamReader iStreamReader = new InputStreamReader(iStream);
        BufferedReader bReader = new BufferedReader(iStreamReader);
        String line = null;
        StringBuilder builder = new StringBuilder();
        while ((line = bReader.readLine()) != null) {
            builder.append(line);
            builder.append("\n");
        }
        bReader.close();
        iStreamReader.close();
        iStream.close();
        return builder.toString();
    }

    public static void main(String[] args) throws IOException {
        Preference pp = new Preference();
        String grammar_text_from_jar = Preference.get_string_from_jar(grammar_path);
    }
}

