/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.FSM;
import edu.ucla.fsm.Sigma;
import edu.ucla.fsm.State;
import edu.ucla.fsm.StringLabel;
import edu.ucla.fsm.Transition;
import edu.ucla.util.Node;
import edu.ucla.util.RegexpParser;
import edu.ucla.util.Scanner;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThompsonConstruction {
    static IdentityHashMap<State, State> states = new IdentityHashMap();
    static String colon = ":";

    public static FSM apply(String string, boolean bl) {
        Scanner scanner = new Scanner(string);
        RegexpParser regexpParser = new RegexpParser(scanner);
        FSM fSM = ThompsonConstruction.apply(regexpParser.parse(), bl);
        return fSM;
    }

    public static FSM apply(Node node, boolean bl) {
        FSM fSM = ThompsonConstruction.build(node, bl);
        if (fSM != null) {
            fSM.renumberStates();
        }
        return fSM;
    }

    public static FSM build(Node node, boolean bl) {
        FSM fSM = null;
        if (node.type == Node.Type.SEGMENT) {
            fSM = ThompsonConstruction.buildSegment(node, bl);
        } else if (node.type == Node.Type.DOT) {
            fSM = ThompsonConstruction.buildDot(ThompsonConstruction.build(node.left, bl), ThompsonConstruction.build(node.right, bl), bl);
        } else if (node.type == Node.Type.PIPE) {
            fSM = ThompsonConstruction.buildPipe(ThompsonConstruction.build(node.left, bl), ThompsonConstruction.build(node.right, bl), bl);
        } else if (node.type == Node.Type.STAR) {
            fSM = ThompsonConstruction.buildStar(ThompsonConstruction.build(node.left, bl), bl);
        }
        return fSM;
    }

    public static FSM buildSegment(Node node, boolean bl) {
        FSM fSM = new FSM();
        State state = new State(0);
        State state2 = new State(1);
        fSM.initials.add(state);
        fSM.finals.add(state2);
        String[] stringArray = node.data.split(colon);
        fSM.transitions.add(new Transition(state, new StringLabel(stringArray[0]), stringArray.length > 1 ? new StringLabel(stringArray[1]) : null, null, state2));
        return fSM;
    }

    public static FSM buildDot(FSM fSM, FSM fSM2, boolean bl) {
        FSM fSM3 = new FSM();
        states.clear();
        ThompsonConstruction.mapStates(fSM.getStates(), new State(1));
        ThompsonConstruction.mapStates(fSM2.getStates(), new State(2));
        states.put(fSM.getFinals().first(), states.get(fSM2.getInitials().first()));
        for (State state : fSM.getInitials()) {
            fSM3.initials.add(ThompsonConstruction.intern(state));
        }
        for (State state : fSM2.getFinals()) {
            fSM3.finals.add(ThompsonConstruction.intern(state));
        }
        fSM3.transitions.addAll(ThompsonConstruction.mapTransitions(fSM.getTransitions()));
        fSM3.transitions.addAll(ThompsonConstruction.mapTransitions(fSM2.getTransitions()));
        return fSM3;
    }

    public static FSM buildPipe(FSM fSM, FSM fSM2, boolean bl) {
        FSM fSM3 = new FSM();
        states.clear();
        ThompsonConstruction.mapStates(fSM.getStates(), new State(1));
        ThompsonConstruction.mapStates(fSM2.getStates(), new State(2));
        State state = new State(0);
        fSM3.initials.add(state);
        State state2 = new State(3);
        fSM3.finals.add(state2);
        for (State state3 : fSM.getInitials()) {
            fSM3.addTransition(new Transition(state, StringLabel.epsilon, bl ? StringLabel.epsilon : null, null, ThompsonConstruction.intern(state3)));
        }
        for (State state3 : fSM2.getInitials()) {
            fSM3.addTransition(new Transition(state, StringLabel.epsilon, bl ? StringLabel.epsilon : null, null, ThompsonConstruction.intern(state3)));
        }
        for (State state3 : fSM.getFinals()) {
            fSM3.addTransition(new Transition(ThompsonConstruction.intern(state3), StringLabel.epsilon, bl ? StringLabel.epsilon : null, null, state2));
        }
        for (State state3 : fSM2.getFinals()) {
            fSM3.addTransition(new Transition(ThompsonConstruction.intern(state3), StringLabel.epsilon, bl ? StringLabel.epsilon : null, null, state2));
        }
        fSM3.transitions.addAll(ThompsonConstruction.mapTransitions(fSM.getTransitions()));
        fSM3.transitions.addAll(ThompsonConstruction.mapTransitions(fSM2.getTransitions()));
        return fSM3;
    }

    public static FSM buildStar(FSM fSM, boolean bl) {
        FSM fSM2 = new FSM();
        states.clear();
        ThompsonConstruction.mapStates(fSM.getStates(), new State(1));
        State state = new State(0);
        fSM2.initials.add(state);
        State state2 = new State(3);
        fSM2.finals.add(state2);
        fSM2.addTransition(new Transition(state, StringLabel.epsilon, bl ? StringLabel.epsilon : null, null, state2));
        for (State state3 : fSM.getInitials()) {
            fSM2.addTransition(new Transition(state, StringLabel.epsilon, bl ? StringLabel.epsilon : null, null, states.get(state3)));
        }
        for (State state3 : fSM.getFinals()) {
            fSM2.addTransition(new Transition(ThompsonConstruction.intern(state3), StringLabel.epsilon, bl ? StringLabel.epsilon : null, null, state2));
        }
        for (State state3 : fSM.getFinals()) {
            for (State state4 : fSM.getInitials()) {
                fSM2.addTransition(new Transition(ThompsonConstruction.intern(state3), StringLabel.epsilon, bl ? StringLabel.epsilon : null, null, ThompsonConstruction.intern(state4)));
            }
        }
        fSM2.transitions.addAll(ThompsonConstruction.mapTransitions(fSM.getTransitions()));
        return fSM2;
    }

    public static void mapStates(TreeSet<State> treeSet, State state) {
        for (State state2 : treeSet) {
            states.put(state2, new State(state2, state));
        }
    }

    public static ArrayList<Transition> mapTransitions(TreeSet<Transition> treeSet) {
        ArrayList<Transition> arrayList = new ArrayList<Transition>();
        for (Transition transition : treeSet) {
            arrayList.add(new Transition(ThompsonConstruction.intern(transition.src), transition.input, transition.output, null, ThompsonConstruction.intern(transition.dest)));
        }
        return arrayList;
    }

    public static State intern(State state) {
        return states.get(state);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.exit(0);
        }
        Options options = new Options();
        GnuParser gnuParser = new GnuParser();
        CommandLine commandLine = null;
        for (Object object : Sigma.OPTIONS) {
            options.addOption(object);
        }
        options.addOption(new Option("regexp", true, "regular expression to be converted to NFA"));
        options.addOption(new Option("t", false, "construct a transducer (not acceptor)"));
        commandLine = gnuParser.parse(options, stringArray, false);
        boolean bl = commandLine.hasOption("t");
        if (commandLine.hasOption("regexp")) {
            Object object;
            Scanner scanner = new Scanner(commandLine.getOptionValue("regexp"));
            RegexpParser regexpParser = new RegexpParser(scanner);
            object = ThompsonConstruction.apply(regexpParser.parse(), bl);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(System.out);
            objectOutputStream.writeObject(object);
        }
    }
}

