/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import java.io.Serializable;

public class State
implements Comparable,
Serializable {
    int id;
    State left;
    State right;
    int hashCode = 0;

    public State() {
    }

    public State(int n) {
        this.id = n;
        this.left = null;
        this.right = null;
        this.hashCode = this.getHashCode();
    }

    public State(State state, State state2) {
        this.left = state;
        this.right = state2;
        this.hashCode = this.getHashCode();
    }

    public int id() {
        return this.id;
    }

    public int compareTo(Object object) {
        int n;
        State state = (State)object;
        if (this.id != state.id) {
            return this.id < state.id ? -1 : 1;
        }
        if (this.left != state.left) {
            if (this.left == null) {
                return -1;
            }
            if (state.left == null) {
                return 1;
            }
            n = this.left.compareTo(state.left);
            if (n != 0) {
                return n;
            }
        }
        if (this.right != state.right) {
            if (this.right == null) {
                return -1;
            }
            if (state.right == null) {
                return 1;
            }
            n = this.right.compareTo(state.right);
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    public int getHashCode() {
        int n = this.id;
        if (this.left != null) {
            n += 7 * this.left.hashCode();
        }
        if (this.right != null) {
            n += 9 * this.right.hashCode();
        }
        return n;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        State state = (State)object;
        return this.compareTo(state) == 0;
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.left == null && this.right == null) {
            stringBuilder.append(this.id);
            return stringBuilder.toString();
        }
        if (bl) {
            stringBuilder.append("\"");
        }
        stringBuilder.append("(");
        if (this.left != null) {
            stringBuilder.append(this.left.toString(false));
        }
        if (this.left != null && this.right != null) {
            stringBuilder.append(",");
        }
        if (this.right != null) {
            stringBuilder.append(this.right.toString(false));
        }
        stringBuilder.append(")");
        if (bl) {
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(true);
    }
}

