/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.FSM;
import edu.ucla.fsm.Intersect;
import edu.ucla.fsm.MohriSproat;
import edu.ucla.fsm.Sigma;
import edu.ucla.fsm.State;
import edu.ucla.fsm.StringLabel;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.TransitionFactoryCompose;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class NewViolationFilter {
    static final StringLabel star = new StringLabel("*");
    static int verbosity = 10;

    public static FSM apply(FSM fSM) {
        FSM fSM2 = null;
        FSM fSM3 = null;
        FSM fSM4 = null;
        fSM2 = MohriSproat.markLeftContext(fSM, new StringLabel[]{star});
        for (Transition iterator : fSM2.getTransitions()) {
            if (iterator.output.equals(star)) {
                iterator.input = star;
            }
            iterator.output = StringLabel.wildcard;
        }
        for (State state : fSM2.getStates()) {
            fSM2.addTransition(new Transition(state, StringLabel.epsilon, StringLabel.wildcard, null, state));
        }
        if (verbosity > 9) {
            System.out.println(fSM2);
        }
        fSM3 = MohriSproat.markLeftContext(fSM, new StringLabel[]{star});
        for (Transition transition : fSM3.getTransitions()) {
            transition.input = StringLabel.wildcard;
        }
        for (State state : fSM3.getStates()) {
            fSM3.addTransition(new Transition(state, StringLabel.wildcard, StringLabel.epsilon, null, state));
        }
        if (verbosity > 9) {
            System.out.println(fSM3);
        }
        fSM4 = Intersect.apply(fSM2, fSM3, new TransitionFactoryCompose());
        LinkedList linkedList = new LinkedList();
        for (Transition transition : fSM4.getTransitions()) {
            if (!transition.output.equals(star) || transition.input.equals(star)) continue;
            linkedList.add(transition);
        }
        fSM4.getTransitions().removeAll(linkedList);
        fSM4.prune();
        for (Transition transition : fSM4.getTransitions()) {
            if (transition.input.equals(star)) {
                transition.input = StringLabel.epsilon;
            }
            if (!transition.output.equals(star)) continue;
            transition.output = StringLabel.epsilon;
        }
        if (verbosity > 9) {
            System.out.println(fSM4);
        }
        return fSM4;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object2;
        if (stringArray.length < 1) {
            System.exit(0);
        }
        Options options = new Options();
        GnuParser gnuParser = new GnuParser();
        CommandLine commandLine = null;
        for (Object object2 : Sigma.OPTIONS) {
            options.addOption((Option)object2);
        }
        options.addOption(new Option("alpha", true, "compiled transducer for the constraint"));
        options.addOption(new Option("help", false, "print this help information"));
        commandLine = gnuParser.parse(options, stringArray, false);
        if (commandLine.hasOption("help")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            System.out.println("\nxxx description to be added");
            helpFormatter.printHelp("java edu.ucla.fsm.NewViolationFilter [options]", options);
            System.exit(0);
        }
        Sigma sigma = new Sigma(commandLine);
        FSM fSM = null;
        FSM fSM2 = null;
        object2 = null;
        ObjectOutputStream objectOutputStream = null;
        if (commandLine.hasOption("alpha")) {
            object2 = new ObjectInputStream(new FileInputStream(new File(commandLine.getOptionValue("alpha"))));
            fSM = (FSM)((ObjectInputStream)object2).readObject();
            fSM2 = NewViolationFilter.apply(fSM);
            objectOutputStream = new ObjectOutputStream(System.out);
            objectOutputStream.writeObject(fSM2);
        }
    }
}

