/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.FeatureMatrix;
import edu.ucla.fsm.Segment;
import edu.ucla.fsm.Sigma;
import java.util.LinkedList;

public class NaturalClassConverter {
    static String leftBracket = "\\[";
    static String rightBracket = "\\]";
    static String leftParen = "(";
    static String rightParen = ")";
    static String plus = "+";
    static String minus = "-";
    static String featureSeparator = ",";
    static String wildcard = ".";
    static String pipe = "|";
    static String colon = ":";

    public static String apply(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split(leftBracket);
        stringBuilder.append(stringArray[0]);
        int n = stringArray.length;
        for (int i = 1; i < n; ++i) {
            String[] stringArray2 = stringArray[i].split(rightBracket);
            stringBuilder.append(NaturalClassConverter.naturalClass(stringArray2[0]));
            if (stringArray2.length <= 1) continue;
            stringBuilder.append(stringArray2[1]);
        }
        return stringBuilder.toString();
    }

    public static String naturalClass(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(leftParen);
        String string2 = string.replaceAll("\\p{Space}*", "");
        string2 = string2.replaceAll(leftBracket, "");
        string2 = string2.replaceAll(rightBracket, "");
        if (!string2.startsWith("+") && !string2.startsWith("-")) {
            for (Segment segment : Sigma.segments) {
                if (!((String)segment.segment.value()).equals(string2)) continue;
                stringBuilder.append(string2);
                break;
            }
        } else {
            FeatureMatrix featureMatrix = new FeatureMatrix(string2);
            boolean bl = true;
            for (Segment segment : Sigma.segments) {
                if (FeatureMatrix.unify(segment.features, featureMatrix) == null) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(pipe);
                }
                stringBuilder.append((String)segment.segment.value());
            }
        }
        stringBuilder.append(rightParen);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2;
        String[] stringArray3 = new String[]{"F", "G", "H"};
        Segment[] segmentArray = new Segment[]{new Segment("a", new String[]{minus, minus, minus}), new Segment("b", new String[]{minus, minus, plus}), new Segment("c", new String[]{minus, plus, minus}), new Segment("d", new String[]{plus, minus, minus})};
        LinkedList<Segment> linkedList = new LinkedList<Segment>();
        for (Segment segment : segmentArray) {
            linkedList.add(segment);
        }
        Sigma sigma = new Sigma(stringArray3, linkedList);
        String string = "([+F])?([-F])*([+F,-G,-H])";
        String string2 = "[-F]";
        String string3 = "[-H]";
        String string4 = "[c]";
        for (String string5 : stringArray2 = new String[]{string, string2, string3, string4}) {
            System.out.println(string5 + " : " + NaturalClassConverter.apply(string5));
        }
    }
}

