/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.FSM;
import edu.ucla.fsm.Intersect;
import edu.ucla.fsm.Sigma;
import edu.ucla.fsm.State;
import edu.ucla.fsm.StringLabel;
import edu.ucla.fsm.SubsetDeterminize;
import edu.ucla.fsm.ThompsonConstruction;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.TransitionFactoryCompose;
import edu.ucla.fsm.TransitionFactoryFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class MohriSproat {
    public static TreeMap<State, State> stateMap = new TreeMap();
    public static StringLabel rightBracket1 = new StringLabel(">1");
    public static StringLabel rightBracket2 = new StringLabel(">2");
    public static StringLabel leftBracket1 = new StringLabel("<1");
    public static StringLabel leftBracket2 = new StringLabel("<2");
    public static StringLabel[] brackets = new StringLabel[]{rightBracket1, rightBracket2, leftBracket1, leftBracket2};
    private static int verbosity = 0;

    public static FSM compile(FSM fSM, FSM fSM2, FSM fSM3) {
        FSM fSM4 = MohriSproat.markRightContext(fSM3, new StringLabel[]{rightBracket1});
        fSM4 = Intersect.apply(fSM4, MohriSproat.markLeftContextBeforeRight(fSM, new StringLabel[]{rightBracket1}, new StringLabel[]{leftBracket1, leftBracket2}), new TransitionFactoryCompose());
        fSM4.prune();
        fSM4.renumberStates();
        fSM4 = Intersect.apply(fSM4, MohriSproat.replace(fSM), new TransitionFactoryCompose());
        fSM4.prune();
        fSM4.renumberStates();
        fSM4 = Intersect.apply(fSM4, MohriSproat.filterLeftContext1(fSM2), new TransitionFactoryCompose());
        fSM4.prune();
        fSM4.renumberStates();
        fSM4 = Intersect.apply(fSM4, MohriSproat.filterLeftContext2(fSM2, Type.Type3), new TransitionFactoryCompose());
        fSM4.prune();
        fSM4.renumberStates();
        if (verbosity > 5) {
            System.out.println("rule: " + fSM4);
        }
        return fSM4;
    }

    public static FSM compileUnderBlockingConstraint(FSM fSM, FSM fSM2, FSM fSM3, FSM fSM4) {
        FSM fSM5 = MohriSproat.markRightContext(fSM3, new StringLabel[]{rightBracket1});
        if (verbosity > 5) {
            System.out.println("r: " + fSM5);
        }
        FSM fSM6 = MohriSproat.markLeftContextBeforeRight(fSM, new StringLabel[]{rightBracket1}, new StringLabel[]{leftBracket1, leftBracket2});
        if (verbosity > 5) {
            System.out.println("f: " + fSM6);
        }
        FSM fSM7 = MohriSproat.replace(fSM);
        if (verbosity > 5) {
            System.out.println("replace: " + fSM7);
        }
        FSM fSM8 = MohriSproat.filterLeftContext1(fSM2);
        if (verbosity > 5) {
            System.out.println("l1: " + fSM8);
        }
        FSM fSM9 = MohriSproat.filterLeftContext2(fSM2, Type.Type4);
        if (verbosity > 5) {
            System.out.println("l2: " + fSM9);
        }
        FSM fSM10 = fSM5;
        fSM10 = Intersect.apply(fSM10, fSM6, new TransitionFactoryCompose());
        if (verbosity > 5) {
            System.out.println(fSM10);
        }
        fSM10 = Intersect.apply(fSM10, fSM7, new TransitionFactoryCompose());
        if (verbosity > 5) {
            System.out.println(fSM10);
        }
        fSM10 = Intersect.apply(fSM10, fSM8, new TransitionFactoryCompose());
        if (verbosity > 5) {
            System.out.println(fSM10);
        }
        fSM10 = Intersect.apply(fSM10, fSM9, new TransitionFactoryCompose());
        if (verbosity > 5) {
            System.out.println(fSM10);
        }
        fSM10 = Intersect.apply(fSM10, fSM4, new TransitionFactoryFilter(12));
        if (verbosity > 5) {
            System.out.println(fSM10);
        }
        return fSM10;
    }

    public static FSM markRightContext(FSM fSM, StringLabel[] stringLabelArray) {
        FSM fSM2 = null;
        fSM2 = fSM.reverse();
        fSM2 = ThompsonConstruction.buildDot(FSM.sigmaStar(null), fSM2, true);
        fSM2 = SubsetDeterminize.apply(fSM2, StringLabel.epsilon, 1);
        fSM2 = fSM2.copy1to2();
        fSM2 = MohriSproat.marker(fSM2, Type.Type1, stringLabelArray, null);
        fSM2 = fSM2.reverse();
        fSM2.renumberStates();
        return fSM2;
    }

    public static FSM markLeftContext(FSM fSM, StringLabel[] stringLabelArray) {
        FSM fSM2 = fSM;
        fSM2 = ThompsonConstruction.buildDot(FSM.sigmaStar(null), fSM2, true);
        fSM2 = SubsetDeterminize.apply(fSM2, StringLabel.epsilon, 1);
        fSM2 = fSM2.copy1to2();
        fSM2 = MohriSproat.marker(fSM2, Type.Type1, stringLabelArray, null);
        fSM2.renumberStates();
        return fSM2;
    }

    public static FSM markLeftContextBeforeRight(FSM fSM, StringLabel[] stringLabelArray, StringLabel[] stringLabelArray2) {
        FSM fSM2 = null;
        fSM2 = MohriSproat.skip(fSM, stringLabelArray, 1);
        fSM2 = ThompsonConstruction.buildDot(fSM, new FSM(stringLabelArray), true);
        fSM2 = fSM2.reverse();
        fSM2 = ThompsonConstruction.buildDot(FSM.sigmaStar(stringLabelArray), fSM2, true);
        fSM2 = SubsetDeterminize.apply(fSM2, StringLabel.epsilon, 1);
        fSM2 = fSM2.copy1to2();
        fSM2 = MohriSproat.marker(fSM2, Type.Type1, stringLabelArray2, null);
        fSM2 = fSM2.reverse();
        fSM2.renumberStates();
        return fSM2;
    }

    public static FSM filterLeftContext1(FSM fSM) {
        FSM fSM2 = null;
        fSM2 = ThompsonConstruction.buildDot(FSM.sigmaStar(null), fSM, true);
        fSM2 = SubsetDeterminize.apply(fSM2, StringLabel.epsilon, 1);
        fSM2 = fSM2.copy1to2();
        fSM2 = MohriSproat.marker(fSM2, Type.Type2, null, new StringLabel[]{leftBracket1});
        fSM2 = MohriSproat.skip(fSM2, new StringLabel[]{leftBracket2}, 12);
        fSM2.renumberStates();
        return fSM2;
    }

    public static FSM filterLeftContext2(FSM fSM, Type type) {
        FSM fSM2 = null;
        fSM2 = ThompsonConstruction.buildDot(FSM.sigmaStar(null), fSM, true);
        fSM2 = SubsetDeterminize.apply(fSM2, StringLabel.epsilon, 1);
        fSM2 = fSM2.copy1to2();
        fSM2 = MohriSproat.marker(fSM2, type, null, new StringLabel[]{leftBracket2});
        fSM2.renumberStates();
        return fSM2;
    }

    public static FSM replace(FSM fSM) {
        FSM fSM2 = fSM;
        fSM2 = MohriSproat.del(fSM2, new StringLabel[]{leftBracket1, leftBracket2, rightBracket1});
        fSM2 = ThompsonConstruction.buildDot(new FSM(new StringLabel[]{leftBracket1}, new StringLabel[]{leftBracket1}), fSM2, true);
        fSM2 = ThompsonConstruction.buildDot(FSM.sigmaStar(new StringLabel[]{leftBracket2, rightBracket1}, new StringLabel[]{leftBracket2, StringLabel.epsilon}), fSM2, true);
        for (State state : fSM2.getFinals()) {
            for (State state2 : fSM2.getInitials()) {
                fSM2.transitions.add(new Transition(state, rightBracket1, StringLabel.epsilon, null, state2));
            }
        }
        fSM2.finals.clear();
        fSM2.finals.addAll(fSM2.initials);
        fSM2.renumberStates();
        return fSM2;
    }

    public static FSM marker(FSM fSM, Type type, StringLabel[] stringLabelArray, StringLabel[] stringLabelArray2) {
        switch (type) {
            case Type1: {
                return MohriSproat.marker1(fSM, stringLabelArray, stringLabelArray2);
            }
            case Type2: {
                return MohriSproat.marker2(fSM, stringLabelArray, stringLabelArray2);
            }
            case Type3: {
                return MohriSproat.marker3(fSM, stringLabelArray, stringLabelArray2);
            }
            case Type4: {
                return MohriSproat.marker4(fSM, stringLabelArray, stringLabelArray2);
            }
        }
        return null;
    }

    public static FSM marker1(FSM fSM, StringLabel[] stringLabelArray, StringLabel[] stringLabelArray2) {
        State state4;
        FSM fSM2 = new FSM();
        stateMap.clear();
        State state2 = new State(0);
        State state3 = null;
        for (State state4 : fSM.getFinals()) {
            state3 = new State(state4, state2);
            stateMap.put(state4, state3);
            if (stringLabelArray != null) {
                for (StringLabel stringLabel : stringLabelArray) {
                    fSM2.transitions.add(new Transition(state4, StringLabel.epsilon, stringLabel, null, state3));
                }
            }
            if (stringLabelArray2 == null) continue;
            for (StringLabel stringLabel : stringLabelArray2) {
                fSM2.transitions.add(new Transition(state4, stringLabel, StringLabel.epsilon, null, state3));
            }
        }
        Object object = null;
        state4 = null;
        for (Transition transition : fSM.getTransitions()) {
            object = transition.src;
            state4 = transition.dest;
            if (fSM.initials.contains(object)) {
                fSM2.initials.add((State)object);
            }
            fSM2.finals.add((State)(stateMap.containsKey(object) ? stateMap.get(object) : object));
            fSM2.finals.add(stateMap.containsKey(state4) ? stateMap.get(state4) : state4);
            object = stateMap.containsKey(object) ? stateMap.get(object) : object;
            fSM2.transitions.add(new Transition((State)object, transition.input, transition.output, null, state4));
        }
        fSM2.renumberStates();
        return fSM2;
    }

    public static FSM marker2(FSM fSM, StringLabel[] stringLabelArray, StringLabel[] stringLabelArray2) {
        FSM fSM2 = new FSM(new TreeSet<State>((SortedSet<State>)fSM.getInitials()), new TreeSet<State>((SortedSet<State>)fSM.getFinals()), new TreeSet<Transition>((SortedSet<Transition>)fSM.getTransitions()));
        for (State state : fSM2.finals) {
            for (StringLabel stringLabel : stringLabelArray2) {
                fSM2.transitions.add(new Transition(state, stringLabel, StringLabel.epsilon, null, state));
            }
        }
        for (State state : fSM2.getStates()) {
            fSM2.finals.add(state);
        }
        return fSM2;
    }

    public static FSM marker3(FSM fSM, StringLabel[] stringLabelArray, StringLabel[] stringLabelArray2) {
        FSM fSM2 = new FSM(new TreeSet<State>((SortedSet<State>)fSM.getInitials()), new TreeSet<State>((SortedSet<State>)fSM.getFinals()), new TreeSet<Transition>((SortedSet<Transition>)fSM.getTransitions()));
        for (State state : fSM2.getStates()) {
            if (fSM.getFinals().contains(state)) continue;
            for (StringLabel stringLabel : stringLabelArray2) {
                fSM2.transitions.add(new Transition(state, stringLabel, StringLabel.epsilon, null, state));
            }
            fSM2.finals.add(state);
        }
        return fSM2;
    }

    public static FSM marker4(FSM fSM, StringLabel[] stringLabelArray, StringLabel[] stringLabelArray2) {
        FSM fSM2 = new FSM(new TreeSet<State>((SortedSet<State>)fSM.getInitials()), new TreeSet<State>((SortedSet<State>)fSM.getFinals()), new TreeSet<Transition>((SortedSet<Transition>)fSM.getTransitions()));
        for (State state : fSM2.getStates()) {
            if (fSM.getFinals().contains(state)) {
                for (StringLabel stringLabel : stringLabelArray2) {
                    fSM2.transitions.add(new Transition(state, stringLabel, stringLabel, null, state));
                }
                continue;
            }
            for (StringLabel stringLabel : stringLabelArray2) {
                fSM2.transitions.add(new Transition(state, stringLabel, StringLabel.epsilon, null, state));
            }
            fSM2.finals.add(state);
        }
        return fSM2;
    }

    public static FSM skip(FSM fSM, StringLabel[] stringLabelArray, int n) {
        FSM fSM2 = new FSM(new TreeSet<State>((SortedSet<State>)fSM.getInitials()), new TreeSet<State>((SortedSet<State>)fSM.getFinals()), new TreeSet<Transition>((SortedSet<Transition>)fSM.getTransitions()));
        for (State state : fSM2.getStates()) {
            for (StringLabel stringLabel : stringLabelArray) {
                fSM2.transitions.add(new Transition(state, n == 1 || n == 12 ? stringLabel : StringLabel.epsilon, n == 2 || n == 12 ? stringLabel : StringLabel.epsilon, null, state));
            }
        }
        return fSM2;
    }

    public static FSM del(FSM fSM, StringLabel[] stringLabelArray) {
        FSM fSM2 = new FSM(new TreeSet<State>((SortedSet<State>)fSM.getInitials()), new TreeSet<State>((SortedSet<State>)fSM.getFinals()), new TreeSet<Transition>((SortedSet<Transition>)fSM.getTransitions()));
        for (State state : fSM2.getStates()) {
            for (StringLabel stringLabel : stringLabelArray) {
                fSM2.transitions.add(new Transition(state, stringLabel, StringLabel.epsilon, null, state));
            }
        }
        return fSM2;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object2;
        if (stringArray.length < 1) {
            System.exit(0);
        }
        Options options = new Options();
        GnuParser gnuParser = new GnuParser();
        CommandLine commandLine = null;
        for (Object object2 : Sigma.OPTIONS) {
            options.addOption(object2);
        }
        options.addOption(new Option("phi", true, "compiled transducer for A -> B (change)"));
        options.addOption(new Option("lambda", true, "compiled acceptor for C (left context)"));
        options.addOption(new Option("rho", true, "compiled acceptor for D (right context)"));
        options.addOption(new Option("help", false, "print this help information"));
        commandLine = gnuParser.parse(options, stringArray, false);
        if (commandLine.hasOption("help")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            System.out.println("\nMohri-Sproat compiler for rewrite rules of the form A -> B / C __ D");
            helpFormatter.printHelp("java edu.ucla.fsm.MohriSproat [options]", options);
            System.exit(0);
        }
        Sigma sigma = new Sigma(commandLine);
        FSM fSM = null;
        FSM fSM2 = null;
        object2 = null;
        Object var8_12 = null;
        ObjectInputStream objectInputStream = null;
        ObjectOutputStream objectOutputStream = null;
        if (commandLine.hasOption("phi")) {
            objectInputStream = new ObjectInputStream(new FileInputStream(new File(commandLine.getOptionValue("phi"))));
            fSM = (FSM)objectInputStream.readObject();
        }
        if (commandLine.hasOption("lambda")) {
            objectInputStream = new ObjectInputStream(new FileInputStream(new File(commandLine.getOptionValue("lambda"))));
            fSM2 = (FSM)objectInputStream.readObject();
        }
        if (commandLine.hasOption("rho")) {
            objectInputStream = new ObjectInputStream(new FileInputStream(new File(commandLine.getOptionValue("rho"))));
            object2 = (FSM)objectInputStream.readObject();
        }
        FSM fSM3 = MohriSproat.compile(fSM, fSM2, (FSM)object2);
        objectOutputStream = new ObjectOutputStream(System.out);
        objectOutputStream.writeObject(fSM3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Type1,
        Type2,
        Type3,
        Type4;

        private static final Type[] type;

        static {
            type = Type.values();
        }
    }
}

