/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.Label;
import edu.ucla.fsm.Sigma;
import java.util.Arrays;

public class FeatureMatrix
extends Label {
    public static String[] EPSILON = new String[Sigma.numberOfFeatures];
    public static String wildcard = ".";
    public String[] value = null;

    public FeatureMatrix(String string) {
        string = string.replaceAll("\\[", "");
        string = string.replaceAll("\\]", "");
        string = string.replaceAll("\\s", "");
        String[] stringArray = string.split(",");
        Object[] objectArray = new String[Sigma.numberOfFeatures];
        Arrays.fill(objectArray, wildcard);
        String string2 = null;
        String string3 = null;
        block0: for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i].substring(0, 1);
            string3 = stringArray[i].substring(1, stringArray[i].length());
            for (int j = 0; j < Sigma.numberOfFeatures; ++j) {
                if (!Sigma.features[j].startsWith(string3)) continue;
                objectArray[j] = string2;
                continue block0;
            }
        }
        this.value = objectArray;
    }

    public FeatureMatrix(String[] stringArray) {
        this.value = stringArray;
    }

    public Object value() {
        return this.value;
    }

    public FeatureMatrix unify(Label label) {
        return FeatureMatrix.unify(this, (FeatureMatrix)label);
    }

    public static FeatureMatrix unify(FeatureMatrix featureMatrix, FeatureMatrix featureMatrix2) {
        String[] stringArray = (String[])featureMatrix.value();
        String[] stringArray2 = (String[])featureMatrix2.value();
        String[] stringArray3 = new String[Sigma.numberOfFeatures];
        for (int i = 0; i < stringArray3.length; ++i) {
            if (stringArray2[i].equals(".")) {
                stringArray3[i] = stringArray[i];
                continue;
            }
            if (stringArray[i].equals(".")) {
                stringArray3[i] = stringArray2[i];
                continue;
            }
            if (stringArray[i].equals(stringArray2[i])) {
                stringArray3[i] = stringArray[i];
                continue;
            }
            return null;
        }
        return new FeatureMatrix(stringArray3);
    }

    public static FeatureMatrix priorityUnify(FeatureMatrix featureMatrix, FeatureMatrix featureMatrix2) {
        if (featureMatrix == null) {
            return null;
        }
        if (featureMatrix2 == null) {
            return featureMatrix;
        }
        String[] stringArray = (String[])featureMatrix.value();
        String[] stringArray2 = (String[])featureMatrix2.value();
        String[] stringArray3 = new String[Sigma.numberOfFeatures];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = stringArray[i].equals(".") ? stringArray2[i] : stringArray[i];
        }
        return new FeatureMatrix(stringArray3);
    }

    public boolean subsumes(FeatureMatrix featureMatrix) {
        if (featureMatrix == null) {
            return false;
        }
        for (int i = 0; i < featureMatrix.value.length; ++i) {
            if (featureMatrix.value[i].equals("WILDCARD") || this.value[i].equals(featureMatrix.value[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isEpsilon() {
        return Arrays.equals(this.value, EPSILON);
    }

    public Label copy() {
        int n = this.value.length;
        String[] stringArray = new String[n];
        System.arraycopy(this.value, 0, stringArray, 0, n);
        return new FeatureMatrix(stringArray);
    }

    public int compareTo(Object object) {
        String[] stringArray = (String[])((FeatureMatrix)object).value();
        int n = this.value.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = this.value[i].compareTo(stringArray[i]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof FeatureMatrix)) {
            return false;
        }
        FeatureMatrix featureMatrix = (FeatureMatrix)object;
        return Arrays.equals(this.value, featureMatrix.value);
    }

    public String toString() {
        Object var1_1 = null;
        return var1_1 == null ? cern.colt.Arrays.toString((Object[])this.value) : var1_1.segment.toString();
    }
}

