/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.DirectionalBestPath;
import edu.ucla.fsm.EpsilonRemoval;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.FSMFileReader;
import edu.ucla.fsm.IntegerWeight;
import edu.ucla.fsm.Intersect;
import edu.ucla.fsm.MohriSproat;
import edu.ucla.fsm.NewViolationFilter;
import edu.ucla.fsm.RandomPath;
import edu.ucla.fsm.Sigma;
import edu.ucla.fsm.StringLabel;
import edu.ucla.fsm.SubsetDeterminize;
import edu.ucla.fsm.ThompsonConstruction;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.TransitionFactoryCompose;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class FSMTester {
    public static void main(String[] stringArray) throws Exception {
        Transition transition2;
        Sigma sigma = new Sigma(new String[]{"a", "b", "c", "d"});
        FSM fSM = null;
        FSM fSM2 = null;
        FSM fSM3 = null;
        FSM fSM4 = null;
        FSM fSM5 = ThompsonConstruction.apply("d", false);
        fSM5 = NewViolationFilter.apply(fSM5);
        fSM5 = MohriSproat.skip(fSM5, MohriSproat.brackets, 2);
        System.out.println(fSM5);
        FSM fSM6 = ThompsonConstruction.apply("(a:b)|(c:d)", true);
        FSM fSM7 = ThompsonConstruction.apply("-", false);
        fSM2 = ThompsonConstruction.apply("(b|d)", false);
        fSM = MohriSproat.compileUnderBlockingConstraint(fSM6, fSM7, fSM2, fSM5);
        fSM.prune();
        fSM.renumberStates();
        fSM = SubsetDeterminize.apply(fSM, StringLabel.epsilon, 12);
        IntegerWeight integerWeight = new IntegerWeight(0);
        IntegerWeight integerWeight2 = new IntegerWeight(-1);
        for (Transition transition2 : fSM.transitions) {
            if (transition2.output.equals(MohriSproat.leftBracket2)) {
                transition2.output = StringLabel.epsilon;
                transition2.weight = integerWeight2;
                continue;
            }
            transition2.weight = integerWeight;
        }
        EpsilonRemoval.apply(fSM);
        fSM.prune();
        System.out.println(fSM);
        fSM = DirectionalBestPath.apply(fSM);
        System.out.println(fSM);
        fSM3 = ThompsonConstruction.apply("a d", false);
        fSM3.copy1to2();
        System.out.println(fSM3);
        fSM4 = Intersect.apply(fSM3, fSM, new TransitionFactoryCompose());
        System.out.println(fSM4);
        System.exit(0);
        Options options = new Options();
        transition2 = new GnuParser();
        for (Option option : Sigma.OPTIONS) {
            options.addOption(option);
        }
        options.addOption("fsm", true, "finite-state machine to read");
        options.addOption("rand", true, "randomly generate the specified number of strings");
        options.addOption("help", false, "display this help information");
        CommandLine commandLine = transition2.parse(options, stringArray, false);
        Sigma sigma2 = new Sigma(commandLine);
        FSM fSM8 = null;
        if (commandLine.hasOption("fsm")) {
            try {
                fSM8 = FSMFileReader.read(new File(commandLine.getOptionValue("fsm")), Sigma.features);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        System.out.println(fSM8);
        if (commandLine.hasOption("rand")) {
            int n = Integer.parseInt(commandLine.getOptionValue("rand"));
            for (int i = 0; i < n; ++i) {
                System.out.println(RandomPath.apply(fSM8));
            }
        }
    }
}

