/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.FSM;
import edu.ucla.fsm.FeatureMatrix;
import edu.ucla.fsm.IntegerWeight;
import edu.ucla.fsm.RealWeight;
import edu.ucla.fsm.Sigma;
import edu.ucla.fsm.State;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.Weight;
import edu.ucla.util.DefaultFileReader;
import java.io.File;
import java.io.FileReader;
import java.io.StreamTokenizer;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.TreeSet;

public class FSMFileReader
extends DefaultFileReader {
    static StreamTokenizer tokenizer;
    static int verbosity;

    public static FSM read(File file) throws Exception {
        return FSMFileReader.read(file, Sigma.features);
    }

    public static FSM read(File file, String[] stringArray) throws Exception {
        TreeSet<State> treeSet = new TreeSet<State>();
        TreeSet<State> treeSet2 = new TreeSet<State>();
        TreeMap<State, State> treeMap = new TreeMap<State, State>();
        TreeSet<Transition> treeSet3 = new TreeSet<Transition>();
        Transition transition = null;
        State state = null;
        State state2 = null;
        State state3 = null;
        FeatureMatrix featureMatrix = null;
        FeatureMatrix featureMatrix2 = null;
        Weight weight = null;
        tokenizer = new StreamTokenizer(new FileReader(file));
        FSMFileReader.initializeStreamTokenizer((StreamTokenizer)tokenizer);
        tokenizer.eolIsSignificant(true);
        tokenizer.nextToken();
        if (!FSMFileReader.tokenizer.sval.equals("initial")) {
            System.out.println("Error reading FSM file: no initial states");
            System.exit(1);
        }
        tokenizer.nextToken();
        if (!FSMFileReader.tokenizer.sval.equals("{")) {
            System.exit(1);
        }
        tokenizer.nextToken();
        while (!FSMFileReader.tokenizer.sval.equals("}")) {
            state = new State(Integer.parseInt(FSMFileReader.tokenizer.sval));
            treeSet.add(state);
            treeMap.put(state, state);
            tokenizer.nextToken();
        }
        if (verbosity > 5) {
            System.out.println(treeSet);
        }
        tokenizer.nextToken();
        tokenizer.nextToken();
        if (!FSMFileReader.tokenizer.sval.equals("final")) {
            System.out.println("Error reading FSM file: no final states");
            System.exit(1);
        }
        tokenizer.nextToken();
        if (!FSMFileReader.tokenizer.sval.equals("{")) {
            System.exit(1);
        }
        tokenizer.nextToken();
        while (!FSMFileReader.tokenizer.sval.equals("}")) {
            state = new State(Integer.parseInt(FSMFileReader.tokenizer.sval));
            if (treeMap.containsKey(state)) {
                treeSet2.add((State)treeMap.get(state));
            } else {
                treeSet2.add(state);
                treeMap.put(state, state);
            }
            tokenizer.nextToken();
        }
        if (verbosity > 5) {
            System.out.println(treeSet2);
        }
        tokenizer.nextToken();
        tokenizer.nextToken();
        do {
            if (treeMap.containsKey(state2 = new State(Integer.parseInt(FSMFileReader.tokenizer.sval)))) {
                state2 = (State)treeMap.get(state2);
            } else {
                treeMap.put(state2, state2);
            }
            tokenizer.nextToken();
            if (!FSMFileReader.tokenizer.sval.equals("->")) {
                System.exit(1);
            }
            tokenizer.nextToken();
            state3 = new State(Integer.parseInt(FSMFileReader.tokenizer.sval));
            if (treeMap.containsKey(state3)) {
                state3 = (State)treeMap.get(state3);
            } else {
                treeMap.put(state3, state3);
            }
            tokenizer.nextToken();
            if (!FSMFileReader.tokenizer.sval.equals("{")) {
                System.exit(1);
            }
            featureMatrix = FSMFileReader.readFeatureMatrix(stringArray);
            tokenizer.nextToken();
            if (FSMFileReader.tokenizer.ttype != 10 && FSMFileReader.tokenizer.sval.equals("{")) {
                featureMatrix2 = FSMFileReader.readFeatureMatrix(stringArray);
                tokenizer.nextToken();
            } else {
                featureMatrix2 = null;
            }
            if (FSMFileReader.tokenizer.ttype != 10) {
                weight = FSMFileReader.tokenizer.sval.contains(".") ? FSMFileReader.readRealWeight() : FSMFileReader.readIntegerWeight();
                tokenizer.nextToken();
            } else {
                weight = null;
            }
            tokenizer.nextToken();
            transition = new Transition(state2, featureMatrix, featureMatrix2, weight, state3);
            treeSet3.add(transition);
            if (verbosity <= 5) continue;
            System.out.println(transition);
        } while (FSMFileReader.tokenizer.ttype != -1 && FSMFileReader.tokenizer.ttype != 10);
        treeMap = null;
        return new FSM(treeSet, treeSet2, treeSet3);
    }

    private static FeatureMatrix readFeatureMatrix(String[] stringArray) throws Exception {
        Object[] objectArray = new String[stringArray.length];
        Arrays.fill(objectArray, ".");
        String string = null;
        String string2 = null;
        tokenizer.nextToken();
        while (!FSMFileReader.tokenizer.sval.equals("}")) {
            if (FSMFileReader.tokenizer.sval.equals("EPSILON")) {
                objectArray = FeatureMatrix.EPSILON;
                tokenizer.nextToken();
                break;
            }
            string2 = FSMFileReader.tokenizer.sval.substring(0, 1);
            string = FSMFileReader.tokenizer.sval.substring(1, FSMFileReader.tokenizer.sval.length());
            objectArray[FSMFileReader.indexOfFeature((String)string, (String[])stringArray)] = string2;
            tokenizer.nextToken();
        }
        return new FeatureMatrix((String[])objectArray);
    }

    private static IntegerWeight readIntegerWeight() throws Exception {
        return new IntegerWeight(Integer.parseInt(FSMFileReader.tokenizer.sval));
    }

    private static RealWeight readRealWeight() throws Exception {
        return new RealWeight(Double.parseDouble(FSMFileReader.tokenizer.sval));
    }

    private static int indexOfFeature(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    static {
        verbosity = 0;
    }
}

