/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.AccessibleStates;
import edu.ucla.fsm.FSMFileReader;
import edu.ucla.fsm.FeatureMatrix;
import edu.ucla.fsm.Segment;
import edu.ucla.fsm.Sigma;
import edu.ucla.fsm.State;
import edu.ucla.fsm.StringLabel;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.Weight;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSM
implements Serializable {
    public TreeSet<State> initials = null;
    public TreeSet<State> finals = null;
    public TreeSet<Transition> transitions = null;
    private static boolean verbose = false;

    public FSM() {
        this.initials = new TreeSet();
        this.finals = new TreeSet();
        this.transitions = new TreeSet();
    }

    public FSM(TreeSet<State> treeSet, TreeSet<State> treeSet2, TreeSet<Transition> treeSet3) {
        this.initials = treeSet;
        this.finals = treeSet2;
        this.transitions = treeSet3;
    }

    public FSM(String[] stringArray) {
        this.initials = new TreeSet();
        this.finals = new TreeSet();
        this.transitions = new TreeSet();
        int n = 0;
        State state = null;
        State state2 = new State(n++);
        this.initials.add(state2);
        for (int i = 0; i < stringArray.length; ++i) {
            state = state2;
            state2 = new State(n++);
            this.transitions.add(new Transition(state, new StringLabel(stringArray[i]), null, null, state2));
        }
        this.finals.add(state2);
    }

    public FSM(StringLabel[] stringLabelArray) {
        this.initials = new TreeSet();
        this.finals = new TreeSet();
        this.transitions = new TreeSet();
        int n = 0;
        State state = null;
        State state2 = new State(n++);
        this.initials.add(state2);
        for (int i = 0; i < stringLabelArray.length; ++i) {
            state = state2;
            state2 = new State(n++);
            this.transitions.add(new Transition(state, stringLabelArray[i], null, null, state2));
        }
        this.finals.add(state2);
    }

    public FSM(StringLabel[] stringLabelArray, StringLabel[] stringLabelArray2) {
        this.initials = new TreeSet();
        this.finals = new TreeSet();
        this.transitions = new TreeSet();
        int n = 0;
        State state = null;
        State state2 = new State(n++);
        this.initials.add(state2);
        for (int i = 0; i < stringLabelArray.length; ++i) {
            state = state2;
            state2 = new State(n++);
            this.transitions.add(new Transition(state, stringLabelArray[i], stringLabelArray2[i], null, state2));
        }
        this.finals.add(state2);
    }

    public static FSM sigmaStar(StringLabel[] stringLabelArray) {
        State state = new State(0);
        FSM fSM = new FSM();
        fSM.initials.add(state);
        fSM.finals.add(state);
        for (Segment segment : Sigma.segments) {
            fSM.transitions.add(new Transition(state, segment.segment, null, null, state));
        }
        if (stringLabelArray != null) {
            for (StringLabel stringLabel : stringLabelArray) {
                fSM.transitions.add(new Transition(state, stringLabel, null, null, state));
            }
        }
        return fSM;
    }

    public static FSM sigmaStar(StringLabel[] stringLabelArray, StringLabel[] stringLabelArray2) {
        State state = new State(0);
        FSM fSM = new FSM();
        fSM.initials.add(state);
        fSM.finals.add(state);
        for (Segment segment : Sigma.segments) {
            fSM.transitions.add(new Transition(state, segment.segment, segment.segment, null, state));
        }
        if (stringLabelArray != null) {
            for (int i = 0; i < stringLabelArray.length; ++i) {
                fSM.transitions.add(new Transition(state, stringLabelArray[i], stringLabelArray2[i], null, state));
            }
        }
        return fSM;
    }

    public TreeSet<State> getInitials() {
        return this.initials;
    }

    public TreeSet<State> getFinals() {
        return this.finals;
    }

    public TreeSet<Transition> getTransitions() {
        return this.transitions;
    }

    public void addInitial(State state) {
        this.initials.add(state);
    }

    public void addFinal(State state) {
        this.finals.add(state);
    }

    public void addTransition(Transition transition) {
        this.transitions.add(transition);
    }

    public TreeSet<State> getStates() {
        TreeSet<State> treeSet = new TreeSet<State>();
        treeSet.addAll(this.initials);
        treeSet.addAll(this.finals);
        for (Transition transition : this.transitions) {
            treeSet.add(transition.src);
            treeSet.add(transition.dest);
        }
        return treeSet;
    }

    public FSM reverse() {
        if (verbose) {
            System.out.println("reversing ...");
        }
        TreeSet<State> treeSet = this.initials;
        this.initials = this.finals;
        this.finals = treeSet;
        State state = null;
        TreeSet<Transition> treeSet2 = new TreeSet<Transition>();
        for (Transition transition : this.transitions) {
            state = transition.src;
            transition.src = transition.dest;
            transition.dest = state;
            treeSet2.add(transition);
        }
        this.transitions.clear();
        this.transitions = null;
        this.transitions = treeSet2;
        if (verbose) {
            System.out.println("done");
        }
        return this;
    }

    public FSM prune() {
        if (verbose) {
            System.out.println("pruning ...");
        }
        TreeSet<State> treeSet = null;
        this.reverse();
        treeSet = AccessibleStates.apply(this);
        this.finals.retainAll(treeSet);
        this.removeDeadTransitions(treeSet);
        this.reverse();
        treeSet = AccessibleStates.apply(this);
        this.finals.retainAll(treeSet);
        this.removeDeadTransitions(treeSet);
        if (verbose) {
            System.out.println("done");
        }
        LinkedList<Transition> linkedList = new LinkedList<Transition>();
        for (Transition transition : this.transitions) {
            if (!transition.src.equals(transition.dest) || transition.input != null && !transition.input.isEpsilon() || transition.output != null && !transition.output.isEpsilon()) continue;
            linkedList.add(transition);
        }
        this.transitions.removeAll(linkedList);
        return this;
    }

    public void removeDeadTransitions(TreeSet<State> treeSet) {
        if (verbose) {
            System.out.println("removing dead transitions ...");
        }
        TreeSet<Transition> treeSet2 = new TreeSet<Transition>();
        State state = null;
        boolean bl = false;
        for (Transition transition : this.transitions) {
            if (transition.src != state) {
                state = transition.src;
                bl = treeSet.contains(state);
            }
            if (!bl || !treeSet.contains(transition.dest)) continue;
            treeSet2.add(transition);
        }
        this.transitions = null;
        this.transitions = treeSet2;
        if (verbose) {
            System.out.println("done");
        }
    }

    public FSM removeEpsilonTransitions() {
        return this;
    }

    public FSM proj1() {
        for (Transition transition : this.transitions) {
            transition.output = null;
        }
        return this;
    }

    public FSM proj2() {
        for (Transition transition : this.transitions) {
            transition.input = null;
        }
        return this;
    }

    public FSM proj1to2() {
        for (Transition transition : this.transitions) {
            transition.output = transition.input;
            transition.input = null;
        }
        return this;
    }

    public FSM proj2to1() {
        for (Transition transition : this.transitions) {
            transition.input = transition.output;
            transition.output = null;
        }
        return this;
    }

    public FSM copy1to2() {
        for (Transition transition : this.transitions) {
            transition.output = transition.input.copy();
        }
        return this;
    }

    public FSM copy2to1() {
        for (Transition transition : this.transitions) {
            transition.input = transition.output.copy();
        }
        return this;
    }

    public FSM mask(boolean[] blArray) {
        String[] stringArray = null;
        String string = ".";
        for (Transition transition : this.transitions) {
            stringArray = (String[])((FeatureMatrix)transition.output).value();
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (!blArray[i]) continue;
                stringArray[i] = string;
            }
        }
        return this;
    }

    public FSM renumberStates() {
        TreeSet treeSet = new TreeSet();
        TreeSet treeSet2 = new TreeSet();
        TreeSet<Transition> treeSet3 = new TreeSet<Transition>();
        int n = 0;
        TreeMap<State, State> treeMap = new TreeMap<State, State>();
        for (State comparable : this.initials) {
            if (!treeMap.containsKey(comparable)) {
                treeMap.put(comparable, new State(n++));
            }
            treeSet.add(treeMap.get(comparable));
        }
        for (State state : this.finals) {
            if (!treeMap.containsKey(state)) {
                treeMap.put(state, new State(n++));
            }
            treeSet2.add(treeMap.get(state));
        }
        for (Transition transition : this.transitions) {
            if (!treeMap.containsKey(transition.src)) {
                treeMap.put(transition.src, new State(n++));
            }
            transition.src = (State)treeMap.get(transition.src);
            if (!treeMap.containsKey(transition.dest)) {
                treeMap.put(transition.dest, new State(n++));
            }
            transition.dest = (State)treeMap.get(transition.dest);
            treeSet3.add(transition);
        }
        treeMap.clear();
        treeMap = null;
        this.initials.clear();
        this.initials = null;
        this.initials = treeSet;
        this.finals.clear();
        this.finals = null;
        this.finals = treeSet2;
        this.transitions.clear();
        this.transitions = null;
        this.transitions = treeSet3;
        return this;
    }

    public int numberOfStates() {
        TreeSet<State> treeSet = new TreeSet<State>();
        for (Transition transition : this.transitions) {
            treeSet.add(transition.src);
            treeSet.add(transition.dest);
        }
        int n = treeSet.size();
        treeSet.clear();
        treeSet = null;
        return n;
    }

    public void resetWeights(Weight weight) {
        for (Transition transition : this.transitions) {
            transition.weight = weight;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\ndigraph G\n{\n");
        stringBuffer.append("graph [size = \"7.5,7.5\" rankdir = LR]\n");
        stringBuffer.append("node [shape = circle]\n");
        for (State comparable : this.initials) {
            stringBuffer.append(comparable.toString());
            stringBuffer.append(" [style = bold");
            if (this.finals.contains(comparable)) {
                stringBuffer.append(" peripheries = 2");
            }
            stringBuffer.append("]\n");
        }
        for (State state : this.finals) {
            if (this.initials.contains(state)) continue;
            stringBuffer.append(state.toString());
            stringBuffer.append(" [peripheries = 2]\n");
        }
        for (Transition transition : this.transitions) {
            stringBuffer.append(transition.toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        Options options = new Options();
        GnuParser gnuParser = new GnuParser();
        CommandLine commandLine = null;
        for (Option option : Sigma.OPTIONS) {
            options.addOption(option);
        }
        options.addOption(new Option("fsmcompile", true, "compile a string to an fsm"));
        options.addOption(new Option("fsmprint", true, "print a compiled fsm in dot format"));
        options.addOption(new Option("att", true, "print a compiled fsm in att format"));
        commandLine = gnuParser.parse(options, stringArray, false);
        Sigma sigma = new Sigma(commandLine);
        if (commandLine.hasOption("fsmcompile")) {
            FSM objectInputStream = FSMFileReader.read(new File(commandLine.getOptionValue("fsmcompile")));
            ObjectOutputStream fSM = new ObjectOutputStream(System.out);
            fSM.writeObject(objectInputStream);
        } else if (commandLine.hasOption("fsmprint")) {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(new File(commandLine.getOptionValue("fsmprint"))));
            FSM fSM = (FSM)objectInputStream.readObject();
            System.out.println(fSM);
        } else if (commandLine.hasOption("att")) {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(new File(commandLine.getOptionValue("att"))));
            FSM fSM = (FSM)objectInputStream.readObject();
            for (State state : fSM.getFinals()) {
                System.out.println(state.id);
            }
            for (Transition transition : fSM.getTransitions()) {
                System.out.println(transition.src.id + "\t" + transition.dest.id + "\t" + Sigma.indexOf((StringLabel)transition.input) + "\t" + Sigma.indexOf((StringLabel)transition.output) + "\t" + transition.weight);
            }
        }
    }
}

