/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.fsm;

import edu.ucla.fsm.FeatureMatrix;
import edu.ucla.fsm.Segment;
import java.util.Arrays;
import java.util.LinkedList;

public class BracketedStringReader {
    private static final String zero = "0";
    private static final String open = "[";
    private static final String close = "]";
    private static final String pipe = "|";
    private static LinkedList sigma = null;
    private static int numberOfTiers = -1;
    private static boolean[] bracketed = null;
    private static boolean[] state = null;
    private static boolean[] state_tmp = null;

    public static void setState(LinkedList linkedList, boolean[] blArray) {
        sigma = linkedList;
        numberOfTiers = blArray.length;
        bracketed = blArray;
    }

    public static void reset() {
        if (state == null) {
            state = new boolean[numberOfTiers];
            state_tmp = new boolean[numberOfTiers];
        } else {
            Arrays.fill(state, false);
        }
    }

    public static String[] segmentToFeatures(String string) {
        int n;
        int n2;
        if (string.equals("EPSILON")) {
            return FeatureMatrix.EPSILON;
        }
        Object[] objectArray = new String[numberOfTiers];
        Arrays.fill(objectArray, zero);
        Arrays.fill(state_tmp, false);
        for (n2 = 0; n2 < string.length() && string.substring(n2, n2 + 1).equals(open); ++n2) {
            for (n = 0; n < numberOfTiers; ++n) {
                if (!bracketed[n] || state[n]) continue;
                objectArray[n] = open;
                BracketedStringReader.state[n] = true;
                BracketedStringReader.state_tmp[n] = true;
            }
        }
        string = string.substring(n2, string.length());
        for (n2 = string.length(); n2 >= 0 && string.substring(n2 - 1, n2).equals(close); --n2) {
            for (n = numberOfTiers - 1; n >= 0; --n) {
                if (bracketed[n] && state[n] && !state_tmp[n]) {
                    objectArray[n] = close;
                    BracketedStringReader.state[n] = false;
                    continue;
                }
                if (!bracketed[n] || !state[n] || !state_tmp[n]) continue;
                objectArray[n] = pipe;
                BracketedStringReader.state[n] = false;
            }
        }
        string = string.substring(0, n2);
        Segment segment = null;
        for (n2 = 0; n2 < sigma.size(); ++n2) {
            segment = (Segment)sigma.get(n2);
            if (!string.equals(segment.segment)) continue;
            for (int i = 0; i < numberOfTiers; ++i) {
                if (bracketed[i]) continue;
                objectArray[i] = segment.features.value[i];
            }
            break;
        }
        return objectArray;
    }
}

