/*
 * Decompiled with CFR 0.152.
 */
package pal.util;

import java.io.PrintWriter;

public interface AlgorithmCallback {
    public boolean isPleaseStop();

    public void updateProgress(double var1);

    public void clearProgress();

    public void updateStatus(String var1);

    public static final class Utils {
        public static final AlgorithmCallback getNullCallback() {
            return NullCallback.INSTANCE;
        }

        public static final AlgorithmCallback getPrintWriterCallback(PrintWriter pw) {
            return new PrintWriterCallback(pw);
        }

        public static final AlgorithmCallback getSubCallback(AlgorithmCallback parent, String id, double minProgress, double maxProgress) {
            return new SubCallback(parent, id, minProgress, maxProgress);
        }

        private static final class SubCallback
        implements AlgorithmCallback {
            private final String id_;
            private final double minProgress_;
            private final double progressRange_;
            private final AlgorithmCallback parent_;

            public SubCallback(AlgorithmCallback parent, String id, double minProgress, double maxProgress) {
                this.id_ = id;
                this.minProgress_ = minProgress;
                this.progressRange_ = maxProgress - minProgress;
                this.parent_ = parent;
            }

            public void updateStatus(String statusString) {
                this.parent_.updateStatus(this.id_ + statusString);
            }

            public boolean isPleaseStop() {
                return this.parent_.isPleaseStop();
            }

            public void updateProgress(double progress) {
                if (progress >= 0.0 && progress <= 1.0) {
                    this.parent_.updateProgress(this.progressRange_ * progress + this.minProgress_);
                } else {
                    System.out.println("Warning: strange usage of progress:" + progress);
                    Thread.dumpStack();
                }
            }

            public void clearProgress() {
                this.parent_.clearProgress();
            }
        }

        private static final class PrintWriterCallback
        implements AlgorithmCallback {
            private final PrintWriter pw_;

            public PrintWriterCallback(PrintWriter pw) {
                this.pw_ = pw;
            }

            public void updateStatus(String statusString) {
                this.pw_.println("Status:" + statusString);
            }

            public void log(Object logInfo) {
                this.pw_.println("Log:" + logInfo);
            }

            public void logNNL(Object logInfo) {
                this.pw_.print(logInfo);
            }

            public void debug(Object logInfo) {
                this.pw_.println("Debug:" + logInfo);
            }

            public boolean isPleaseStop() {
                return false;
            }

            public void updateProgress(double progress) {
                this.pw_.println("Progress:" + progress);
            }

            public void clearProgress() {
                this.pw_.println("Clear Progress");
            }
        }

        private static final class NullCallback
        implements AlgorithmCallback {
            static final AlgorithmCallback INSTANCE = new NullCallback();

            private NullCallback() {
            }

            public void updateStatus(String statusString) {
            }

            public boolean isPleaseStop() {
                return false;
            }

            public void updateProgress(double progress) {
            }

            public void clearProgress() {
            }
        }
    }
}

