/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import java.util.ArrayList;
import pal.algorithmics.Assessor;
import pal.algorithmics.Markable;
import pal.algorithmics.StateProvider;
import pal.algorithmics.StoppingCriteria;
import pal.algorithmics.UndoableAction;
import pal.alignment.Alignment;
import pal.alignment.AlignmentUtils;
import pal.datatype.DataType;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.LHCalculator;
import pal.eval.PatternInfo;
import pal.eval.Posteriors;
import pal.eval.SimpleLHCalculator;
import pal.math.MersenneTwisterFast;
import pal.math.MinimiserMonitor;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;
import pal.math.OrthogonalHints;
import pal.math.UnivariateFunction;
import pal.math.UnivariateMinimum;
import pal.misc.Identifier;
import pal.substmodel.SubstitutionModel;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.tree.NodeUtils;
import pal.tree.SimpleTree;
import pal.tree.Tree;
import pal.util.AlgorithmCallback;

public class UnrootedMLSearcher
implements Markable,
StateProvider {
    private static final int STARTING_UPDATE_ID = 0;
    private static final double CONSTRUCTED_BRANCH_LENGTH = 0.01;
    private static final double MINIMUM_BRANCH_LENGTH = 0.0;
    private static final double MAXIMUM_BRANCH_LENGTH = 10.0;
    private Connection treeAccess_;
    private final SubstitutionModel model_;
    private final ConstructionTool tool_;
    private final Connection[] allConnections_;
    private final UNode[] orderedNodes_;
    private final MersenneTwisterFast random_ = new MersenneTwisterFast();
    private final OptimisationHandler optimisationHandler_;

    public UnrootedMLSearcher(Alignment alignment, SubstitutionModel model) {
        this(alignment, model, SimpleLHCalculator.getFactory());
    }

    public UnrootedMLSearcher(Alignment alignment, SubstitutionModel model, LHCalculator.Factory calcFactory) {
        this.model_ = model;
        int numberOfStates = this.model_.getDataType().getNumStates();
        this.tool_ = new ConstructionTool(alignment, numberOfStates, model.getNumberOfTransitionCategories(), calcFactory);
        this.treeAccess_ = new Connection(Identifier.getNames(alignment), this.tool_, this.random_);
        ArrayList v = new ArrayList();
        this.treeAccess_.getAllConnections(v);
        this.allConnections_ = new Connection[v.size()];
        v.toArray(this.allConnections_);
        this.optimisationHandler_ = new OptimisationHandler(this.model_, this.tool_);
        this.treeAccess_.setup(this.tool_, this.allConnections_);
        this.optimisationHandler_.setup(this.treeAccess_, true);
        this.orderedNodes_ = this.tool_.getOrderedNodes();
    }

    public UnrootedMLSearcher(Node root, Alignment alignment, SubstitutionModel model) {
        this(root, alignment, model, SimpleLHCalculator.getFactory());
    }

    public UnrootedMLSearcher(Node root, Alignment alignment, SubstitutionModel model, LHCalculator.Factory calcFactory) {
        this.model_ = model;
        int numberOfStates = this.model_.getDataType().getNumStates();
        this.tool_ = new ConstructionTool(alignment, numberOfStates, model.getNumberOfTransitionCategories(), calcFactory);
        this.treeAccess_ = new Connection(root, this.tool_);
        ArrayList v = new ArrayList();
        this.treeAccess_.getAllConnections(v);
        this.allConnections_ = new Connection[v.size()];
        v.toArray(this.allConnections_);
        this.optimisationHandler_ = new OptimisationHandler(this.model_, this.tool_);
        this.treeAccess_.setup(this.tool_, this.allConnections_);
        this.optimisationHandler_.setup(this.treeAccess_, true);
        this.orderedNodes_ = this.tool_.getOrderedNodes();
    }

    public Object getStateReference() {
        return new StateObject(this.allConnections_);
    }

    public void restoreState(Object stateReference) {
        StateObject so = (StateObject)stateReference;
        so.rebuildTree(this.allConnections_, this.orderedNodes_);
    }

    public UndoableAction getNNIAction(StoppingCriteria.Factory stopper) {
        Assessor a = this.getSimpleAssessor(stopper);
        return new NNIAction(this.allConnections_, a, this.random_, this.tool_);
    }

    public UndoableAction getBranchLengthOptimiseAction(StoppingCriteria.Factory stopper) {
        return new BranchLengthOptimiseAction(this.allConnections_, stopper.newInstance(), AlgorithmCallback.Utils.getNullCallback());
    }

    public UndoableAction getNNIBranchLengthOptimiseAction(StoppingCriteria.Factory stopper) {
        return new NNIBranchLengthOptimiseAction(this.allConnections_, this.model_, stopper.newInstance(), AlgorithmCallback.Utils.getNullCallback(), this.tool_);
    }

    public UndoableAction getBranchLengthWithModelOptimiseAction(StoppingCriteria.Factory stopper, MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits) {
        return new BranchLengthWithModelOptimiseAction(this.tool_, this.allConnections_, stopper.newInstance(), AlgorithmCallback.Utils.getNullCallback(), minimiser, MinimiserMonitor.Utils.createNullMonitor(), this.model_, fxFracDigits, xFracDigits);
    }

    public UndoableAction getModelOptimiseAction(MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits) {
        return new ModelOptimiseAction(this.treeAccess_, minimiser, MinimiserMonitor.Utils.createNullMonitor(), this.model_, fxFracDigits, xFracDigits, this.tool_);
    }

    public UndoableAction getModelOptimiseAction(MultivariateMinimum minimiser, MinimiserMonitor monitor, int fxFracDigits, int xFracDigits) {
        return new ModelOptimiseAction(this.treeAccess_, minimiser, monitor, this.model_, fxFracDigits, xFracDigits, this.tool_);
    }

    public UndoableAction getSPRAction(StoppingCriteria.Factory stopper) {
        Assessor a = this.getSimpleAssessor(stopper);
        return new SPRAction(this.allConnections_, this, a, this.random_, this.tool_);
    }

    public UndoableAction getSweepSPRAction(StoppingCriteria.Factory stopper) {
        Assessor a = this.getSimpleAssessor(stopper);
        SPRAction base = new SPRAction(this.allConnections_, this, a, this.random_, this.tool_);
        return new SweepSPRAction(this.allConnections_, base, this.random_);
    }

    public UndoableAction getFullSweepSPRAction(StoppingCriteria.Factory stopper) {
        Assessor a = this.getSimpleAssessor(stopper);
        SPRAction base = new SPRAction(this.allConnections_, this, a, this.random_, this.tool_);
        return new FullSweepSPRAction(this.allConnections_, base);
    }

    public final void mark() {
        int i = 0;
        while (i < this.allConnections_.length) {
            this.allConnections_[i].mark();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.orderedNodes_.length) {
            this.orderedNodes_[i2].mark();
            ++i2;
        }
    }

    public final void undoToMark() {
        int i = 0;
        while (i < this.allConnections_.length) {
            this.allConnections_[i].undoToMark();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.orderedNodes_.length) {
            this.orderedNodes_[i2].undoToMark();
            ++i2;
        }
        this.treeAccess_.setup(this.tool_, this.allConnections_);
    }

    private final Connection getRandomConnection() {
        return this.allConnections_[this.random_.nextInt(this.allConnections_.length)];
    }

    public void testLiklihood() {
        Workspace workspace = new Workspace(30, this.tool_.getNumberOfSites(), this.tool_);
        OptimisationHandler oh = new OptimisationHandler(this.model_, this.tool_);
        oh.setup(this.treeAccess_, true);
        this.treeAccess_.testLikelihood(this.model_, this.tool_);
    }

    public double calculateLikelihood() {
        return this.treeAccess_.calculateLogLikelihood(this.model_, true, this.tool_.allocateNewExternalCalculator(), this.tool_);
    }

    public double calculateLikelihood2() {
        return this.treeAccess_.calculateLogLikelihood2(this.model_, true, this.tool_.allocateNewExternalCalculator(), this.tool_);
    }

    public Posteriors calculatePosteriors() {
        return this.treeAccess_.calculatePosteriors(this.model_, true, this.tool_.allocateNewExternalCalculator(), this.tool_);
    }

    public double simpleOptimiseLikelihood(StoppingCriteria stopper, AlgorithmCallback callback) {
        stopper.reset();
        double maximum = Double.NEGATIVE_INFINITY;
        boolean firstTime = true;
        while (!stopper.isTimeToStop()) {
            int i = 0;
            while (i < this.allConnections_.length) {
                Connection c = this.allConnections_[i];
                maximum = this.optimisationHandler_.optimiseBranchLength(c, firstTime);
                firstTime = false;
                ++i;
            }
            stopper.newIteration(maximum, maximum, true, true, callback);
        }
        return maximum;
    }

    public Tree buildPALTree() {
        return new SimpleTree(this.buildPALNode());
    }

    public Node buildPALNode() {
        Node n = this.treeAccess_.buildPALNode();
        NodeUtils.lengths2Heights(n);
        return n;
    }

    public final Assessor getSimpleAssessor(StoppingCriteria.Factory stopper) {
        return new SimpleAssessor(stopper.newInstance(), AlgorithmCallback.Utils.getNullCallback());
    }

    private static final UNode createUNode(Node n, Connection parentConnection, ConstructionTool tool) {
        if (n.isLeaf()) {
            return new LeafNode(n, parentConnection, tool);
        }
        return new InternalNode(n, parentConnection, tool);
    }

    private static final UNode createUNode(String[] leafNames, Connection parentConnection, ConstructionTool tool, MersenneTwisterFast r) {
        if (leafNames.length == 1) {
            return new LeafNode(leafNames[0], parentConnection, tool);
        }
        return new InternalNode(leafNames, parentConnection, tool, r);
    }

    private static final String[] subset(String[] array, int starting, int width) {
        String[] subset = new String[width];
        System.arraycopy(array, starting, subset, 0, width);
        return subset;
    }

    private static final String[] subset(String[] array, int starting) {
        return UnrootedMLSearcher.subset(array, starting, array.length - starting);
    }

    private static final String[][] split(String[] leafNames, MersenneTwisterFast r) {
        if (leafNames.length == 2) {
            return new String[][]{{leafNames[0]}, {leafNames[1]}};
        }
        int split = r.nextInt(leafNames.length - 2) + 1;
        return new String[][]{UnrootedMLSearcher.subset(leafNames, 0, split), UnrootedMLSearcher.subset(leafNames, split)};
    }

    private static final class ConstructionTool {
        private final String[] names_;
        private final int[][] sequences_;
        private final int numberOfStates_;
        private final int numberOfCategories_;
        private final int numberOfSites_;
        private final DataType dt_;
        private int nextConnectionIndex_ = 0;
        private final ArrayList allUNodes_ = new ArrayList();
        private final LHCalculator.Generator calcGenerator_;

        public ConstructionTool(Alignment alignment, int numberOfStates, int numberOfCategories, LHCalculator.Factory calculatorFactory) {
            DataType dt = alignment.getDataType();
            this.dt_ = dt.isAmbiguous() ? dt.getAmbiguousVersion().getSpecificDataType() : alignment.getDataType();
            this.numberOfSites_ = alignment.getSiteCount();
            this.numberOfStates_ = numberOfStates;
            this.numberOfCategories_ = numberOfCategories;
            this.names_ = Identifier.getNames(alignment);
            this.sequences_ = AlignmentUtils.getAlignedStates(alignment, this.dt_.getNumStates());
            this.calcGenerator_ = calculatorFactory.createSeries(numberOfCategories, this.dt_);
        }

        public PatternInfo constructFreshPatternInfo(boolean binaryPattern) {
            return new PatternInfo(this.numberOfSites_, binaryPattern);
        }

        public final ConditionalProbabilityStore newConditionalProbabilityStore(boolean isForLeaf) {
            return this.calcGenerator_.createAppropriateConditionalProbabilityStore(isForLeaf);
        }

        public final int allocateNextConnectionIndex() {
            return this.nextConnectionIndex_++;
        }

        public LHCalculator.Internal allocateNewInternalCalculator() {
            return this.calcGenerator_.createNewInternal();
        }

        public LHCalculator.External allocateNewExternalCalculator() {
            return this.calcGenerator_.createNewExternal();
        }

        public LHCalculator.Leaf createNewLeafCalculator(int[] patternStateMatchup, int numberOfPatterns) {
            return this.calcGenerator_.createNewLeaf(patternStateMatchup, numberOfPatterns);
        }

        public int build(PatternInfo beingBuilt, PatternInfo left, PatternInfo right) {
            return beingBuilt.build(left, right, this.numberOfSites_);
        }

        public final int allocateNextUNodeIndex(UNode node) {
            int index = this.allUNodes_.size();
            this.allUNodes_.add(node);
            return index;
        }

        public final UNode[] getOrderedNodes() {
            UNode[] result = new UNode[this.allUNodes_.size()];
            this.allUNodes_.toArray(result);
            return result;
        }

        public DataType getDataType() {
            return this.dt_;
        }

        public final int getNumberOfSites() {
            return this.numberOfSites_;
        }

        public int[] getSequence(String name) {
            int i = 0;
            while (i < this.names_.length) {
                if (name.equals(this.names_[i])) {
                    return this.sequences_[i];
                }
                ++i;
            }
            throw new IllegalArgumentException("Unknown sequence:" + name);
        }

        public int getNumberOfStates() {
            return this.numberOfStates_;
        }

        public int getNumberOfTransitionCategories() {
            return this.numberOfCategories_;
        }
    }

    private static final class NNIOptimisationHandler
    implements UnivariateFunction {
        private final double[][][] transitionProbabiltityStore_;
        private ConditionalProbabilityStore leftFlatConditionalProbabilities_;
        private ConditionalProbabilityStore rightFlatConditionalProbabilities_;
        private final ConditionalProbabilityStore leftFlatStore_;
        private final ConditionalProbabilityStore rightFlatStore_;
        private final ConditionalProbabilityStore leftLeftExtendedStore_;
        private final ConditionalProbabilityStore leftRightExtendedStore_;
        private final ConditionalProbabilityStore rightLeftExtendedStore_;
        private final ConditionalProbabilityStore rightRightExtendedStore_;
        private final ConditionalProbabilityStore tempStore_;
        private final SubstitutionModel model_;
        private final int numberOfCategories_;
        private final int numberOfStates_;
        private PatternInfo currentPatternInfo_;
        private final LHCalculator.External calculator_;
        private final UnivariateMinimum um_;
        private final ConstructionTool tool_;
        private final PatternInfo leftPatternStore_;
        private final PatternInfo rightPatternStore_;
        private final PatternInfo centerPatternStore_;
        private final Connection[] allConnections_;

        public NNIOptimisationHandler(Connection[] allConnections, SubstitutionModel model, ConstructionTool tool) {
            this.numberOfStates_ = model.getDataType().getNumStates();
            this.allConnections_ = allConnections;
            this.calculator_ = tool.allocateNewExternalCalculator();
            this.numberOfCategories_ = model.getNumberOfTransitionCategories();
            this.transitionProbabiltityStore_ = new double[this.numberOfCategories_][this.numberOfStates_][this.numberOfStates_];
            this.model_ = model;
            this.tool_ = tool;
            this.leftPatternStore_ = tool.constructFreshPatternInfo(true);
            this.rightPatternStore_ = tool.constructFreshPatternInfo(true);
            this.centerPatternStore_ = tool.constructFreshPatternInfo(true);
            this.tempStore_ = tool.newConditionalProbabilityStore(false);
            this.leftFlatStore_ = tool.newConditionalProbabilityStore(false);
            this.rightFlatStore_ = tool.newConditionalProbabilityStore(false);
            this.leftLeftExtendedStore_ = tool.newConditionalProbabilityStore(false);
            this.leftRightExtendedStore_ = tool.newConditionalProbabilityStore(false);
            this.rightLeftExtendedStore_ = tool.newConditionalProbabilityStore(false);
            this.rightRightExtendedStore_ = tool.newConditionalProbabilityStore(false);
            this.um_ = new UnivariateMinimum();
        }

        private final ConditionalProbabilityStore calculateFlat(PatternInfo patternInfo, ConditionalProbabilityStore resultStore, ConditionalProbabilityStore leftExtend, ConditionalProbabilityStore rightExtend) {
            this.calculator_.calculateFlat(patternInfo, leftExtend, rightExtend, resultStore);
            return resultStore;
        }

        public double optimiseSimulataneousNNIBranchLength(Connection c, boolean modelChanged) {
            UNode leftNode = c.getLeft();
            UNode rightNode = c.getRight();
            PatternInfo leftLeftPI = leftNode.getLeftPatternInfo(c);
            PatternInfo rightRightPI = rightNode.getRightPatternInfo(c);
            if (leftLeftPI == null || rightRightPI == null) {
                this.setup(c, modelChanged);
                this.um_.findMinimum(c.getBranchLength(), this);
                c.setBranchLength(this.um_.minx);
                return -this.um_.fminx;
            }
            PatternInfo leftRightPI = leftNode.getRightPatternInfo(c);
            PatternInfo rightLeftPI = rightNode.getLeftPatternInfo(c);
            ConditionalProbabilityStore leftLeftExtended = leftNode.getLeftExtendedConditionalProbabilities(this.model_, false, c, this.calculator_, this.leftLeftExtendedStore_);
            ConditionalProbabilityStore leftRightExtended = leftNode.getRightExtendedConditionalProbabilities(this.model_, false, c, this.calculator_, this.leftRightExtendedStore_);
            ConditionalProbabilityStore rightLeftExtended = rightNode.getLeftExtendedConditionalProbabilities(this.model_, false, c, this.calculator_, this.rightLeftExtendedStore_);
            ConditionalProbabilityStore rightRightExtended = rightNode.getRightExtendedConditionalProbabilities(this.model_, false, c, this.calculator_, this.rightRightExtendedStore_);
            this.tool_.build(this.rightPatternStore_, rightLeftPI, rightRightPI);
            this.tool_.build(this.leftPatternStore_, leftLeftPI, leftRightPI);
            this.tool_.build(this.centerPatternStore_, this.leftPatternStore_, this.rightPatternStore_);
            ConditionalProbabilityStore leftFlat = this.calculateFlat(c.getLeftPatternInfo(), this.leftFlatStore_, leftLeftExtended, leftRightExtended);
            ConditionalProbabilityStore rightFlat = this.calculateFlat(c.getRightPatternInfo(), this.rightFlatStore_, rightLeftExtended, rightRightExtended);
            this.setPatternInfo(leftFlat, rightFlat, c.getCenterPatternInfo(this.tool_));
            this.um_.findMinimum(c.getBranchLength(), this);
            double standardMaxFX = -this.um_.fminx;
            double standardMaxX = this.um_.minx;
            this.tool_.build(this.leftPatternStore_, rightLeftPI, leftRightPI);
            this.tool_.build(this.rightPatternStore_, leftLeftPI, rightRightPI);
            this.tool_.build(this.centerPatternStore_, this.leftPatternStore_, this.rightPatternStore_);
            leftFlat = this.calculateFlat(this.leftPatternStore_, this.leftFlatStore_, rightLeftExtended, leftRightExtended);
            rightFlat = this.calculateFlat(this.rightPatternStore_, this.rightFlatStore_, leftLeftExtended, rightRightExtended);
            this.setPatternInfo(leftFlat, rightFlat, this.centerPatternStore_);
            this.um_.findMinimum(c.getBranchLength(), this);
            double leftLeftSwapMaxX = this.um_.findMinimum(c.getBranchLength(), this);
            double leftLeftSwapMaxFX = -this.um_.fminx;
            this.tool_.build(this.leftPatternStore_, rightRightPI, leftRightPI);
            this.tool_.build(this.rightPatternStore_, rightLeftPI, leftLeftPI);
            this.tool_.build(this.centerPatternStore_, this.leftPatternStore_, this.rightPatternStore_);
            leftFlat = this.calculateFlat(this.leftPatternStore_, this.leftFlatStore_, rightRightExtended, leftRightExtended);
            rightFlat = this.calculateFlat(this.rightPatternStore_, this.rightFlatStore_, rightLeftExtended, leftLeftExtended);
            this.setPatternInfo(leftFlat, rightFlat, this.centerPatternStore_);
            this.um_.findMinimum(c.getBranchLength(), this);
            double diagSwapMaxX = this.um_.minx;
            double diagSwapMaxFX = -this.um_.fminx;
            if (standardMaxFX > diagSwapMaxFX) {
                if (standardMaxFX > leftLeftSwapMaxFX) {
                    c.setBranchLength(standardMaxX);
                    return standardMaxFX;
                }
                c.doNNI(true, true);
                c.setup(this.tool_, this.allConnections_);
                c.setBranchLength(leftLeftSwapMaxX);
                return leftLeftSwapMaxFX;
            }
            if (diagSwapMaxFX > leftLeftSwapMaxFX) {
                c.setBranchLength(diagSwapMaxX);
                c.doNNI(false, true);
                c.setup(this.tool_, this.allConnections_);
                return diagSwapMaxFX;
            }
            c.setBranchLength(leftLeftSwapMaxX);
            c.doNNI(true, true);
            c.setup(this.tool_, this.allConnections_);
            return leftLeftSwapMaxFX;
        }

        private void setup(Connection c, boolean modelChanged) {
            this.leftFlatConditionalProbabilities_ = c.getLeftFlatConditionalProbabilities(this.model_, modelChanged);
            this.rightFlatConditionalProbabilities_ = c.getRightFlatConditionalProbabilities(this.model_, modelChanged);
            this.currentPatternInfo_ = c.getCenterPatternInfo(this.tool_);
        }

        public void setPatternInfo(ConditionalProbabilityStore leftFlatConditionalProbabilities, ConditionalProbabilityStore rightFlatConditionalProbabilities, PatternInfo pi) {
            this.leftFlatConditionalProbabilities_ = leftFlatConditionalProbabilities;
            this.rightFlatConditionalProbabilities_ = rightFlatConditionalProbabilities;
            this.currentPatternInfo_ = pi;
        }

        public double evaluate(double argument) {
            return -this.calculator_.calculateLogLikelihood(argument, this.model_, this.currentPatternInfo_, this.leftFlatConditionalProbabilities_, this.rightFlatConditionalProbabilities_, this.tempStore_);
        }

        public double getLowerBound() {
            return 0.0;
        }

        public double getUpperBound() {
            return 1.0;
        }
    }

    private static final class OptimisationHandler
    implements UnivariateFunction {
        private final double[][][] transitionProbabiltityStore_;
        private ConditionalProbabilityStore leftFlatConditionalProbabilities_;
        private ConditionalProbabilityStore rightFlatConditionalProbabilities_;
        private final SubstitutionModel model_;
        private final int numberOfCategories_;
        private final int numberOfStates_;
        private PatternInfo currentPatternInfo_;
        private final LHCalculator.External calculator_;
        private final ConditionalProbabilityStore tempStore_;
        private final UnivariateMinimum um_;
        private final ConstructionTool tool_;

        public OptimisationHandler(SubstitutionModel model, ConstructionTool tool) {
            this.numberOfStates_ = model.getDataType().getNumStates();
            this.calculator_ = tool.allocateNewExternalCalculator();
            this.tempStore_ = tool.newConditionalProbabilityStore(false);
            this.tool_ = tool;
            this.numberOfCategories_ = model.getNumberOfTransitionCategories();
            this.transitionProbabiltityStore_ = new double[this.numberOfCategories_][this.numberOfStates_][this.numberOfStates_];
            this.model_ = model;
            this.um_ = new UnivariateMinimum();
        }

        public double optimiseBranchLength(Connection c, boolean modelChanged) {
            this.setup(c, modelChanged);
            this.um_.findMinimum(c.getBranchLength(), this);
            c.setBranchLength(this.um_.minx);
            return -this.um_.fminx;
        }

        public void setup(Connection c, boolean modelChanged) {
            this.leftFlatConditionalProbabilities_ = c.getLeftFlatConditionalProbabilities(this.model_, modelChanged);
            this.rightFlatConditionalProbabilities_ = c.getRightFlatConditionalProbabilities(this.model_, modelChanged);
            this.currentPatternInfo_ = c.getCenterPatternInfo(this.tool_);
        }

        public void setPatternInfo(ConditionalProbabilityStore leftFlatConditionalProbabilities, ConditionalProbabilityStore rightFlatConditionalProbabilities, PatternInfo pi) {
            this.leftFlatConditionalProbabilities_ = leftFlatConditionalProbabilities;
            this.rightFlatConditionalProbabilities_ = rightFlatConditionalProbabilities;
        }

        public double evaluate(double argument) {
            return -this.calculator_.calculateLogLikelihood(argument, this.model_, this.currentPatternInfo_, this.leftFlatConditionalProbabilities_, this.rightFlatConditionalProbabilities_, this.tempStore_);
        }

        public double getLowerBound() {
            return 0.0;
        }

        public double getUpperBound() {
            return 10.0;
        }
    }

    private static final class Connection {
        private UNode leftNode_;
        private UNode rightNode_;
        private double branchLength_;
        private final PatternInfo centerPattern_;
        private boolean centerPatternValid_;
        private final int index_;
        private UNode markLeftNode_ = null;
        private UNode markRightNode_ = null;
        private double markBranchLength_;

        public Connection(String[] leafNames, ConstructionTool tool, MersenneTwisterFast r) {
            this.index_ = tool.allocateNextConnectionIndex();
            String[][] split = UnrootedMLSearcher.split(leafNames, r);
            this.leftNode_ = UnrootedMLSearcher.createUNode(split[0], this, tool, r);
            this.rightNode_ = UnrootedMLSearcher.createUNode(split[1], this, tool, r);
            this.centerPattern_ = new PatternInfo(tool.getNumberOfSites(), true);
            this.centerPatternValid_ = false;
            this.branchLength_ = 0.01;
        }

        public Connection(String[] leafNames, UNode parent, ConstructionTool tool, MersenneTwisterFast r) {
            this.index_ = tool.allocateNextConnectionIndex();
            this.branchLength_ = 0.01;
            this.rightNode_ = parent;
            this.leftNode_ = UnrootedMLSearcher.createUNode(leafNames, this, tool, r);
            this.centerPattern_ = new PatternInfo(tool.getNumberOfSites(), true);
            this.centerPatternValid_ = false;
        }

        public Connection(Node n, ConstructionTool tool) {
            if (n.getChildCount() != 2) {
                throw new IllegalArgumentException("Base tree must be bificating");
            }
            this.index_ = tool.allocateNextConnectionIndex();
            Node l = n.getChild(0);
            Node r = n.getChild(1);
            this.branchLength_ = l.getBranchLength() + r.getBranchLength();
            this.leftNode_ = UnrootedMLSearcher.createUNode(l, this, tool);
            this.rightNode_ = UnrootedMLSearcher.createUNode(r, this, tool);
            this.centerPattern_ = new PatternInfo(tool.getNumberOfSites(), true);
            this.centerPatternValid_ = false;
        }

        public Connection(Node n, UNode parent, ConstructionTool tool) {
            this.index_ = tool.allocateNextConnectionIndex();
            this.branchLength_ = n.getBranchLength();
            this.rightNode_ = parent;
            this.leftNode_ = UnrootedMLSearcher.createUNode(n, this, tool);
            this.centerPattern_ = new PatternInfo(tool.getNumberOfSites(), true);
            this.centerPatternValid_ = false;
        }

        public final UNode getLeft() {
            return this.leftNode_;
        }

        public final UNode getRight() {
            return this.rightNode_;
        }

        public final void mark() {
            this.markBranchLength_ = this.branchLength_;
            this.markLeftNode_ = this.leftNode_;
            this.markRightNode_ = this.rightNode_;
        }

        public final PatternInfo getLeftPatternInfo() {
            return this.leftNode_.getPatternInfo(this);
        }

        public final PatternInfo getRightPatternInfo() {
            return this.rightNode_.getPatternInfo(this);
        }

        public final PatternInfo getCenterPatternInfo(ConstructionTool tool) {
            if (!this.centerPatternValid_) {
                tool.build(this.centerPattern_, this.getLeftPatternInfo(), this.getRightPatternInfo());
                this.centerPatternValid_ = true;
            }
            return this.centerPattern_;
        }

        public final void undoToMark() {
            if (this.markLeftNode_ == null) {
                throw new RuntimeException("Assertion error : undo to mark when no mark made");
            }
            this.branchLength_ = this.markBranchLength_;
            this.leftNode_ = this.markLeftNode_;
            this.rightNode_ = this.markRightNode_;
        }

        public String toString() {
            return "(" + this.leftNode_ + ", " + this.rightNode_ + ")";
        }

        public boolean hasConnection(Connection c, UNode caller) {
            if (c == this) {
                return true;
            }
            if (caller == this.leftNode_) {
                return this.rightNode_.hasConnection(c, this);
            }
            if (caller == this.rightNode_) {
                return this.leftNode_.hasConnection(c, this);
            }
            throw new IllegalArgumentException("Unknown caller");
        }

        public Connection getLeftLeftConnection() {
            return this.leftNode_.getLeft(this);
        }

        public Connection getLeftRightConnection() {
            return this.leftNode_.getRight(this);
        }

        public Connection getRightLeftConnection() {
            return this.rightNode_.getLeft(this);
        }

        public Connection getRightRightConnection() {
            return this.rightNode_.getRight(this);
        }

        public Connection attachTo(Connection attachmentPoint, Connection[] store) {
            Connection reattachment;
            UNode used;
            UNode uNode = used = this.leftNode_.hasConnection(attachmentPoint, this) ? this.leftNode_ : this.rightNode_;
            if (used.hasDirectConnection(attachmentPoint)) {
                return null;
            }
            Connection redundant = used.extract(this);
            Connection leftUsed = used.getLeft(this);
            Connection rightUsed = used.getRight(this);
            if (leftUsed == redundant) {
                reattachment = rightUsed;
            } else if (rightUsed == redundant) {
                reattachment = leftUsed;
            } else {
                throw new IllegalArgumentException("Assertion error");
            }
            if (redundant == null) {
                throw new RuntimeException("Assertion error : I should be able to extract from one of my nodes!");
            }
            UNode attachmentOldRight = attachmentPoint.rightNode_;
            attachmentPoint.swapNode(attachmentOldRight, used);
            redundant.swapNode(redundant.getOther(used), attachmentOldRight);
            attachmentOldRight.swapConnection(attachmentPoint, redundant);
            store[0] = this;
            store[1] = redundant;
            store[2] = attachmentPoint;
            used.setConnections(store, 3);
            return reattachment;
        }

        public Node buildPALNode() {
            Node[] children = new Node[]{this.leftNode_.buildPALNode(this.branchLength_ / 2.0, this), this.rightNode_.buildPALNode(this.branchLength_ / 2.0, this)};
            return NodeFactory.createNode(children);
        }

        public Node buildPALNode(UNode caller) {
            if (this.leftNode_ == caller) {
                return this.rightNode_.buildPALNode(this.branchLength_, this);
            }
            if (this.rightNode_ == caller) {
                return this.leftNode_.buildPALNode(this.branchLength_, this);
            }
            throw new IllegalArgumentException("Unknown caller!");
        }

        private static final int getIndex(Connection c) {
            if (c == null) {
                return -1;
            }
            return c.index_;
        }

        public void fillInConnectionState(int[] array, int insertionIndex) {
            int r;
            int l = this.leftNode_.getIndex();
            if (l < (r = this.rightNode_.getIndex())) {
                array[insertionIndex++] = l;
                array[insertionIndex] = r;
            } else {
                array[insertionIndex++] = r;
                array[insertionIndex] = l;
            }
        }

        public void setNodes(UNode left, UNode right) {
            this.leftNode_ = left;
            this.rightNode_ = right;
        }

        public void swapNode(UNode nodeToReplace, UNode replacement) {
            if (nodeToReplace == this.leftNode_) {
                this.leftNode_ = replacement;
            } else if (nodeToReplace == this.rightNode_) {
                this.rightNode_ = replacement;
            } else {
                throw new RuntimeException("Unknown node to replace");
            }
        }

        public final ConditionalProbabilityStore getLeftFlatConditionalProbabilities(SubstitutionModel model, boolean modelChanged) {
            return this.leftNode_.getFlatConditionalProbabilities(model, modelChanged, this, 0, true);
        }

        public final ConditionalProbabilityStore getRightFlatConditionalProbabilities(SubstitutionModel model, boolean modelChanged) {
            return this.rightNode_.getFlatConditionalProbabilities(model, modelChanged, this, 0, false);
        }

        public final double getBranchLength() {
            return this.branchLength_;
        }

        public final void setBranchLength(double x) {
            this.branchLength_ = x;
        }

        public String toString(UNode caller) {
            if (caller == this.leftNode_) {
                return this.rightNode_.toString(this);
            }
            if (caller != this.rightNode_) {
                throw new RuntimeException("Unknown caller");
            }
            return this.leftNode_.toString(this);
        }

        public void testLikelihood(SubstitutionModel model, ConstructionTool tool) {
            this.testLikelihood(null, model, tool);
        }

        public void testLikelihood(UNode caller, SubstitutionModel model, ConstructionTool tool) {
            int numberOfCategories = tool.getNumberOfTransitionCategories();
            int numberOfSites = tool.getNumberOfSites();
            int numberOfStates = tool.getNumberOfStates();
            double[][][] resultStore = new double[numberOfCategories][numberOfSites][numberOfStates];
            System.out.println("Likleihood:" + this.calculateLogLikelihood(model, true, tool.allocateNewExternalCalculator(), tool));
            if (caller != this.leftNode_) {
                this.leftNode_.testLikelihood(this, model, tool);
            }
            if (caller != this.rightNode_) {
                this.rightNode_.testLikelihood(this, model, tool);
            }
        }

        public ConditionalProbabilityStore getExtendedConditionalProbabilities(SubstitutionModel model, boolean modelChanged, UNode caller, int depth, boolean isForLeft) {
            UNode other = this.getOther(caller);
            return other.getExtendedConditionalProbabilities(this.branchLength_, model, modelChanged, this, depth, isForLeft);
        }

        public ConditionalProbabilityStore getExtendedConditionalProbabilities(SubstitutionModel model, boolean modelChanged, UNode caller, LHCalculator.External externalCalculator, ConditionalProbabilityStore extendedStore) {
            UNode other = this.getOther(caller);
            return other.getExtendedConditionalProbabilities(this.branchLength_, model, modelChanged, this, externalCalculator, extendedStore);
        }

        public void setup(ConstructionTool tool, Connection[] allConnections) {
            this.leftNode_.rebuildPattern(tool);
            int i = 0;
            while (i < allConnections.length) {
                allConnections[i].centerPatternValid_ = false;
                ++i;
            }
        }

        public void getAllConnections(ArrayList store) {
            this.getAllConnections(store, null);
        }

        public void getAllConnections(ArrayList store, UNode caller) {
            store.add(this);
            if (caller != this.leftNode_) {
                this.leftNode_.getAllConnections(store, this);
            }
            if (caller != this.rightNode_) {
                this.rightNode_.getAllConnections(store, this);
            }
        }

        public void getCenterPatternInfo(PatternInfo store, ConstructionTool tool) {
            PatternInfo left = this.leftNode_.getPatternInfo(this);
            PatternInfo right = this.rightNode_.getPatternInfo(this);
            tool.build(store, left, right);
        }

        public UNode getOther(UNode caller) {
            if (this.leftNode_ == caller) {
                return this.rightNode_;
            }
            if (this.rightNode_ == caller) {
                return this.leftNode_;
            }
            throw new RuntimeException("Unknown caller!");
        }

        public final void doNNI(MersenneTwisterFast r) {
            this.doNNI(r.nextBoolean(), r.nextBoolean());
        }

        public boolean doNNI(boolean leftSwapLeft, boolean rightSwapLeft) {
            Connection second;
            Connection first;
            Connection connection = first = leftSwapLeft ? this.leftNode_.getLeft(this) : this.leftNode_.getRight(this);
            if (first == null) {
                return false;
            }
            Connection connection2 = second = rightSwapLeft ? this.rightNode_.getLeft(this) : this.rightNode_.getRight(this);
            if (second == null) {
                return false;
            }
            this.leftNode_.swapConnection(first, this.rightNode_, second);
            return true;
        }

        public double calculateLogLikelihood(SubstitutionModel model, boolean modelChanged, LHCalculator.External calculator, ConstructionTool tool) {
            PatternInfo pi = this.getCenterPatternInfo(tool);
            ConditionalProbabilityStore leftConditionalProbabilityProbabilties = this.leftNode_.getFlatConditionalProbabilities(model, modelChanged, this, 0, true);
            ConditionalProbabilityStore rightConditionalProbabilityProbabilties = this.rightNode_.getExtendedConditionalProbabilities(this.branchLength_, model, modelChanged, this, 0, false);
            return calculator.calculateLogLikelihood(model, pi, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties);
        }

        public double calculateLogLikelihood2(SubstitutionModel model, boolean modelChanged, LHCalculator.External calculator, ConstructionTool tool) {
            PatternInfo pi = this.getCenterPatternInfo(tool);
            ConditionalProbabilityStore left = this.leftNode_.getFlatConditionalProbabilities(model, modelChanged, this, 0, true);
            ConditionalProbabilityStore right = this.rightNode_.getFlatConditionalProbabilities(model, modelChanged, this, 0, false);
            return calculator.calculateLogLikelihood(this.branchLength_, model, pi, left, right, tool.newConditionalProbabilityStore(false));
        }

        public Posteriors calculatePosteriors(SubstitutionModel model, boolean modelChanged, LHCalculator.External calculator, ConstructionTool tool) {
            PatternInfo pi = this.getCenterPatternInfo(tool);
            ConditionalProbabilityStore left = this.leftNode_.getFlatConditionalProbabilities(model, modelChanged, this, 0, true);
            ConditionalProbabilityStore right = this.rightNode_.getFlatConditionalProbabilities(model, modelChanged, this, 0, false);
            double[][] store = new double[tool.getNumberOfTransitionCategories()][pi.getNumberOfPatterns()];
            calculator.calculateCategoryPatternProbabilities(this.branchLength_, model, pi, left, right, tool.newConditionalProbabilityStore(false), store);
            return Posteriors.Utils.create(store, false, model, pi.getNumberOfPatterns(), pi.getSitePatternMatchup(), tool.getNumberOfSites());
        }
    }

    private static final class LeafNode
    implements UNode {
        private final String id_;
        private Connection parentConnection_;
        private Connection markParentConnection_;
        private final int[] sequence_;
        private final PatternInfo pattern_;
        private final int index_;
        private final LHCalculator.Leaf leafCalculator_;

        public LeafNode(String id, Connection parentConnection, ConstructionTool tool) {
            this.id_ = id;
            this.parentConnection_ = parentConnection;
            this.index_ = tool.allocateNextUNodeIndex(this);
            this.sequence_ = tool.getSequence(this.id_);
            int numberOfSites = this.sequence_.length;
            int numberOfStates = tool.getNumberOfStates();
            int numberOfCategories = tool.getNumberOfTransitionCategories();
            int[] stateCount = new int[numberOfStates + 1];
            int[] statePatternMatchup = new int[numberOfStates + 1];
            int[] patternStateMatchup = new int[numberOfStates + 1];
            int[] sitePatternMatchup = new int[numberOfSites];
            int uniqueCount = 0;
            int site = 0;
            while (site < numberOfSites) {
                int state = this.sequence_[site];
                if (stateCount[state] == 0) {
                    stateCount[state] = 1;
                    int pattern = uniqueCount++;
                    patternStateMatchup[pattern] = state;
                    statePatternMatchup[state] = pattern;
                } else {
                    int n = state;
                    stateCount[n] = stateCount[n] + 1;
                }
                sitePatternMatchup[site] = statePatternMatchup[state];
                ++site;
            }
            this.leafCalculator_ = tool.createNewLeafCalculator(patternStateMatchup, uniqueCount);
            this.pattern_ = new PatternInfo(sitePatternMatchup, uniqueCount);
        }

        public LeafNode(Node c, Connection parentConnection, ConstructionTool tool) {
            this(c.getIdentifier().getName(), parentConnection, tool);
        }

        public boolean hasDirectConnection(Connection c) {
            return this.parentConnection_ == c;
        }

        public void mark() {
            this.markParentConnection_ = this.parentConnection_;
        }

        public void undoToMark() {
            this.parentConnection_ = this.markParentConnection_;
        }

        public boolean hasConnection(Connection c, Connection caller) {
            if (caller != this.parentConnection_) {
                throw new IllegalArgumentException("Unknown caller!");
            }
            return this.parentConnection_ == c;
        }

        public Connection extract(Connection caller) {
            if (caller != this.parentConnection_) {
                throw new IllegalArgumentException("Unknown caller!");
            }
            return null;
        }

        public ConditionalProbabilityStore getLeftExtendedConditionalProbabilities(SubstitutionModel model, boolean modelChanged, Connection callingConnection, LHCalculator.External externalCalculator, ConditionalProbabilityStore resultStore) {
            throw new RuntimeException("Assertion error : Not applicable for leaf nodes!");
        }

        public ConditionalProbabilityStore getRightExtendedConditionalProbabilities(SubstitutionModel model, boolean modelChanged, Connection callingConnection, LHCalculator.External externalCalculator, ConditionalProbabilityStore resultStore) {
            throw new RuntimeException("Assertion error : Not applicable for leaf nodes!");
        }

        public PatternInfo getLeftPatternInfo(Connection caller) {
            return null;
        }

        public PatternInfo getRightPatternInfo(Connection caller) {
            return null;
        }

        public void setConnections(Connection[] store, int number) {
            if (number != 1) {
                throw new IllegalArgumentException("Must be one connection not:" + number);
            }
            this.parentConnection_ = store[0];
        }

        public void testLikelihood(Connection caller, SubstitutionModel model, ConstructionTool tool) {
            if (caller != this.parentConnection_) {
                throw new IllegalArgumentException("Unknown caller!");
            }
        }

        public final int getIndex() {
            return this.index_;
        }

        public void swapConnection(Connection original, Connection newConnection) {
            if (original != this.parentConnection_) {
                throw new IllegalArgumentException("Unknown original");
            }
            this.parentConnection_ = newConnection;
        }

        public void swapConnection(Connection original, UNode nodeToReplace, Connection newConnection) {
            this.swapConnection(original, newConnection);
            newConnection.swapNode(nodeToReplace, this);
            original.swapNode(this, nodeToReplace);
        }

        public Connection getLeft(Connection caller) {
            return null;
        }

        public Connection getRight(Connection caller) {
            return null;
        }

        public void getAllConnections(ArrayList store, Connection caller) {
            if (caller != this.parentConnection_) {
                throw new IllegalArgumentException("Unknown caller!");
            }
        }

        public PatternInfo getPatternInfo(Connection caller) {
            if (caller != this.parentConnection_) {
                throw new IllegalArgumentException("Unknown caller!");
            }
            return this.pattern_;
        }

        public void rebuildConnectionPatterns(ConstructionTool tool, Connection caller) {
            if (caller != this.parentConnection_) {
                throw new IllegalArgumentException("Unknown caller!");
            }
        }

        public int rebuildPattern(ConstructionTool tool, Connection caller, boolean firstPass) {
            if (caller != this.parentConnection_) {
                throw new IllegalArgumentException("Uknown caller!");
            }
            return this.pattern_.getNumberOfPatterns();
        }

        public int rebuildPattern(ConstructionTool tool) {
            return this.parentConnection_.getOther(this).redirectRebuildPattern(tool);
        }

        public int redirectRebuildPattern(ConstructionTool tool) {
            return this.pattern_.getNumberOfPatterns();
        }

        public final ConditionalProbabilityStore getFlatConditionalProbabilities(SubstitutionModel model, boolean modelChanged, Connection callingConnection, LHCalculator.External external, ConditionalProbabilityStore resultStore) {
            if (callingConnection != this.parentConnection_) {
                throw new IllegalArgumentException("Unknown calling connection");
            }
            return this.leafCalculator_.getFlatConditionalProbabilities();
        }

        public final ConditionalProbabilityStore getFlatConditionalProbabilities(SubstitutionModel model, boolean modelChanged, Connection callingConnection, int depth, boolean isForLeft) {
            if (callingConnection != this.parentConnection_) {
                throw new IllegalArgumentException("Unknown calling connection");
            }
            return this.leafCalculator_.getFlatConditionalProbabilities();
        }

        public ConditionalProbabilityStore getExtendedConditionalProbabilities(double distance, SubstitutionModel model, boolean modelChanged, Connection callingConnection, LHCalculator.External external, ConditionalProbabilityStore resultStore) {
            if (callingConnection != this.parentConnection_) {
                throw new IllegalArgumentException("Unknown calling connection");
            }
            return this.leafCalculator_.getExtendedConditionalProbabilities(distance, model, modelChanged);
        }

        public ConditionalProbabilityStore getExtendedConditionalProbabilities(double distance, SubstitutionModel model, boolean modelChanged, Connection callingConnection, int depth, boolean isForLeft) {
            if (callingConnection != this.parentConnection_) {
                throw new IllegalArgumentException("Unknown calling connection");
            }
            return this.leafCalculator_.getExtendedConditionalProbabilities(distance, model, modelChanged);
        }

        public Node buildPALNode(double branchLength, Connection caller) {
            if (caller != this.parentConnection_) {
                throw new IllegalArgumentException("Unknown calling connection");
            }
            return NodeFactory.createNodeBranchLength(branchLength, new Identifier(this.id_));
        }

        public String toString(Connection caller) {
            return this.id_;
        }
    }

    private static final class InternalNode
    implements UNode {
        private final Connection[] connections_ = new Connection[3];
        private final Connection[] markConnections_ = new Connection[3];
        private final PatternInfo[] patterns_;
        private static final int[] LEFT_LOOKUP = new int[]{1, 0, 0};
        private static final int[] RIGHT_LOOKUP = new int[]{2, 2, 1};
        private final int index_;
        private final LHCalculator.Internal calculator_;
        private boolean topologyChangedSinceLastFlat_ = true;
        private boolean topologyChangedSincleLastExtended_ = true;

        private InternalNode(String[] leafNames, Connection parentConnection, ConstructionTool tool, MersenneTwisterFast r) {
            this.connections_[0] = parentConnection;
            this.index_ = tool.allocateNextUNodeIndex(this);
            this.calculator_ = tool.allocateNewInternalCalculator();
            String[][] split = UnrootedMLSearcher.split(leafNames, r);
            this.connections_[1] = new Connection(split[0], this, tool, r);
            this.connections_[2] = new Connection(split[1], this, tool, r);
            int numberOfSites = tool.getNumberOfSites();
            this.patterns_ = new PatternInfo[]{new PatternInfo(numberOfSites, true), new PatternInfo(numberOfSites, true), new PatternInfo(numberOfSites, true)};
        }

        public InternalNode(Node i, Connection parentConnection, ConstructionTool tool) {
            this.connections_[0] = parentConnection;
            this.connections_[1] = new Connection(i.getChild(0), this, tool);
            this.connections_[2] = new Connection(i.getChild(1), this, tool);
            this.index_ = tool.allocateNextUNodeIndex(this);
            this.calculator_ = tool.allocateNewInternalCalculator();
            int numberOfSites = tool.getNumberOfSites();
            this.patterns_ = new PatternInfo[]{new PatternInfo(numberOfSites, true), new PatternInfo(numberOfSites, true), new PatternInfo(numberOfSites, true)};
        }

        public void mark() {
            this.markConnections_[0] = this.connections_[0];
            this.markConnections_[1] = this.connections_[1];
            this.markConnections_[2] = this.connections_[2];
        }

        public void undoToMark() {
            this.connections_[0] = this.markConnections_[0];
            this.connections_[1] = this.markConnections_[1];
            this.connections_[2] = this.markConnections_[2];
            this.topologyChanged();
        }

        private final void topologyChanged() {
            this.topologyChangedSinceLastFlat_ = true;
            this.topologyChangedSincleLastExtended_ = true;
        }

        public boolean hasDirectConnection(Connection c) {
            int i = 0;
            while (i < this.connections_.length) {
                if (this.connections_[i] == c) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean hasConnection(Connection c, Connection caller) {
            int i = 0;
            while (i < this.connections_.length) {
                if (this.connections_[i] == c || this.connections_[i] != caller && this.connections_[i].hasConnection(c, this)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public final int getIndex() {
            return this.index_;
        }

        public void testLikelihood(Connection caller, SubstitutionModel model, ConstructionTool tool) {
            int i = 0;
            while (i < this.connections_.length) {
                if (this.connections_[i] != caller) {
                    this.connections_[i].testLikelihood(this, model, tool);
                }
                ++i;
            }
        }

        public void setConnections(Connection[] store, int number) {
            if (number != 3) {
                throw new IllegalArgumentException("Must be three connections not:" + number);
            }
            System.arraycopy(store, 0, this.connections_, 0, 3);
            this.topologyChanged();
        }

        public Connection getLeft(Connection caller) {
            return this.connections_[LEFT_LOOKUP[this.getCallerIndex(caller)]];
        }

        public Connection getRight(Connection caller) {
            return this.connections_[RIGHT_LOOKUP[this.getCallerIndex(caller)]];
        }

        public Connection extract(Connection caller) {
            int callerIndex = this.getCallerIndex(caller);
            Connection left = this.connections_[LEFT_LOOKUP[callerIndex]];
            Connection right = this.connections_[RIGHT_LOOKUP[callerIndex]];
            UNode rightNode = right.getOther(this);
            left.swapNode(this, rightNode);
            rightNode.swapConnection(right, left);
            this.topologyChanged();
            return right;
        }

        public void swapConnection(Connection original, UNode nodeToReplace, Connection newConnection) {
            int index = this.getCallerIndex(original);
            this.connections_[index] = newConnection;
            newConnection.swapNode(nodeToReplace, this);
            original.swapNode(this, nodeToReplace);
            nodeToReplace.swapConnection(newConnection, original);
            this.topologyChanged();
        }

        public void swapConnection(Connection original, Connection newConnection) {
            int index = this.getCallerIndex(original);
            this.connections_[index] = newConnection;
            this.topologyChanged();
        }

        public PatternInfo getPatternInfo(Connection caller) {
            return this.patterns_[this.getCallerIndex(caller)];
        }

        public Node buildPALNode(double branchLength, Connection caller) {
            int callerIndex = this.getCallerIndex(caller);
            Connection leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
            Connection rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
            Node[] children = new Node[]{leftConnection.buildPALNode(this), rightConnection.buildPALNode(this)};
            return NodeFactory.createNodeBranchLength(branchLength, children);
        }

        public String toString(Connection caller) {
            StringBuffer sb = new StringBuffer();
            boolean printed = false;
            int i = 0;
            while (i < this.connections_.length) {
                if (this.connections_[i] != caller) {
                    if (printed) {
                        sb.append(", ");
                    }
                    printed = true;
                    sb.append(this.connections_[i].toString(this));
                }
                ++i;
            }
            return sb.toString();
        }

        public int rebuildPattern(ConstructionTool tool) {
            return this.rebuildPattern(tool, null, true);
        }

        public int redirectRebuildPattern(ConstructionTool tool) {
            return this.rebuildPattern(tool);
        }

        public void getAllConnections(ArrayList store, Connection caller) {
            int i = 0;
            while (i < this.connections_.length) {
                if (this.connections_[i] != caller) {
                    this.connections_[i].getAllConnections(store, this);
                }
                ++i;
            }
        }

        private final int getCallerIndex(Connection caller) {
            if (caller == null) {
                throw new IllegalArgumentException("getCallerIndex() called on null object");
            }
            if (caller == this.connections_[0]) {
                return 0;
            }
            if (caller == this.connections_[1]) {
                return 1;
            }
            if (caller == this.connections_[2]) {
                return 2;
            }
            throw new IllegalArgumentException("Unknown caller");
        }

        public int rebuildPattern(ConstructionTool tool, Connection caller, boolean firstPass) {
            if (firstPass) {
                int i = 0;
                while (i < this.connections_.length) {
                    if (this.connections_[i] != caller) {
                        UNode other = this.connections_[i].getOther(this);
                        other.rebuildPattern(tool, this.connections_[i], firstPass);
                    }
                    ++i;
                }
                if (caller == null) {
                    return this.rebuildPattern(tool, null, false);
                }
                return this.rebuildMyPattern(tool, this.getCallerIndex(caller));
            }
            int i = 0;
            while (i < this.connections_.length) {
                if (this.connections_[i] != caller) {
                    this.rebuildMyPattern(tool, i);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.connections_.length) {
                if (this.connections_[i2] != caller) {
                    this.connections_[i2].getOther(this).rebuildPattern(tool, this.connections_[i2], firstPass);
                }
                ++i2;
            }
            int max = 0;
            int i3 = 0;
            while (i3 < this.patterns_.length) {
                int count = this.patterns_[i3].getNumberOfPatterns();
                if (count > max) {
                    max = count;
                }
                ++i3;
            }
            return max;
        }

        public ConditionalProbabilityStore getLeftExtendedConditionalProbabilities(SubstitutionModel model, boolean modelChanged, Connection callingConnection, LHCalculator.External external, ConditionalProbabilityStore resultStore) {
            int callerIndex = this.getCallerIndex(callingConnection);
            Connection leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
            return leftConnection.getExtendedConditionalProbabilities(model, modelChanged, (UNode)this, external, resultStore);
        }

        public ConditionalProbabilityStore getRightExtendedConditionalProbabilities(SubstitutionModel model, boolean modelChanged, Connection callingConnection, LHCalculator.External external, ConditionalProbabilityStore resultStore) {
            int callerIndex = this.getCallerIndex(callingConnection);
            Connection rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
            return rightConnection.getExtendedConditionalProbabilities(model, modelChanged, (UNode)this, external, resultStore);
        }

        public PatternInfo getLeftPatternInfo(Connection caller) {
            int callerIndex = this.getCallerIndex(caller);
            Connection leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
            UNode other = leftConnection.getOther(this);
            return other.getPatternInfo(leftConnection);
        }

        public PatternInfo getRightPatternInfo(Connection caller) {
            int callerIndex = this.getCallerIndex(caller);
            Connection rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
            UNode other = rightConnection.getOther(this);
            return other.getPatternInfo(rightConnection);
        }

        public ConditionalProbabilityStore getFlatConditionalProbabilities(SubstitutionModel model, boolean modelChanged, Connection callerConnection, LHCalculator.External externalCalculator, ConditionalProbabilityStore resultStore) {
            int callerIndex = this.getCallerIndex(callerConnection);
            PatternInfo pi = this.patterns_[callerIndex];
            Connection leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
            Connection rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
            externalCalculator.calculateFlat(pi, leftConnection.getExtendedConditionalProbabilities(model, modelChanged, (UNode)this, 0, true), rightConnection.getExtendedConditionalProbabilities(model, modelChanged, (UNode)this, 0, false), resultStore);
            return resultStore;
        }

        public ConditionalProbabilityStore getFlatConditionalProbabilities(SubstitutionModel model, boolean modelChanged, Connection callerConnection, int depth, boolean isForLeft) {
            int callerIndex = this.getCallerIndex(callerConnection);
            PatternInfo pi = this.patterns_[callerIndex];
            Connection leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
            Connection rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
            boolean childrenChanged = this.topologyChangedSinceLastFlat_;
            this.topologyChangedSinceLastFlat_ = false;
            return this.calculator_.calculateFlat(pi, leftConnection.getExtendedConditionalProbabilities(model, modelChanged, (UNode)this, depth + 1, true), rightConnection.getExtendedConditionalProbabilities(model, modelChanged, (UNode)this, depth + 1, false), childrenChanged);
        }

        public ConditionalProbabilityStore getExtendedConditionalProbabilities(double distance, SubstitutionModel model, boolean modelChanged, Connection callerConnection, LHCalculator.External externalCalculator, ConditionalProbabilityStore resultStore) {
            int callerIndex = this.getCallerIndex(callerConnection);
            PatternInfo pi = this.patterns_[callerIndex];
            Connection leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
            Connection rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
            externalCalculator.calculateExtended(distance, model, pi, leftConnection.getExtendedConditionalProbabilities(model, modelChanged, (UNode)this, 0, true), rightConnection.getExtendedConditionalProbabilities(model, modelChanged, (UNode)this, 0, false), resultStore);
            return resultStore;
        }

        public ConditionalProbabilityStore getExtendedConditionalProbabilities(double distance, SubstitutionModel model, boolean modelChanged, Connection callerConnection, int depth, boolean isForLeft) {
            int callerIndex = this.getCallerIndex(callerConnection);
            PatternInfo pi = this.patterns_[callerIndex];
            Connection leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
            Connection rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
            boolean childrenChanged = this.topologyChangedSincleLastExtended_;
            this.topologyChangedSincleLastExtended_ = false;
            return this.calculator_.calculateExtended(distance, model, pi, leftConnection.getExtendedConditionalProbabilities(model, modelChanged, (UNode)this, depth + 1, true), rightConnection.getExtendedConditionalProbabilities(model, modelChanged, (UNode)this, depth + 1, false), modelChanged, childrenChanged);
        }

        private int rebuildMyPattern(ConstructionTool tool, int index) {
            Connection leftConnection = this.connections_[LEFT_LOOKUP[index]];
            Connection rightConnection = this.connections_[RIGHT_LOOKUP[index]];
            UNode left = leftConnection.getOther(this);
            UNode right = rightConnection.getOther(this);
            PatternInfo leftPattern = left.getPatternInfo(leftConnection);
            PatternInfo rightPattern = right.getPatternInfo(rightConnection);
            return tool.build(this.patterns_[index], leftPattern, rightPattern);
        }
    }

    private static interface UNode {
        public String toString(Connection var1);

        public PatternInfo getPatternInfo(Connection var1);

        public Node buildPALNode(double var1, Connection var3);

        public void testLikelihood(Connection var1, SubstitutionModel var2, ConstructionTool var3);

        public void getAllConnections(ArrayList var1, Connection var2);

        public int getIndex();

        public boolean hasDirectConnection(Connection var1);

        public boolean hasConnection(Connection var1, Connection var2);

        public void mark();

        public void undoToMark();

        public Connection extract(Connection var1);

        public Connection getLeft(Connection var1);

        public Connection getRight(Connection var1);

        public void setConnections(Connection[] var1, int var2);

        public void swapConnection(Connection var1, UNode var2, Connection var3);

        public void swapConnection(Connection var1, Connection var2);

        public int rebuildPattern(ConstructionTool var1, Connection var2, boolean var3);

        public int rebuildPattern(ConstructionTool var1);

        public int redirectRebuildPattern(ConstructionTool var1);

        public ConditionalProbabilityStore getFlatConditionalProbabilities(SubstitutionModel var1, boolean var2, Connection var3, int var4, boolean var5);

        public ConditionalProbabilityStore getFlatConditionalProbabilities(SubstitutionModel var1, boolean var2, Connection var3, LHCalculator.External var4, ConditionalProbabilityStore var5);

        public ConditionalProbabilityStore getLeftExtendedConditionalProbabilities(SubstitutionModel var1, boolean var2, Connection var3, LHCalculator.External var4, ConditionalProbabilityStore var5);

        public ConditionalProbabilityStore getRightExtendedConditionalProbabilities(SubstitutionModel var1, boolean var2, Connection var3, LHCalculator.External var4, ConditionalProbabilityStore var5);

        public PatternInfo getLeftPatternInfo(Connection var1);

        public PatternInfo getRightPatternInfo(Connection var1);

        public ConditionalProbabilityStore getExtendedConditionalProbabilities(double var1, SubstitutionModel var3, boolean var4, Connection var5, int var6, boolean var7);

        public ConditionalProbabilityStore getExtendedConditionalProbabilities(double var1, SubstitutionModel var3, boolean var4, Connection var5, LHCalculator.External var6, ConditionalProbabilityStore var7);
    }

    private static final class Workspace {
        private final double[][][][] conditionalLikelihoodTables_;
        private final double[] endStateProbabilityStore_;
        private final double[][][] transitionProbabilityStore_;
        private final int numberOfCategories_;
        private final int numberOfStates_;
        private final boolean[] locks_;

        public Workspace(int capacity, int maxNumberOfPatterns, ConstructionTool tool) {
            this.numberOfCategories_ = tool.getNumberOfTransitionCategories();
            this.numberOfStates_ = tool.getNumberOfStates();
            this.conditionalLikelihoodTables_ = new double[capacity][this.numberOfCategories_][maxNumberOfPatterns][tool.getNumberOfStates()];
            this.endStateProbabilityStore_ = new double[this.numberOfStates_];
            this.transitionProbabilityStore_ = new double[this.numberOfCategories_][this.numberOfStates_][this.numberOfStates_];
            this.locks_ = new boolean[capacity];
        }

        public final int getNumberOfCategories() {
            return this.numberOfCategories_;
        }

        public final int getNumberOfStates() {
            return this.numberOfStates_;
        }

        public final double[] getEndStateProbabilityStore() {
            return this.endStateProbabilityStore_;
        }

        public final int obtainLock() {
            int i = 0;
            while (i < this.locks_.length) {
                if (!this.locks_[i]) {
                    this.locks_[i] = true;
                    return i;
                }
                ++i;
            }
            throw new RuntimeException("Assertion error : no locks available");
        }

        public final double[][][] getTransitionProbabilityStore() {
            return this.transitionProbabilityStore_;
        }

        public final void returnLock(int lockNumber, double[][][] probabilities) {
            if (this.locks_[lockNumber]) {
                if (this.conditionalLikelihoodTables_[lockNumber] != probabilities) {
                    throw new IllegalArgumentException("Table mismatch");
                }
            } else {
                throw new IllegalArgumentException("Lock already unlocked:" + lockNumber);
            }
            this.locks_[lockNumber] = false;
        }

        public final void freeLock(int lockNumber) {
            if (!this.locks_[lockNumber]) {
                throw new IllegalArgumentException("Lock already unlocked:" + lockNumber);
            }
            this.locks_[lockNumber] = false;
        }

        public final double[][][] getConditionalProbabilityTable(int lockNumber) {
            if (this.locks_[lockNumber]) {
                return this.conditionalLikelihoodTables_[lockNumber];
            }
            throw new IllegalArgumentException("Accessing unlocked table:" + lockNumber);
        }
    }

    private static final class SPRAction
    implements UndoableAction {
        private Connection toRemove_ = null;
        private Connection attachmentPoint_ = null;
        private Connection reattachmentPoint_ = null;
        private final Connection[] allConnections_;
        private final Connection[] store_ = new Connection[3];
        private final double[] branchLengths_;
        private boolean lastActionSuccessful_ = false;
        private final Assessor assessor_;
        private final Markable subject_;
        private final MersenneTwisterFast random_;
        private final ConstructionTool tool_;

        public SPRAction(Connection[] allConnections, Markable subject, Assessor assessor, MersenneTwisterFast random, ConstructionTool tool) {
            this.allConnections_ = allConnections;
            this.subject_ = subject;
            this.assessor_ = assessor;
            this.tool_ = tool;
            this.branchLengths_ = new double[allConnections.length];
            this.random_ = random;
        }

        public SPRAction setRandomTargets() {
            int i = this.random_.nextInt(this.allConnections_.length);
            int j = this.random_.nextInt(this.allConnections_.length - 1);
            if (j >= i) {
                ++j;
            }
            this.toRemove_ = this.allConnections_[i];
            this.attachmentPoint_ = this.allConnections_[j];
            return this;
        }

        public SPRAction setTarget(Connection toRemove, Connection attachmentPoint) {
            this.toRemove_ = toRemove;
            this.attachmentPoint_ = attachmentPoint;
            return this;
        }

        public boolean isActionSuccessful() {
            return this.lastActionSuccessful_;
        }

        public double doSetupAction(double currentScore) {
            this.subject_.mark();
            this.reattachmentPoint_ = this.toRemove_.attachTo(this.attachmentPoint_, this.store_);
            boolean bl = this.lastActionSuccessful_ = this.reattachmentPoint_ != null;
            if (this.lastActionSuccessful_) {
                int i = 0;
                while (i < this.allConnections_.length) {
                    this.branchLengths_[i] = this.allConnections_[i].getBranchLength();
                    ++i;
                }
                this.toRemove_.setup(this.tool_, this.allConnections_);
            }
            return this.lastActionSuccessful_ ? this.assessor_.getCurrentValue() : currentScore;
        }

        public double doAction(double currentScore, double desparationValue) {
            this.setRandomTargets();
            return this.doSetupAction(currentScore);
        }

        public boolean isActionDeterministic() {
            return false;
        }

        public boolean undoAction() {
            if (this.lastActionSuccessful_) {
                this.subject_.undoToMark();
                return true;
            }
            throw new RuntimeException("Undo last called when last operation not successful");
        }
    }

    private static final class FullSweepSPRAction
    implements UndoableAction {
        private SPRAction baseAction_;
        private final Connection[] allConnections_;
        private boolean lastActionSuccessful_ = false;

        public FullSweepSPRAction(Connection[] allConnections, SPRAction baseAction) {
            this.baseAction_ = baseAction;
            this.allConnections_ = allConnections;
        }

        public double doAction(double originalScore, double desparationValue) {
            Connection bestStart = null;
            Connection bestEnd = null;
            double bestScore = originalScore;
            int i = 0;
            while (i < this.allConnections_.length) {
                Connection start = this.allConnections_[i];
                int j = i + 1;
                while (j < this.allConnections_.length) {
                    Connection end = this.allConnections_[i];
                    this.baseAction_.setTarget(start, end);
                    double score = this.baseAction_.doSetupAction(originalScore);
                    if (this.baseAction_.isActionSuccessful()) {
                        if (score > bestScore) {
                            bestStart = start;
                            bestEnd = end;
                            bestScore = score;
                        }
                        this.baseAction_.undoAction();
                    }
                    ++j;
                }
                ++i;
            }
            if (bestStart != null) {
                this.baseAction_.setTarget(bestStart, bestEnd);
                this.lastActionSuccessful_ = true;
                return this.baseAction_.doSetupAction(originalScore);
            }
            this.lastActionSuccessful_ = false;
            return originalScore;
        }

        public boolean isActionDeterministic() {
            return true;
        }

        public boolean isActionSuccessful() {
            return this.lastActionSuccessful_;
        }

        public boolean undoAction() {
            if (this.lastActionSuccessful_) {
                return this.baseAction_.undoAction();
            }
            throw new RuntimeException("Illegal operation : undoLast() called when last operation invalid (may already have been undone)");
        }
    }

    private static final class SweepSPRAction
    implements UndoableAction {
        private Connection toMove_ = null;
        private SPRAction baseAction_;
        private boolean lastActionSuccessful_ = false;
        private final Connection[] shuffledConnections_;
        private final MersenneTwisterFast random_;

        public SweepSPRAction(Connection[] allConnections, SPRAction baseAction, MersenneTwisterFast random) {
            this.baseAction_ = baseAction;
            this.random_ = random;
            this.shuffledConnections_ = new Connection[allConnections.length];
            System.arraycopy(allConnections, 0, this.shuffledConnections_, 0, allConnections.length);
        }

        public SweepSPRAction setRandomTarget() {
            return this.setTarget(this.shuffledConnections_[this.random_.nextInt(this.shuffledConnections_.length)]);
        }

        public SweepSPRAction setTarget(Connection toMove) {
            this.toMove_ = toMove;
            this.shuffle(this.shuffledConnections_);
            return this;
        }

        public boolean isActionDeterministic() {
            return false;
        }

        private final void shuffle(Connection[] cs) {
            int i = 0;
            while (i < cs.length) {
                int j = this.random_.nextInt(cs.length - i) + i;
                Connection t = cs[i];
                cs[i] = cs[j];
                cs[j] = t;
                ++i;
            }
        }

        public double doAction(double originalScore, double desparationValue) {
            this.setRandomTarget();
            return this.doSetupAction(originalScore);
        }

        public double doSetupAction(double originalScore) {
            Connection best = null;
            double bestScore = originalScore;
            int i = 0;
            while (i < this.shuffledConnections_.length) {
                Connection c = this.shuffledConnections_[i];
                if (c != this.toMove_) {
                    this.baseAction_.setTarget(this.toMove_, c);
                    double score = this.baseAction_.doSetupAction(originalScore);
                    if (this.baseAction_.isActionSuccessful()) {
                        if (score > bestScore) {
                            best = c;
                            bestScore = score;
                        }
                        this.baseAction_.undoAction();
                    }
                }
                ++i;
            }
            if (best != null) {
                this.baseAction_.setTarget(this.toMove_, best);
                this.lastActionSuccessful_ = true;
                return this.baseAction_.doSetupAction(originalScore);
            }
            this.lastActionSuccessful_ = false;
            return originalScore;
        }

        public boolean isActionSuccessful() {
            return this.lastActionSuccessful_;
        }

        public boolean undoAction() {
            if (this.lastActionSuccessful_) {
                return this.baseAction_.undoAction();
            }
            throw new RuntimeException("Illegal operation : undoLast() called when last operation invalid (may already have been undone)");
        }
    }

    private static final class NNIAction
    implements UndoableAction {
        private boolean leftSwapLeft_;
        private boolean rightSwapLeft_;
        private Connection connection_;
        private final Connection[] allConnections_;
        private final double[] branchLengths_;
        private final Assessor assessor_;
        private boolean lastActionSuccessful_ = false;
        private final MersenneTwisterFast random_;
        private final ConstructionTool tool_;

        public NNIAction(Connection[] allConnections, Assessor assessor, MersenneTwisterFast r, ConstructionTool tool) {
            this.allConnections_ = allConnections;
            this.assessor_ = assessor;
            this.random_ = r;
            this.tool_ = tool;
            this.branchLengths_ = new double[allConnections.length];
        }

        public double doAction(double currentScore, double desparationValue) {
            this.connection_ = this.allConnections_[this.random_.nextInt(this.allConnections_.length)];
            this.leftSwapLeft_ = this.random_.nextBoolean();
            this.rightSwapLeft_ = this.random_.nextBoolean();
            this.lastActionSuccessful_ = this.connection_.doNNI(this.leftSwapLeft_, this.rightSwapLeft_);
            if (this.lastActionSuccessful_) {
                int i = 0;
                while (i < this.allConnections_.length) {
                    this.branchLengths_[i] = this.allConnections_[i].getBranchLength();
                    ++i;
                }
                this.connection_.setup(this.tool_, this.allConnections_);
                return this.assessor_.getCurrentValue();
            }
            return currentScore;
        }

        public boolean isActionDeterministic() {
            return false;
        }

        public boolean isActionSuccessful() {
            return this.lastActionSuccessful_;
        }

        public boolean undoAction() {
            if (this.lastActionSuccessful_) {
                this.connection_.doNNI(this.leftSwapLeft_, this.rightSwapLeft_);
                int i = 0;
                while (i < this.allConnections_.length) {
                    this.allConnections_[i].setBranchLength(this.branchLengths_[i]);
                    ++i;
                }
                this.connection_.setup(this.tool_, this.allConnections_);
                this.lastActionSuccessful_ = false;
                return true;
            }
            throw new RuntimeException("Illegal operation : undoLast() called when last operation invalid (may already have been undone)");
        }
    }

    private static final class ModelOptimiseAction
    implements UndoableAction,
    MultivariateFunction {
        private final Connection treeAccess_;
        private final MultivariateMinimum minimiser_;
        private final MinimiserMonitor monitor_;
        private final SubstitutionModel model_;
        private final double[] modelParameterStore_;
        private final double[] xvec_;
        private final int fxDigits_;
        private final int xDigits_;
        private final LHCalculator.External calculator_;
        private final ConstructionTool tool_;

        public ModelOptimiseAction(Connection treeAccess, MultivariateMinimum minimiser, MinimiserMonitor monitor, SubstitutionModel model, int fxDigits, int xDigits, ConstructionTool tool) {
            this.treeAccess_ = treeAccess;
            this.minimiser_ = minimiser;
            this.monitor_ = monitor;
            this.model_ = model;
            this.tool_ = tool;
            this.calculator_ = this.tool_.allocateNewExternalCalculator();
            this.modelParameterStore_ = new double[model.getNumParameters()];
            this.xvec_ = new double[model.getNumParameters()];
            this.xDigits_ = xDigits;
            this.fxDigits_ = fxDigits;
        }

        public double evaluate(double[] xvec) {
            int i = 0;
            while (i < xvec.length) {
                this.model_.setParameter(xvec[i], i);
                ++i;
            }
            return -this.treeAccess_.calculateLogLikelihood(this.model_, true, this.calculator_, this.tool_);
        }

        public int getNumArguments() {
            return this.xvec_.length;
        }

        public double getLowerBound(int n) {
            return this.model_.getLowerLimit(n);
        }

        public double getUpperBound(int n) {
            return this.model_.getUpperLimit(n);
        }

        public OrthogonalHints getOrthogonalHints() {
            return this.model_.getOrthogonalHints();
        }

        public boolean isActionDeterministic() {
            return true;
        }

        public double doAction(double currentScore, double desparationValue) {
            int i = 0;
            while (i < this.modelParameterStore_.length) {
                this.modelParameterStore_[i] = this.model_.getParameter(i);
                ++i;
            }
            System.arraycopy(this.modelParameterStore_, 0, this.xvec_, 0, this.xvec_.length);
            double minimum = -this.minimiser_.findMinimum(this, this.xvec_, this.fxDigits_, this.xDigits_, this.monitor_);
            int i2 = 0;
            while (i2 < this.xvec_.length) {
                this.model_.setParameter(this.xvec_[i2], i2);
                ++i2;
            }
            return minimum;
        }

        public boolean isActionSuccessful() {
            return true;
        }

        public boolean undoAction() {
            int i = 0;
            while (i < this.modelParameterStore_.length) {
                this.model_.setParameter(this.modelParameterStore_[i], i);
                ++i;
            }
            return true;
        }
    }

    private static final class BranchLengthWithModelOptimiseAction
    implements UndoableAction,
    MultivariateFunction {
        private final StoppingCriteria stopper_;
        private final AlgorithmCallback callback_;
        private final double[] branchLengths_;
        private final Connection[] allConnections_;
        private final MultivariateMinimum minimiser_;
        private final MinimiserMonitor monitor_;
        private final SubstitutionModel model_;
        private final double[] modelParameterStore_;
        private final double[] xvec_;
        private final int fxDigits_;
        private final int xDigits_;
        private final LHCalculator.External calculator_;
        private final UnivariateMinimum um_;
        private final OptimisationHandler optimisationHandler_;
        private final ConstructionTool tool_;

        public BranchLengthWithModelOptimiseAction(ConstructionTool tool, Connection[] allConnections, StoppingCriteria stopper, AlgorithmCallback callback, MultivariateMinimum minimiser, MinimiserMonitor monitor, SubstitutionModel model, int fxDigits, int xDigits) {
            this.stopper_ = stopper;
            this.stopper_.reset();
            this.tool_ = tool;
            this.callback_ = callback;
            this.allConnections_ = allConnections;
            this.branchLengths_ = new double[allConnections.length];
            this.minimiser_ = minimiser;
            this.monitor_ = monitor;
            this.model_ = model;
            this.calculator_ = tool.allocateNewExternalCalculator();
            this.modelParameterStore_ = new double[model.getNumParameters()];
            this.xvec_ = new double[model.getNumParameters()];
            this.xDigits_ = xDigits;
            this.fxDigits_ = fxDigits;
            this.um_ = new UnivariateMinimum();
            this.optimisationHandler_ = new OptimisationHandler(this.model_, tool);
        }

        public double evaluate(double[] xvec) {
            int i = 0;
            while (i < xvec.length) {
                this.model_.setParameter(xvec[i], i);
                ++i;
            }
            return -this.allConnections_[0].calculateLogLikelihood(this.model_, true, this.calculator_, this.tool_);
        }

        public int getNumArguments() {
            return this.xvec_.length;
        }

        public double getLowerBound(int n) {
            return this.model_.getLowerLimit(n);
        }

        public double getUpperBound(int n) {
            return this.model_.getUpperLimit(n);
        }

        public OrthogonalHints getOrthogonalHints() {
            return this.model_.getOrthogonalHints();
        }

        public double doAction(double currentScore, double desparationValue) {
            int i = 0;
            while (i < this.allConnections_.length) {
                this.branchLengths_[i] = this.allConnections_[i].getBranchLength();
                ++i;
            }
            int i2 = 0;
            while (i2 < this.modelParameterStore_.length) {
                this.modelParameterStore_[i2] = this.model_.getParameter(i2);
                ++i2;
            }
            this.stopper_.reset();
            System.arraycopy(this.modelParameterStore_, 0, this.xvec_, 0, this.xvec_.length);
            double minimum = Double.POSITIVE_INFINITY;
            boolean firstTime = true;
            while (!this.stopper_.isTimeToStop()) {
                int i3 = 0;
                while (i3 < this.allConnections_.length) {
                    Connection c = this.allConnections_[i3];
                    this.optimisationHandler_.setup(c, firstTime);
                    firstTime = false;
                    this.um_.findMinimum(c.getBranchLength(), this.optimisationHandler_);
                    c.setBranchLength(this.um_.minx);
                    minimum = this.minimiser_.findMinimum(this, this.xvec_, this.fxDigits_, this.xDigits_, this.monitor_);
                    int x = 0;
                    while (x < this.xvec_.length) {
                        this.model_.setParameter(this.xvec_[x], x);
                        ++x;
                    }
                    c.setBranchLength(this.um_.minx);
                    ++i3;
                }
                this.stopper_.newIteration(minimum, minimum, true, true, this.callback_);
            }
            return -minimum;
        }

        public boolean isActionSuccessful() {
            return true;
        }

        public boolean undoAction() {
            int i = 0;
            while (i < this.allConnections_.length) {
                this.allConnections_[i].setBranchLength(this.branchLengths_[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.modelParameterStore_.length) {
                this.model_.setParameter(this.modelParameterStore_[i2], i2);
                ++i2;
            }
            return true;
        }

        public boolean isActionDeterministic() {
            return false;
        }
    }

    private final class BranchLengthOptimiseAction
    implements UndoableAction {
        private final StoppingCriteria stopper_;
        private final AlgorithmCallback callback_;
        private final double[] branchLengths_;
        private final Connection[] allConnections_;

        public BranchLengthOptimiseAction(Connection[] allConnections, StoppingCriteria stopper, AlgorithmCallback callback) {
            this.stopper_ = stopper;
            this.stopper_.reset();
            this.callback_ = callback;
            this.allConnections_ = allConnections;
            this.branchLengths_ = new double[allConnections.length];
        }

        public double doAction(double currentScore, double desparationValue) {
            int i = 0;
            while (i < this.allConnections_.length) {
                this.branchLengths_[i] = this.allConnections_[i].getBranchLength();
                ++i;
            }
            return UnrootedMLSearcher.this.simpleOptimiseLikelihood(this.stopper_, this.callback_);
        }

        public boolean isActionSuccessful() {
            return true;
        }

        public boolean undoAction() {
            int i = 0;
            while (i < this.allConnections_.length) {
                this.allConnections_[i].setBranchLength(this.branchLengths_[i]);
                ++i;
            }
            return true;
        }

        public boolean isActionDeterministic() {
            return false;
        }
    }

    private static final class NNIBranchLengthOptimiseAction
    implements UndoableAction {
        private final StoppingCriteria stopper_;
        private final AlgorithmCallback callback_;
        private final Connection[] allConnections_;
        private NNIOptimisationHandler handler_;

        public NNIBranchLengthOptimiseAction(Connection[] allConnections, SubstitutionModel model, StoppingCriteria stopper, AlgorithmCallback callback, ConstructionTool tool) {
            this.stopper_ = stopper;
            this.stopper_.reset();
            this.callback_ = callback;
            this.allConnections_ = allConnections;
            this.handler_ = new NNIOptimisationHandler(allConnections, model, tool);
        }

        public double doAction(double currentScore, double desparationValue) {
            this.stopper_.reset();
            double maximum = Double.NEGATIVE_INFINITY;
            boolean firstTime = true;
            while (!this.stopper_.isTimeToStop()) {
                int i = 0;
                while (i < this.allConnections_.length) {
                    Connection c = this.allConnections_[i];
                    maximum = this.handler_.optimiseSimulataneousNNIBranchLength(c, firstTime);
                    firstTime = false;
                    ++i;
                }
                this.stopper_.newIteration(maximum, maximum, true, true, this.callback_);
            }
            return maximum;
        }

        public boolean isActionSuccessful() {
            return true;
        }

        public boolean undoAction() {
            return false;
        }

        public boolean isActionDeterministic() {
            return false;
        }
    }

    private final class SimpleAssessor
    implements Assessor {
        private final StoppingCriteria stopper_;
        private final AlgorithmCallback callback_;

        public SimpleAssessor(StoppingCriteria stopper, AlgorithmCallback callback) {
            this.stopper_ = stopper;
            this.stopper_.reset();
            this.callback_ = callback;
        }

        public double getCurrentValue() {
            return UnrootedMLSearcher.this.simpleOptimiseLikelihood(this.stopper_, this.callback_);
        }
    }

    public static final class StateObject {
        private final double[] branchLengths_;
        private final int[] connectionInfo_;

        public StateObject(Connection[] allConnections) {
            this.branchLengths_ = new double[allConnections.length];
            this.connectionInfo_ = new int[allConnections.length * 2];
            int i = 0;
            while (i < allConnections.length) {
                this.branchLengths_[i] = allConnections[i].getBranchLength();
                allConnections[i].fillInConnectionState(this.connectionInfo_, i * 2);
                ++i;
            }
        }

        private final int fillIn(Connection[] store, int nodeIndex, Connection[] allConnections) {
            int found = 0;
            int i = 0;
            while (i < allConnections.length) {
                if (this.connectionInfo_[i * 2] == nodeIndex || this.connectionInfo_[i * 2 + 1] == nodeIndex) {
                    store[found++] = allConnections[i];
                }
                ++i;
            }
            return found;
        }

        public final void rebuildTree(Connection[] allConnections, UNode[] orderedNodes) {
            int i = 0;
            while (i < allConnections.length) {
                allConnections[i].setNodes(orderedNodes[this.connectionInfo_[i * 2]], orderedNodes[this.connectionInfo_[i * 2 + 1]]);
                ++i;
            }
            Connection[] store = new Connection[3];
            int nodeIndex = 0;
            while (nodeIndex < orderedNodes.length) {
                int found = this.fillIn(store, nodeIndex, allConnections);
                orderedNodes[nodeIndex].setConnections(store, found);
                ++nodeIndex;
            }
        }

        public boolean equals(Object o) {
            if (o instanceof StateObject) {
                StateObject so = (StateObject)o;
                int[] other = so.connectionInfo_;
                int i = 0;
                while (i < this.connectionInfo_.length) {
                    if (this.connectionInfo_[i] != other[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
    }
}

