/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.tree.ParameterizedTree;
import pal.tree.Tree;
import pal.tree.TreeRooter;

public class UnconstrainedTree
extends ParameterizedTree.ParameterizedTreeBase
implements ParameterizedTree {
    public UnconstrainedTree(Tree t) {
        this.setBaseTree(t);
        if (this.getRoot().getChildCount() < 3) {
            throw new IllegalArgumentException("The root node must have at least three childs!");
        }
        int i = 0;
        while (i < this.getNumParameters()) {
            this.setParameter(this.getDefaultValue(i), i);
            ++i;
        }
    }

    protected UnconstrainedTree(UnconstrainedTree toCopy) {
        super(toCopy);
    }

    public int getNumParameters() {
        return this.getInternalNodeCount() + this.getExternalNodeCount() - 1;
    }

    public void setParameter(double param, int n) {
        if (n < this.getExternalNodeCount()) {
            this.getExternalNode(n).setBranchLength(param);
        } else {
            this.getInternalNode(n - this.getExternalNodeCount()).setBranchLength(param);
        }
    }

    public String getParameterizationInfo() {
        return "Unconstrained tree";
    }

    public double getParameter(int n) {
        if (n < this.getExternalNodeCount()) {
            return this.getExternalNode(n).getBranchLength();
        }
        return this.getInternalNode(n - this.getExternalNodeCount()).getBranchLength();
    }

    public void setParameterSE(double paramSE, int n) {
        if (n < this.getExternalNodeCount()) {
            this.getExternalNode(n).setBranchLengthSE(paramSE);
        } else {
            this.getInternalNode(n - this.getExternalNodeCount()).setBranchLengthSE(paramSE);
        }
    }

    public double getLowerLimit(int n) {
        return 1.0E-9;
    }

    public double getUpperLimit(int n) {
        return 1.0;
    }

    public double getDefaultValue(int n) {
        return 0.04;
    }

    public Tree getCopy() {
        return new UnconstrainedTree(this);
    }

    public static final ParameterizedTree.Factory getParameterizedTreeFactory() {
        return TreeFactory.DEFAULT_INSTANCE;
    }

    private static class TreeFactory
    implements ParameterizedTree.Factory {
        public static final ParameterizedTree.Factory DEFAULT_INSTANCE = new TreeFactory();

        private TreeFactory() {
        }

        public ParameterizedTree generateNewTree(Tree base) {
            if (base.getRoot().getChildCount() == 2) {
                base = new TreeRooter(base).getUnrootedTree();
            }
            return new UnconstrainedTree(base);
        }
    }
}

