/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.misc.Utils;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.tree.SimpleTree;
import pal.tree.Tree;
import pal.tree.TreeIterator;
import pal.util.AlgorithmCallback;

public class TreeRooter {
    public static final int MIMIC_CONSTRUCTION = 100;
    public static final int EXPAND_CONSTRUCTION = 200;
    public static final int REDUCE_CONSTRUCTION = 300;
    private Connection unrootedTree_;
    private final int units_;
    private final double firstChildNodeLength_;
    private final boolean inputTreeUnrooted_;
    private static final ConnectionMethodCaller ASSERT_PATH_INFO_CALLER = new ConnectionMethodCaller(){

        public void callOn(Connection c, UndirectedNode callingNode) {
            c.assertPathInfo(callingNode);
        }
    };
    private static final ConnectionMethodCaller CLEAR_PATH_INFO_CALLER = new ConnectionMethodCaller(){

        public void callOn(Connection c, UndirectedNode callingNode) {
            c.clearPathInfo(callingNode);
        }
    };
    private static final ConnectionMethodCaller UPDATE_PATH_INFO_CALLER = new ConnectionMethodCaller(){

        public void callOn(Connection c, UndirectedNode callingNode) {
            c.updatePathInfo(callingNode);
        }
    };
    private static final ConnectionMethodCaller GET_NUMBER_OF_CONNECTIONS_CALLER = new ConnectionMethodCaller(){

        public void callOn(Connection c, UndirectedNode callingNode) {
            c.getNumberOfConnections(callingNode);
        }
    };

    public TreeRooter(Tree base, int constructionMode) {
        this(base.getRoot(), base.getUnits(), constructionMode);
    }

    public TreeRooter(Tree base) {
        this(base.getRoot(), base.getUnits());
    }

    public TreeRooter(Node base) {
        this(base, 5);
    }

    public TreeRooter(Node base, int units) {
        this(base, units, 100);
    }

    public TreeRooter(Node base, int units, int constructionMode) {
        this.unrootedTree_ = TreeRooter.construct(base, constructionMode);
        this.inputTreeUnrooted_ = base.getChildCount() > 2;
        this.firstChildNodeLength_ = base.getChild(0).getBranchLength();
        this.units_ = units;
        this.unrootedTree_.clearPathInfo();
    }

    private static final Connection construct(Node n, int constructionMode) {
        if (n.getChildCount() == 2) {
            return new Connection(n.getChild(0), n.getChild(1), constructionMode);
        }
        UndirectedNode un = new UndirectedNode(n, constructionMode);
        return un.getPeerParentConnection();
    }

    public Node getMidPointRooted() {
        return this.unrootedTree_.getMidPointRooted();
    }

    public Node getDefaultRoot() {
        return this.unrootedTree_.getRootedAround(this.firstChildNodeLength_);
    }

    public Node getAsInputRooting() {
        if (this.inputTreeUnrooted_) {
            return this.getUnrooted();
        }
        return this.getDefaultRoot();
    }

    public Tree getAsInputRootingTree() {
        return TreeRooter.constructTree(this.getAsInputRooting(), this.units_);
    }

    public Tree getDefaultRootTree() {
        return TreeRooter.constructTree(this.getDefaultRoot(), this.units_);
    }

    public Tree getMidPointRootedTree() {
        return TreeRooter.constructTree(this.getMidPointRooted(), this.units_);
    }

    public Node getUnrooted() {
        return this.unrootedTree_.getUnrooted();
    }

    public Tree getUnrootedTree() {
        return TreeRooter.constructTree(this.getUnrooted(), this.units_);
    }

    private Connection[] getAllConnections() {
        return this.unrootedTree_.getAllConnections();
    }

    public Node getRootedBy(String[] outgroupNames) {
        return this.unrootedTree_.getRootedAroundMRCA(outgroupNames);
    }

    public Node getRootedBy(String[] outgroupNames, double ingroupBranchLength) {
        return this.unrootedTree_.getRootedAroundMRCA(outgroupNames, ingroupBranchLength);
    }

    public Node[] getAllRootedBy(String[] outgroupNames) {
        return this.unrootedTree_.getAllRootedAroundMRCA(outgroupNames);
    }

    public Tree getTreeRootedBy(String[] outgroupNames) {
        return TreeRooter.constructTree(this.getRootedBy(outgroupNames), this.units_);
    }

    public Tree getTreeRootedBy(String[] outgroupNames, double ingroupBranchLength) {
        return TreeRooter.constructTree(this.getRootedBy(outgroupNames, ingroupBranchLength), this.units_);
    }

    public Tree[] getAllTreesRootedBy(String[] outgroupNames) {
        Node[] nodes = this.getAllRootedBy(outgroupNames);
        Tree[] trees = new Tree[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            trees[i] = TreeRooter.constructTree(nodes[i], this.units_);
            ++i;
        }
        return trees;
    }

    public TreeIterator getEveryRootIterator() {
        return new RootIterator(this.getAllConnections(), this.units_);
    }

    public Tree[] getEveryRoot() {
        Connection[] connections = this.getAllConnections();
        Tree[] results = new Tree[connections.length];
        int i = 0;
        while (i < connections.length) {
            results[i] = TreeRooter.constructTree(connections[i].getRootedAround(), this.units_);
            ++i;
        }
        return results;
    }

    public Node getRootedAbove(Node n) {
        UndirectedNode match = this.unrootedTree_.getRelatedNode(n);
        if (match == null) {
            throw new IllegalArgumentException("Parameter node not found in original tree");
        }
        return match.getPeerParentConnection().getRootedAround();
    }

    public Tree getTreeRootedAbove(Node n) {
        return TreeRooter.constructTree(this.getRootedAbove(n), this.units_);
    }

    public static final Tree getUnrooted(Tree base) {
        return new TreeRooter(base).getUnrootedTree();
    }

    public static final Tree getMidpointRooted(Tree base) {
        return new TreeRooter(base).getMidPointRootedTree();
    }

    public static final Tree[] getEveryRoot(Tree base) {
        return new TreeRooter(base).getEveryRoot();
    }

    public static final TreeIterator getEveryRootIterator(Tree base) {
        return new TreeRooter(base).getEveryRootIterator();
    }

    public static final Tree getRootedBy(Tree base, String[] outgroupNames) {
        return new TreeRooter(base).getTreeRootedBy(outgroupNames);
    }

    public static final Tree getRootedBy(Tree base, String[] outgroupNames, double ingroupBranchLength) {
        return new TreeRooter(base).getTreeRootedBy(outgroupNames, ingroupBranchLength);
    }

    public static final Tree[] getAllRootingsBy(Tree base, String[] outgroupNames) {
        return new TreeRooter(base).getAllTreesRootedBy(outgroupNames);
    }

    private static final Tree constructTree(Node n, int units) {
        SimpleTree st = new SimpleTree(n);
        st.setUnits(units);
        return st;
    }

    private static final boolean contains(String[] names, String name) {
        int i = 0;
        while (i < names.length) {
            if (name.equals(names[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final class RootIterator
    implements TreeIterator {
        private final Connection[] connections_;
        private final int units_;
        private int currentConnection_;

        public RootIterator(Connection[] connections, int units) {
            this.connections_ = connections;
            this.units_ = units;
            this.currentConnection_ = 0;
        }

        public Tree getNextTree(AlgorithmCallback callback) {
            return TreeRooter.constructTree(this.connections_[this.currentConnection_++].getRootedAround(), this.units_);
        }

        public boolean isMoreTrees() {
            return this.currentConnection_ != this.connections_.length;
        }
    }

    private static final class UndirectedNode {
        private Connection[] connectedNodes_;
        private final Node peer_;

        private UndirectedNode(Connection connection, int childStartingIndex, Node parent) {
            this.peer_ = null;
            this.connectedNodes_ = new Connection[3];
            int numberOfChildren = parent.getChildCount();
            this.connectedNodes_[0] = connection;
            if (numberOfChildren - childStartingIndex == 2) {
                this.connectedNodes_[1] = new Connection(this, parent.getChild(childStartingIndex), 200);
                this.connectedNodes_[2] = new Connection(this, parent.getChild(childStartingIndex + 1), 200);
            } else {
                this.connectedNodes_[1] = new Connection(this, parent.getChild(childStartingIndex), 200);
                this.connectedNodes_[2] = new Connection(this, parent, childStartingIndex + 1, 0.0);
            }
        }

        public UndirectedNode(Node peer, int constructionMode) {
            int numberOfChildren = peer.getChildCount();
            if (numberOfChildren <= 2) {
                throw new IllegalArgumentException("Peer must have at least three children!");
            }
            this.peer_ = peer;
            if (constructionMode == 300) {
                int numberOfReducedChildren = UndirectedNode.countReducedChildren(peer);
                this.connectedNodes_ = new Connection[numberOfReducedChildren];
                int i = 0;
                while (i < numberOfReducedChildren) {
                    Connection c;
                    this.connectedNodes_[i] = c = new Connection(this, UndirectedNode.getReducedChild(peer, i), 300);
                    ++i;
                }
            } else if (constructionMode == 100 || numberOfChildren <= 3) {
                this.connectedNodes_ = new Connection[numberOfChildren];
                int i = 0;
                while (i < numberOfChildren) {
                    this.connectedNodes_[i] = new Connection(this, peer.getChild(i), constructionMode);
                    ++i;
                }
            } else {
                this.connectedNodes_ = new Connection[3];
                this.connectedNodes_[0] = new Connection(this, peer.getChild(0), constructionMode);
                this.connectedNodes_[1] = new Connection(this, peer.getChild(1), constructionMode);
                this.connectedNodes_[2] = new Connection(this, peer, 2, 0.0);
            }
        }

        private UndirectedNode(int constructionMode, Connection parentConnection, Node peer) {
            this.peer_ = peer;
            int numberOfChildren = peer.getChildCount();
            if (constructionMode == 300) {
                int numberOfReducedChildren = UndirectedNode.countReducedChildren(peer);
                this.connectedNodes_ = new Connection[numberOfReducedChildren + 1];
                this.connectedNodes_[0] = parentConnection;
                int i = 0;
                while (i < numberOfReducedChildren) {
                    Connection c;
                    this.connectedNodes_[i + 1] = c = new Connection(this, UndirectedNode.getReducedChild(peer, i), 300);
                    ++i;
                }
            } else if (constructionMode == 100 || numberOfChildren <= 2) {
                this.connectedNodes_ = new Connection[numberOfChildren + 1];
                this.connectedNodes_[0] = parentConnection;
                int i = 0;
                while (i < numberOfChildren) {
                    this.connectedNodes_[i + 1] = new Connection(this, peer.getChild(i), constructionMode);
                    ++i;
                }
            } else {
                this.connectedNodes_ = new Connection[3];
                this.connectedNodes_[0] = parentConnection;
                this.connectedNodes_[1] = new Connection(this, peer.getChild(0), constructionMode);
                this.connectedNodes_[2] = new Connection(this, peer, 1, 0.0);
            }
        }

        private static final int countReducedChildren(Node base) {
            int count = 0;
            int childCount = base.getChildCount();
            int i = 0;
            while (i < childCount) {
                Node c = base.getChild(i);
                count = !c.isLeaf() && c.getBranchLength() <= 1.0E-9 ? (count += UndirectedNode.countReducedChildren(c)) : ++count;
                ++i;
            }
            return count;
        }

        private static final Node getReducedChild(Node base, int childIndex) {
            int childCount = base.getChildCount();
            int i = 0;
            while (i < childCount) {
                Node c = base.getChild(i);
                if (!c.isLeaf() && c.getBranchLength() <= 1.0E-9) {
                    Node rc = UndirectedNode.getReducedChild(c, childIndex);
                    if (rc != null) {
                        return rc;
                    }
                    childIndex -= UndirectedNode.countReducedChildren(c);
                } else {
                    if (childIndex == 0) {
                        return c;
                    }
                    --childIndex;
                }
                ++i;
            }
            return null;
        }

        public Connection getPeerParentConnection() {
            return this.connectedNodes_[0];
        }

        private void assertCallingConnection(Connection callingConnection) {
            boolean found = false;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                if (this.connectedNodes_[i] == callingConnection) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                throw new RuntimeException("Assertion error : calling connection not one of my connections");
            }
        }

        public void callMethodOnConnections(Connection callingConnection, ConnectionMethodCaller caller) {
            this.assertCallingConnection(callingConnection);
            int i = 0;
            while (i < this.connectedNodes_.length) {
                if (this.connectedNodes_[i] != callingConnection) {
                    caller.callOn(this.connectedNodes_[i], this);
                }
                ++i;
            }
        }

        public int getNumberOfConnections() {
            return this.getNumberOfConnections(null);
        }

        public int getNumberOfConnections(Connection callingConnection) {
            int count = 0;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (c != callingConnection) {
                    count += c.getNumberOfConnections(this);
                }
                ++i;
            }
            return count;
        }

        public Connection[] getAllConnections() {
            int size = this.getNumberOfConnections();
            Connection[] array = new Connection[size];
            this.getConnections(array, 0);
            return array;
        }

        public int getConnections(Connection[] array, int index) {
            return this.getConnections(null, array, index);
        }

        public int getConnections(Connection callingConnection, Connection[] array, int index) {
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (c != callingConnection) {
                    index = c.getConnections(this, array, index);
                }
                ++i;
            }
            return index;
        }

        private final Connection getMidPointConnection(Connection callingConnection, Connection best) {
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (c != callingConnection) {
                    best = c.getMidPointConnection(this, best);
                }
                ++i;
            }
            return best;
        }

        public final Connection getMRCAConnectionBaseTraverse(Connection callingConnection, String[] nodeNames) {
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection mrca;
                Connection c = this.connectedNodes_[i];
                if (c != callingConnection && (mrca = c.getMRCAConnectionBaseTraverse(this, nodeNames)) != null) {
                    return mrca;
                }
                ++i;
            }
            return null;
        }

        public final int getAllMRCAConnectionBaseTraverse(Connection callingConnection, String[] nodeNames, Connection[] store, int numberInStore) {
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (c != callingConnection) {
                    numberInStore = c.getAllMRCAConnectionBaseTraverse(this, nodeNames, store, numberInStore);
                }
                ++i;
            }
            return numberInStore;
        }

        public final boolean isLeaf() {
            return this.connectedNodes_.length <= 1;
        }

        public double getMaximumPathLengthToLeaf(Connection blockingConnection) {
            double maxPathLength = 0.0;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (this.connectedNodes_[i] != blockingConnection) {
                    UndirectedNode other = c.getOtherEnd(this);
                    double length = c.getMaxLengthToLeaf(this) + c.getDistance();
                    maxPathLength = Math.max(maxPathLength, length);
                }
                ++i;
            }
            return maxPathLength;
        }

        public Node buildTree(Connection blockingConnection, double distance) {
            if (this.connectedNodes_.length == 1) {
                return NodeFactory.createNodeBranchLength(distance, this.peer_.getIdentifier());
            }
            Node[] children = new Node[this.connectedNodes_.length - 1];
            int addIndex = 0;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                if (blockingConnection != this.connectedNodes_[i]) {
                    UndirectedNode other = this.connectedNodes_[i].getOtherEnd(this);
                    children[addIndex++] = other.buildTree(this.connectedNodes_[i], this.connectedNodes_[i].distance_);
                }
                ++i;
            }
            return NodeFactory.createNodeBranchLength(distance, children);
        }

        public Node buildUnrootedTree() {
            if (this.connectedNodes_.length == 1) {
                return NodeFactory.createNode(this.peer_.getIdentifier());
            }
            Node[] children = new Node[this.connectedNodes_.length];
            int i = 0;
            while (i < this.connectedNodes_.length) {
                UndirectedNode other = this.connectedNodes_[i].getOtherEnd(this);
                children[i] = other.buildTree(this.connectedNodes_[i], this.connectedNodes_[i].distance_);
                ++i;
            }
            return NodeFactory.createNode(children);
        }

        public UndirectedNode getMRCA(Connection callingConnection, String[] nodeNames) {
            if (this.isLeaf()) {
                if (TreeRooter.contains(nodeNames, this.peer_.getIdentifier().getName())) {
                    return this;
                }
                return null;
            }
            int count = 0;
            UndirectedNode lastMRCA = null;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                UndirectedNode other;
                UndirectedNode mrca;
                Connection c = this.connectedNodes_[i];
                if (callingConnection != c && (mrca = (other = c.getOtherEnd(this)).getMRCA(c, nodeNames)) != null) {
                    ++count;
                    lastMRCA = mrca;
                }
                ++i;
            }
            switch (count) {
                case 0: {
                    return null;
                }
                case 1: {
                    return lastMRCA;
                }
            }
            return this;
        }

        public Connection getMRCAConnection(Connection callingConnection, String[] nodeNames) {
            if (this.isLeaf()) {
                if (TreeRooter.contains(nodeNames, this.peer_.getIdentifier().getName())) {
                    return callingConnection;
                }
                return null;
            }
            int count = 0;
            Connection lastMRCA = null;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection mrca;
                Connection c = this.connectedNodes_[i];
                if (callingConnection != c && (mrca = c.getMRCAConnection(this, nodeNames)) != null) {
                    ++count;
                    lastMRCA = mrca;
                }
                ++i;
            }
            switch (count) {
                case 0: {
                    return null;
                }
                case 1: {
                    return lastMRCA;
                }
            }
            return callingConnection;
        }

        private UndirectedNode getRelatedNode(Node peer, Connection callerConnection) {
            if (this.peer_ == peer) {
                return this;
            }
            int i = 0;
            while (i < this.connectedNodes_.length) {
                UndirectedNode n;
                Connection c = this.connectedNodes_[i];
                if (c != callerConnection && (n = this.connectedNodes_[i].getOtherEnd(this).getRelatedNode(peer, c)) != null) {
                    return n;
                }
                ++i;
            }
            return null;
        }

        public UndirectedNode getRelatedNode(Node peer) {
            return this.getRelatedNode(peer, null);
        }
    }

    private static interface ConnectionMethodCaller {
        public void callOn(Connection var1, UndirectedNode var2);
    }

    private static final class Connection {
        private UndirectedNode firstNode_;
        private double maximumPathLengthToLeafViaFirstNode_;
        private boolean isFirstPathInfoFound_ = false;
        private UndirectedNode secondNode_;
        private double maximumPathLengthToLeafViaSecondNode_;
        private boolean isSecondPathInfoFound_ = false;
        private double distance_;

        public Connection(UndirectedNode firstNode, UndirectedNode secondNode, double distance) {
            this.firstNode_ = firstNode;
            this.secondNode_ = secondNode;
            this.distance_ = distance;
        }

        public Connection(UndirectedNode baseNode, Node parent, int startingIndex, double distance) {
            this.firstNode_ = baseNode;
            this.secondNode_ = new UndirectedNode(this, startingIndex, parent);
            this.distance_ = distance;
        }

        public Connection(UndirectedNode parentNode, Node child, int constructionMode) {
            this.firstNode_ = parentNode;
            this.distance_ = child.getBranchLength();
            this.secondNode_ = new UndirectedNode(constructionMode, this, child);
        }

        public Connection(Node first, Node second, int constructionMode) {
            this.distance_ = first.getBranchLength() + second.getBranchLength();
            this.firstNode_ = new UndirectedNode(constructionMode, this, first);
            this.secondNode_ = new UndirectedNode(constructionMode, this, second);
        }

        public void setDistance(double distance) {
            this.distance_ = distance;
        }

        public UndirectedNode getFirst() {
            return this.firstNode_;
        }

        public UndirectedNode getSecond() {
            return this.secondNode_;
        }

        public UndirectedNode getRelatedNode(Node n) {
            UndirectedNode fromFirst = this.firstNode_.getRelatedNode(n, this);
            if (fromFirst != null) {
                return fromFirst;
            }
            return this.secondNode_.getRelatedNode(n, this);
        }

        public Node getUnrooted() {
            if (this.firstNode_.isLeaf()) {
                return this.secondNode_.buildUnrootedTree();
            }
            return this.firstNode_.buildUnrootedTree();
        }

        public final double getMaximumPathLengthToLeafViaFirst() {
            if (!this.isFirstPathInfoFound_) {
                this.maximumPathLengthToLeafViaFirstNode_ = this.firstNode_.getMaximumPathLengthToLeaf(this);
                this.isFirstPathInfoFound_ = true;
            }
            return this.maximumPathLengthToLeafViaFirstNode_;
        }

        public final double getMaximumPathLengthToLeafViaSecond() {
            if (!this.isSecondPathInfoFound_) {
                this.maximumPathLengthToLeafViaSecondNode_ = this.secondNode_.getMaximumPathLengthToLeaf(this);
                this.isSecondPathInfoFound_ = true;
            }
            return this.maximumPathLengthToLeafViaSecondNode_;
        }

        public final double getMaximumPathDifference() {
            return Math.abs(this.getMaximumPathLengthToLeafViaFirst() - this.getMaximumPathLengthToLeafViaSecond());
        }

        public Connection getMRCAConnection(String[] nodeNames) {
            return this.getMRCAConnection(null, nodeNames);
        }

        public Node getRootedAroundMRCA(String[] nodeNames) {
            Connection mrca = this.getMRCAConnectionBaseTraverse(nodeNames);
            if (mrca != null) {
                return mrca.getRootedAround();
            }
            throw new IllegalArgumentException("Non existent outgroup:" + Utils.toString(nodeNames));
        }

        public Node[] getAllRootedAroundMRCA(String[] nodeNames) {
            Connection[] mrca = this.getAllMRCAConnectionBaseTraverse(nodeNames);
            if (mrca.length == 0) {
                throw new IllegalArgumentException("Non existent outgroup:" + Utils.toString(nodeNames));
            }
            Node[] nodes = new Node[mrca.length];
            int i = 0;
            while (i < nodes.length) {
                nodes[i] = mrca[i].getRootedAround();
                ++i;
            }
            return nodes;
        }

        public Node getRootedAroundMRCA(String[] nodeNames, double ingroupBranchLength) {
            Connection mrca = this.getMRCAConnectionBaseTraverse(nodeNames);
            if (mrca != null) {
                return mrca.getRootedAround(ingroupBranchLength, nodeNames);
            }
            throw new IllegalArgumentException("Non existent outgroup:" + Utils.toString(nodeNames));
        }

        public Connection getMRCAConnection(UndirectedNode blockingNode, String[] nodeNames) {
            Connection second;
            Connection first = this.firstNode_ != blockingNode ? this.firstNode_.getMRCAConnection(this, nodeNames) : null;
            Connection connection = second = this.secondNode_ != blockingNode ? this.secondNode_.getMRCAConnection(this, nodeNames) : null;
            if (first != null) {
                if (second != null) {
                    return this;
                }
                return first;
            }
            return second;
        }

        public Connection getMRCAConnectionBaseTraverse(String[] nodeNames) {
            return this.getMRCAConnectionBaseTraverse(null, nodeNames);
        }

        public Connection[] getAllMRCAConnectionBaseTraverse(String[] nodeNames) {
            Connection[] store = new Connection[this.getNumberOfConnections()];
            int total = this.getAllMRCAConnectionBaseTraverse(nodeNames, store, 0);
            Connection[] result = new Connection[total];
            System.arraycopy(store, 0, result, 0, total);
            return result;
        }

        public int getAllMRCAConnectionBaseTraverse(String[] nodeNames, Connection[] store, int numberInStore) {
            return this.getAllMRCAConnectionBaseTraverse(null, nodeNames, store, numberInStore);
        }

        public Connection getMRCAConnectionBaseTraverse(UndirectedNode callingNode, String[] nodeNames) {
            Connection first = this.firstNode_.getMRCAConnection(this, nodeNames);
            Connection second = this.secondNode_.getMRCAConnection(this, nodeNames);
            if (first != null) {
                Connection attempt;
                if (second == null) {
                    return first;
                }
                if (first == second && second == this) {
                    return this;
                }
                if (this.firstNode_ != callingNode && (attempt = this.firstNode_.getMRCAConnectionBaseTraverse(this, nodeNames)) != null) {
                    return attempt;
                }
                if (this.secondNode_ != callingNode && (attempt = this.secondNode_.getMRCAConnectionBaseTraverse(this, nodeNames)) != null) {
                    return attempt;
                }
            }
            return second;
        }

        private final int addToStore(Connection c, Connection[] store, int numberInStore) {
            int i = 0;
            while (i < numberInStore) {
                if (store[i] == c) {
                    return numberInStore;
                }
                ++i;
            }
            store[numberInStore++] = c;
            return numberInStore;
        }

        public int getAllMRCAConnectionBaseTraverse(UndirectedNode callingNode, String[] nodeNames, Connection[] store, int numberInStore) {
            Connection first = this.firstNode_.getMRCAConnection(this, nodeNames);
            Connection second = this.secondNode_.getMRCAConnection(this, nodeNames);
            if (first != null) {
                if (second == null) {
                    return this.addToStore(first, store, numberInStore);
                }
                if (first == second && second == this) {
                    return this.addToStore(this, store, numberInStore);
                }
                if (this.firstNode_ != callingNode) {
                    numberInStore = this.firstNode_.getAllMRCAConnectionBaseTraverse(this, nodeNames, store, numberInStore);
                }
                if (this.secondNode_ != callingNode) {
                    numberInStore = this.secondNode_.getAllMRCAConnectionBaseTraverse(this, nodeNames, store, numberInStore);
                }
            }
            return numberInStore;
        }

        public final int getNumberOfConnections() {
            return this.getNumberOfConnections(null);
        }

        protected final int getNumberOfConnections(UndirectedNode blockingNode) {
            int count = 0;
            if (this.firstNode_ != blockingNode) {
                count += this.firstNode_.getNumberOfConnections(this);
            }
            if (this.secondNode_ != blockingNode) {
                count += this.secondNode_.getNumberOfConnections(this);
            }
            return count + 1;
        }

        public final Connection[] getAllConnections() {
            int size = this.getNumberOfConnections();
            Connection[] array = new Connection[size];
            this.getConnections(array, 0);
            return array;
        }

        protected final int getConnections(Connection[] array, int index) {
            return this.getConnections(null, array, index);
        }

        protected final int getConnections(UndirectedNode blockingNode, Connection[] array, int index) {
            array[index++] = this;
            if (this.firstNode_ != blockingNode) {
                index = this.firstNode_.getConnections(this, array, index);
            }
            if (this.secondNode_ != blockingNode) {
                index = this.secondNode_.getConnections(this, array, index);
            }
            return index;
        }

        public final Connection getMidPointConnection(UndirectedNode blockingNode, Connection best) {
            if (blockingNode == this.secondNode_) {
                best = this.firstNode_.getMidPointConnection(this, best);
            } else if (blockingNode == this.firstNode_) {
                best = this.secondNode_.getMidPointConnection(this, best);
            } else {
                throw new RuntimeException("Assertion error : getMidPointConnection called with invalid blockingNode");
            }
            double myPathDiff = this.getMaximumPathDifference();
            double bestDiff = best.getMaximumPathDifference();
            return myPathDiff < bestDiff ? this : best;
        }

        public Connection getMidPointConnection() {
            Connection best = this;
            best = this.getMidPointConnection(this.firstNode_, best);
            best = this.getMidPointConnection(this.secondNode_, best);
            return best;
        }

        public Node getMidPointRooted() {
            return this.getMidPointConnection().getRootedAround();
        }

        public double getMaxLengthToLeaf(UndirectedNode blockingNode) {
            if (this.secondNode_ == blockingNode) {
                return this.getMaximumPathLengthToLeafViaFirst();
            }
            if (this.firstNode_ == blockingNode) {
                return this.getMaximumPathLengthToLeafViaSecond();
            }
            throw new RuntimeException("Connection.GetMaxLengthToLeaf() called from unknown asking node");
        }

        public void recalculateMaximumPathLengths() {
            this.clearPathInfo();
            this.updatePathInfo();
            this.assertPathInfo();
        }

        public void assertPathInfo() {
            this.assertPathInfo(null);
        }

        public void assertPathInfo(UndirectedNode blockingNode) {
            if (this.isFirstPathInfoFound_ && this.isSecondPathInfoFound_) {
                if (blockingNode != this.firstNode_) {
                    this.firstNode_.callMethodOnConnections(this, ASSERT_PATH_INFO_CALLER);
                }
                if (blockingNode != this.secondNode_) {
                    this.secondNode_.callMethodOnConnections(this, ASSERT_PATH_INFO_CALLER);
                }
            } else {
                throw new RuntimeException("Assertion error : assertPathInfo failed!");
            }
        }

        public void updatePathInfo() {
            this.updatePathInfo(null);
        }

        public void updatePathInfo(UndirectedNode blockingNode) {
            if (!this.isFirstPathInfoFound_) {
                this.maximumPathLengthToLeafViaFirstNode_ = this.firstNode_.getMaximumPathLengthToLeaf(this);
                this.isFirstPathInfoFound_ = true;
            }
            if (blockingNode != this.firstNode_) {
                this.firstNode_.callMethodOnConnections(this, UPDATE_PATH_INFO_CALLER);
            }
            if (!this.isSecondPathInfoFound_) {
                this.maximumPathLengthToLeafViaSecondNode_ = this.secondNode_.getMaximumPathLengthToLeaf(this);
                this.isSecondPathInfoFound_ = true;
            }
            if (blockingNode != this.secondNode_) {
                this.secondNode_.callMethodOnConnections(this, UPDATE_PATH_INFO_CALLER);
            }
        }

        public void clearPathInfo() {
            this.clearPathInfo(null);
        }

        public void clearPathInfo(UndirectedNode blockingNode) {
            this.isFirstPathInfoFound_ = false;
            this.isSecondPathInfoFound_ = false;
            if (blockingNode != this.firstNode_) {
                this.firstNode_.callMethodOnConnections(this, CLEAR_PATH_INFO_CALLER);
            }
            if (blockingNode != this.secondNode_) {
                this.secondNode_.callMethodOnConnections(this, CLEAR_PATH_INFO_CALLER);
            }
        }

        public final double getDistance() {
            return this.distance_;
        }

        public final boolean isConnectedTo(UndirectedNode node) {
            return node == this.firstNode_ || node == this.secondNode_;
        }

        public final UndirectedNode getOtherEnd(UndirectedNode oneEnd) {
            if (oneEnd == this.firstNode_) {
                return this.secondNode_;
            }
            if (oneEnd == this.secondNode_) {
                return this.firstNode_;
            }
            throw new RuntimeException("Assertion error : getOtherEnd called with non connecting node");
        }

        public final Node getRootedAround() {
            double rightDist;
            double leftDist = this.getMaximumPathLengthToLeafViaFirst();
            double diff = leftDist - (rightDist = this.getMaximumPathLengthToLeafViaSecond());
            if (diff > this.distance_) {
                diff = 0.0;
            } else if (diff < -this.distance_) {
                diff = 0.0;
            }
            Node left = this.firstNode_.buildTree(this, (this.distance_ - diff) / 2.0);
            Node right = this.secondNode_.buildTree(this, (this.distance_ + diff) / 2.0);
            return NodeFactory.createNode(new Node[]{left, right});
        }

        public final Node getRootedAround(double distanceForFirstChild) {
            double distanceForSecondChild = this.distance_ - distanceForFirstChild;
            if (distanceForSecondChild < 0.0) {
                distanceForFirstChild = this.distance_;
                distanceForSecondChild = 0.0;
            }
            Node left = this.firstNode_.buildTree(this, distanceForFirstChild);
            Node right = this.secondNode_.buildTree(this, distanceForSecondChild);
            return NodeFactory.createNode(new Node[]{left, right});
        }

        public final Node getRootedAround(double ingroupDistance, String[] outgroupMembers) {
            UndirectedNode ingroup;
            UndirectedNode outgroup;
            if (this.firstNode_.getMRCA(this, outgroupMembers) != null) {
                outgroup = this.firstNode_;
                ingroup = this.secondNode_;
            } else {
                ingroup = this.firstNode_;
                outgroup = this.secondNode_;
            }
            double distanceForOutgroup = this.distance_ - ingroupDistance;
            if (distanceForOutgroup < 0.0) {
                ingroupDistance = this.distance_;
                distanceForOutgroup = 0.0;
            }
            Node left = ingroup.buildTree(this, ingroupDistance);
            Node right = outgroup.buildTree(this, distanceForOutgroup);
            return NodeFactory.createNode(new Node[]{left, right});
        }
    }
}

