/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.util.Hashtable;
import java.util.Vector;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.Tree;

public class RootedTreeUtils {
    public static boolean containsSubtree(Node root, Node node) {
        return RootedTreeUtils.getSubtree(root, node) != null;
    }

    public static boolean containsClade(Node root, Node clade) {
        return RootedTreeUtils.getClade(root, clade) != null;
    }

    public static Node getSubtree(Node root, Node node) {
        if (RootedTreeUtils.equal(root, node)) {
            return root;
        }
        int i = 0;
        while (i < root.getChildCount()) {
            Node match = RootedTreeUtils.getSubtree(root.getChild(i), node);
            if (match != null) {
                return match;
            }
            ++i;
        }
        return null;
    }

    public static Node getClade(Node root, Node clade) {
        if (RootedTreeUtils.sameTaxa(root, clade)) {
            return root;
        }
        int i = 0;
        while (i < root.getChildCount()) {
            Node match = RootedTreeUtils.getClade(root.getChild(i), clade);
            if (match != null) {
                return match;
            }
            ++i;
        }
        return null;
    }

    public static boolean equal(Node node1, Node node2) {
        int nodeCount2;
        int nodeCount1 = node1.getChildCount();
        if (nodeCount1 != (nodeCount2 = node2.getChildCount())) {
            return false;
        }
        if (nodeCount1 == 0) {
            return node1.getIdentifier().getName().equals(node2.getIdentifier().getName());
        }
        if (RootedTreeUtils.equal(node1.getChild(0), node2.getChild(0))) {
            return RootedTreeUtils.equal(node1.getChild(1), node2.getChild(1));
        }
        if (RootedTreeUtils.equal(node1.getChild(0), node2.getChild(1))) {
            return RootedTreeUtils.equal(node1.getChild(1), node2.getChild(0));
        }
        return false;
    }

    public static boolean sameTaxa(Node node1, Node node2) {
        int leafCount2;
        int leafCount1 = NodeUtils.getLeafCount(node1);
        if (leafCount1 != (leafCount2 = NodeUtils.getLeafCount(node2))) {
            return false;
        }
        Hashtable table = new Hashtable(leafCount1 + 1);
        RootedTreeUtils.collectTaxa(node1, table);
        return !RootedTreeUtils.containsNovelTaxa(node2, table);
    }

    public static int collectTaxa(Node root, Hashtable table) {
        int nc = root.getChildCount();
        if (nc == 0) {
            String name = root.getIdentifier().getName();
            if (table.containsKey(name)) {
                return 0;
            }
            table.put(name, name);
            return 1;
        }
        int newTaxaCount = 0;
        int i = 0;
        while (i < nc) {
            newTaxaCount += RootedTreeUtils.collectTaxa(root.getChild(i), table);
            ++i;
        }
        return newTaxaCount;
    }

    public static boolean containsNovelTaxa(Node root, Hashtable taxa) {
        int nc = root.getChildCount();
        if (nc == 0) {
            return !taxa.containsKey(root.getIdentifier().getName());
        }
        int i = 0;
        while (i < nc) {
            if (RootedTreeUtils.containsNovelTaxa(root.getChild(i), taxa)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int newTaxaCount(Node root, Hashtable table) {
        int nc = root.getChildCount();
        if (nc == 0) {
            return table.containsKey(root.getIdentifier().getName()) ? 0 : 1;
        }
        int newTaxaCount = 0;
        int i = 0;
        while (i < nc) {
            newTaxaCount += RootedTreeUtils.newTaxaCount(root.getChild(i), table);
            ++i;
        }
        return newTaxaCount;
    }

    public static int subtreeCount(Node subtree, Vector trees) {
        int count = 0;
        int i = 0;
        while (i < trees.size()) {
            Node root = ((Tree)trees.elementAt(i)).getRoot();
            if (RootedTreeUtils.containsSubtree(root, subtree)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static double getMeanSubtreeHeight(Node subtree, Vector trees) {
        int count = 0;
        double totalHeight = 0.0;
        int i = 0;
        while (i < trees.size()) {
            Node root = ((Tree)trees.elementAt(i)).getRoot();
            Node match = RootedTreeUtils.getSubtree(root, subtree);
            if (match != null) {
                ++count;
                totalHeight += match.getNodeHeight();
            }
            ++i;
        }
        return totalHeight / (double)count;
    }

    public static double getMeanCladeHeight(Node clade, Vector trees) {
        int count = 0;
        double totalHeight = 0.0;
        int i = 0;
        while (i < trees.size()) {
            Node root = ((Tree)trees.elementAt(i)).getRoot();
            Node match = RootedTreeUtils.getClade(root, clade);
            if (match != null) {
                ++count;
                totalHeight += match.getNodeHeight();
            }
            ++i;
        }
        return totalHeight / (double)count;
    }

    public static int cladeCount(Node subtree, Vector trees) {
        int count = 0;
        int i = 0;
        while (i < trees.size()) {
            Node root = ((Tree)trees.elementAt(i)).getRoot();
            if (RootedTreeUtils.containsClade(root, subtree)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static void collectProportions(Tree tree, Vector trees) {
        int i = 0;
        while (i < tree.getInternalNodeCount()) {
            Node node = tree.getInternalNode(i);
            if (!node.isRoot()) {
                int cladeCount = RootedTreeUtils.cladeCount(node, trees);
                StringBuffer buffer = new StringBuffer();
                RootedTreeUtils.collectLeafNames(node, buffer);
                double pr = (double)cladeCount / (double)trees.size();
                tree.setAttribute(node, "clade probability", new Double(pr));
                double meanCladeHeight = RootedTreeUtils.getMeanCladeHeight(node, trees);
                tree.setAttribute(node, "mean clade height", new Double(meanCladeHeight));
            }
            int subtreeCount = RootedTreeUtils.subtreeCount(node, trees);
            double pr = (double)subtreeCount / (double)trees.size();
            tree.setAttribute(node, "subtree probability", new Double(pr));
            ++i;
        }
    }

    private static void collectLeafNames(Node node, StringBuffer buffer) {
        if (node.isLeaf()) {
            buffer.append(node.getIdentifier().getName());
            buffer.append(' ');
        } else {
            int i = 0;
            while (i < node.getChildCount()) {
                RootedTreeUtils.collectLeafNames(node.getChild(i), buffer);
                ++i;
            }
        }
    }
}

