/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.io.PrintWriter;
import java.util.Vector;
import pal.io.FormattedOutput;
import pal.misc.Identifier;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.util.Log;

public class NodeUtils {
    public static void getExternalNodes(Node root, Vector store) {
        if (root.isLeaf()) {
            store.addElement(root);
        } else {
            int i = 0;
            while (i < root.getChildCount()) {
                NodeUtils.getExternalNodes(root.getChild(i), store);
                ++i;
            }
        }
    }

    public static Node[] getExternalNodes(Node root) {
        Vector v = new Vector();
        NodeUtils.getExternalNodes(root, v);
        Object[] result = new Node[v.size()];
        v.copyInto(result);
        return result;
    }

    public static void getInternalNodes(Node root, Vector store) {
        if (!root.isLeaf()) {
            store.addElement(root);
            int i = 0;
            while (i < root.getChildCount()) {
                NodeUtils.getInternalNodes(root.getChild(i), store);
                ++i;
            }
        }
    }

    public static Node[] getInternalNodes(Node root, boolean includeRoot) {
        Vector v = new Vector();
        NodeUtils.getInternalNodes(root, v);
        Object[] result = new Node[v.size()];
        v.copyInto(result);
        if (includeRoot) {
            return result;
        }
        Node[] adjustedResult = new Node[result.length - 1];
        System.arraycopy(result, 1, adjustedResult, 0, adjustedResult.length);
        return adjustedResult;
    }

    public static int getMaxNodeDepth(Node root) {
        int max = 0;
        int i = 0;
        while (i < root.getChildCount()) {
            int depth = NodeUtils.getMaxNodeDepth(root.getChild(i));
            if (depth > max) {
                max = depth;
            }
            ++i;
        }
        return max + 1;
    }

    public static final double[] getPathLengthInfo(Node root) {
        double[] lengthInfo = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        NodeUtils.getLengthInfo(root, 0.0, lengthInfo);
        return lengthInfo;
    }

    public static final double getMaximumPathLengthLengthToLeaf(Node root) {
        if (root.isLeaf()) {
            return 0.0;
        }
        double maxLength = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < root.getChildCount()) {
            Node c = root.getChild(i);
            double length = c.getBranchLength() + NodeUtils.getMaximumPathLengthLengthToLeaf(c);
            maxLength = Math.max(length, maxLength);
            ++i;
        }
        return maxLength;
    }

    public static final double getMinimumPathLengthLengthToLeaf(Node root) {
        if (root.isLeaf()) {
            return 0.0;
        }
        double minLength = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < root.getChildCount()) {
            Node c = root.getChild(i);
            double length = c.getBranchLength() + NodeUtils.getMinimumPathLengthLengthToLeaf(c);
            minLength = Math.min(length, minLength);
            ++i;
        }
        return minLength;
    }

    private static final void getLengthInfo(Node root, double lengthFromRoot, double[] lengthInfo) {
        if (root.isLeaf()) {
            if (lengthFromRoot < lengthInfo[1]) {
                if (lengthFromRoot < lengthInfo[0]) {
                    lengthInfo[1] = lengthInfo[0];
                    lengthInfo[0] = lengthFromRoot;
                } else {
                    lengthInfo[1] = lengthFromRoot;
                }
            }
            if (lengthFromRoot > lengthInfo[2]) {
                if (lengthFromRoot > lengthInfo[3]) {
                    lengthInfo[2] = lengthInfo[3];
                    lengthInfo[3] = lengthFromRoot;
                } else {
                    lengthInfo[2] = lengthFromRoot;
                }
            }
        } else {
            int i = 0;
            while (i < root.getChildCount()) {
                Node c = root.getChild(i);
                NodeUtils.getLengthInfo(c, lengthFromRoot + c.getBranchLength(), lengthInfo);
                ++i;
            }
        }
    }

    public static void lengths2Heights(Node root) {
        NodeUtils.lengths2Heights(root, NodeUtils.getMaximumPathLengthLengthToLeaf(root));
    }

    public static int getInternalNodeCount(Node root) {
        if (root.isLeaf()) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < root.getChildCount()) {
            count += NodeUtils.getInternalNodeCount(root.getChild(i));
            ++i;
        }
        return count + 1;
    }

    public static void lengths2HeightsKeepTips(Node node, boolean useMax) {
        if (!node.isLeaf()) {
            int i = 0;
            while (i < node.getChildCount()) {
                NodeUtils.lengths2HeightsKeepTips(node.getChild(i), useMax);
                ++i;
            }
            double totalHL = 0.0;
            double maxHL = 0.0;
            double hl = 0.0;
            double maxH = 0.0;
            double h = 0.0;
            int i2 = 0;
            while (i2 < node.getChildCount()) {
                h = node.getChild(i2).getNodeHeight();
                hl = node.getChild(i2).getBranchLength() + h;
                if (hl > maxHL) {
                    maxHL = hl;
                }
                if (h > maxH) {
                    maxH = h;
                }
                totalHL += hl;
                ++i2;
            }
            if (useMax) {
                hl = maxHL;
            } else {
                hl = totalHL / (double)node.getChildCount();
                if (hl < maxH) {
                    hl = maxHL;
                }
            }
            node.setNodeHeight(hl);
            int i3 = 0;
            while (i3 < node.getChildCount()) {
                h = node.getChild(i3).getNodeHeight();
                node.getChild(i3).setBranchLength(hl - h);
                ++i3;
            }
        }
    }

    private static void lengths2Heights(Node node, double newHeight) {
        if (!node.isRoot()) {
            node.setNodeHeight(newHeight -= node.getBranchLength());
        } else {
            node.setNodeHeight(newHeight);
        }
        int i = 0;
        while (i < node.getChildCount()) {
            NodeUtils.lengths2Heights(node.getChild(i), newHeight);
            ++i;
        }
    }

    public static void exchangeInfo(Node node1, Node node2) {
        Identifier swaps = node1.getIdentifier();
        node1.setIdentifier(node2.getIdentifier());
        node2.setIdentifier(swaps);
        double swapd = node1.getBranchLength();
        node1.setBranchLength(node2.getBranchLength());
        node2.setBranchLength(swapd);
        swapd = node1.getNodeHeight();
        node1.setNodeHeight(node2.getNodeHeight());
        node2.setNodeHeight(swapd);
        swapd = node1.getBranchLengthSE();
        node1.setBranchLengthSE(node2.getBranchLengthSE());
        node2.setBranchLengthSE(swapd);
    }

    public static void heights2Lengths(Node node) {
        NodeUtils.heights2Lengths(node, true);
    }

    public static void heights2Lengths(Node node, boolean respectMinimum) {
        int i = 0;
        while (i < node.getChildCount()) {
            NodeUtils.heights2Lengths(node.getChild(i));
            ++i;
        }
        if (node.isRoot()) {
            node.setBranchLength(0.0);
        } else {
            node.setBranchLength(node.getParent().getNodeHeight() - node.getNodeHeight());
            if (respectMinimum && node.getBranchLength() < 1.0E-9) {
                node.setBranchLength(1.0E-9);
            }
        }
    }

    public static void localHeights2Lengths(Node node, boolean respectMinimum) {
        int i = 0;
        while (i < node.getChildCount()) {
            Node child = node.getChild(i);
            child.setBranchLength(node.getNodeHeight() - child.getNodeHeight());
            ++i;
        }
        if (node.isRoot()) {
            node.setBranchLength(0.0);
        } else {
            node.setBranchLength(node.getParent().getNodeHeight() - node.getNodeHeight());
            if (respectMinimum && node.getBranchLength() < 1.0E-9) {
                node.setBranchLength(1.0E-9);
            }
        }
    }

    public static double findLargestChild(Node node) {
        double max = node.getChild(0).getNodeHeight();
        int j = 1;
        while (j < node.getChildCount()) {
            double h = node.getChild(j).getNodeHeight();
            if (h > max) {
                max = h;
            }
            ++j;
        }
        return max;
    }

    public static void removeChild(Node parent, Node child) {
        int rm = -1;
        int i = 0;
        while (i < parent.getChildCount()) {
            if (child == parent.getChild(i)) {
                rm = i;
                break;
            }
            ++i;
        }
        parent.removeChild(rm);
    }

    public static void removeBranch(Node node) {
        if (node.isRoot() || node.isLeaf()) {
            throw new IllegalArgumentException("INTERNAL NODE REQUIRED (NOT ROOT)");
        }
        Node parent = node.getParent();
        int numChilds = node.getChildCount();
        int i = 0;
        while (i < numChilds) {
            parent.addChild(node.getChild(i));
            ++i;
        }
        int rm = -1;
        int i2 = 0;
        while (i2 < parent.getChildCount()) {
            if (node == parent.getChild(i2)) {
                rm = i2;
                break;
            }
            ++i2;
        }
        parent.removeChild(rm);
        node.setParent(parent);
        node.setNumber(rm);
    }

    public static void restoreBranch(Node node) {
        if (node.isRoot() || node.isLeaf()) {
            throw new IllegalArgumentException("INTERNAL NODE REQUIRED (NOT ROOT)");
        }
        Node parent = node.getParent();
        int numChilds = node.getChildCount();
        int i = 0;
        while (i < numChilds) {
            Node c = node.getChild(i);
            NodeUtils.removeChild(parent, c);
            c.setParent(node);
            ++i;
        }
        parent.insertChild(node, node.getNumber());
    }

    public static void joinChilds(Node node, int n1, int n2) {
        int c2;
        int c1;
        if (n1 == n2) {
            throw new IllegalArgumentException("CHILDREN MUST BE DIFFERENT");
        }
        if (n2 < n1) {
            c1 = n2;
            c2 = n1;
        } else {
            c1 = n1;
            c2 = n2;
        }
        Node newNode = NodeFactory.createNode();
        Node child1 = node.getChild(c1);
        Node child2 = node.getChild(c2);
        node.setChild(c1, newNode);
        newNode.setParent(node);
        node.removeChild(c2);
        newNode.addChild(child1);
        newNode.addChild(child2);
    }

    public static Node preorderSuccessor(Node node) {
        Node next = null;
        if (node.isLeaf()) {
            Node cn = node;
            Node ln = null;
            do {
                if (cn.isRoot()) {
                    next = cn;
                    break;
                }
                ln = cn;
            } while ((cn = cn.getParent()).getChild(cn.getChildCount() - 1) == ln);
            if (next == null) {
                int i = 0;
                while (i < cn.getChildCount() - 1) {
                    if (cn.getChild(i) == ln) {
                        next = cn.getChild(i + 1);
                        break;
                    }
                    ++i;
                }
            }
        } else {
            next = node.getChild(0);
        }
        return next;
    }

    public static Node postorderSuccessor(Node node) {
        Node cn = null;
        Node parent = node.getParent();
        if (node.isRoot()) {
            cn = node;
        } else {
            if (parent.getChild(parent.getChildCount() - 1) == node) {
                return parent;
            }
            int i = 0;
            while (i < parent.getChildCount() - 1) {
                if (parent.getChild(i) == node) {
                    cn = parent.getChild(i + 1);
                    break;
                }
                ++i;
            }
        }
        while (cn.getChildCount() > 0) {
            cn = cn.getChild(0);
        }
        return cn;
    }

    public static void printNH(PrintWriter out, Node node, boolean printLengths, boolean printInternalLabels) {
        NodeUtils.printNH(out, node, printLengths, printInternalLabels, 0, true);
    }

    public static int printNH(PrintWriter out, Node node, boolean printLengths, boolean printInternalLabels, int column, boolean breakLines) {
        if (breakLines) {
            column = NodeUtils.breakLine(out, column);
        }
        if (!node.isLeaf()) {
            out.print("(");
            ++column;
            int i = 0;
            while (i < node.getChildCount()) {
                if (i != 0) {
                    out.print(",");
                    ++column;
                }
                column = NodeUtils.printNH(out, node.getChild(i), printLengths, printInternalLabels, column, breakLines);
                ++i;
            }
            out.print(")");
            ++column;
        }
        if (!node.isRoot()) {
            if (node.isLeaf() || printInternalLabels) {
                if (breakLines) {
                    column = NodeUtils.breakLine(out, column);
                }
                String id = node.getIdentifier().toString();
                out.print(id);
                column += id.length();
            }
            if (printLengths) {
                out.print(":");
                ++column;
                if (breakLines) {
                    column = NodeUtils.breakLine(out, column);
                }
                column += FormattedOutput.getInstance().displayDecimal(out, node.getBranchLength(), 7);
            }
        }
        return column;
    }

    private static int breakLine(PrintWriter out, int column) {
        if (column > 70) {
            out.println();
            column = 0;
        }
        return column;
    }

    public static final Node[] findByIdentifier(Node node, String[] identifierNames) {
        Node[] nodes = new Node[identifierNames.length];
        boolean foundSomething = false;
        int i = 0;
        while (i < nodes.length) {
            nodes[i] = NodeUtils.findByIdentifier(node, identifierNames[i]);
            foundSomething = foundSomething || nodes[i] != null;
            ++i;
        }
        if (!foundSomething) {
            return null;
        }
        return nodes;
    }

    public static final Node[] findByIdentifier(Node node, Identifier[] identifiers) {
        Node[] nodes = new Node[identifiers.length];
        int i = 0;
        while (i < nodes.length) {
            nodes[i] = NodeUtils.findByIdentifier(node, identifiers[i]);
            ++i;
        }
        return nodes;
    }

    public static final Node findByIdentifier(Node node, Identifier identifier) {
        return NodeUtils.findByIdentifier(node, identifier.getName());
    }

    public static final Node findByIdentifier(Node node, String identifierName) {
        Log.getDefaultLogger().debug("node identifier = " + node.getIdentifier());
        Log.getDefaultLogger().debug("target identifier name = " + identifierName);
        if (node.getIdentifier().getName().equals(identifierName)) {
            return node;
        }
        Node pos = null;
        int i = 0;
        while (i < node.getChildCount()) {
            pos = NodeUtils.findByIdentifier(node.getChild(i), identifierName);
            if (pos != null) {
                return pos;
            }
            ++i;
        }
        if (pos != null) {
            return pos;
        }
        return null;
    }

    public static double getDistanceToRoot(Node node) {
        if (node.isRoot()) {
            return 0.0;
        }
        return node.getBranchLength() + NodeUtils.getDistanceToRoot(node.getParent());
    }

    public static int getLeafCount(Node node) {
        int count = 0;
        if (!node.isLeaf()) {
            int i = 0;
            while (i < node.getChildCount()) {
                count += NodeUtils.getLeafCount(node.getChild(i));
                ++i;
            }
        } else {
            count = 1;
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isAncestor(Node possibleAncestor, Node node) {
        if (node != possibleAncestor) ** GOTO lbl5
        return true;
lbl-1000:
        // 1 sources

        {
            if ((node = node.getParent()) != possibleAncestor) continue;
            return true;
lbl5:
            // 2 sources

            ** while (!node.isRoot())
        }
lbl6:
        // 1 sources

        return false;
    }

    public static Node getFirstCommonAncestor(Node[] nodes) {
        Node currentCA = nodes[0];
        int i = 1;
        while (i < nodes.length) {
            if (currentCA != null && nodes[i] != null && (currentCA = NodeUtils.getFirstCommonAncestor(currentCA, nodes[i])) == null) {
                return null;
            }
            ++i;
        }
        return currentCA;
    }

    /*
     * Unable to fully structure code
     */
    public static Node getFirstCommonAncestor(Node nodeOne, Node nodeTwo) {
        if (NodeUtils.isAncestor(nodeTwo, nodeOne)) {
            return nodeTwo;
        }
        if (!NodeUtils.isAncestor(nodeOne, nodeTwo)) ** GOTO lbl7
        return nodeOne;
lbl-1000:
        // 1 sources

        {
            if (!NodeUtils.isAncestor(nodeTwo = nodeTwo.getParent(), nodeOne)) continue;
            return nodeTwo;
lbl7:
            // 2 sources

            ** while (!nodeTwo.isRoot())
        }
lbl8:
        // 1 sources

        return null;
    }

    public static final int getUnrootedBranchCount(Node center) {
        if (center.isRoot()) {
            return center.getChildCount();
        }
        return center.getChildCount() + 1;
    }

    public static final void convertNegativeBranchLengthsToZeroLength(Node node) {
        NodeUtils.convertNegativeBranchLengthsToZeroLengthImpl(node);
        NodeUtils.lengths2Heights(node);
    }

    private static final void convertNegativeBranchLengthsToZeroLengthImpl(Node node) {
        if (node.getBranchLength() < 0.0) {
            node.setBranchLength(0.0);
        }
        int i = 0;
        while (i < node.getChildCount()) {
            NodeUtils.convertNegativeBranchLengthsToZeroLengthImpl(node.getChild(i));
            ++i;
        }
    }
}

