/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.tree.ParameterizedTree;

public class LogParameterizedTree
extends ParameterizedTree.ParameterizedTreeBase
implements ParameterizedTree {
    ParameterizedTree params;
    private double[] logMins;
    private double[] logMaxs;
    private double[] logDefaults;

    public LogParameterizedTree(ParameterizedTree params) {
        this.setBaseTree(params);
        this.params = params;
        this.logMins = new double[params.getNumParameters()];
        this.logMaxs = new double[params.getNumParameters()];
        this.logDefaults = new double[params.getNumParameters()];
        int i = 0;
        while (i < this.logMins.length) {
            this.logMins[i] = Math.log(params.getLowerLimit(i));
            this.logMaxs[i] = Math.log(params.getUpperLimit(i));
            this.logDefaults[i] = Math.log(params.getDefaultValue(i));
            ++i;
        }
    }

    public int getNumParameters() {
        return this.params.getNumParameters();
    }

    public void setParameter(double logParam, int n) {
        double realParam = Math.exp(logParam + this.logMins[n]);
        this.params.setParameter(realParam, n);
    }

    public double getParameter(int n) {
        return Math.log(this.params.getParameter(n)) - this.logMins[n];
    }

    public void setParameterSE(double paramSE, int n) {
    }

    public double getLowerLimit(int n) {
        return 0.0;
    }

    public double getUpperLimit(int n) {
        return this.logMaxs[n] - this.logMins[n];
    }

    public double getDefaultValue(int n) {
        return this.logDefaults[n] - this.logMins[n];
    }

    public String getParameterizationInfo() {
        return this.params.getParameterizationInfo() + " (using log scaling)";
    }
}

