/*
 * Decompiled with CFR 0.152.
 */
package pal.supgma;

import pal.alignment.SitePattern;
import pal.coalescent.DemographicModel;
import pal.coalescent.SerialCoalescentGenerator;
import pal.distance.AlignmentDistanceMatrix;
import pal.distance.DistanceMatrix;
import pal.distance.DistanceMatrixSource;
import pal.io.FormattedOutput;
import pal.math.LMSSolver;
import pal.mep.DeltaModel;
import pal.mep.MutationRateModel;
import pal.misc.TimeOrderCharacterData;
import pal.substmodel.SubstitutionModel;
import pal.supgma.RateHandler;
import pal.supgma.SUPGMATree;
import pal.supgma.ThetaHandler;
import pal.tree.ClusterTree;
import pal.tree.SimulatedAlignment;
import pal.tree.Tree;
import pal.tree.TreeGenerator;
import pal.tree.TreeUtils;
import pal.util.AlgorithmCallback;
import pal.util.HeapSort;

public class SUPGMABase {
    private static final int SF_DIGITS = 5;
    private DistanceMatrixSource distanceSource_;
    private TimeOrderCharacterData tocd_;
    private RateHandler rateHandler_ = null;
    private ThetaHandler thetaHandler_ = null;

    public SUPGMABase(DistanceMatrixSource distanceSource, TimeOrderCharacterData tocd) {
        this.distanceSource_ = distanceSource;
        this.tocd_ = tocd;
    }

    public String toString() {
        return "SUPGMA BASE: (DMS:" + this.distanceSource_ + ") " + "(Rate Handler:" + this.rateHandler_ + ") " + "(Theta Handler:" + this.thetaHandler_ + ")";
    }

    public void setThetaHandler(ThetaHandler handler) {
        this.thetaHandler_ = handler;
    }

    public void setRateHandler(RateHandler rateHandler) {
        this.rateHandler_ = rateHandler;
    }

    private double[] getDistances(AlgorithmCallback callback) {
        int num = this.tocd_.getIdCount();
        double[] distanceArray = new double[num * (num - 1) / 2];
        int index = 0;
        DistanceMatrix distances = this.distanceSource_.generateMatrix(callback);
        int i = 0;
        while (i < num) {
            int j = i + 1;
            while (j < num) {
                distanceArray[index++] = distances.getDistance(i, j);
                ++j;
            }
            ++i;
        }
        return distanceArray;
    }

    public Tree solve(AlgorithmCallback callback, ClusterTree.ClusteringMethod cm, LMSSolver solver) {
        Analyser a = this.generateAnalyser();
        PopulationParameters pp = a.analyse(this.distanceSource_.generateMatrix(callback), this.tocd_, solver);
        return pp.generateSUPGMATree(cm);
    }

    public PopulationParameters process(DistanceMatrixSource alternativeSource, AlgorithmCallback callback, LMSSolver solver) {
        Analyser a = this.generateAnalyser();
        return a.analyse(alternativeSource.generateMatrix(callback), this.tocd_, solver);
    }

    public PopulationParameters process(AlgorithmCallback callback, LMSSolver solver) {
        Analyser a = this.generateAnalyser();
        return a.analyse(this.distanceSource_.generateMatrix(callback), this.tocd_, solver);
    }

    public Tree generateAlignmentBootstrappedSUPGMATree(AlgorithmCallback callback, ClusterTree.ClusteringMethod cm, PopulationParameters pp, int numberOfReplicates, LMSSolver solver) {
        return pp.generateSUPGMATree(callback, cm, this.distanceSource_, numberOfReplicates, solver);
    }

    public Analyser generateAnalyser() {
        if (this.tocd_.hasTimes()) {
            return new TimeBasedAnalyser(this.thetaHandler_, this.rateHandler_);
        }
        return new NoTimeBasedAnalyser(this.thetaHandler_);
    }

    static final class Utils {
        Utils() {
        }

        static final String generateHTML(String model, double[] values) {
            return "<ul><li>Type:" + model + "</li>" + "<li>" + (values.length == 1 ? "Parameter Value:" : "Parameter Values:") + FormattedOutput.getInstance().getSFString(values, 5, ", ") + "</li>" + "</ul>" + (values.length == 1 ? "" : "<i>Parameter values are ordered with most recent first. </i>");
        }

        static final String generateHTML(String deltaModel, double[] deltaValues, String thetaModel, double[] thetaValues) {
            return "<ul><li><b>Delta Model:</b>" + Utils.generateHTML(deltaModel, deltaValues) + "</li>" + "<li><b>Theta Model:</b>" + Utils.generateHTML(thetaModel, thetaValues) + "</li>" + "</ul>";
        }
    }

    public static interface CISummary {
        public String toSummary(double var1);
    }

    public static interface PopulationParameters {
        public boolean isCICompatible();

        public CISummary inferCI(AlgorithmCallback var1, int var2, SimulatedAlignment.Factory var3, SubstitutionModel var4, LMSSolver var5);

        public Tree generateSUPGMATree(ClusterTree.ClusteringMethod var1);

        public Tree generateSUPGMATree(AlgorithmCallback var1, ClusterTree.ClusteringMethod var2, DistanceMatrixSource var3, int var4, LMSSolver var5);

        public Tree[] simulateTrees(int var1, AlgorithmCallback var2, LMSSolver var3);

        public Tree simulateTree();

        public String generateHTML();
    }

    private static final class Bootstrapper
    implements TreeGenerator {
        private final ClusterTree.ClusteringMethod cm_;
        private final Analyser analyser_;
        private final DistanceMatrixSource dms_;
        private final TimeOrderCharacterData tocd_;
        private final LMSSolver solver_;

        public Bootstrapper(TimeOrderCharacterData tocd, DistanceMatrixSource dms, Analyser analyser, ClusterTree.ClusteringMethod cm, LMSSolver solver) {
            this.dms_ = dms;
            this.cm_ = cm;
            this.solver_ = solver;
            this.analyser_ = analyser;
            this.tocd_ = tocd;
        }

        public Tree getNextTree(Tree baseTree, AlgorithmCallback callback) {
            DistanceMatrix dm = this.dms_.generateReplicate(callback);
            PopulationParameters pp = this.analyser_.analyse(dm, this.tocd_, this.solver_);
            return pp.generateSUPGMATree(this.cm_);
        }
    }

    private static final class SimpleCISummary
    implements CISummary {
        SummaryData[] data_;
        double[] rateValues_;
        double[] thetaValues_;

        public SimpleCISummary(double[] rateValues, double[] thetaValues, SummaryData[] data) {
            this.data_ = data;
            this.rateValues_ = rateValues;
            this.thetaValues_ = thetaValues;
        }

        public String toSummary(double alpha) {
            String s = "<ul>";
            int i = 0;
            while (i < this.data_.length) {
                s = s + "<li>" + this.data_[i].toSummary(alpha) + "</li>";
                ++i;
            }
            s = s + "</ul>";
            return s;
        }
    }

    private static final class SummaryData {
        double[] values_;
        String details_;

        public SummaryData(String details, double[] values) {
            this.values_ = values;
            this.details_ = details;
        }

        public String toSummary(double alphaLevel) {
            int ciPercent = 100 - (int)(alphaLevel * 100.0);
            int lowerIndex = (int)(alphaLevel / 2.0 * (double)this.values_.length);
            int upperIndex = this.values_.length - (int)(alphaLevel / 2.0 * (double)this.values_.length);
            FormattedOutput fo = FormattedOutput.getInstance();
            String lowerValue = fo.getSFString(this.values_[lowerIndex], 5);
            String upperValue = fo.getSFString(this.values_[upperIndex], 5);
            return "<b>" + this.details_ + " interval (alpha = " + alphaLevel + " => " + ciPercent + "%)<br>" + "</b>" + "[ " + lowerValue + " - " + upperValue + "]";
        }
    }

    private static final class TimedPopulationParameters
    extends AbstractPopulationParameters
    implements PopulationParameters {
        private final double[] times_;
        private final RateHandler rateHandler_;
        private final LMSSolver solver_;

        protected TimedPopulationParameters(Analyser analyser, RateHandler rateHandler, ThetaHandler thetaHandler, DistanceMatrix dm, TimeOrderCharacterData tocd, double[] deltas, double[] times, double[] thetas, LMSSolver solver) {
            super(analyser, thetaHandler, dm, tocd, deltas, thetas);
            this.solver_ = solver;
            this.times_ = times;
            this.rateHandler_ = rateHandler;
        }

        protected boolean isDeltasCICompatible() {
            return this.rateHandler_.isCICompatible();
        }

        protected DeltaModel generateDeltaModel() {
            return DeltaModel.Utils.getMutationRateModelBased(this.rateHandler_.generateRateModelFactory(this.getDeltas(), this.getBaseTOCD()));
        }

        protected TimeOrderCharacterData getTOCDSuitableForDeltas() {
            return this.getBaseTOCD();
        }

        public CISummary inferCI(AlgorithmCallback callback, int numberOfReplicates, SimulatedAlignment.Factory alignmentFactory, SubstitutionModel evolutionaryModel, LMSSolver solver) {
            double[] thetaValues = null;
            double[] rateValues = null;
            TimeOrderCharacterData baseTOCD = this.getBaseTOCD();
            MutationRateModel.Factory mepFactory = this.rateHandler_.generateRateModelFactory(this.getDeltas(), baseTOCD);
            MutationRateModel mep = mepFactory.generateNewModel();
            double numberOfReplicatesD = numberOfReplicates;
            DemographicModel demo = this.generateDemographicModel();
            TimeOrderCharacterData scaledTOCD = mep.scale(baseTOCD);
            SerialCoalescentGenerator scg = new SerialCoalescentGenerator(scaledTOCD, demo, 1);
            if (this.isThetaHandlerCICompatible()) {
                thetaValues = new double[numberOfReplicates];
            }
            if (this.rateHandler_.isCICompatible()) {
                rateValues = new double[numberOfReplicates];
            }
            int i = 0;
            while (i < numberOfReplicates) {
                if (callback.isPleaseStop()) {
                    return null;
                }
                Tree tree = scg.generateTree();
                SimulatedAlignment alignment = alignmentFactory.generateAlignment(tree);
                tree = null;
                if (callback.isPleaseStop()) {
                    return null;
                }
                AlignmentDistanceMatrix dm = new AlignmentDistanceMatrix(SitePattern.getSitePattern(alignment), evolutionaryModel);
                TimeOrderCharacterData rearrangedTOCD = new TimeOrderCharacterData(alignment, baseTOCD.getUnits());
                rearrangedTOCD.setTimesAndOrdinals(baseTOCD);
                TimedPopulationParameters pp = TimeBasedAnalyser.analyseImpl(this.getCreatingAnalyser(), this.getThetaHandler(), this.rateHandler_, dm, rearrangedTOCD, this.solver_);
                if (thetaValues != null) {
                    thetaValues[i] = pp.getFirstTheta();
                }
                if (rateValues != null) {
                    rateValues[i] = pp.getFirstDelta();
                }
                callback.updateProgress((double)i / numberOfReplicatesD);
                ++i;
            }
            SummaryData rateSummary = null;
            SummaryData thetaSummary = null;
            if (rateValues != null) {
                HeapSort.sort(rateValues);
                rateSummary = new SummaryData("Mutation rate", rateValues);
            }
            if (thetaValues != null) {
                HeapSort.sort(thetaValues);
                thetaSummary = new SummaryData("Theta", thetaValues);
            }
            SummaryData[] summaryData = rateValues != null ? (thetaValues != null ? new SummaryData[]{rateSummary, thetaSummary} : new SummaryData[]{rateSummary}) : new SummaryData[]{thetaSummary};
            return new SimpleCISummary(this.getDeltas(), this.getThetas(), summaryData);
        }

        private String getDeltaModelType() {
            return "Mutation rate based, " + this.rateHandler_.getInfo();
        }

        public String generateHTML() {
            return Utils.generateHTML(this.getDeltaModelType(), this.getDeltas(), this.getThetaModelType(), this.getThetas());
        }
    }

    private static final class NoTimePopulationParameters
    extends AbstractPopulationParameters
    implements PopulationParameters {
        private final TimeOrderCharacterData esTOCD_;

        protected NoTimePopulationParameters(Analyser analyser, ThetaHandler thetaHandler, DistanceMatrix dm, TimeOrderCharacterData tocd, double[] deltas, double[] thetas) {
            super(analyser, thetaHandler, dm, tocd, deltas, thetas);
            this.esTOCD_ = tocd.generateExpectedSubsitutionsTimedTOCD(deltas);
        }

        protected boolean isDeltasCICompatible() {
            return this.getNumberOfDeltas() == 1;
        }

        protected TimeOrderCharacterData getTOCDSuitableForDeltas() {
            return this.esTOCD_;
        }

        protected DeltaModel generateDeltaModel() {
            return DeltaModel.Utils.getUntimedBased(this.getDeltas());
        }

        public CISummary inferCI(AlgorithmCallback callback, int numberOfReplicates, SimulatedAlignment.Factory alignmentFactory, SubstitutionModel evolutionaryModel, LMSSolver solver) {
            throw new RuntimeException("Assertion error : Not possible!");
        }

        public String generateHTML() {
            return Utils.generateHTML("Straight Delta values (no time information)", this.getDeltas(), this.getThetaModelType(), this.getThetas());
        }
    }

    private static abstract class AbstractPopulationParameters
    implements PopulationParameters {
        private DistanceMatrix dm_;
        private TimeOrderCharacterData baseTOCD_;
        private TimeOrderCharacterData esTOCD_;
        private double[] deltas_;
        private double[] thetas_;
        private ThetaHandler thetaHandler_;
        private final Analyser analyser_;

        protected AbstractPopulationParameters(Analyser analyser, ThetaHandler thetaHandler, DistanceMatrix dm, TimeOrderCharacterData baseTOCD, double[] deltas, double[] thetas) {
            this.dm_ = dm;
            this.analyser_ = analyser;
            this.baseTOCD_ = baseTOCD;
            this.deltas_ = pal.misc.Utils.getCopy(deltas);
            this.thetas_ = pal.misc.Utils.getCopy(thetas);
            this.thetaHandler_ = thetaHandler;
        }

        public final Tree[] simulateTrees(int numberOfTreesToSimulate, AlgorithmCallback callback, LMSSolver solver) {
            TimeOrderCharacterData suitableTOCD = this.getTOCDSuitableForDeltas();
            SerialCoalescentGenerator scg = new SerialCoalescentGenerator(suitableTOCD, this.thetaHandler_.generateDemographicModel(this.deltas_, this.thetas_, suitableTOCD), numberOfTreesToSimulate);
            return scg.generateTrees(callback);
        }

        public final Tree simulateTree() {
            TimeOrderCharacterData suitableTOCD = this.getTOCDSuitableForDeltas();
            SerialCoalescentGenerator scg = new SerialCoalescentGenerator(suitableTOCD, this.thetaHandler_.generateDemographicModel(this.deltas_, this.thetas_, suitableTOCD), 1);
            return scg.generateTree();
        }

        protected final Analyser getCreatingAnalyser() {
            return this.analyser_;
        }

        public final Tree generateSUPGMATree(ClusterTree.ClusteringMethod cm) {
            return new SUPGMATree(this.dm_, this.getBaseTOCD(), this.generateDeltaModel(), true, cm);
        }

        public Tree generateSUPGMATree(AlgorithmCallback callback, ClusterTree.ClusteringMethod cm, DistanceMatrixSource replicateSource, int numberOfAlignmentBootstrapReplicates, LMSSolver solver) {
            Tree[] trees = new Tree[numberOfAlignmentBootstrapReplicates];
            DeltaModel deltaModel = this.generateDeltaModel();
            SUPGMATree base = new SUPGMATree(this.dm_, this.getBaseTOCD(), deltaModel, true, cm);
            if (numberOfAlignmentBootstrapReplicates == 0) {
                return base;
            }
            Bootstrapper tg = new Bootstrapper(this.getBaseTOCD(), replicateSource, this.analyser_, cm, solver);
            return TreeUtils.getReplicateCladeSupport("bootstrap", base, tg, numberOfAlignmentBootstrapReplicates, callback);
        }

        public boolean isCICompatible() {
            return this.thetaHandler_.canGenerateDemogrpahicModel() && (this.thetaHandler_.isCICompatible() || this.isDeltasCICompatible());
        }

        protected final int getNumberOfDeltas() {
            return this.deltas_.length;
        }

        protected final int getNumberOfThetas() {
            return this.thetas_.length;
        }

        protected final double getFirstDelta() {
            return this.deltas_[0];
        }

        protected final double getFirstTheta() {
            return this.thetas_[0];
        }

        protected final String getThetaModelType() {
            return this.thetaHandler_.getInfo();
        }

        protected final double[] getDeltas() {
            return this.deltas_;
        }

        protected final double[] getThetas() {
            return this.thetas_;
        }

        protected final TimeOrderCharacterData getBaseTOCD() {
            return this.baseTOCD_;
        }

        protected final boolean isThetaHandlerCICompatible() {
            return this.thetaHandler_.isCICompatible();
        }

        protected final ThetaHandler getThetaHandler() {
            return this.thetaHandler_;
        }

        protected final DemographicModel generateDemographicModel() {
            return this.thetaHandler_.generateDemographicModel(this.deltas_, this.thetas_, this.baseTOCD_);
        }

        protected final DemographicModel generateDemographicModel(TimeOrderCharacterData tocd) {
            return this.thetaHandler_.generateDemographicModel(this.deltas_, this.thetas_, tocd);
        }

        protected abstract boolean isDeltasCICompatible();

        protected abstract DeltaModel generateDeltaModel();

        protected abstract TimeOrderCharacterData getTOCDSuitableForDeltas();
    }

    private static final class NoTimeBasedAnalyser
    implements Analyser {
        ThetaHandler thetaHandler_;

        public NoTimeBasedAnalyser(ThetaHandler thetaHandler) {
            this.thetaHandler_ = thetaHandler;
        }

        private static final int getNumberOfDeltas(TimeOrderCharacterData tocd) {
            return tocd.getSampleCount() - 1;
        }

        protected static final NoTimePopulationParameters analyseImpl(Analyser analyser, ThetaHandler thetaHandler, DistanceMatrix dm, TimeOrderCharacterData tocd, LMSSolver solver) {
            int num = tocd.getIdCount();
            int totalNumberOfDistances = num * (num - 1) / 2;
            int numberOfThetas = thetaHandler.getNumberOfParameters(tocd);
            int numberOfDeltas = NoTimeBasedAnalyser.getNumberOfDeltas(tocd);
            double[][] m = new double[totalNumberOfDistances][numberOfDeltas + numberOfThetas];
            double[] distanceArray = new double[totalNumberOfDistances];
            int index = 0;
            int i = 0;
            while (i < num) {
                int iSample = tocd.getTimeOrdinal(i);
                int j = i + 1;
                while (j < num) {
                    int jSample = tocd.getTimeOrdinal(j);
                    int minSample = Math.min(iSample, jSample);
                    int maxSample = Math.max(iSample, jSample);
                    thetaHandler.fillInLSInfo(m[index], 0, minSample, maxSample);
                    int sample = minSample;
                    while (sample < maxSample) {
                        m[index][sample + numberOfThetas] = 1.0;
                        ++sample;
                    }
                    distanceArray[index++] = dm.getDistance(i, j);
                    ++j;
                }
                ++i;
            }
            double[] values = solver.solve(m, distanceArray);
            double[] deltas = new double[numberOfDeltas];
            double[] thetas = new double[numberOfThetas];
            System.arraycopy(values, 0, thetas, 0, numberOfThetas);
            System.arraycopy(values, numberOfThetas, deltas, 0, numberOfDeltas);
            return new NoTimePopulationParameters(analyser, thetaHandler, dm, tocd, deltas, thetas);
        }

        public PopulationParameters analyse(DistanceMatrix dm, TimeOrderCharacterData tocd, LMSSolver solver) {
            return NoTimeBasedAnalyser.analyseImpl(this, this.thetaHandler_, dm, tocd, solver);
        }
    }

    private static final class TimeBasedAnalyser
    implements Analyser {
        private final ThetaHandler thetaHandler_;
        private final RateHandler rateHandler_;

        public TimeBasedAnalyser(ThetaHandler thetaHandler, RateHandler rateHandler) {
            this.thetaHandler_ = thetaHandler;
            this.rateHandler_ = rateHandler;
        }

        private static final double[] getResults(ThetaHandler thetaHandler, RateHandler rateHandler, double[][] distanceMatrix, TimeOrderCharacterData tocd, LMSSolver solver) {
            int num = tocd.getIdCount();
            int totalNumberOfDistances = num * (num - 1) / 2;
            int numberOfThetas = thetaHandler.getNumberOfParameters(tocd);
            int numberOfRates = rateHandler.getNumberOfParameters(tocd);
            if (numberOfRates + numberOfThetas == 0) {
                return new double[0];
            }
            double[][] m = new double[totalNumberOfDistances][numberOfThetas + numberOfRates];
            double[] distanceArray = new double[totalNumberOfDistances];
            double[] sampleTimes = tocd.getUniqueTimeArray();
            double[][] adjustedDistanceMatrix = pal.misc.Utils.getCopy(distanceMatrix);
            rateHandler.adjustDistances(adjustedDistanceMatrix, tocd);
            int index = 0;
            int i = 0;
            while (i < num) {
                double iTime = tocd.getTime(i);
                int iSample = tocd.getTimeOrdinal(i);
                int j = i + 1;
                while (j < num) {
                    int jSample = tocd.getTimeOrdinal(j);
                    int minSample = Math.min(iSample, jSample);
                    int maxSample = Math.max(iSample, jSample);
                    thetaHandler.fillInLSInfo(m[index], 0, minSample, maxSample);
                    rateHandler.fillInLSInfo(m[index], numberOfThetas, minSample, maxSample, sampleTimes);
                    distanceArray[index] = adjustedDistanceMatrix[i][j];
                    ++index;
                    ++j;
                }
                ++i;
            }
            return solver.solve(m, distanceArray);
        }

        public PopulationParameters analyse(DistanceMatrix dm, TimeOrderCharacterData tocd, LMSSolver solver) {
            return TimeBasedAnalyser.analyseImpl(this, this.thetaHandler_, this.rateHandler_, dm, tocd, solver);
        }

        protected static final TimedPopulationParameters analyseImpl(Analyser analyser, ThetaHandler thetaHandler, RateHandler rateHandler, DistanceMatrix dm, TimeOrderCharacterData tocd, LMSSolver solver) {
            int numberOfThetas = thetaHandler.getNumberOfParameters(tocd);
            int numberOfRates = rateHandler.getNumberOfParameters(tocd);
            double[] values = TimeBasedAnalyser.getResults(thetaHandler, rateHandler, dm.getClonedDistances(), tocd, solver);
            double[] rates = new double[numberOfRates];
            double[] thetas = new double[numberOfThetas];
            double[] times = tocd.getUniqueTimeArray();
            System.arraycopy(values, 0, thetas, 0, numberOfThetas);
            System.arraycopy(values, numberOfThetas, rates, 0, numberOfRates);
            return new TimedPopulationParameters(analyser, rateHandler, thetaHandler, dm, tocd, rates, times, thetas, solver);
        }
    }

    private static interface Analyser {
        public PopulationParameters analyse(DistanceMatrix var1, TimeOrderCharacterData var2, LMSSolver var3);
    }
}

