/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.PrintWriter;
import pal.substmodel.NucleotideModel;
import pal.util.XMLConstants;

public class TN
extends NucleotideModel
implements XMLConstants {
    public static final int KAPPA_PARAMETER_INDEX = 0;
    public static final int R_PARAMETER_INDEX = 1;
    private boolean showSE;
    private double kappa;
    private double kappaSE;
    private double r;
    private double rSE;

    public TN(double kappa, double r, double[] freq) {
        super(freq);
        this.kappa = kappa;
        this.r = r;
        this.setParameters(new double[]{kappa, r});
        this.showSE = false;
    }

    public TN(double[] params, double[] freq) {
        this(params[0], params[1], freq);
    }

    public int getModelID() {
        return 1;
    }

    public void report(PrintWriter out) {
        out.println("Model of substitution: TN (Tamura-Nei 1993)");
        out.print("Transition/transversion rate ratio kappa: ");
        this.format.displayDecimal(out, this.kappa, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.kappaSE, 2);
            out.print(")");
        }
        out.println();
        out.print("Y/R transition rate ratio: ");
        this.format.displayDecimal(out, this.r, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.rSE, 2);
            out.print(")");
        }
        out.println();
        out.println();
        this.printFrequencies(out);
        this.printRatios(out);
    }

    public int getNumParameters() {
        return 2;
    }

    public void setParameterSE(double paramSE, int n) {
        switch (n) {
            case 0: {
                this.kappaSE = paramSE;
                break;
            }
            case 1: {
                this.rSE = paramSE;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.showSE = true;
    }

    public double getLowerLimit(int n) {
        return 1.0E-4;
    }

    public double getUpperLimit(int n) {
        return 100.0;
    }

    public double getDefaultValue(int n) {
        double value;
        switch (n) {
            case 0: {
                value = 4.0;
                break;
            }
            case 1: {
                value = 0.5;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return value;
    }

    public String getUniqueName() {
        return "Tamura-Nei";
    }

    public String getParameterName(int i) {
        switch (i) {
            case 0: {
                return "kappa";
            }
            case 1: {
                return "prymidine/purine transition ratio";
            }
        }
        return "unknown";
    }

    protected void rebuildRateMatrix(double[][] rate, double[] parameters) {
        this.kappa = parameters[0];
        this.r = parameters[1];
        rate[0][1] = 1.0;
        rate[0][2] = 2.0 * this.kappa / (this.r + 1.0);
        rate[0][3] = 1.0;
        rate[1][2] = 1.0;
        rate[1][3] = 2.0 * this.kappa * this.r / (this.r + 1.0);
        rate[2][3] = 1.0;
    }
}

