/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import pal.datatype.CodonTableFactory;
import pal.substmodel.F81;
import pal.substmodel.F84;
import pal.substmodel.GTR;
import pal.substmodel.RateMatrix;
import pal.substmodel.SubstitutionModel;
import pal.substmodel.TN;
import pal.substmodel.YangCodonModel;

public final class SubstitutionTool {
    public static final SubstitutionModel createJC69Model() {
        return F81.JC69_MODEL;
    }

    public static final RateMatrix createJC69Matrix() {
        return F81.JC69_MATRIX;
    }

    public static final SubstitutionModel createF81Model(double[] baseFrequencies) {
        return SubstitutionModel.Utils.createSubstitutionModel(new F81(baseFrequencies));
    }

    public static final RateMatrix createF81Matrix(double[] baseFrequencies) {
        return new F81(baseFrequencies);
    }

    public static final SubstitutionModel createF84Model(double expectedTsTv, double[] baseFrequencies) {
        return SubstitutionModel.Utils.createSubstitutionModel(new F84(expectedTsTv, baseFrequencies));
    }

    public static final RateMatrix createF84Matrix(double expectedTsTv, double[] baseFrequencies) {
        return new F84(expectedTsTv, baseFrequencies);
    }

    public static final SubstitutionModel createTNModel(double kappa, double r, double[] baseFrequencies) {
        return SubstitutionModel.Utils.createSubstitutionModel(new TN(kappa, r, baseFrequencies));
    }

    public static final RateMatrix createTNMatrix(double kappa, double r, double[] baseFrequencies) {
        return new TN(kappa, r, baseFrequencies);
    }

    public static final SubstitutionModel createGTRModel(double a, double b, double c, double d, double e, double[] baseFrequencies) {
        return SubstitutionModel.Utils.createSubstitutionModel(new GTR(a, b, c, d, e, baseFrequencies));
    }

    public static final RateMatrix createGTRMatrix(double a, double b, double c, double d, double e, double[] baseFrequencies) {
        return new GTR(a, b, c, d, e, baseFrequencies);
    }

    public static final SubstitutionModel createM1YangCodonModel(double kappa, double omega, double[] baseFrequencies) {
        return SubstitutionModel.Utils.createSubstitutionModel(new YangCodonModel(omega, kappa, baseFrequencies));
    }

    public static final SubstitutionModel createM2YangCodonModel(double kappa, double p0, double[] baseFrequencies) {
        return new YangCodonModel.SimpleNeutralSelection(CodonTableFactory.createUniversalTranslator(), baseFrequencies, kappa, p0);
    }

    public static final SubstitutionModel createM3YangCodonModel(double kappa, double p0, double p1, double omega, double[] baseFrequencies) {
        return new YangCodonModel.SimplePositiveSelection(CodonTableFactory.createUniversalTranslator(), baseFrequencies, kappa, omega, p0, p1);
    }
}

