/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import pal.datatype.DataType;
import pal.math.OrthogonalHints;
import pal.misc.PalObjectListener;
import pal.misc.Parameterized;
import pal.misc.Report;
import pal.substmodel.RateDistribution;
import pal.substmodel.RateMatrix;

public interface SubstitutionModel
extends Parameterized,
Report,
Serializable {
    public DataType getDataType();

    public int getNumberOfTransitionCategories();

    public double getTransitionCategoryProbability(int var1);

    public double[] getTransitionCategoryProbabilities();

    public void getTransitionProbabilities(double var1, double[][][] var3);

    public void getTransitionProbabilitiesTranspose(double var1, double[][][] var3);

    public void getTransitionProbabilities(double var1, int var3, double[][] var4);

    public void getTransitionProbabilitiesTranspose(double var1, int var3, double[][] var4);

    public double[] getEquilibriumFrequencies();

    public void addPalObjectListener(PalObjectListener var1);

    public void removePalObjectListener(PalObjectListener var1);

    public OrthogonalHints getOrthogonalHints();

    public Object clone();

    public static class Utils {
        public static final double[][][] generateTransitionProbabilityTables(SubstitutionModel model) {
            int numberOfStates = model.getDataType().getNumStates();
            return new double[model.getNumberOfTransitionCategories()][numberOfStates][numberOfStates];
        }

        public static final SubstitutionModel createSubstitutionModel(RateMatrix rm) {
            return new SimpleSubstitutionModel(rm);
        }

        public static final SubstitutionModel createSubstitutionModel(RateMatrix rm, RateDistribution rd) {
            return new RateDistributionSubstitutionModel(rm, rd);
        }

        public static final SubstitutionModel createSubstitutionModel(RateMatrix rm, RateDistribution rd, boolean parameteriseDistribution) {
            return new RateDistributionSubstitutionModel(rm, rd, parameteriseDistribution);
        }

        private static class RateDistributionSubstitutionModel
        extends Parameterized.ParameterizedUser
        implements SubstitutionModel {
            private RateMatrix matrixBase_;
            private RateDistribution distribution_;
            private int numberOfDistributionCategories_;
            private boolean parameteriseDistribution_;
            private static final long serialVersionUID = -3530291767049646272L;

            private void writeObject(ObjectOutputStream out) throws IOException {
                out.writeByte(2);
                out.writeObject(this.matrixBase_);
                out.writeObject(this.distribution_);
                out.writeBoolean(this.parameteriseDistribution_);
            }

            private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                byte version = in.readByte();
                switch (version) {
                    default: {
                        this.matrixBase_ = (RateMatrix)in.readObject();
                        this.distribution_ = (RateDistribution)in.readObject();
                        this.numberOfDistributionCategories_ = this.distribution_.getNumberOfRates();
                        this.parameteriseDistribution_ = in.readBoolean();
                        this.setParameterizedBase(this.parameteriseDistribution_ ? Parameterized.Utils.combine(new Parameterized[]{this.matrixBase_, this.distribution_}) : this.matrixBase_);
                        break;
                    }
                    case 1: {
                        this.matrixBase_ = (RateMatrix)in.readObject();
                        this.distribution_ = (RateDistribution)in.readObject();
                        this.numberOfDistributionCategories_ = this.distribution_.getNumberOfRates();
                        this.parameteriseDistribution_ = true;
                        this.setParameterizedBase(this.parameteriseDistribution_ ? Parameterized.Utils.combine(new Parameterized[]{this.matrixBase_, this.distribution_}) : this.matrixBase_);
                    }
                }
            }

            private RateDistributionSubstitutionModel(RateDistributionSubstitutionModel toCopy) {
                this.matrixBase_ = (RateMatrix)toCopy.matrixBase_.clone();
                this.distribution_ = (RateDistribution)toCopy.distribution_.clone();
                this.parameteriseDistribution_ = toCopy.parameteriseDistribution_;
                this.numberOfDistributionCategories_ = this.distribution_.getNumberOfRates();
                this.setParameterizedBase(this.parameteriseDistribution_ ? Parameterized.Utils.combine(new Parameterized[]{this.matrixBase_, this.distribution_}) : this.matrixBase_);
            }

            public RateDistributionSubstitutionModel(RateMatrix base, RateDistribution distribution) {
                this(base, distribution, true);
            }

            public RateDistributionSubstitutionModel(RateMatrix base, RateDistribution distribution, boolean parameteriseDistribution) {
                super(parameteriseDistribution ? Parameterized.Utils.combine(new Parameterized[]{base, distribution}) : base);
                this.matrixBase_ = base;
                this.distribution_ = distribution;
                this.numberOfDistributionCategories_ = this.distribution_.getNumberOfRates();
            }

            public double[] getTransitionCategoryProbabilities() {
                return this.distribution_.probability;
            }

            public DataType getDataType() {
                return this.matrixBase_.getDataType();
            }

            public int getNumberOfTransitionCategories() {
                return this.distribution_.getNumberOfRates();
            }

            public double getTransitionCategoryProbability(int category) {
                return this.distribution_.probability[category];
            }

            public double[] getEquilibriumFrequencies() {
                return this.matrixBase_.getEquilibriumFrequencies();
            }

            public void getTransitionProbabilities(double branchLength, double[][][] store) {
                int i = 0;
                while (i < this.numberOfDistributionCategories_) {
                    this.matrixBase_.setDistance(branchLength * this.distribution_.rate[i]);
                    this.matrixBase_.getTransitionProbabilities(store[i]);
                    ++i;
                }
            }

            public void getTransitionProbabilities(double branchLength, int category, double[][] store) {
                this.matrixBase_.setDistance(branchLength * this.distribution_.rate[category]);
                this.matrixBase_.getTransitionProbabilities(store);
            }

            public void getTransitionProbabilitiesTranspose(double branchLength, double[][][] store) {
                int i = 0;
                while (i < this.numberOfDistributionCategories_) {
                    this.matrixBase_.setDistanceTranspose(branchLength * this.distribution_.rate[i]);
                    this.matrixBase_.getTransitionProbabilities(store[i]);
                    ++i;
                }
            }

            public void getTransitionProbabilitiesTranspose(double branchLength, int category, double[][] store) {
                this.matrixBase_.setDistanceTranspose(branchLength * this.distribution_.rate[category]);
                this.matrixBase_.getTransitionProbabilities(store);
            }

            public void addPalObjectListener(PalObjectListener l) {
                this.matrixBase_.addPalObjectListener(l);
                this.distribution_.addPalObjectListener(l);
            }

            public void removePalObjectListener(PalObjectListener l) {
                this.matrixBase_.removePalObjectListener(l);
                this.distribution_.removePalObjectListener(l);
            }

            public OrthogonalHints getOrthogonalHints() {
                return null;
            }

            public boolean isParameterBaseIncludingDistribution() {
                return this.parameteriseDistribution_;
            }

            public void report(PrintWriter out) {
                this.matrixBase_.report(out);
                out.println();
                this.distribution_.report(out);
            }

            public String toString() {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, true);
                this.report(pw);
                return "Substitution Model (with Rate Distribution):\n" + sw.toString();
            }

            public Object clone() {
                return new RateDistributionSubstitutionModel(this);
            }

            public SubstitutionModel getCopy() {
                return new RateDistributionSubstitutionModel(this);
            }
        }

        private static class SimpleSubstitutionModel
        extends Parameterized.ParameterizedUser
        implements SubstitutionModel {
            private RateMatrix matrixBase_;
            private static final long serialVersionUID = 3054360219040005677L;

            private void writeObject(ObjectOutputStream out) throws IOException {
                out.writeByte(1);
                out.writeObject(this.matrixBase_);
            }

            private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                byte version = in.readByte();
                switch (version) {
                    default: 
                }
                this.matrixBase_ = (RateMatrix)in.readObject();
                this.setParameterizedBase(this.matrixBase_);
            }

            private SimpleSubstitutionModel(SimpleSubstitutionModel toCopy) {
                this.matrixBase_ = (RateMatrix)toCopy.matrixBase_.clone();
                this.setParameterizedBase(this.matrixBase_);
            }

            public SimpleSubstitutionModel(RateMatrix base) {
                super(base);
                this.matrixBase_ = base;
            }

            public DataType getDataType() {
                return this.matrixBase_.getDataType();
            }

            public int getNumberOfTransitionCategories() {
                return 1;
            }

            public double getTransitionCategoryProbability(int category) {
                return 1.0;
            }

            public double[] getTransitionCategoryProbabilities() {
                return new double[]{1.0};
            }

            public double[] getEquilibriumFrequencies() {
                return this.matrixBase_.getEquilibriumFrequencies();
            }

            public void getTransitionProbabilities(double branchLength, double[][][] store) {
                this.matrixBase_.setDistance(branchLength);
                this.matrixBase_.getTransitionProbabilities(store[0]);
            }

            public void getTransitionProbabilities(double branchLength, int category, double[][] store) {
                this.matrixBase_.setDistance(branchLength);
                this.matrixBase_.getTransitionProbabilities(store);
            }

            public void getTransitionProbabilitiesTranspose(double branchLength, double[][][] store) {
                this.matrixBase_.setDistanceTranspose(branchLength);
                this.matrixBase_.getTransitionProbabilities(store[0]);
            }

            public void getTransitionProbabilitiesTranspose(double branchLength, int category, double[][] store) {
                this.matrixBase_.setDistanceTranspose(branchLength);
                this.matrixBase_.getTransitionProbabilities(store);
            }

            public void addPalObjectListener(PalObjectListener l) {
                this.matrixBase_.addPalObjectListener(l);
            }

            public void removePalObjectListener(PalObjectListener l) {
                this.matrixBase_.removePalObjectListener(l);
            }

            public OrthogonalHints getOrthogonalHints() {
                return null;
            }

            public void report(PrintWriter out) {
                this.matrixBase_.report(out);
            }

            public String toString() {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, true);
                this.report(pw);
                return "Simple Substitution Model:\n" + sw.toString();
            }

            public Object clone() {
                return new SimpleSubstitutionModel(this);
            }

            public SubstitutionModel getCopy() {
                return new SimpleSubstitutionModel(this);
            }
        }
    }
}

