/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.PrintWriter;
import pal.statistics.GammaDistribution;
import pal.substmodel.RateDistribution;

public class GammaRates
extends RateDistribution {
    private boolean showSE;
    private double alpha;
    private double alphaSE;

    public GammaRates(int n, double a) {
        super(n);
        this.alpha = a;
        this.showSE = false;
        this.makeGamma(this.alpha);
    }

    public void report(PrintWriter out) {
        out.println("Model of rate heterogeneity: Discrete Gamma");
        out.println("Number of rate categories: " + this.numRates);
        out.print("Gamma distribution parameter alpha: ");
        this.format.displayDecimal(out, this.alpha, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.alphaSE, 2);
            out.println(")");
        } else {
            out.println();
        }
        out.println();
        this.printRates(out);
    }

    public int getNumParameters() {
        return 1;
    }

    public void setParameter(double param, int n) {
        this.alpha = param;
        this.makeGamma(this.alpha);
    }

    public double getParameter(int n) {
        return this.alpha;
    }

    public void setParameterSE(double paramSE, int n) {
        this.alphaSE = paramSE;
        this.showSE = true;
    }

    public double getLowerLimit(int n) {
        return 0.001;
    }

    public double getUpperLimit(int n) {
        return 100.0;
    }

    public double getDefaultValue(int n) {
        return 0.5;
    }

    private void makeGamma(double a) {
        double mean = 0.0;
        int i = 0;
        while (i < this.numRates) {
            this.rate[i] = GammaDistribution.quantile((2.0 * (double)i + 1.0) / (2.0 * (double)this.numRates), a, 1.0 / a);
            mean += this.rate[i];
            ++i;
        }
        mean /= (double)this.numRates;
        int i2 = 0;
        while (i2 < this.numRates) {
            int n = i2;
            this.rate[n] = this.rate[n] / mean;
            this.probability[i2] = 1.0 / (double)this.numRates;
            ++i2;
        }
        this.fireParametersChangedEvent();
    }
}

