/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import java.io.PrintWriter;
import pal.io.FormattedOutput;
import pal.math.ErrorFunction;
import pal.misc.Report;

public class KishinoHasegawaTest
implements Report {
    public int bestH;
    public double[] delta;
    public double[] deltaSE;
    public double[] pval;

    public void compare(double[][] sLogL) {
        this.khtest(sLogL, null);
    }

    public void compare(double[][] pLogL, int[] alias) {
        this.khtest(pLogL, alias);
    }

    public void report(PrintWriter out) {
        FormattedOutput fo = FormattedOutput.getInstance();
        out.println("KISHINO-HASEGAWA TEST:");
        out.println();
        out.println("tree\tdeltaL\tS.E.\tpval (two-sided)");
        out.println("----------------------------------------");
        int i = 0;
        while (i < this.pval.length) {
            out.print(i + 1 + "\t");
            fo.displayDecimal(out, this.delta[i], 2);
            out.print("\t");
            fo.displayDecimal(out, this.deltaSE[i], 2);
            out.print("\t");
            fo.displayDecimal(out, this.pval[i], 4);
            if (this.pval[i] < 0.05) {
                out.println(" **");
            } else {
                out.println();
            }
            ++i;
        }
        out.println();
        out.println("** indicates a tree that is significantly worse than the ML tree (5% level)");
    }

    private void khtest(double[][] pLogL, int[] alias) {
        int numH = pLogL.length;
        this.delta = new double[numH];
        this.deltaSE = new double[numH];
        this.pval = new double[numH];
        int numSites = alias == null ? pLogL[0].length : alias.length;
        double[] logL = new double[numH];
        int i = 0;
        while (i < numSites) {
            int p = alias == null ? i : alias[i];
            int j = 0;
            while (j < numH) {
                int n = j;
                logL[n] = logL[n] + pLogL[j][p];
                ++j;
            }
            ++i;
        }
        this.bestH = 0;
        double maxLogL = logL[0];
        int i2 = 1;
        while (i2 < numH) {
            if (logL[i2] > maxLogL) {
                this.bestH = i2;
                maxLogL = logL[i2];
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < numH) {
            this.delta[i3] = logL[this.bestH] - logL[i3];
            ++i3;
        }
        int i4 = 0;
        while (i4 < numH) {
            double mean = this.delta[i4] / (double)numSites;
            double var = 0.0;
            int j = 0;
            while (j < numSites) {
                int p = alias == null ? j : alias[j];
                double diff = pLogL[this.bestH][p] - pLogL[i4][p] - mean;
                var += diff * diff;
                ++j;
            }
            this.deltaSE[i4] = Math.sqrt((double)numSites * var / (double)(numSites - 1));
            ++i4;
        }
        int i5 = 0;
        while (i5 < numH) {
            this.pval[i5] = ErrorFunction.erfc(this.delta[i5] / this.deltaSE[i5] / Math.sqrt(2.0));
            ++i5;
        }
        logL = null;
    }
}

