/*
 * Decompiled with CFR 0.152.
 */
package pal.misc;

import pal.math.MultivariateFunction;
import pal.math.OrthogonalHints;
import pal.misc.Parameterized;

public class Utils {
    public static final double[] getCopy(double[] array) {
        if (array == null) {
            return null;
        }
        double[] copy = new double[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static final double[] getCopy(double[] array, int start, int end) {
        if (array == null) {
            return null;
        }
        double[] copy = new double[end - start];
        System.arraycopy(array, start, copy, 0, copy.length);
        return copy;
    }

    public static final double[] getCopy(double[] array, int start) {
        return Utils.getCopy(array, start, array.length);
    }

    public static final byte[] getCopy(byte[] array) {
        if (array == null) {
            return null;
        }
        byte[] copy = new byte[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static final double[][] getCopy(double[][] array) {
        if (array == null) {
            return null;
        }
        double[][] copy = new double[array.length][];
        int i = 0;
        while (i < copy.length) {
            copy[i] = new double[array[i].length];
            System.arraycopy(array[i], 0, copy[i], 0, array[i].length);
            ++i;
        }
        return copy;
    }

    public static final double[][][] getCopy(double[][][] array) {
        if (array == null) {
            return null;
        }
        double[][][] copy = new double[array.length][][];
        int i = 0;
        while (i < copy.length) {
            copy[i] = Utils.getCopy(array[i]);
            ++i;
        }
        return copy;
    }

    public static final byte[][] getCopy(byte[][] array) {
        if (array == null) {
            return null;
        }
        byte[][] copy = new byte[array.length][];
        int i = 0;
        while (i < copy.length) {
            copy[i] = new byte[array[i].length];
            System.arraycopy(array[i], 0, copy[i], 0, array[i].length);
            ++i;
        }
        return copy;
    }

    public static final boolean[][] getCopy(boolean[][] array) {
        if (array == null) {
            return null;
        }
        boolean[][] copy = new boolean[array.length][];
        int i = 0;
        while (i < copy.length) {
            copy[i] = new boolean[array[i].length];
            System.arraycopy(array[i], 0, copy[i], 0, array[i].length);
            ++i;
        }
        return copy;
    }

    public static final int[] getCopy(int[] array) {
        if (array == null) {
            return null;
        }
        int[] copy = new int[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static final int[] getCopy(int[] array, int startingIndex) {
        if (array == null) {
            return null;
        }
        int[] copy = new int[array.length - startingIndex];
        System.arraycopy(array, startingIndex, copy, 0, array.length - startingIndex);
        return copy;
    }

    public static final void copy(double[][] source, double[][] dest) {
        int i = 0;
        while (i < source.length) {
            System.arraycopy(source[i], 0, dest[i], 0, source[i].length);
            ++i;
        }
    }

    public static final String toString(double[] array, int number) {
        StringBuffer sb = new StringBuffer(array.length * 7);
        int i = 0;
        while (i < number) {
            sb.append(array[i]);
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public static final String toString(Object[] array, int number) {
        StringBuffer sb = new StringBuffer(array.length * 7);
        int i = 0;
        while (i < number) {
            sb.append(array[i]);
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public static final String toString(Object[] array, String divider) {
        return Utils.toString(array, divider, array.length);
    }

    public static final String toString(Object[] array, String divider, int number) {
        StringBuffer sb = new StringBuffer(array.length * 7);
        int i = 0;
        while (i < number) {
            sb.append(array[i]);
            if (i != number - 1) {
                sb.append(divider);
            }
            ++i;
        }
        return sb.toString();
    }

    public static final String toString(Object[] array) {
        return Utils.toString(array, array.length);
    }

    public static final String toString(double[] array) {
        return Utils.toString(array, array.length);
    }

    public static final String toString(int[] array) {
        return Utils.toString(array, array.length);
    }

    public static final String toString(int[] array, int number) {
        StringBuffer sb = new StringBuffer(array.length * 7);
        int i = 0;
        while (i < number) {
            sb.append(array[i]);
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public static final String toString(double[][] array) {
        String ss = "";
        int i = 0;
        while (i < array.length) {
            ss = ss + i + ":" + Utils.toString(array[i]) + '\n';
            ++i;
        }
        return ss;
    }

    public static final String toString(int[][] array) {
        String ss = "";
        int i = 0;
        while (i < array.length) {
            ss = ss + i + ":" + Utils.toString(array[i]) + '\n';
            ++i;
        }
        return ss;
    }

    public static final MultivariateFunction combineMultivariateFunction(MultivariateFunction base, Parameterized[] additionalParameters) {
        return new CombineMultiParam(base, additionalParameters);
    }

    private static class CombineMultiParam
    implements MultivariateFunction {
        Parameterized[] additionalParameters_;
        MultivariateFunction base_;
        double[] baseArgumentStorage_;
        double[] lowerBounds_;
        double[] upperBounds_;

        public CombineMultiParam(MultivariateFunction base, Parameterized[] additionalParameters) {
            this.additionalParameters_ = additionalParameters;
            this.base_ = base;
            int numberOfArguments = this.base_.getNumArguments();
            this.baseArgumentStorage_ = new double[numberOfArguments];
            int i = 0;
            while (i < additionalParameters.length) {
                numberOfArguments += additionalParameters[i].getNumParameters();
                ++i;
            }
            this.lowerBounds_ = new double[numberOfArguments];
            this.upperBounds_ = new double[numberOfArguments];
            int argumentNumber = 0;
            int i2 = 0;
            while (i2 < this.base_.getNumArguments()) {
                this.lowerBounds_[argumentNumber] = this.base_.getLowerBound(i2);
                this.upperBounds_[argumentNumber] = this.base_.getUpperBound(i2);
                ++argumentNumber;
                ++i2;
            }
            int i3 = 0;
            while (i3 < additionalParameters.length) {
                int j = 0;
                while (j < additionalParameters[i3].getNumParameters()) {
                    this.lowerBounds_[argumentNumber] = additionalParameters[i3].getLowerLimit(j);
                    this.upperBounds_[argumentNumber] = additionalParameters[i3].getUpperLimit(j);
                    ++argumentNumber;
                    ++j;
                }
                ++i3;
            }
        }

        public double evaluate(double[] argument) {
            int argumentNumber = 0;
            int i = 0;
            while (i < this.baseArgumentStorage_.length) {
                this.baseArgumentStorage_[i] = argument[argumentNumber];
                ++argumentNumber;
                ++i;
            }
            int i2 = 0;
            while (i2 < this.additionalParameters_.length) {
                int numParam = this.additionalParameters_[i2].getNumParameters();
                int j = 0;
                while (j < numParam) {
                    this.additionalParameters_[i2].setParameter(argument[argumentNumber], j);
                    ++argumentNumber;
                    ++j;
                }
                ++i2;
            }
            return this.base_.evaluate(this.baseArgumentStorage_);
        }

        public int getNumArguments() {
            return this.lowerBounds_.length;
        }

        public double getLowerBound(int n) {
            return this.lowerBounds_[n];
        }

        public double getUpperBound(int n) {
            return this.upperBounds_[n];
        }

        public OrthogonalHints getOrthogonalHints() {
            return null;
        }
    }
}

