/*
 * Decompiled with CFR 0.152.
 */
package pal.misc;

import pal.misc.MultiParameterized;
import pal.misc.PalObjectListener;

public interface Parameterized {
    public int getNumParameters();

    public void setParameter(double var1, int var3);

    public double getParameter(int var1);

    public void setParameterSE(double var1, int var3);

    public double getLowerLimit(int var1);

    public double getUpperLimit(int var1);

    public double getDefaultValue(int var1);

    public static final class Utils {
        public static final double[] getParameters(Parameterized source) {
            double[] params = new double[source.getNumParameters()];
            int i = 0;
            while (i < params.length) {
                params[i] = source.getParameter(i);
                ++i;
            }
            return params;
        }

        public static final Parameterized createParametizedWrapper(double[] parameters, double[] lowerLimits, double[] upperLimits, double[] defaultValues) {
            return new ParameterizedWrapper(parameters, lowerLimits, upperLimits, defaultValues);
        }

        public static final Parameterized createParametizedWrapper(double[] parameters, double[] lowerLimits, double[] upperLimits, double[] defaultValues, double[] parametersSE) {
            return new ParameterizedWrapper(parameters, lowerLimits, upperLimits, defaultValues, parametersSE);
        }

        public static final Parameterized combine(Parameterized[] bases) {
            return new MultiParameterized(bases);
        }

        public static final Parameterized combine(Parameterized baseOne, Parameterized baseTwo) {
            return new MultiParameterized(new Parameterized[]{baseOne, baseTwo});
        }

        private static final class ParameterizedWrapper
        extends ParameterizedBase
        implements Parameterized {
            public ParameterizedWrapper(double[] parameters, double[] lowerLimits, double[] upperLimits, double[] defaultValues) {
                super(parameters, lowerLimits, upperLimits, defaultValues);
            }

            public ParameterizedWrapper(double[] parameters, double[] lowerLimits, double[] upperLimits, double[] defaultValues, double[] parametersSE) {
                super(parameters, lowerLimits, upperLimits, defaultValues, parametersSE);
            }
        }
    }

    public static abstract class Null
    implements Parameterized {
        protected Null() {
        }

        public int getNumParameters() {
            return 0;
        }

        private double error() {
            throw new RuntimeException("Assertion error : should not be called as no parameters!");
        }

        public void setParameter(double param, int n) {
            this.error();
        }

        public double getParameter(int n) {
            return this.error();
        }

        public void setParameterSE(double paramSE, int n) {
            this.error();
        }

        public double getLowerLimit(int n) {
            return this.error();
        }

        public double getUpperLimit(int n) {
            return this.error();
        }

        public double getDefaultValue(int n) {
            return this.error();
        }
    }

    public static abstract class ParameterizedBase
    extends PalObjectListener.EventGenerator {
        private double[] parameters_;
        private double[] lowerLimits_;
        private double[] upperLimits_;
        private double[] defaultValues_;
        private double[] parametersSE_;

        protected ParameterizedBase(double[] parameters, double[] lowerLimits, double[] upperLimits, double[] defaultValues) {
            this.setSource(parameters, lowerLimits, upperLimits, defaultValues);
        }

        protected ParameterizedBase(double[] parameters, double[] lowerLimits, double[] upperLimits, double[] defaultValues, double[] parametersSE) {
            this.setSource(parameters, lowerLimits, upperLimits, defaultValues, parametersSE);
        }

        protected ParameterizedBase() {
        }

        protected void setSource(double[] parameters, double[] lowerLimits, double[] upperLimits, double[] defaultValues) {
            this.setSource(parameters, lowerLimits, upperLimits, defaultValues, new double[parameters.length]);
        }

        protected void setSource(double[] parameters, double[] lowerLimits, double[] upperLimits, double[] defaultValues, double[] parametersSE) {
            this.parameters_ = parameters;
            this.lowerLimits_ = lowerLimits;
            this.upperLimits_ = upperLimits;
            this.defaultValues_ = defaultValues;
            this.parametersSE_ = parametersSE;
            int length = this.parameters_.length;
            if (lowerLimits.length != length) {
                this.sizeError();
            }
            if (upperLimits.length != length) {
                this.sizeError();
            }
            if (defaultValues.length != length) {
                this.sizeError();
            }
            if (parametersSE.length != length) {
                this.sizeError();
            }
        }

        private final void sizeError() {
            throw new IllegalArgumentException("All arrays do not match in size");
        }

        public int getNumParameters() {
            return this.parameters_.length;
        }

        public void setParameter(double param, int n) {
            this.parameters_[n] = param;
            this.fireParametersChangedEvent();
        }

        public double getParameter(int n) {
            return this.parameters_[n];
        }

        public void setParameterSE(double paramSE, int n) {
            this.parametersSE_[n] = paramSE;
        }

        public double getLowerLimit(int n) {
            return this.lowerLimits_[n];
        }

        public double getUpperLimit(int n) {
            return this.upperLimits_[n];
        }

        public double getDefaultValue(int n) {
            return this.defaultValues_[n];
        }

        protected double[] getParametersSE() {
            return this.parametersSE_;
        }
    }

    public static abstract class ParameterizedUser
    extends PalObjectListener.EventGenerator {
        private Parameterized base_;

        protected ParameterizedUser(Parameterized base) {
            this.base_ = base;
        }

        protected ParameterizedUser() {
        }

        protected void setParameterizedBase(Parameterized base) {
            this.base_ = base;
        }

        public int getNumParameters() {
            return this.base_.getNumParameters();
        }

        public void setParameter(double param, int n) {
            this.base_.setParameter(param, n);
            this.fireParametersChangedEvent();
        }

        protected double getRandomParameterValue(int parameter) {
            double min = this.base_.getLowerLimit(parameter);
            double max = this.base_.getUpperLimit(parameter);
            return Math.random() * (max - min) + min;
        }

        protected void randomiseParameters() {
            int numberParameters = this.base_.getNumParameters();
            int i = 0;
            while (i < numberParameters) {
                this.base_.setParameter(this.getRandomParameterValue(i), i);
                ++i;
            }
        }

        public double getParameter(int n) {
            return this.base_.getParameter(n);
        }

        public void setParameterSE(double paramSE, int n) {
            this.base_.setParameterSE(paramSE, n);
        }

        public double getLowerLimit(int n) {
            return this.base_.getLowerLimit(n);
        }

        public double getUpperLimit(int n) {
            return this.base_.getUpperLimit(n);
        }

        public double getDefaultValue(int n) {
            return this.base_.getDefaultValue(n);
        }
    }
}

