/*
 * Decompiled with CFR 0.152.
 */
package pal.misc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import pal.misc.IdGroup;
import pal.misc.Nameable;
import pal.util.Comparable;

public class Identifier
implements Serializable,
Comparable,
Nameable {
    private String name = null;
    private static final long serialVersionUID = -7873729831795750538L;
    public static Identifier ANONYMOUS = new Identifier("");

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.name = (String)in.readObject();
    }

    public Identifier() {
    }

    public Identifier(String name) {
        this.setName(name);
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(Object c) {
        return this.getName().compareTo(((Identifier)c).getName());
    }

    public boolean equals(Object c) {
        if (c instanceof Identifier) {
            return this.getName().equals(((Identifier)c).getName());
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public static final String[] getNames(Identifier[] ids) {
        String[] names = new String[ids.length];
        int i = 0;
        while (i < names.length) {
            names[i] = ids[i].getName();
            ++i;
        }
        return names;
    }

    public static final String[] getNames(Identifier[] ids, int toIgnore) {
        if (toIgnore < 0 || toIgnore >= ids.length) {
            return Identifier.getNames(ids);
        }
        String[] names = new String[ids.length - 1];
        int index = 0;
        int i = 0;
        while (i < names.length) {
            if (i != toIgnore) {
                names[index] = ids[i].getName();
                ++index;
            }
            ++i;
        }
        return names;
    }

    public static final Identifier[] getIdentifiers(String[] names) {
        Identifier[] ids = new Identifier[names.length];
        int i = 0;
        while (i < names.length) {
            ids[i] = new Identifier(names[i]);
            ++i;
        }
        return ids;
    }

    public static final Identifier[] getIdentifiers(IdGroup idGroup) {
        Identifier[] ids = new Identifier[idGroup.getIdCount()];
        int i = 0;
        while (i < ids.length) {
            ids[i] = idGroup.getIdentifier(i);
            ++i;
        }
        return ids;
    }

    public static final String[] getNames(IdGroup ids) {
        String[] names = new String[ids.getIdCount()];
        int i = 0;
        while (i < names.length) {
            names[i] = ids.getIdentifier(i).getName();
            ++i;
        }
        return names;
    }

    public static final String[] getNames(IdGroup ids, int toIgnore) {
        if (toIgnore < 0 || toIgnore >= ids.getIdCount()) {
            return Identifier.getNames(ids);
        }
        int numberOfIDS = ids.getIdCount();
        String[] names = new String[numberOfIDS - 1];
        int index = 0;
        int i = 0;
        while (i < numberOfIDS) {
            if (i != toIgnore) {
                names[index] = ids.getIdentifier(i).getName();
                ++index;
            }
            ++i;
        }
        return names;
    }

    public static final String[] getNames(IdGroup ids, int[] toIgnore) {
        if (toIgnore == null) {
            return Identifier.getNames(ids);
        }
        int numberOfIDS = ids.getIdCount();
        Vector<String> names = new Vector<String>(numberOfIDS);
        int i = 0;
        while (i < numberOfIDS) {
            boolean ignore = false;
            int j = 0;
            while (j < toIgnore.length) {
                if (toIgnore[j] == i) {
                    ignore = true;
                    break;
                }
                ++j;
            }
            if (!ignore) {
                names.addElement(ids.getIdentifier(i).getName());
            }
            ++i;
        }
        Object[] namesFinal = new String[names.size()];
        names.copyInto(namesFinal);
        return namesFinal;
    }
}

