/*
 * Decompiled with CFR 0.152.
 */
package pal.mep;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.io.OutputTarget;
import pal.mep.MutationRateModel;
import pal.misc.Parameterized;
import pal.misc.Report;
import pal.misc.Summarizable;
import pal.misc.Units;

public class WindowedMutationRate
extends MutationRateModel
implements Report,
Summarizable,
Parameterized,
Serializable {
    private double muBackground;
    private double muWindow;
    private double muBackgroundSE;
    private double muWindowSE;
    private double windowCenter;
    private double windowWidth;
    private boolean backgroundFixed = false;
    String[] summaryTypes = null;

    protected WindowedMutationRate(WindowedMutationRate toCopy) {
        super(toCopy);
        this.muBackground = toCopy.muBackground;
        this.muWindow = toCopy.muWindow;
        this.muBackgroundSE = toCopy.muBackgroundSE;
        this.muWindowSE = toCopy.muWindowSE;
        this.windowCenter = toCopy.windowCenter;
        this.windowWidth = toCopy.windowWidth;
    }

    public WindowedMutationRate(double windowCenter, double windowWidth, int units, double maximumMutationRate) {
        super(units, maximumMutationRate);
        this.windowCenter = windowCenter;
        this.windowWidth = windowWidth;
        this.muBackground = this.getDefaultValue(0);
        this.muWindow = this.getDefaultValue(0);
    }

    public WindowedMutationRate(double muBackground, double windowCenter, double windowWidth, int units, double maximumMutationRate) {
        super(units, maximumMutationRate);
        this.muBackground = muBackground;
        this.backgroundFixed = true;
        this.windowCenter = windowCenter;
        this.windowWidth = windowWidth;
        this.muWindow = this.getDefaultValue(0);
    }

    public WindowedMutationRate(double muWindow, double muBackground, double windowCenter, double windowWidth, int units, boolean fixedb, double maximumMutationRate) {
        super(units, maximumMutationRate);
        this.muWindow = muWindow;
        this.muBackground = muBackground;
        this.backgroundFixed = fixedb;
        this.windowCenter = windowCenter;
        this.windowWidth = windowWidth;
    }

    public WindowedMutationRate(double muWindow, double muBackground, double windowCenter, double windowWidth, int units, double maximumMutationRate) {
        this(muWindow, muBackground, windowCenter, windowWidth, units, false, maximumMutationRate);
    }

    public Object clone() {
        return this.getCopy();
    }

    public MutationRateModel getCopy() {
        return new WindowedMutationRate(this);
    }

    public String[] getSummaryTypes() {
        if (this.summaryTypes == null) {
            this.summaryTypes = new String[4];
            this.summaryTypes[0] = "window mu";
            this.summaryTypes[1] = "background mu";
            this.summaryTypes[2] = "window center";
            this.summaryTypes[3] = "window width";
        }
        return this.summaryTypes;
    }

    public double getSummaryValue(int summaryType) {
        switch (summaryType) {
            case 0: {
                return this.muWindow;
            }
            case 1: {
                return this.muBackground;
            }
            case 2: {
                return this.windowCenter;
            }
            case 3: {
                return this.windowWidth;
            }
        }
        throw new RuntimeException("Assertion error: unknown summary type :" + summaryType);
    }

    public double getMu() {
        return this.getMutationRate(0.0);
    }

    public final double getMutationRate(double t) {
        if (t > this.windowCenter - this.windowWidth / 2.0 && t <= this.windowCenter + this.windowWidth / 2.0) {
            return this.muWindow;
        }
        return this.muBackground;
    }

    public final double getExpectedSubstitutions(double time) {
        double height = 0.0;
        double totalTime = this.windowCenter - this.windowWidth / 2.0;
        if (totalTime > time) {
            return this.muBackground * time;
        }
        if (totalTime >= 0.0) {
            height += this.muBackground * totalTime;
        } else {
            System.err.println("Mutation window spans time zero!");
        }
        if (totalTime + this.windowWidth > time) {
            return height + this.muWindow * (time - totalTime);
        }
        return (height += this.muWindow * this.windowWidth) + this.muBackground * (time - (totalTime += this.windowWidth));
    }

    public final double getEndTime(double expectedSubs, double startTime) {
        double windowStart = this.windowCenter - this.windowWidth;
        double windowEnd = this.windowCenter + this.windowWidth;
        if (startTime >= windowStart) {
            if (startTime > windowEnd) {
                return expectedSubs / this.muBackground + startTime;
            }
            double eTime = expectedSubs / this.muWindow + startTime;
            if (eTime < windowEnd) {
                return eTime;
            }
            double wSubs = this.muWindow * (windowEnd - startTime);
            return (expectedSubs - wSubs) / this.muBackground + windowEnd;
        }
        double eTime = expectedSubs / this.muWindow + startTime;
        if (eTime < windowStart) {
            return eTime;
        }
        double bwSubs = this.muBackground * (windowStart - startTime);
        eTime = (expectedSubs - bwSubs) / this.muWindow + windowStart;
        if (eTime < windowEnd) {
            return eTime;
        }
        double windowSubs = this.muWindow * this.windowWidth;
        return (expectedSubs - windowSubs - bwSubs) / this.muBackground + windowEnd;
    }

    public final void scale(double scale) {
        this.muBackground *= scale;
        this.muWindow *= scale;
    }

    public int getNumParameters() {
        if (this.backgroundFixed) {
            return 1;
        }
        return 2;
    }

    public double getParameter(int k) {
        switch (k) {
            case 0: {
                return this.muWindow;
            }
            case 1: {
                return this.muBackground;
            }
        }
        return this.muWindow;
    }

    public double getUpperLimit(int k) {
        return 1.0E12;
    }

    public double getLowerLimit(int k) {
        return 1.0E-12;
    }

    public double getDefaultValue(int k) {
        if (this.getUnits() == 1) {
            return 1.0E-6;
        }
        return 1.0E-6;
    }

    public void setParameter(double value, int k) {
        switch (k) {
            case 0: {
                this.muWindow = value;
                break;
            }
            case 1: {
                this.muBackground = value;
            }
        }
    }

    public void setParameterSE(double value, int k) {
        switch (k) {
            case 0: {
                this.muWindowSE = value;
                break;
            }
            case 1: {
                this.muBackgroundSE = value;
            }
        }
    }

    public String toString() {
        OutputTarget out = OutputTarget.openString();
        this.report(out);
        out.close();
        return out.getString();
    }

    public void report(PrintWriter out) {
        out.println("Mutation rate model: windowed mutation rate ");
        out.print("Unit of time: ");
        out.print(Units.UNIT_NAMES[this.getUnits()]);
        out.println();
        out.println();
        out.println("Parameters of demographic function:");
        out.print("window = ");
        this.fo.displayDecimal(out, this.windowCenter - this.windowWidth / 2.0, 6);
        out.print(" - ");
        this.fo.displayDecimal(out, this.windowCenter + this.windowWidth / 2.0, 6);
        out.println();
        out.print("window mutation rate = ");
        this.fo.displayDecimal(out, this.muWindow, 9);
        out.println();
        out.print("background mutation rate = ");
        this.fo.displayDecimal(out, this.muBackground, 9);
        out.println();
        if (this.backgroundFixed) {
            out.println("background mutation rate fixed.");
        } else {
            out.println("background mutation rate free to vary.");
        }
    }

    public String toSingleLine() {
        String line = "";
        line = line + "win mu\t" + this.muWindow + "\t";
        line = line + "bg mu\t" + this.muBackground + "\t";
        line = line + "win cen\t" + this.windowCenter + "\t";
        line = line + "win wid\t" + this.windowWidth + "\t";
        return line;
    }

    public MutationRateModel.Factory generateFactory() {
        return new RateFactory(this.muWindow, this.muBackground, this.windowCenter, this.windowWidth, this.getUnits(), this.getMaximumMutationRate());
    }

    public static final MutationRateModel.Factory getFactory(double muWindow, double muBackground, double windowCenter, double windowWidth, int units, double maximumMutationRate) {
        return new RateFactory(muWindow, muBackground, windowCenter, windowWidth, units, maximumMutationRate);
    }

    private static final class RateFactory
    implements MutationRateModel.Factory {
        private final double muWindow_;
        private final double muBackground_;
        private final double maximumMutationRate_;
        private final double windowCenter_;
        private final double windowWidth_;
        private final int units_;

        public RateFactory(double muWindow, double muBackground, double windowCenter, double windowWidth, int units, double maximumMutationRate) {
            this.muWindow_ = muWindow;
            this.muBackground_ = muBackground;
            this.windowCenter_ = windowCenter;
            this.windowWidth_ = windowWidth;
            this.units_ = units;
            this.maximumMutationRate_ = maximumMutationRate;
        }

        public MutationRateModel generateNewModel() {
            return new WindowedMutationRate(this.muWindow_, this.muBackground_, this.windowCenter_, this.windowWidth_, this.units_, this.maximumMutationRate_);
        }
    }
}

