/*
 * Decompiled with CFR 0.152.
 */
package pal.mep;

import java.io.Serializable;
import pal.io.FormattedOutput;
import pal.math.OrthogonalHints;
import pal.mep.MutationRateModel;
import pal.misc.Identifier;
import pal.misc.PalObjectListener;
import pal.misc.Parameterized;
import pal.misc.TimeOrderCharacterData;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public interface DeltaModel
extends Serializable {
    public Instance generateInstance(TimeOrderCharacterData var1);

    public boolean canGenerateAlternativeTreeRepresentation();

    public static final class Utils {
        public static final DeltaModel getMutationRateModelBased(MutationRateModel.Factory mepFactory) {
            return new MutationRateDeltaModel(mepFactory);
        }

        public static final DeltaModel getUntimedBased() {
            return UntimedDeltaModel.DEFAULT_INSTNACE;
        }

        public static final DeltaModel getUntimedBased(double[] initalDeltas) {
            return new UntimedDeltaModel(initalDeltas);
        }

        public static final DeltaModel getDisjointBased(DeltaModel primaryModel, DeltaModel subgroupModel, TimeOrderCharacterData subgroupTOCD) {
            return new DisjointDeltaModel(primaryModel, subgroupModel, subgroupTOCD);
        }

        private static final class UntimedDeltaModel
        implements DeltaModel {
            private static final double DEFAULT_MAX_HEIGHT = 10000.0;
            public static final DeltaModel DEFAULT_INSTNACE = new UntimedDeltaModel(10000.0);
            private final double maxRelativeHeight_;
            private final double[] initialDeltas_;

            public UntimedDeltaModel(double maxRelativeHeight) {
                this(maxRelativeHeight, null);
            }

            public UntimedDeltaModel(double[] initalDeltas) {
                this(10000.0, initalDeltas);
            }

            public UntimedDeltaModel(double maxRelativeHeight, double[] initalDeltas) {
                this.maxRelativeHeight_ = maxRelativeHeight;
                this.initialDeltas_ = initalDeltas;
            }

            public Instance generateInstance(TimeOrderCharacterData tocd) {
                return new InstanceImpl(tocd, this.maxRelativeHeight_, this.initialDeltas_);
            }

            public boolean canGenerateAlternativeTreeRepresentation() {
                return true;
            }

            private static class InstanceImpl
            extends PalObjectListener.EventGenerator
            implements Instance {
                TimeOrderCharacterData tocd_;
                final double[] intervalRates_;
                final double maxIntervalWidth_;

                public InstanceImpl(TimeOrderCharacterData tocd) {
                    this(tocd, 10000.0);
                }

                public InstanceImpl(TimeOrderCharacterData tocd, double maxIntervalWidth) {
                    this(tocd, maxIntervalWidth, null);
                }

                public InstanceImpl(TimeOrderCharacterData tocd, double maxIntervalWidth, double[] initalDeltas) {
                    this.tocd_ = tocd;
                    this.maxIntervalWidth_ = maxIntervalWidth;
                    this.intervalRates_ = new double[this.tocd_.getSampleCount() - 1];
                    if (initalDeltas != null) {
                        int maxIndex = Math.min(this.intervalRates_.length, initalDeltas.length);
                        System.arraycopy(initalDeltas, 0, this.intervalRates_, 0, Math.min(this.intervalRates_.length, initalDeltas.length));
                    }
                }

                public Tree generateAlternativeRepresentation(Tree expectedSubstitutionsTree) {
                    return expectedSubstitutionsTree;
                }

                public OrthogonalHints getOrthogonalHints() {
                    return null;
                }

                public int getNumParameters() {
                    return this.intervalRates_.length;
                }

                public void setParameter(double param, int n) {
                    this.intervalRates_[n] = param;
                    this.fireParametersChangedEvent();
                }

                public double getParameter(int n) {
                    return this.intervalRates_[n];
                }

                public void setParameterSE(double paramSE, int n) {
                }

                public double getLowerLimit(int n) {
                    return 0.0;
                }

                public double getUpperLimit(int n) {
                    return this.maxIntervalWidth_;
                }

                public double getDefaultValue(int n) {
                    return 0.0;
                }

                public double getExpectedSubstitutionsToTime(double time) throws UnsupportedOperationException {
                    throw new UnsupportedOperationException("Can't do");
                }

                public double getExpectedSubstitutions(int taxon) {
                    int sample = this.tocd_.getTimeOrdinal(taxon);
                    double total = 0.0;
                    int i = 0;
                    while (i < sample) {
                        total += this.intervalRates_[i];
                        ++i;
                    }
                    return total;
                }

                public String getHTMLInfo() {
                    return "<ul><li>No time information was available</li><li>Interval deltas (in expected substitutions):" + FormattedOutput.getInstance().getSFString(this.intervalRates_, 4, ", ") + "</li>" + "</ul>";
                }
            }
        }

        private static final class DisjointDeltaModel
        implements DeltaModel {
            private final DeltaModel primaryModel_;
            private final DeltaModel subgroupModel_;
            private final TimeOrderCharacterData subgroupTOCD_;

            public DisjointDeltaModel(DeltaModel primaryModel, DeltaModel subgroupModel, TimeOrderCharacterData subgroupTOCD) {
                this.primaryModel_ = primaryModel;
                this.subgroupModel_ = subgroupModel;
                this.subgroupTOCD_ = subgroupTOCD;
            }

            public Instance generateInstance(TimeOrderCharacterData tocd) {
                return new InstanceImpl(this.primaryModel_.generateInstance(tocd), tocd, this.subgroupModel_.generateInstance(this.subgroupTOCD_), this.subgroupTOCD_);
            }

            public boolean canGenerateAlternativeTreeRepresentation() {
                return true;
            }

            private static final class InstanceImpl
            extends Parameterized.ParameterizedUser
            implements Instance {
                private final Instance primaryModel_;
                private final Instance subgroupModel_;
                private final TimeOrderCharacterData primaryTOCD_;
                private final TimeOrderCharacterData subgroupTOCD_;
                private final int[] subgroupTaxonLookup_;

                public InstanceImpl(Instance primaryModel, TimeOrderCharacterData primaryTOCD, Instance subgroupModel, TimeOrderCharacterData subgroupTOCD) {
                    this.primaryModel_ = primaryModel;
                    this.primaryTOCD_ = primaryTOCD;
                    this.subgroupModel_ = subgroupModel;
                    this.subgroupTOCD_ = subgroupTOCD;
                    this.setParameterizedBase(Parameterized.Utils.combine(primaryModel, subgroupModel));
                    this.subgroupTaxonLookup_ = new int[primaryTOCD.getIdCount()];
                    int i = 0;
                    while (i < this.subgroupTaxonLookup_.length) {
                        this.subgroupTaxonLookup_[i] = subgroupTOCD.whichIdNumber(primaryTOCD.getIdentifier(i).getName());
                        ++i;
                    }
                }

                public Tree generateAlternativeRepresentation(Tree expectedSubstitutionsTree) {
                    return expectedSubstitutionsTree;
                }

                public double getExpectedSubstitutionsToTime(double time) throws UnsupportedOperationException {
                    throw new UnsupportedOperationException("Can't do");
                }

                public OrthogonalHints getOrthogonalHints() {
                    return null;
                }

                public double getExpectedSubstitutions(int taxon) {
                    int subgroupIndex = this.subgroupTaxonLookup_[taxon];
                    if (subgroupIndex >= 0) {
                        return this.subgroupModel_.getExpectedSubstitutions(subgroupIndex);
                    }
                    return this.primaryModel_.getExpectedSubstitutions(taxon);
                }

                public String getHTMLInfo() {
                    return "<ul><li>Disjoint Model</li><li>Primary Model:" + this.primaryModel_.getHTMLInfo() + "</li>" + "<li>Sub group Model:" + this.subgroupModel_.getHTMLInfo() + "</li>" + "<li>Sub group members:" + pal.misc.Utils.toString((Object[])Identifier.getNames(this.subgroupTOCD_), ", ") + "</li>" + "</ul>";
                }
            }
        }

        private static final class MutationRateDeltaModel
        implements DeltaModel {
            private final MutationRateModel.Factory mepFactory_;

            public MutationRateDeltaModel(MutationRateModel.Factory mepFactory) {
                this.mepFactory_ = mepFactory;
            }

            public Instance generateInstance(TimeOrderCharacterData tocd) {
                return new InstanceImpl(this.mepFactory_.generateNewModel(), tocd);
            }

            public boolean canGenerateAlternativeTreeRepresentation() {
                return true;
            }

            private static final class InstanceImpl
            extends Parameterized.ParameterizedUser
            implements Instance {
                private final MutationRateModel model_;
                private final TimeOrderCharacterData tocd_;

                public InstanceImpl(MutationRateModel model, TimeOrderCharacterData tocd) {
                    this.model_ = model;
                    this.tocd_ = tocd;
                    this.setParameterizedBase(this.model_);
                }

                public Tree generateAlternativeRepresentation(Tree expectedSubstitutionsTree) {
                    return TreeUtils.scale(expectedSubstitutionsTree, this.model_, this.model_.getUnits());
                }

                public double getExpectedSubstitutionsToTime(double time) throws UnsupportedOperationException {
                    return this.model_.getExpectedSubstitutions(time);
                }

                public OrthogonalHints getOrthogonalHints() {
                    return this.model_.getOrthogonalHints();
                }

                public double getExpectedSubstitutions(int taxon) {
                    return this.model_.getExpectedSubstitutions(this.tocd_.getTime(taxon));
                }

                public String getHTMLInfo() {
                    return "<ul><li>Rate Inferable (time information available)</li><li>Details:" + this.model_.toSingleLine() + "</li>" + "</ul>";
                }
            }
        }
    }

    public static interface Instance
    extends Parameterized,
    Serializable {
        public double getExpectedSubstitutions(int var1);

        public double getExpectedSubstitutionsToTime(double var1) throws UnsupportedOperationException;

        public OrthogonalHints getOrthogonalHints();

        public Tree generateAlternativeRepresentation(Tree var1);

        public String getHTMLInfo();

        public void addPalObjectListener(PalObjectListener var1);

        public void removePalObjectListener(PalObjectListener var1);
    }
}

