/*
 * Decompiled with CFR 0.152.
 */
package pal.mep;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import pal.io.OutputTarget;
import pal.mep.MutationRateModel;
import pal.misc.Parameterized;
import pal.misc.Report;
import pal.misc.Summarizable;
import pal.misc.Units;

public class ConstantMutationRate
extends MutationRateModel
implements Report,
Summarizable,
Parameterized,
Serializable {
    private static final String[] CP_SUMMARY_TYPES = new String[]{"mu", "muSE"};
    private static final double DEFAULT_RATE_VALUE = 1.0E-6;
    private double mu;
    private double muSE;
    private double minimumMutationRate_;
    private boolean parameterize_;
    private static final long serialVersionUID = -6086097377649319118L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeDouble(this.mu);
        out.writeDouble(this.muSE);
        out.writeDouble(this.minimumMutationRate_);
        out.writeBoolean(this.parameterize_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.mu = in.readDouble();
        this.muSE = in.readDouble();
        this.minimumMutationRate_ = in.readDouble();
        this.parameterize_ = in.readBoolean();
    }

    public ConstantMutationRate(int units, double maximumMutationRate) {
        this(1.0E-6, units, maximumMutationRate);
    }

    public ConstantMutationRate(double rate, int units, double maximumMutationRate) {
        this(rate, units, 0.0, maximumMutationRate);
    }

    public ConstantMutationRate(double rate, int units, double minimumMu, double maximumMu) {
        this(rate, units, minimumMu, maximumMu, true);
    }

    private ConstantMutationRate(double rate, int units, double minimumMu, double maximumMu, boolean parameterize) {
        super(units, maximumMu);
        this.mu = Math.max(Math.min(maximumMu, rate), minimumMu);
        this.parameterize_ = parameterize;
        this.minimumMutationRate_ = minimumMu;
    }

    protected ConstantMutationRate(ConstantMutationRate toCopy) {
        super(toCopy);
        this.mu = toCopy.mu;
        this.muSE = toCopy.muSE;
        this.minimumMutationRate_ = toCopy.minimumMutationRate_;
        this.parameterize_ = toCopy.parameterize_;
    }

    public Object clone() {
        return this.getCopy();
    }

    public MutationRateModel getCopy() {
        return new ConstantMutationRate(this);
    }

    public String[] getSummaryTypes() {
        return CP_SUMMARY_TYPES;
    }

    public double getSummaryValue(int summaryType) {
        switch (summaryType) {
            case 0: {
                return this.mu;
            }
            case 1: {
                return this.muSE;
            }
        }
        throw new RuntimeException("Assertion error: unknown summary type :" + summaryType);
    }

    public double getMu() {
        return this.mu;
    }

    public void setMu(double m) {
        this.mu = m;
    }

    public final double getMutationRate(double t) {
        return this.mu;
    }

    public final double getExpectedSubstitutions(double t) {
        return this.mu * t;
    }

    public final double getEndTime(double expectedSubs, double startTime) {
        return expectedSubs / this.mu;
    }

    public final void scale(double scale) {
        this.mu *= scale;
    }

    public int getNumParameters() {
        return this.parameterize_ ? 1 : 0;
    }

    public double getParameter(int k) {
        return this.mu;
    }

    public double getUpperLimit(int k) {
        return this.getMaximumMutationRate();
    }

    public double getLowerLimit(int k) {
        return this.minimumMutationRate_;
    }

    public double getDefaultValue(int k) {
        return 1.0E-6;
    }

    public void setParameter(double value, int k) {
        this.mu = value;
    }

    public void setParameterSE(double value, int k) {
        this.muSE = value;
    }

    public String toString() {
        OutputTarget out = OutputTarget.openString();
        this.report(out);
        out.close();
        return out.getString();
    }

    public void report(PrintWriter out) {
        out.println("Mutation rate model: constant mutation rate ");
        out.print("Unit of time: ");
        out.print(Units.UNIT_NAMES[this.getUnits()]);
        out.println();
        out.println();
        out.println("Parameters of function: mu(t) = mu");
        out.print(" mutation rate: ");
        this.fo.displayDecimal(out, this.mu, 6);
    }

    public String toSingleLine() {
        String s = "Single rate model. Mutation rate, mu = " + this.mu;
        if (this.minimumMutationRate_ == this.getMaximumMutationRate() && this.minimumMutationRate_ == this.mu) {
            s = s + " (fixed)";
        }
        return s;
    }

    public static final MutationRateModel.Factory getFixedFactory(double rate, int units) {
        return new RateFactory(rate, units, false, rate);
    }

    public static final MutationRateModel.Factory getFreeFactory(int units, double maximumMutationRate) {
        return new RateFactory(maximumMutationRate / 2.0, units, true, maximumMutationRate);
    }

    public static final MutationRateModel.Factory getFreeFactory(double initialRate, int units, double maximumMutationRate) {
        return new RateFactory(initialRate, units, true, maximumMutationRate);
    }

    public static final MutationRateModel.Factory getFreeFactory(double initialRate, int units, double minimumRate, double maximumRate) {
        return new RateFactory(initialRate, units, true, minimumRate, maximumRate);
    }

    public MutationRateModel.Factory generateFactory() {
        return new RateFactory(this.mu, this.getUnits(), this.parameterize_, this.getMaximumMutationRate());
    }

    public static final ConstantMutationRate createFixed(double rate, int units) {
        return new ConstantMutationRate(rate, units, rate, rate, false);
    }

    private static final class RateFactory
    implements MutationRateModel.Factory {
        private final double initialRate_;
        private final int units_;
        private final boolean parameterise_;
        private final double maximumMutationRate_;
        private final double minimumMutationRate_;

        public RateFactory(double initialRate, int units, boolean parameterise, double maximumMutationRate) {
            this(initialRate, units, parameterise, 0.0, maximumMutationRate);
        }

        public RateFactory(double initialRate, int units, boolean parameterise, double minimumMutationRate, double maximumMutationRate) {
            this.initialRate_ = initialRate;
            this.units_ = units;
            this.maximumMutationRate_ = maximumMutationRate;
            this.minimumMutationRate_ = minimumMutationRate;
            this.parameterise_ = parameterise;
        }

        public MutationRateModel generateNewModel() {
            if (this.parameterise_) {
                return new ConstantMutationRate(this.initialRate_, this.units_, this.minimumMutationRate_, this.maximumMutationRate_);
            }
            return ConstantMutationRate.createFixed(this.initialRate_, this.units_);
        }
    }
}

