/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.DifferentialEvolution;
import pal.math.MinimiserMonitor;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;

public class GeneralizedDEOptimizer
extends MultivariateMinimum {
    private DifferentialEvolution optimiser_;
    private int currentNumberOfParameters_ = 0;
    private int populationSize_ = -1;

    public GeneralizedDEOptimizer() {
        this(-1);
    }

    public GeneralizedDEOptimizer(int populationSize) {
        this.populationSize_ = populationSize;
    }

    public void optimize(MultivariateFunction f, double[] xvec, double tolfx, double tolx) {
        this.optimize(f, xvec, tolfx, tolx, null);
    }

    public void optimize(MultivariateFunction f, double[] xvec, double tolfx, double tolx, MinimiserMonitor monitor) {
        if (this.optimiser_ == null || xvec.length != this.currentNumberOfParameters_) {
            this.optimiser_ = this.populationSize_ > 0 ? new DifferentialEvolution(xvec.length, this.populationSize_) : new DifferentialEvolution(xvec.length);
            this.currentNumberOfParameters_ = xvec.length;
        }
        this.optimiser_.optimize(f, xvec, tolfx, tolx, monitor);
    }

    public static final MultivariateMinimum.Factory generateFactory(int populationSize) {
        return new SearchFactory(populationSize);
    }

    public static final MultivariateMinimum.Factory generateFactory() {
        return new SearchFactory();
    }

    private static final class SearchFactory
    implements MultivariateMinimum.Factory {
        private final int populationSize_;

        private SearchFactory() {
            this(-1);
        }

        private SearchFactory(int populationSize) {
            this.populationSize_ = populationSize;
        }

        public MultivariateMinimum generateNewMinimiser() {
            if (this.populationSize_ > 0) {
                return new GeneralizedDEOptimizer(this.populationSize_);
            }
            return new GeneralizedDEOptimizer();
        }
    }
}

