/*
 * Decompiled with CFR 0.152.
 */
package pal.gui;

import java.awt.Color;
import java.io.Serializable;
import java.util.Hashtable;
import pal.gui.LabelDisplayer;
import pal.misc.Identifier;

public final class NameColouriser
implements Serializable {
    private final Hashtable displayMappings_ = new Hashtable();

    public NameColouriser() {
    }

    public NameColouriser(String name, Color colour) {
        this.addMapping(name, colour);
    }

    public NameColouriser(String[] names, Color colour) {
        int i = 0;
        while (i < names.length) {
            this.addMapping(names[i], colour);
            ++i;
        }
    }

    public NameColouriser(Identifier name, Color colour) {
        this.addMapping(name, colour);
    }

    public void addMapping(String name, Color colour) {
        this.displayMappings_.put(name, LabelDisplayer.Utils.buildDisplay(colour));
    }

    public void addMapping(String name, Color colour, int fontStyle) {
        this.displayMappings_.put(name, LabelDisplayer.Utils.buildDisplay(colour, fontStyle));
    }

    public void addMapping(String name, LabelDisplayer display) {
        this.displayMappings_.put(name, display);
    }

    public void addMapping(Identifier id, Color colour) {
        if (id != null && id.getName() != null) {
            this.displayMappings_.put(id.getName(), LabelDisplayer.Utils.buildDisplay(colour));
        }
    }

    public void addMappings(String[] names, Color[] colours) {
        int i = 0;
        while (i < names.length) {
            this.displayMappings_.put(names[i], LabelDisplayer.Utils.buildDisplay(colours[i]));
            ++i;
        }
    }

    public LabelDisplayer getDisplay(String name, LabelDisplayer defaultDisplay) {
        if (name == null || !this.displayMappings_.containsKey(name)) {
            return defaultDisplay;
        }
        return (LabelDisplayer)this.displayMappings_.get(name);
    }

    public LabelDisplayer getDisplay(Identifier id, LabelDisplayer defaultDisplay) {
        if (id == null) {
            return defaultDisplay;
        }
        return this.getDisplay(id.getName(), defaultDisplay);
    }
}

