/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.eval.ConditionalProbabilityStore;
import pal.eval.LHCalculator;
import pal.substmodel.SubstitutionModel;

public class SimpleLeafCalculator
implements LHCalculator.Leaf {
    private final int numberOfStates_;
    private final double[][][] transitionProbabilitiyStore_;
    private final ConditionalProbabilityStore conditionalProbabilities_;
    private final ConditionalProbabilityStore flatConditionalProbabilities_;
    private double lastDistance_ = -1.0;

    public SimpleLeafCalculator(int[] patternStateMatchup, int numberOfPatterns, int numberOfStates, int numberOfCategories, LHCalculator.Generator parent) {
        this.numberOfStates_ = numberOfStates;
        this.transitionProbabilitiyStore_ = new double[numberOfCategories][numberOfStates][numberOfStates];
        this.conditionalProbabilities_ = parent.createAppropriateConditionalProbabilityStore(true);
        this.flatConditionalProbabilities_ = parent.createAppropriateConditionalProbabilityStore(true);
        double[][] stateStuff = new double[numberOfStates][numberOfStates];
        int i = 0;
        while (i < numberOfStates) {
            stateStuff[i][i] = 1.0;
            ++i;
        }
        double[] gapStore = new double[numberOfStates];
        int i2 = 0;
        while (i2 < gapStore.length) {
            gapStore[i2] = 1.0;
            ++i2;
        }
        double[][][] extendedStore = this.conditionalProbabilities_.getIncompleteConditionalProbabilityAccess(numberOfPatterns, true, true);
        double[][][] flatStore = this.flatConditionalProbabilities_.getIncompleteConditionalProbabilityAccess(numberOfPatterns, true, true);
        int pattern = 0;
        while (pattern < numberOfPatterns) {
            int cat;
            int state = patternStateMatchup[pattern];
            if (state == numberOfStates) {
                cat = 0;
                while (cat < numberOfCategories) {
                    extendedStore[cat][pattern] = gapStore;
                    flatStore[cat][pattern] = gapStore;
                    ++cat;
                }
            } else {
                cat = 0;
                while (cat < numberOfCategories) {
                    extendedStore[cat][pattern] = this.transitionProbabilitiyStore_[cat][state];
                    flatStore[cat][pattern] = stateStuff[state];
                    ++cat;
                }
            }
            ++pattern;
        }
    }

    public ConditionalProbabilityStore getFlatConditionalProbabilities() {
        return this.flatConditionalProbabilities_;
    }

    public ConditionalProbabilityStore getExtendedConditionalProbabilities(double distance, SubstitutionModel model, boolean modelChanged) {
        if (distance != this.lastDistance_ || this.lastDistance_ < 0.0 || modelChanged) {
            model.getTransitionProbabilitiesTranspose(distance, this.transitionProbabilitiyStore_);
            this.lastDistance_ = distance;
            this.conditionalProbabilities_.setBasedOnCachedData(true);
        } else {
            this.conditionalProbabilities_.setBasedOnCachedData(false);
        }
        return this.conditionalProbabilities_;
    }
}

