/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pal.datatype.DataType;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.LHCalculator;
import pal.eval.PatternInfo;
import pal.eval.SimpleLeafCalculator;
import pal.substmodel.SubstitutionModel;

public class SimpleLHCalculator
implements LHCalculator {
    private static final SimpleFactory FACTORY_INSTANCE = new SimpleFactory();

    private static final void calculateFlatImpl(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, ConditionalProbabilityStore resultStore, int numberOfCategories, int numberOfStates) {
        int[] patternLookup = centerPattern.getPatternLookup();
        int numberOfPatterns = centerPattern.getNumberOfPatterns();
        double[][][] resultStoreValues = resultStore.getConditionalProbabilityAccess(numberOfPatterns, false);
        int category = 0;
        while (category < numberOfCategories) {
            int patternAccess = 0;
            double[][] myPatternStateProbabilities = resultStoreValues[category];
            double[][] leftPatternStateProbabilities = leftConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            double[][] rightPatternStateProbabilities = rightConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                int leftPattern = patternLookup[patternAccess++];
                int rightPattern = patternLookup[patternAccess++];
                double[] myStateProbabilities = myPatternStateProbabilities[pattern];
                double[] leftStateProbabilities = leftPatternStateProbabilities[leftPattern];
                double[] rightStateProbabilities = rightPatternStateProbabilities[rightPattern];
                int endState = 0;
                while (endState < numberOfStates) {
                    myStateProbabilities[endState] = leftStateProbabilities[endState] * rightStateProbabilities[endState];
                    ++endState;
                }
                ++pattern;
            }
            ++category;
        }
    }

    private static final void calculateExtendedImpl(double[][][] transitionProbabilityStore, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, ConditionalProbabilityStore resultStore, int numberOfCategories, int numberOfStates, double[] endStateProbabilityStore) {
        int[] patternLookup = centerPattern.getPatternLookup();
        int numberOfPatterns = centerPattern.getNumberOfPatterns();
        double[][][] resultStoreValues = resultStore.getConditionalProbabilityAccess(numberOfPatterns, false);
        int category = 0;
        while (category < numberOfCategories) {
            int patternAccess = 0;
            double[][] myPatternStateProbabilities = resultStoreValues[category];
            double[][] leftPatternStateProbabilities = leftConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            double[][] rightPatternStateProbabilities = rightConditionalProbabilityProbabilties.getCurrentConditionalProbabilities(category);
            double[][] transProb = transitionProbabilityStore[category];
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                int leftPattern = patternLookup[patternAccess++];
                int rightPattern = patternLookup[patternAccess++];
                double[] myStateProbabilities = myPatternStateProbabilities[pattern];
                double[] leftStateProbabilities = leftPatternStateProbabilities[leftPattern];
                double[] rightStateProbabilities = rightPatternStateProbabilities[rightPattern];
                int endState = 0;
                while (endState < numberOfStates) {
                    endStateProbabilityStore[endState] = leftStateProbabilities[endState] * rightStateProbabilities[endState];
                    ++endState;
                }
                int startState = 0;
                while (startState < numberOfStates) {
                    double probTotal = 0.0;
                    double[] speedupArray = transProb[startState];
                    int endState2 = 0;
                    while (endState2 < numberOfStates) {
                        probTotal += speedupArray[endState2] * endStateProbabilityStore[endState2];
                        ++endState2;
                    }
                    myStateProbabilities[startState] = probTotal;
                    ++startState;
                }
                ++pattern;
            }
            ++category;
        }
    }

    public static final LHCalculator.Factory getFactory() {
        return FACTORY_INSTANCE;
    }

    private static final class SimpleGenerator
    implements LHCalculator.Generator {
        private int numberOfCategories_;
        private int numberOfStates_;
        private double[] endStateProbabilityStore_;
        private static final long serialVersionUID = 75762749252L;

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeByte(1);
            out.writeInt(this.numberOfCategories_);
            out.writeInt(this.numberOfStates_);
            out.writeObject(this.endStateProbabilityStore_);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            byte version = in.readByte();
            switch (version) {
                default: 
            }
            this.numberOfCategories_ = in.readInt();
            this.numberOfStates_ = in.readInt();
            this.endStateProbabilityStore_ = (double[])in.readObject();
        }

        public SimpleGenerator(int numberOfCategories, int numberOfStates) {
            this.numberOfCategories_ = numberOfCategories;
            this.numberOfStates_ = numberOfStates;
            this.endStateProbabilityStore_ = new double[numberOfStates];
        }

        public LHCalculator.Leaf createNewLeaf(int[] patternStateMatchup, int numberOfPatterns) {
            return new SimpleLeafCalculator(patternStateMatchup, numberOfPatterns, this.numberOfStates_, this.numberOfCategories_, this);
        }

        public LHCalculator.Leaf createNewLeaf(int[] patternStateMatchup, int numberOfPatterns, LHCalculator.Generator parentGenerator) {
            return new SimpleLeafCalculator(patternStateMatchup, numberOfPatterns, this.numberOfStates_, this.numberOfCategories_, parentGenerator);
        }

        public LHCalculator.External createNewExternal() {
            return new ExternalImpl(this.numberOfCategories_, this.numberOfStates_, this.endStateProbabilityStore_);
        }

        public LHCalculator.Internal createNewInternal() {
            return new InternalImpl(this.numberOfCategories_, this.numberOfStates_, this.endStateProbabilityStore_, this);
        }

        public LHCalculator.External createNewExternal(LHCalculator.Generator parentGenerator) throws IllegalArgumentException {
            return new ExternalImpl(this.numberOfCategories_, this.numberOfStates_, this.endStateProbabilityStore_);
        }

        public LHCalculator.Internal createNewInternal(LHCalculator.Generator parentGenerator) throws IllegalArgumentException {
            return new InternalImpl(this.numberOfCategories_, this.numberOfStates_, this.endStateProbabilityStore_, parentGenerator);
        }

        public ConditionalProbabilityStore createAppropriateConditionalProbabilityStore(boolean isForLeaf) {
            return new ConditionalProbabilityStore(this.numberOfCategories_, this.numberOfStates_, false);
        }

        public boolean isAllowCaching() {
            return false;
        }
    }

    private static final class SimpleFactory
    implements LHCalculator.Factory {
        public LHCalculator.Generator createSeries(int numberOfCategories, DataType dt) {
            return new SimpleGenerator(numberOfCategories, dt.getNumStates());
        }
    }

    private static final class InternalImpl
    implements LHCalculator.Internal {
        private final int numberOfCategories_;
        private final int numberOfStates_;
        private final ConditionalProbabilityStore myResultStore_;
        private final double[][][] transitionProbabilityStore_;
        private final double[] endStateProbabilityStore_;
        private int currentNumberOfPatterns_ = 0;
        private double lastDistance_ = -1.0;

        private InternalImpl(int numberOfCategories, int numberOfStates, double[] endStateProbabilityStore, LHCalculator.Generator parentGenerator) {
            this.numberOfCategories_ = numberOfCategories;
            this.numberOfStates_ = numberOfStates;
            this.endStateProbabilityStore_ = endStateProbabilityStore;
            this.transitionProbabilityStore_ = new double[numberOfCategories][numberOfStates][numberOfStates];
            this.myResultStore_ = parentGenerator.createAppropriateConditionalProbabilityStore(false);
        }

        public final ConditionalProbabilityStore calculateExtended(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, boolean modelChangedSinceLastCall, boolean childrenChanged) {
            if (modelChangedSinceLastCall || distance != this.lastDistance_ || this.lastDistance_ < 0.0) {
                model.getTransitionProbabilities(distance, this.transitionProbabilityStore_);
                this.lastDistance_ = distance;
            }
            SimpleLHCalculator.calculateExtendedImpl(this.transitionProbabilityStore_, centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, this.myResultStore_, this.numberOfCategories_, this.numberOfStates_, this.endStateProbabilityStore_);
            return this.myResultStore_;
        }

        public final ConditionalProbabilityStore calculateFlat(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, boolean childrenChanged) {
            SimpleLHCalculator.calculateFlatImpl(centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, this.myResultStore_, this.numberOfCategories_, this.numberOfStates_);
            return this.myResultStore_;
        }
    }

    private static final class ExternalImpl
    implements LHCalculator.External {
        private final int numberOfCategories_;
        private final int numberOfStates_;
        private final double[][][] transitionProbabilityStore_;
        private final double[] endStateProbabilityStore_;
        private static final long serialVersionUID = 98765372758522L;

        private ExternalImpl(int numberOfCategories, int numberOfStates, double[] endStateProbabilityStore) {
            this.numberOfCategories_ = numberOfCategories;
            this.numberOfStates_ = numberOfStates;
            this.endStateProbabilityStore_ = endStateProbabilityStore;
            this.transitionProbabilityStore_ = new double[numberOfCategories][numberOfStates][numberOfStates];
        }

        public final void calculateExtended(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, ConditionalProbabilityStore resultStore) {
            model.getTransitionProbabilities(distance, this.transitionProbabilityStore_);
            SimpleLHCalculator.calculateExtendedImpl(this.transitionProbabilityStore_, centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, resultStore, this.numberOfCategories_, this.numberOfStates_, this.endStateProbabilityStore_);
        }

        public final void calculateFlat(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties, ConditionalProbabilityStore resultStore) {
            SimpleLHCalculator.calculateFlatImpl(centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, resultStore, this.numberOfCategories_, this.numberOfStates_);
        }

        private final double[][][] getResultStoreValues(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftFlatConditionalProbabilities, ConditionalProbabilityStore rightFlatConditionalProbabilities, ConditionalProbabilityStore tempStore) {
            int[] patternWeights = centerPattern.getPatternWeights();
            int[] patternLookup = centerPattern.getPatternLookup();
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            model.getTransitionProbabilities(distance, this.transitionProbabilityStore_);
            double[][][] resultStoreValues = tempStore.getConditionalProbabilityAccess(numberOfPatterns, false);
            int category = 0;
            while (category < this.numberOfCategories_) {
                int patternAccess = 0;
                double[][] myPatternStateProbabilities = resultStoreValues[category];
                double[][] leftPatternStateProbabilities = leftFlatConditionalProbabilities.getCurrentConditionalProbabilities(category);
                double[][] rightPatternStateProbabilities = rightFlatConditionalProbabilities.getCurrentConditionalProbabilities(category);
                double[][] transProb = this.transitionProbabilityStore_[category];
                int pattern = 0;
                while (pattern < numberOfPatterns) {
                    int leftPattern = patternLookup[patternAccess++];
                    int rightPattern = patternLookup[patternAccess++];
                    double[] myStateProbabilities = myPatternStateProbabilities[pattern];
                    double[] leftStateProbabilities = leftPatternStateProbabilities[leftPattern];
                    double[] rightStateProbabilities = rightPatternStateProbabilities[rightPattern];
                    int startState = 0;
                    while (startState < this.numberOfStates_) {
                        double probTotal = 0.0;
                        double[] speedupArray = transProb[startState];
                        int endState = 0;
                        while (endState < this.numberOfStates_) {
                            probTotal += speedupArray[endState] * leftStateProbabilities[endState];
                            ++endState;
                        }
                        myStateProbabilities[startState] = probTotal * rightStateProbabilities[startState];
                        ++startState;
                    }
                    ++pattern;
                }
                ++category;
            }
            return resultStoreValues;
        }

        public double calculateLogLikelihood(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftFlatConditionalProbabilities, ConditionalProbabilityStore rightFlatConditionalProbabilities, ConditionalProbabilityStore tempStore) {
            int[] patternWeights = centerPattern.getPatternWeights();
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            double[][][] resultStoreValues = this.getResultStoreValues(distance, model, centerPattern, leftFlatConditionalProbabilities, rightFlatConditionalProbabilities, tempStore);
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            double[] probabilities = model.getTransitionCategoryProbabilities();
            double logLikelihood = 0.0;
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                double total = 0.0;
                int cat = 0;
                while (cat < this.numberOfCategories_) {
                    double[] states = resultStoreValues[cat][pattern];
                    double prob = 0.0;
                    int state = 0;
                    while (state < this.numberOfStates_) {
                        prob += equilibriumFrequencies[state] * states[state];
                        ++state;
                    }
                    total += probabilities[cat] * prob;
                    ++cat;
                }
                logLikelihood += Math.log(total) * (double)patternWeights[pattern];
                ++pattern;
            }
            return logLikelihood;
        }

        public void calculateCategoryPatternProbabilities(double distance, SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftFlatConditionalProbabilities, ConditionalProbabilityStore rightFlatConditionalProbabilities, ConditionalProbabilityStore tempStore, double[][] categoryPatternLogLikelihoods) {
            int[] patternWeights = centerPattern.getPatternWeights();
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            double[][][] resultStoreValues = this.getResultStoreValues(distance, model, centerPattern, leftFlatConditionalProbabilities, rightFlatConditionalProbabilities, tempStore);
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            double logLikelihood = 0.0;
            int cat = 0;
            while (cat < this.numberOfCategories_) {
                double total = 0.0;
                double[][] patternValues = resultStoreValues[cat];
                double[] patternLogLikelihoods = categoryPatternLogLikelihoods[cat];
                int pattern = 0;
                while (pattern < numberOfPatterns) {
                    double[] states = patternValues[pattern];
                    double prob = 0.0;
                    int state = 0;
                    while (state < this.numberOfStates_) {
                        prob += equilibriumFrequencies[state] * states[state];
                        ++state;
                    }
                    patternLogLikelihoods[pattern] = prob;
                    ++pattern;
                }
                ++cat;
            }
        }

        public double calculateLogLikelihood(SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore) {
            int[] patternWeights = centerPattern.getPatternWeights();
            int[] patternLookup = centerPattern.getPatternLookup();
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            int[] sitePatternMatchup = centerPattern.getSitePatternMatchup();
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            double[] probabilities = model.getTransitionCategoryProbabilities();
            double logLikelihood = 0.0;
            double[][][] leftConditionalProbabilities = leftConditionalProbabilitiesStore.getCurrentConditionalProbabilities();
            double[][][] rightConditionalProbabilities = rightConditionalProbabilitiesStore.getCurrentConditionalProbabilities();
            int patternIndex = 0;
            int pattern = 0;
            while (pattern < numberOfPatterns) {
                double total = 0.0;
                int leftIndex = patternLookup[patternIndex++];
                int rightIndex = patternLookup[patternIndex++];
                int cat = 0;
                while (cat < this.numberOfCategories_) {
                    double[] left = leftConditionalProbabilities[cat][leftIndex];
                    double[] right = rightConditionalProbabilities[cat][rightIndex];
                    double prob = 0.0;
                    int state = 0;
                    while (state < this.numberOfStates_) {
                        prob += equilibriumFrequencies[state] * (left[state] * right[state]);
                        ++state;
                    }
                    total += probabilities[cat] * prob;
                    ++cat;
                }
                logLikelihood += Math.log(total) * (double)patternWeights[pattern];
                ++pattern;
            }
            return logLikelihood;
        }

        public void calculateCategoryPatternProbabilities(SubstitutionModel model, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore, double[][] categoryPatternLogLikelihoods) {
            int[] patternLookup = centerPattern.getPatternLookup();
            int numberOfPatterns = centerPattern.getNumberOfPatterns();
            double[] equilibriumFrequencies = model.getEquilibriumFrequencies();
            double[][][] leftConditionalProbabilities = leftConditionalProbabilitiesStore.getCurrentConditionalProbabilities();
            double[][][] rightConditionalProbabilities = rightConditionalProbabilitiesStore.getCurrentConditionalProbabilities();
            int cat = 0;
            while (cat < this.numberOfCategories_) {
                double total = 0.0;
                double[][] leftPatterns = leftConditionalProbabilities[cat];
                double[][] rightPatterns = rightConditionalProbabilities[cat];
                double[] patternLogLikelihoods = categoryPatternLogLikelihoods[cat];
                int patternIndex = 0;
                int pattern = 0;
                while (pattern < numberOfPatterns) {
                    double[] left = leftPatterns[patternLookup[patternIndex++]];
                    double[] right = rightPatterns[patternLookup[patternIndex++]];
                    double prob = 0.0;
                    int state = 0;
                    while (state < this.numberOfStates_) {
                        prob += equilibriumFrequencies[state] * (left[state] * right[state]);
                        ++state;
                    }
                    patternLogLikelihoods[pattern] = prob;
                    ++pattern;
                }
                ++cat;
            }
        }
    }
}

