/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.substmodel.SubstitutionModel;

public interface Posteriors {
    public SubstitutionModel getRelatedModel();

    public double[] getSitePosteriors(int var1);

    public static final class Utils {
        public static final Posteriors create(double[][] categoryPatternConditionalProbabilities, boolean isLoggedConditionals, SubstitutionModel model, int numberOfPatterns, int[] sitePatternMatchup, int numberOfSites) {
            return new SimplePosteriors(categoryPatternConditionalProbabilities, isLoggedConditionals, model, numberOfPatterns, sitePatternMatchup, numberOfSites);
        }

        public static final Posteriors create(double[][] categoryPatternConditionalProbabilities, boolean isLoggedConditionals, int numberOfPatterns, int[] sitePatternMatchup, int numberOfSites) {
            return new SimplePosteriors(categoryPatternConditionalProbabilities, isLoggedConditionals, numberOfPatterns, sitePatternMatchup, numberOfSites);
        }

        private static final class SimplePosteriors
        implements Posteriors {
            private final double[][] categoryPatternConditionalProbabilities_;
            private final double[][] patternPosteriors_;
            private final int[] sitePatternMatchup_;
            private final SubstitutionModel model_;
            private final int numberOfSites_;

            public SimplePosteriors(double[][] categoryPatternConditionalProbabilities, boolean isLoggedConditionals, int numberOfPatterns, int[] sitePatternMatchup, int numberOfSites) {
                this(categoryPatternConditionalProbabilities, isLoggedConditionals, null, numberOfPatterns, sitePatternMatchup, numberOfSites);
            }

            public SimplePosteriors(double[][] categoryPatternConditionalProbabilities, boolean isLoggedConditionals, SubstitutionModel model, int numberOfPatterns, int[] sitePatternMatchup, int numberOfSites) {
                int numberOfCategories = model.getNumberOfTransitionCategories();
                this.categoryPatternConditionalProbabilities_ = isLoggedConditionals ? SimplePosteriors.convertLogged(categoryPatternConditionalProbabilities, numberOfCategories, numberOfPatterns) : pal.misc.Utils.getCopy(categoryPatternConditionalProbabilities);
                this.numberOfSites_ = numberOfSites;
                this.sitePatternMatchup_ = pal.misc.Utils.getCopy(sitePatternMatchup);
                this.patternPosteriors_ = new double[numberOfPatterns][numberOfCategories];
                int p = 0;
                while (p < numberOfPatterns) {
                    double total = 0.0;
                    int c = 0;
                    while (c < numberOfCategories) {
                        total += categoryPatternConditionalProbabilities[c][p];
                        ++c;
                    }
                    int c2 = 0;
                    while (c2 < numberOfCategories) {
                        this.patternPosteriors_[p][c2] = categoryPatternConditionalProbabilities[c2][p] / total;
                        ++c2;
                    }
                    ++p;
                }
                this.model_ = model;
            }

            public SubstitutionModel getRelatedModel() {
                return this.model_;
            }

            public double[] getSitePosteriors(int site) {
                return this.patternPosteriors_[this.sitePatternMatchup_[site]];
            }

            private static final double[][] convertLogged(double[][] loggedStore, int numberOfCategories, int numberOfPatterns) {
                double[][] result = new double[numberOfCategories][numberOfPatterns];
                int c = 0;
                while (c < numberOfCategories) {
                    int p = 0;
                    while (p < numberOfPatterns) {
                        result[c][p] = Math.exp(loggedStore[c][p]);
                        ++p;
                    }
                    ++c;
                }
                return result;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < this.numberOfSites_) {
                    sb.append("Site ");
                    sb.append(i + 1);
                    sb.append(":");
                    sb.append(pal.misc.Utils.toString(this.getSitePosteriors(i)));
                    sb.append("\n");
                    ++i;
                }
                return sb.toString();
            }
        }
    }
}

