/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.misc.Utils;

public final class PatternInfo {
    private final int[] sitePatternMatchup_;
    private final int[] patternWeights_;
    private final int[] patternLookup_;
    private int numberOfPatterns_;

    public PatternInfo(int numberOfSites, boolean binaryPattern) {
        this.sitePatternMatchup_ = new int[numberOfSites];
        this.patternWeights_ = new int[numberOfSites];
        this.numberOfPatterns_ = 0;
        this.patternLookup_ = new int[binaryPattern ? numberOfSites * 2 : numberOfSites];
    }

    public PatternInfo(int[] sitePatternMatchup, int[] patternWeights, int[] patternLookup, int initialNumberOfPatterns) {
        this.sitePatternMatchup_ = sitePatternMatchup;
        this.patternWeights_ = patternWeights;
        this.patternLookup_ = patternLookup;
        this.numberOfPatterns_ = initialNumberOfPatterns;
    }

    public PatternInfo(int[] sitePatternMatchup, int initialNumberOfPatterns) {
        this(sitePatternMatchup, null, initialNumberOfPatterns);
    }

    public PatternInfo(int[] sitePatternMatchup, int[] patternWeights, int initialNumberOfPatterns) {
        this(sitePatternMatchup, patternWeights, null, initialNumberOfPatterns);
    }

    public String toString() {
        return Utils.toString(this.patternLookup_, this.numberOfPatterns_ * 2);
    }

    public String sitePatternMatchupToString() {
        return Utils.toString(this.sitePatternMatchup_);
    }

    public final int[] getPatternLookup() {
        return this.patternLookup_;
    }

    public int[] getPatternWeights() {
        return this.patternWeights_;
    }

    public final int getNumberOfSites() {
        return this.sitePatternMatchup_.length;
    }

    public final int[] getSitePatternMatchup() {
        return this.sitePatternMatchup_;
    }

    public final int getNumberOfPatterns() {
        return this.numberOfPatterns_;
    }

    public void setNumberOfPatterns(int n) {
        this.numberOfPatterns_ = n;
    }

    public int build(PatternInfo leftPattern, PatternInfo rightPattern, int numberOfSites) {
        if (rightPattern.getNumberOfPatterns() == 0) {
            System.out.println("Error: right");
        }
        if (leftPattern.getNumberOfPatterns() == 0) {
            System.out.println("Error: left");
        }
        int numberOfLeftPatterns = leftPattern.getNumberOfPatterns();
        int numberOfRightPatterns = rightPattern.getNumberOfPatterns();
        int[] leftSitePatternMatchup = leftPattern.getSitePatternMatchup();
        int[] rightSitePatternMatchup = rightPattern.getSitePatternMatchup();
        int uniqueCount = 0;
        int uniqueCountTimesTwo = 0;
        int i = 0;
        while (i < numberOfSites) {
            int leftPatternIndex = leftSitePatternMatchup[i];
            int rightPatternIndex = rightSitePatternMatchup[i];
            int patternIndex = PatternInfo.getMatchingPattern(leftPatternIndex, rightPatternIndex, this.patternLookup_, uniqueCount);
            if (patternIndex < 0) {
                this.sitePatternMatchup_[i] = uniqueCount;
                this.patternLookup_[uniqueCountTimesTwo++] = leftPatternIndex;
                this.patternLookup_[uniqueCountTimesTwo++] = rightPatternIndex;
                this.patternWeights_[uniqueCount++] = 1;
            } else {
                int n = patternIndex;
                this.patternWeights_[n] = this.patternWeights_[n] + 1;
                this.sitePatternMatchup_[i] = patternIndex;
            }
            ++i;
        }
        this.numberOfPatterns_ = uniqueCount;
        return uniqueCount;
    }

    private static final int getMatchingPattern(int leftPattern, int rightPattern, int[] patternLookup, int numberOfPatternsFoundSoFar) {
        int index = 0;
        int i = 0;
        while (i < numberOfPatternsFoundSoFar) {
            boolean matchRight;
            boolean matchLeft = patternLookup[index++] == leftPattern;
            boolean bl = matchRight = patternLookup[index++] == rightPattern;
            if (matchLeft && matchRight) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

